/*
 * Decompiled with CFR 0.152.
 */
package shark.internal.aosp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.internal.aosp.ByteArrayComparator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J(\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J(\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lshark/internal/aosp/ByteArrayTimSort;", "", "a", "", "c", "Lshark/internal/aosp/ByteArrayComparator;", "entrySize", "", "([BLshark/internal/aosp/ByteArrayComparator;I)V", "minGallop", "runBase", "", "runLen", "stackSize", "tmp", "ensureCapacity", "minCapacity", "mergeAt", "", "i", "mergeCollapse", "mergeForceCollapse", "mergeHi", "base1", "len1", "base2", "len2", "mergeLo", "pushRun", "Companion", "shark-graph"})
public final class ByteArrayTimSort {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] a;
    @NotNull
    private final ByteArrayComparator c;
    private final int entrySize;
    private int minGallop;
    @Nullable
    private byte[] tmp;
    private int stackSize;
    @NotNull
    private final int[] runBase;
    @NotNull
    private final int[] runLen;
    private static final int MIN_MERGE = 32;
    private static final int MIN_GALLOP = 7;
    private static final int INITIAL_TMP_STORAGE_LENGTH = 256;
    private static final boolean DEBUG = false;

    private ByteArrayTimSort(byte[] a, ByteArrayComparator c, int entrySize) {
        this.a = a;
        this.c = c;
        this.entrySize = entrySize;
        this.minGallop = 7;
        int len = this.a.length / this.entrySize;
        byte[] newArray = new byte[this.entrySize * (len < 512 ? len >>> 1 : 256)];
        this.tmp = newArray;
        int stackLen = len < 120 ? 5 : (len < 1542 ? 10 : (len < 119151 ? 19 : 40));
        this.runBase = new int[stackLen];
        this.runLen = new int[stackLen];
    }

    private final void pushRun(int runBase, int runLen) {
        this.runBase[this.stackSize] = runBase;
        this.runLen[this.stackSize] = runLen;
        int n = this.stackSize;
        this.stackSize = n + 1;
    }

    private final void mergeCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n >= 1 && this.runLen[n - 1] <= this.runLen[n] + this.runLen[n + 1] || n >= 2 && this.runLen[n - 2] <= this.runLen[n] + this.runLen[n - 1]) {
                if (this.runLen[n - 1] < this.runLen[n + 1]) {
                    --n;
                }
            } else if (this.runLen[n] > this.runLen[n + 1]) break;
            this.mergeAt(n);
        }
    }

    private final void mergeForceCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] < this.runLen[n + 1]) {
                --n;
            }
            this.mergeAt(n);
        }
    }

    private final void mergeAt(int i) {
        int base1 = this.runBase[i];
        int len1 = this.runLen[i];
        int base2 = this.runBase[i + 1];
        int len2 = this.runLen[i + 1];
        this.runLen[i] = len1 + len2;
        if (i == this.stackSize - 3) {
            this.runBase[i + 1] = this.runBase[i + 2];
            this.runLen[i + 1] = this.runLen[i + 2];
        }
        int n = this.stackSize;
        this.stackSize = n + -1;
        int k = ByteArrayTimSort.Companion.gallopRight(this.a, base2, this.a, base1, len1, 0, this.entrySize, this.c);
        base1 += k;
        if ((len1 -= k) == 0) {
            return;
        }
        len2 = ByteArrayTimSort.Companion.gallopLeft(this.a, base1 + len1 - 1, this.a, base2, len2, len2 - 1, this.entrySize, this.c);
        if (len2 == 0) {
            return;
        }
        if (len1 <= len2) {
            this.mergeLo(base1, len1, base2, len2);
        } else {
            this.mergeHi(base1, len1, base2, len2);
        }
    }

    private final void mergeLo(int base1, int len1, int base2, int len2) {
        int len12 = len1;
        int len22 = len2;
        byte[] a = this.a;
        int entrySize = this.entrySize;
        byte[] tmp = this.ensureCapacity(len12);
        System.arraycopy(a, base1 * entrySize, tmp, 0, len12 * entrySize);
        int cursor1 = 0;
        int cursor2 = base2;
        int dest = base1;
        int destIndex = dest * entrySize;
        int cursor2Index = cursor2 * entrySize;
        for (int i = 0; i < entrySize; ++i) {
            a[destIndex + i] = a[cursor2Index + i];
        }
        ++dest;
        ++cursor2;
        if (--len22 == 0) {
            System.arraycopy(tmp, cursor1 * entrySize, a, dest * entrySize, len12 * entrySize);
            return;
        }
        if (len12 == 1) {
            System.arraycopy(a, cursor2 * entrySize, a, dest * entrySize, len22 * entrySize);
            int destLen2Index = (dest + len22) * entrySize;
            int cursor1Index = cursor1 * entrySize;
            for (int i = 0; i < entrySize; ++i) {
                a[destLen2Index + i] = tmp[cursor1Index + i];
            }
            return;
        }
        ByteArrayComparator c = this.c;
        int minGallop = this.minGallop;
        block6: while (true) {
            int i;
            int cursor2Index2;
            int destIndex2;
            int count1 = 0;
            int count2 = 0;
            do {
                if (c.compare(entrySize, a, cursor2, tmp, cursor1) < 0) {
                    destIndex2 = dest * entrySize;
                    cursor2Index2 = cursor2 * entrySize;
                    for (i = 0; i < entrySize; ++i) {
                        a[destIndex2 + i] = a[cursor2Index2 + i];
                    }
                    ++dest;
                    ++cursor2;
                    ++count2;
                    count1 = 0;
                    if (--len22 != 0) continue;
                    break block6;
                }
                destIndex2 = dest * entrySize;
                int cursor1Index = cursor1 * entrySize;
                for (i = 0; i < entrySize; ++i) {
                    a[destIndex2 + i] = tmp[cursor1Index + i];
                }
                ++dest;
                ++cursor1;
                ++count1;
                count2 = 0;
                if (--len12 == 1) break block6;
            } while ((count1 | count2) < minGallop);
            do {
                if ((count1 = ByteArrayTimSort.Companion.gallopRight(a, cursor2, tmp, cursor1, len12, 0, entrySize, c)) != 0) {
                    System.arraycopy(tmp, cursor1 * entrySize, a, dest * entrySize, count1 * entrySize);
                    dest += count1;
                    cursor1 += count1;
                    if ((len12 -= count1) <= 1) break block6;
                }
                destIndex2 = dest * entrySize;
                cursor2Index2 = cursor2 * entrySize;
                for (i = 0; i < entrySize; ++i) {
                    a[destIndex2 + i] = a[cursor2Index2 + i];
                }
                ++dest;
                ++cursor2;
                if (--len22 == 0) break block6;
                count2 = ByteArrayTimSort.Companion.gallopLeft(tmp, cursor1, a, cursor2, len22, 0, entrySize, c);
                if (count2 != 0) {
                    System.arraycopy(a, cursor2 * entrySize, a, dest * entrySize, count2 * entrySize);
                    dest += count2;
                    cursor2 += count2;
                    if ((len22 -= count2) == 0) break block6;
                }
                destIndex2 = dest * entrySize;
                int cursor1Index = cursor1 * entrySize;
                for (int i2 = 0; i2 < entrySize; ++i2) {
                    a[destIndex2 + i2] = tmp[cursor1Index + i2];
                }
                ++dest;
                ++cursor1;
                if (--len12 == 1) break block6;
                --minGallop;
            } while (count1 >= 7 | count2 >= 7);
            if (minGallop < 0) {
                minGallop = 0;
            }
            minGallop += 2;
        }
        this.minGallop = minGallop < 1 ? 1 : minGallop;
        switch (len12) {
            case 1: {
                System.arraycopy(a, cursor2 * entrySize, a, dest * entrySize, len22 * entrySize);
                int destLen2Index = (dest + len22) * entrySize;
                int cursor1Index = cursor1 * entrySize;
                for (int i = 0; i < entrySize; ++i) {
                    a[destLen2Index + i] = tmp[cursor1Index + i];
                }
                break;
            }
            case 0: {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            default: {
                System.arraycopy(tmp, cursor1 * entrySize, a, dest * entrySize, len12 * entrySize);
            }
        }
    }

    private final void mergeHi(int base1, int len1, int base2, int len2) {
        int i;
        int cursor2Index;
        int len12 = len1;
        int len22 = len2;
        byte[] a = this.a;
        byte[] tmp = this.ensureCapacity(len22);
        int entrySize = this.entrySize;
        System.arraycopy(a, base2 * entrySize, tmp, 0, len22 * entrySize);
        int cursor1 = base1 + len12 - 1;
        int cursor2 = len22 - 1;
        int dest = base2 + len22 - 1;
        int destIndex = dest * entrySize;
        int cursor1Index = cursor1 * entrySize;
        for (int i2 = 0; i2 < entrySize; ++i2) {
            a[destIndex + i2] = a[cursor1Index + i2];
        }
        --dest;
        --cursor1;
        if (--len12 == 0) {
            System.arraycopy(tmp, 0, a, (dest - (len22 - 1)) * entrySize, len22 * entrySize);
            return;
        }
        if (len22 == 1) {
            System.arraycopy(a, ((cursor1 -= len12) + 1) * entrySize, a, ((dest -= len12) + 1) * entrySize, len12 * entrySize);
            int destIndex2 = dest * entrySize;
            int cursor2Index2 = cursor2 * entrySize;
            for (int i3 = 0; i3 < entrySize; ++i3) {
                a[destIndex2 + i3] = tmp[cursor2Index2 + i3];
            }
            return;
        }
        ByteArrayComparator c = this.c;
        int minGallop = this.minGallop;
        block6: while (true) {
            int count1 = 0;
            int count2 = 0;
            do {
                int i4;
                int destIndex3;
                if (c.compare(entrySize, tmp, cursor2, a, cursor1) < 0) {
                    destIndex3 = dest * entrySize;
                    int cursor1Index2 = cursor1 * entrySize;
                    for (i4 = 0; i4 < entrySize; ++i4) {
                        a[destIndex3 + i4] = a[cursor1Index2 + i4];
                    }
                    --dest;
                    --cursor1;
                    ++count1;
                    count2 = 0;
                    if (--len12 != 0) continue;
                    break block6;
                }
                destIndex3 = dest * entrySize;
                int cursor2Index3 = cursor2 * entrySize;
                for (i4 = 0; i4 < entrySize; ++i4) {
                    a[destIndex3 + i4] = tmp[cursor2Index3 + i4];
                }
                --dest;
                --cursor2;
                ++count2;
                count1 = 0;
                if (--len22 == 1) break block6;
            } while ((count1 | count2) < minGallop);
            do {
                if ((count1 = len12 - ByteArrayTimSort.Companion.gallopRight(tmp, cursor2, a, base1, len12, len12 - 1, entrySize, c)) != 0) {
                    System.arraycopy(a, ((cursor1 -= count1) + 1) * entrySize, a, ((dest -= count1) + 1) * entrySize, count1 * entrySize);
                    if ((len12 -= count1) == 0) break block6;
                }
                destIndex = dest * entrySize;
                cursor2Index = cursor2 * entrySize;
                for (i = 0; i < entrySize; ++i) {
                    a[destIndex + i] = tmp[cursor2Index + i];
                }
                --dest;
                --cursor2;
                if (--len22 == 1) break block6;
                count2 = len22 - ByteArrayTimSort.Companion.gallopLeft(a, cursor1, tmp, 0, len22, len22 - 1, entrySize, c);
                if (count2 != 0) {
                    System.arraycopy(tmp, ((cursor2 -= count2) + 1) * entrySize, a, ((dest -= count2) + 1) * entrySize, count2 * entrySize);
                    if ((len22 -= count2) <= 1) break block6;
                }
                int destIndex4 = dest * entrySize;
                int cursor1Index3 = cursor1 * entrySize;
                for (int i5 = 0; i5 < entrySize; ++i5) {
                    a[destIndex4 + i5] = a[cursor1Index3 + i5];
                }
                --dest;
                --cursor1;
                if (--len12 == 0) break block6;
                --minGallop;
            } while (count1 >= 7 | count2 >= 7);
            if (minGallop < 0) {
                minGallop = 0;
            }
            minGallop += 2;
        }
        this.minGallop = minGallop < 1 ? 1 : minGallop;
        switch (len22) {
            case 1: {
                System.arraycopy(a, ((cursor1 -= len12) + 1) * entrySize, a, ((dest -= len12) + 1) * entrySize, len12 * entrySize);
                int destIndex5 = dest * entrySize;
                cursor2Index = cursor2 * entrySize;
                for (i = 0; i < entrySize; ++i) {
                    a[destIndex5 + i] = tmp[cursor2Index + i];
                }
                break;
            }
            case 0: {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            default: {
                System.arraycopy(tmp, 0, a, (dest - (len22 - 1)) * entrySize, len22 * entrySize);
            }
        }
    }

    private final byte[] ensureCapacity(int minCapacity) {
        Intrinsics.checkNotNull((Object)this.tmp);
        if (this.tmp.length < minCapacity * this.entrySize) {
            int newSize = minCapacity;
            newSize |= newSize >> 1;
            newSize |= newSize >> 2;
            newSize |= newSize >> 4;
            newSize |= newSize >> 8;
            newSize |= newSize >> 16;
            newSize = ++newSize < 0 ? minCapacity : Math.min(newSize, this.a.length / this.entrySize >>> 1);
            byte[] newArray = new byte[newSize * this.entrySize];
            this.tmp = newArray;
        }
        Intrinsics.checkNotNull((Object)this.tmp);
        return this.tmp;
    }

    public /* synthetic */ ByteArrayTimSort(byte[] a, ByteArrayComparator c, int entrySize, DefaultConstructorMarker $constructor_marker) {
        this(a, c, entrySize);
    }

    public static final /* synthetic */ int access$getStackSize$p(ByteArrayTimSort $this) {
        return $this.stackSize;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J0\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JH\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JH\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J(\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J.\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010 \u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lshark/internal/aosp/ByteArrayTimSort$Companion;", "", "()V", "DEBUG", "", "INITIAL_TMP_STORAGE_LENGTH", "", "MIN_GALLOP", "MIN_MERGE", "binarySort", "", "a", "", "lo", "hi", "start", "entrySize", "c", "Lshark/internal/aosp/ByteArrayComparator;", "checkStartAndEnd", "len", "end", "countRunAndMakeAscending", "gallopLeft", "keyArray", "keyIndex", "base", "hint", "gallopRight", "minRunLength", "n", "reverseRange", "sort", "shark-graph"})
    public static final class Companion {
        private Companion() {
        }

        public final void sort(@NotNull byte[] a, int entrySize, @NotNull ByteArrayComparator c) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            this.sort(a, 0, a.length / entrySize, entrySize, c);
        }

        public final void sort(@NotNull byte[] a, int lo, int hi, int entrySize, @NotNull ByteArrayComparator c) {
            int runLen;
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            int lo2 = lo;
            this.checkStartAndEnd(a.length / entrySize, lo2, hi);
            int nRemaining = hi - lo2;
            if (nRemaining < 2) {
                return;
            }
            if (nRemaining < 32) {
                int initRunLen = this.countRunAndMakeAscending(a, lo2, hi, entrySize, c);
                this.binarySort(a, lo2, hi, lo2 + initRunLen, entrySize, c);
                return;
            }
            ByteArrayTimSort ts = new ByteArrayTimSort(a, c, entrySize, null);
            int minRun = this.minRunLength(nRemaining);
            do {
                if ((runLen = this.countRunAndMakeAscending(a, lo2, hi, entrySize, c)) < minRun) {
                    int force = nRemaining <= minRun ? nRemaining : minRun;
                    this.binarySort(a, lo2, lo2 + force, lo2 + runLen, entrySize, c);
                    runLen = force;
                }
                ts.pushRun(lo2, runLen);
                ts.mergeCollapse();
                lo2 += runLen;
            } while ((nRemaining -= runLen) != 0);
            ts.mergeForceCollapse();
        }

        private final void checkStartAndEnd(int len, int start, int end) {
            if (start < 0 || end > len) {
                throw new ArrayIndexOutOfBoundsException("start < 0 || end > len. start=" + start + ", end=" + end + ", len=" + len);
            }
            if (start > end) {
                throw new IllegalArgumentException("start > end: " + start + " > " + end);
            }
        }

        private final void binarySort(byte[] a, int lo, int hi, int start, int entrySize, ByteArrayComparator c) {
            int start2 = start;
            if (start2 == lo) {
                ++start2;
            }
            byte[] pivot = new byte[entrySize];
            while (start2 < hi) {
                int startIndex = start2 * entrySize;
                for (int i = 0; i < entrySize; ++i) {
                    pivot[i] = a[startIndex + i];
                }
                int left = lo;
                int right = start2;
                while (left < right) {
                    int mid = left + right >>> 1;
                    if (c.compare(entrySize, pivot, 0, a, mid) < 0) {
                        right = mid;
                        continue;
                    }
                    left = mid + 1;
                }
                int n = start2 - left;
                switch (n) {
                    case 2: {
                        int i;
                        int leftIndex = left * entrySize;
                        int leftPlusOneIndex = (left + 1) * entrySize;
                        int leftPlusTwoIndex = (left + 2) * entrySize;
                        for (i = 0; i < entrySize; ++i) {
                            a[leftPlusTwoIndex + i] = a[leftPlusOneIndex + i];
                        }
                        for (i = 0; i < entrySize; ++i) {
                            a[leftPlusOneIndex + i] = a[leftIndex + i];
                        }
                        break;
                    }
                    case 1: {
                        int leftIndex = left * entrySize;
                        int leftPlusOneIndex = (left + 1) * entrySize;
                        for (int i = 0; i < entrySize; ++i) {
                            a[leftPlusOneIndex + i] = a[leftIndex + i];
                        }
                        break;
                    }
                    default: {
                        System.arraycopy(a, left * entrySize, a, (left + 1) * entrySize, n * entrySize);
                    }
                }
                int leftIndex = left * entrySize;
                for (int i = 0; i < entrySize; ++i) {
                    a[leftIndex + i] = pivot[i];
                }
                ++start2;
            }
        }

        private final int countRunAndMakeAscending(byte[] a, int lo, int hi, int entrySize, ByteArrayComparator c) {
            int runHi = lo + 1;
            if (runHi == hi) {
                return 1;
            }
            int comparison = c.compare(entrySize, a, runHi, a, lo);
            ++runHi;
            if (comparison < 0) {
                while (runHi < hi && c.compare(entrySize, a, runHi, a, runHi - 1) < 0) {
                    ++runHi;
                }
                this.reverseRange(a, lo, runHi, entrySize);
            } else {
                while (runHi < hi && c.compare(entrySize, a, runHi, a, runHi - 1) >= 0) {
                    ++runHi;
                }
            }
            return runHi - lo;
        }

        private final void reverseRange(byte[] a, int lo, int hi, int entrySize) {
            int hi2 = hi;
            --hi2;
            for (int lo2 = lo; lo2 < hi2; ++lo2, --hi2) {
                int loIndex = lo2 * entrySize;
                int hiIndex = hi2 * entrySize;
                for (int i = 0; i < entrySize; ++i) {
                    byte t = a[loIndex + i];
                    a[loIndex + i] = a[hiIndex + i];
                    a[hiIndex + i] = t;
                }
            }
        }

        private final int minRunLength(int n) {
            int n2;
            int r = 0;
            for (n2 = n; n2 >= 32; n2 >>= 1) {
                r |= n2 & 1;
            }
            return n2 + r;
        }

        private final int gallopLeft(byte[] keyArray, int keyIndex, byte[] a, int base, int len, int hint, int entrySize, ByteArrayComparator c) {
            int maxOfs;
            int lastOfs = 0;
            int ofs = 1;
            if (c.compare(entrySize, keyArray, keyIndex, a, base + hint) > 0) {
                maxOfs = len - hint;
                while (ofs < maxOfs && c.compare(entrySize, keyArray, keyIndex, a, base + hint + ofs) > 0) {
                    lastOfs = ofs;
                    if ((ofs = ofs * 2 + 1) > 0) continue;
                    ofs = maxOfs;
                }
                if (ofs > maxOfs) {
                    ofs = maxOfs;
                }
                lastOfs += hint;
                ofs += hint;
            } else {
                maxOfs = hint + 1;
                while (ofs < maxOfs && c.compare(entrySize, keyArray, keyIndex, a, base + hint - ofs) <= 0) {
                    lastOfs = ofs;
                    if ((ofs = ofs * 2 + 1) > 0) continue;
                    ofs = maxOfs;
                }
                if (ofs > maxOfs) {
                    ofs = maxOfs;
                }
                int tmp = lastOfs;
                lastOfs = hint - ofs;
                ofs = hint - tmp;
            }
            ++lastOfs;
            while (lastOfs < ofs) {
                int m = lastOfs + (ofs - lastOfs >>> 1);
                if (c.compare(entrySize, keyArray, keyIndex, a, base + m) > 0) {
                    lastOfs = m + 1;
                    continue;
                }
                ofs = m;
            }
            return ofs;
        }

        private final int gallopRight(byte[] keyArray, int keyIndex, byte[] a, int base, int len, int hint, int entrySize, ByteArrayComparator c) {
            int maxOfs;
            int ofs = 1;
            int lastOfs = 0;
            if (c.compare(entrySize, keyArray, keyIndex, a, base + hint) < 0) {
                maxOfs = hint + 1;
                while (ofs < maxOfs && c.compare(entrySize, keyArray, keyIndex, a, base + hint - ofs) < 0) {
                    lastOfs = ofs;
                    if ((ofs = ofs * 2 + 1) > 0) continue;
                    ofs = maxOfs;
                }
                if (ofs > maxOfs) {
                    ofs = maxOfs;
                }
                int tmp = lastOfs;
                lastOfs = hint - ofs;
                ofs = hint - tmp;
            } else {
                maxOfs = len - hint;
                while (ofs < maxOfs && c.compare(entrySize, keyArray, keyIndex, a, base + hint + ofs) >= 0) {
                    lastOfs = ofs;
                    if ((ofs = ofs * 2 + 1) > 0) continue;
                    ofs = maxOfs;
                }
                if (ofs > maxOfs) {
                    ofs = maxOfs;
                }
                lastOfs += hint;
                ofs += hint;
            }
            ++lastOfs;
            while (lastOfs < ofs) {
                int m = lastOfs + (ofs - lastOfs >>> 1);
                if (c.compare(entrySize, keyArray, keyIndex, a, base + m) < 0) {
                    ofs = m;
                    continue;
                }
                lastOfs = m + 1;
            }
            return ofs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

