/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import shark.HprofReader;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lshark/Hprof;", "Ljava/io/Closeable;", "channel", "Ljava/nio/channels/FileChannel;", "source", "Lokio/BufferedSource;", "reader", "Lshark/HprofReader;", "heapDumpTimestamp", "", "hprofVersion", "Lshark/Hprof$HprofVersion;", "fileLength", "(Ljava/nio/channels/FileChannel;Lokio/BufferedSource;Lshark/HprofReader;JLshark/Hprof$HprofVersion;J)V", "getFileLength", "()J", "getHeapDumpTimestamp", "getHprofVersion", "()Lshark/Hprof$HprofVersion;", "getReader", "()Lshark/HprofReader;", "close", "", "moveReaderTo", "newPosition", "Companion", "HprofVersion", "shark-hprof"})
public final class Hprof
implements Closeable {
    private final FileChannel channel;
    private final BufferedSource source;
    @NotNull
    private final HprofReader reader;
    private final long heapDumpTimestamp;
    @NotNull
    private final HprofVersion hprofVersion;
    private final long fileLength;
    private static final Map<String, HprofVersion> supportedVersions;
    public static final Companion Companion;

    @Override
    public void close() {
        this.source.close();
    }

    public final void moveReaderTo(long newPosition) {
        long currentPosition = this.reader.getPosition();
        if (currentPosition == newPosition) {
            return;
        }
        this.source.buffer().clear();
        this.channel.position(newPosition);
        this.reader.setPosition$shark_hprof(newPosition);
    }

    @NotNull
    public final HprofReader getReader() {
        return this.reader;
    }

    public final long getHeapDumpTimestamp() {
        return this.heapDumpTimestamp;
    }

    @NotNull
    public final HprofVersion getHprofVersion() {
        return this.hprofVersion;
    }

    public final long getFileLength() {
        return this.fileLength;
    }

    private Hprof(FileChannel channel, BufferedSource source, HprofReader reader, long heapDumpTimestamp, HprofVersion hprofVersion, long fileLength) {
        this.channel = channel;
        this.source = source;
        this.reader = reader;
        this.heapDumpTimestamp = heapDumpTimestamp;
        this.hprofVersion = hprofVersion;
        this.fileLength = fileLength;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        HprofVersion[] $this$map$iv = HprofVersion.values();
        boolean $i$f$map = false;
        HprofVersion[] hprofVersionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var5_5 = $this$mapTo$iv$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = var5_5[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getVersionString(), (Object)it);
            collection.add(pair);
        }
        supportedVersions = MapsKt.toMap((Iterable)((List)var3_3));
    }

    public /* synthetic */ Hprof(FileChannel channel, BufferedSource source, HprofReader reader, long heapDumpTimestamp, HprofVersion hprofVersion, long fileLength, DefaultConstructorMarker $constructor_marker) {
        this(channel, source, reader, heapDumpTimestamp, hprofVersion, fileLength);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lshark/Hprof$HprofVersion;", "", "versionString", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getVersionString", "()Ljava/lang/String;", "JDK1_2_BETA3", "JDK1_2_BETA4", "JDK_6", "ANDROID", "shark-hprof"})
    public static final class HprofVersion
    extends Enum<HprofVersion> {
        public static final /* enum */ HprofVersion JDK1_2_BETA3;
        public static final /* enum */ HprofVersion JDK1_2_BETA4;
        public static final /* enum */ HprofVersion JDK_6;
        public static final /* enum */ HprofVersion ANDROID;
        private static final /* synthetic */ HprofVersion[] $VALUES;
        @NotNull
        private final String versionString;

        static {
            HprofVersion[] hprofVersionArray = new HprofVersion[4];
            HprofVersion[] hprofVersionArray2 = hprofVersionArray;
            hprofVersionArray[0] = JDK1_2_BETA3 = new HprofVersion("JAVA PROFILE 1.0");
            hprofVersionArray[1] = JDK1_2_BETA4 = new HprofVersion("JAVA PROFILE 1.0.1");
            hprofVersionArray[2] = JDK_6 = new HprofVersion("JAVA PROFILE 1.0.2");
            hprofVersionArray[3] = ANDROID = new HprofVersion("JAVA PROFILE 1.0.3");
            $VALUES = hprofVersionArray;
        }

        @NotNull
        public final String getVersionString() {
            return this.versionString;
        }

        private HprofVersion(String versionString) {
            this.versionString = versionString;
        }

        public static HprofVersion[] values() {
            return (HprofVersion[])$VALUES.clone();
        }

        public static HprofVersion valueOf(String string) {
            return Enum.valueOf(HprofVersion.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lshark/Hprof$Companion;", "", "()V", "supportedVersions", "", "", "Lshark/Hprof$HprofVersion;", "open", "Lshark/Hprof;", "hprofFile", "Ljava/io/File;", "shark-hprof"})
    public static final class Companion {
        @NotNull
        public final Hprof open(@NotNull File hprofFile) {
            Intrinsics.checkParameterIsNotNull((Object)hprofFile, (String)"hprofFile");
            long fileLength = hprofFile.length();
            if (fileLength == 0L) {
                throw (Throwable)new IllegalArgumentException("Hprof file is 0 byte length");
            }
            File file = hprofFile;
            boolean bl = false;
            FileInputStream inputStream = new FileInputStream(file);
            FileChannel channel = inputStream.getChannel();
            BufferedSource source = Okio.buffer((Source)Okio.source((InputStream)inputStream));
            long endOfVersionString = source.indexOf((byte)0);
            String versionName = source.readUtf8(endOfVersionString);
            HprofVersion hprofVersion = (HprofVersion)((Object)supportedVersions.get(versionName));
            boolean bl2 = hprofVersion != null;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Unsupported Hprof version [" + versionName + "] not in supported list " + supportedVersions.keySet();
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            source.skip(1L);
            int identifierByteSize = source.readInt();
            long heapDumpTimestamp = source.readLong();
            long byteReadCount = endOfVersionString + 1L + (long)4 + (long)8;
            BufferedSource bufferedSource = source;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource, (String)"source");
            HprofReader reader = new HprofReader(bufferedSource, identifierByteSize, byteReadCount);
            FileChannel fileChannel = channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"channel");
            return new Hprof(fileChannel, source, reader, heapDumpTimestamp, hprofVersion, fileLength, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

