/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.HprofVersion;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lshark/HprofHeader;", "", "heapDumpTimestamp", "", "version", "Lshark/HprofVersion;", "identifierByteSize", "", "(JLshark/HprofVersion;I)V", "getHeapDumpTimestamp", "()J", "getIdentifierByteSize", "()I", "recordsPosition", "getRecordsPosition", "getVersion", "()Lshark/HprofVersion;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "shark-hprof"})
@SourceDebugExtension(value={"SMAP\nHprofHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HprofHeader.kt\nshark/HprofHeader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,68:1\n8811#2,2:69\n9071#2,4:71\n*S KotlinDebug\n*F\n+ 1 HprofHeader.kt\nshark/HprofHeader\n*L\n30#1:69,2\n30#1:71,4\n*E\n"})
public final class HprofHeader {
    @NotNull
    public static final Companion Companion;
    private final long heapDumpTimestamp;
    @NotNull
    private final HprofVersion version;
    private final int identifierByteSize;
    private final int recordsPosition;
    @NotNull
    private static final Map<String, HprofVersion> supportedVersions;

    public HprofHeader(long heapDumpTimestamp, @NotNull HprofVersion version, int identifierByteSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        this.heapDumpTimestamp = heapDumpTimestamp;
        this.version = version;
        this.identifierByteSize = identifierByteSize;
        byte[] byArray = this.version.getVersionString().getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.recordsPosition = byArray.length + 1 + 4 + 8;
    }

    public /* synthetic */ HprofHeader(long l, HprofVersion hprofVersion, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            l = System.currentTimeMillis();
        }
        if ((n2 & 2) != 0) {
            hprofVersion = HprofVersion.ANDROID;
        }
        if ((n2 & 4) != 0) {
            n = 4;
        }
        this(l, hprofVersion, n);
    }

    public final long getHeapDumpTimestamp() {
        return this.heapDumpTimestamp;
    }

    @NotNull
    public final HprofVersion getVersion() {
        return this.version;
    }

    public final int getIdentifierByteSize() {
        return this.identifierByteSize;
    }

    public final int getRecordsPosition() {
        return this.recordsPosition;
    }

    public final long component1() {
        return this.heapDumpTimestamp;
    }

    @NotNull
    public final HprofVersion component2() {
        return this.version;
    }

    public final int component3() {
        return this.identifierByteSize;
    }

    @NotNull
    public final HprofHeader copy(long heapDumpTimestamp, @NotNull HprofVersion version, int identifierByteSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        return new HprofHeader(heapDumpTimestamp, version, identifierByteSize);
    }

    public static /* synthetic */ HprofHeader copy$default(HprofHeader hprofHeader, long l, HprofVersion hprofVersion, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = hprofHeader.heapDumpTimestamp;
        }
        if ((n2 & 2) != 0) {
            hprofVersion = hprofHeader.version;
        }
        if ((n2 & 4) != 0) {
            n = hprofHeader.identifierByteSize;
        }
        return hprofHeader.copy(l, hprofVersion, n);
    }

    @NotNull
    public String toString() {
        return "HprofHeader(heapDumpTimestamp=" + this.heapDumpTimestamp + ", version=" + (Object)((Object)this.version) + ", identifierByteSize=" + this.identifierByteSize + ')';
    }

    public int hashCode() {
        int result = Long.hashCode(this.heapDumpTimestamp);
        result = result * 31 + this.version.hashCode();
        result = result * 31 + Integer.hashCode(this.identifierByteSize);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HprofHeader)) {
            return false;
        }
        HprofHeader hprofHeader = (HprofHeader)other;
        if (this.heapDumpTimestamp != hprofHeader.heapDumpTimestamp) {
            return false;
        }
        if (this.version != hprofHeader.version) {
            return false;
        }
        return this.identifierByteSize == hprofHeader.identifierByteSize;
    }

    public HprofHeader() {
        this(0L, null, 0, 7, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        HprofVersion[] $this$associateBy$iv = HprofVersion.values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        HprofVersion[] hprofVersionArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        int n = ((void)$this$associateByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var9_9 = element$iv$iv = $this$associateByTo$iv$iv[i];
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getVersionString(), element$iv$iv);
        }
        supportedVersions = destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lshark/HprofHeader$Companion;", "", "()V", "supportedVersions", "", "", "Lshark/HprofVersion;", "parseHeaderOf", "Lshark/HprofHeader;", "hprofFile", "Ljava/io/File;", "source", "Lokio/BufferedSource;", "shark-hprof"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final HprofHeader parseHeaderOf(@NotNull File hprofFile) {
            HprofHeader hprofHeader;
            Intrinsics.checkNotNullParameter((Object)hprofFile, (String)"hprofFile");
            long fileLength = hprofFile.length();
            if (fileLength == 0L) {
                throw new IllegalArgumentException("Hprof file is 0 byte length");
            }
            Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((InputStream)new FileInputStream(hprofFile)));
            Throwable throwable = null;
            try {
                BufferedSource it = (BufferedSource)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                hprofHeader = Companion.parseHeaderOf(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return hprofHeader;
        }

        @NotNull
        public final HprofHeader parseHeaderOf(@NotNull BufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(!source.exhausted())) {
                boolean bl = false;
                throw new IllegalArgumentException("Source has no available bytes");
            }
            long endOfVersionString = source.indexOf((byte)0);
            String versionName = source.readUtf8(endOfVersionString);
            HprofVersion version = (HprofVersion)((Object)supportedVersions.get(versionName));
            if (version == null) {
                boolean $i$a$-checkNotNull-HprofHeader$Companion$parseHeaderOf$42 = false;
                String $i$a$-checkNotNull-HprofHeader$Companion$parseHeaderOf$42 = "Unsupported Hprof version [" + versionName + "] not in supported list " + supportedVersions.keySet();
                throw new IllegalStateException($i$a$-checkNotNull-HprofHeader$Companion$parseHeaderOf$42.toString());
            }
            source.skip(1L);
            int identifierByteSize = source.readInt();
            long heapDumpTimestamp = source.readLong();
            return new HprofHeader(heapDumpTimestamp, version, identifierByteSize);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

