/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import shark.GcRoot;
import shark.HprofHeader;
import shark.HprofRecord;
import shark.PrimitiveType;
import shark.ValueHolder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 |2\u00020\u0001:\u0001|B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\bJ\u000e\u0010/\u001a\u0002002\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u00020\rJ\u000e\u00104\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020@J\u0006\u0010A\u001a\u00020\bJ\u000e\u0010B\u001a\u0002002\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020FJ\u0006\u0010G\u001a\u00020HJ\u0006\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u00020LJ\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020P2\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010Q\u001a\u00020RJ\u0006\u0010S\u001a\u00020TJ\u0006\u0010U\u001a\u00020VJ\u0016\u0010W\u001a\u00020X2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010Y\u001a\u00020ZJ\u000e\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\bJ\u0006\u0010^\u001a\u00020_J\u0006\u0010`\u001a\u00020aJ\u0006\u0010b\u001a\u00020cJ\u0006\u0010d\u001a\u00020eJ\u0006\u0010f\u001a\u00020\rJ\u0006\u0010g\u001a\u00020\bJ\u0006\u0010h\u001a\u00020\rJ\u000e\u0010i\u001a\u00020X2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\rJ\u0006\u0010m\u001a\u00020nJ\u000e\u0010o\u001a\u00020\r2\u0006\u0010l\u001a\u00020\rJ\u000e\u0010p\u001a\u00020q2\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010p\u001a\u00020q2\u0006\u0010\u0019\u001a\u00020\bJ\u0006\u0010r\u001a\u00020qJ\u0006\u0010s\u001a\u00020qJ\u0006\u0010t\u001a\u00020qJ\u0006\u0010u\u001a\u00020qJ\u0006\u0010v\u001a\u00020qJ\u0006\u0010w\u001a\u00020qJ\u0006\u0010x\u001a\u00020qJ\u0006\u0010y\u001a\u00020qJ\u0006\u0010z\u001a\u00020qJ\u0006\u0010{\u001a\u00020qR\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lshark/HprofRecordReader;", "", "header", "Lshark/HprofHeader;", "source", "Lokio/BufferedSource;", "(Lshark/HprofHeader;Lokio/BufferedSource;)V", "<set-?>", "", "bytesRead", "getBytesRead", "()J", "identifierByteSize", "", "typeSizes", "", "readBoolean", "", "readBooleanArray", "", "arrayLength", "readByte", "", "readByteArray", "", "byteCount", "readChar", "", "readCharArray", "", "readClassDumpRecord", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ClassDumpRecord;", "readDebuggerGcRootRecord", "Lshark/GcRoot$Debugger;", "readDouble", "", "readDoubleArray", "", "readFinalizingGcRootRecord", "Lshark/GcRoot$Finalizing;", "readFloat", "", "readFloatArray", "", "readHeapDumpInfoRecord", "Lshark/HprofRecord$HeapDumpRecord$HeapDumpInfoRecord;", "readId", "readIdArray", "", "readInstanceDumpRecord", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$InstanceDumpRecord;", "readInt", "readIntArray", "readInternedStringGcRootRecord", "Lshark/GcRoot$InternedString;", "readJavaFrameGcRootRecord", "Lshark/GcRoot$JavaFrame;", "readJniGlobalGcRootRecord", "Lshark/GcRoot$JniGlobal;", "readJniLocalGcRootRecord", "Lshark/GcRoot$JniLocal;", "readJniMonitorGcRootRecord", "Lshark/GcRoot$JniMonitor;", "readLoadClassRecord", "Lshark/HprofRecord$LoadClassRecord;", "readLong", "readLongArray", "readMonitorUsedGcRootRecord", "Lshark/GcRoot$MonitorUsed;", "readNativeStackGcRootRecord", "Lshark/GcRoot$NativeStack;", "readObjectArrayDumpRecord", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ObjectArrayDumpRecord;", "readPrimitiveArrayDumpRecord", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$PrimitiveArrayDumpRecord;", "readReferenceCleanupGcRootRecord", "Lshark/GcRoot$ReferenceCleanup;", "readShort", "", "readShortArray", "", "readStackFrameRecord", "Lshark/HprofRecord$StackFrameRecord;", "readStackTraceRecord", "Lshark/HprofRecord$StackTraceRecord;", "readStickyClassGcRootRecord", "Lshark/GcRoot$StickyClass;", "readString", "", "charset", "Ljava/nio/charset/Charset;", "readStringRecord", "Lshark/HprofRecord$StringRecord;", "length", "readThreadBlockGcRootRecord", "Lshark/GcRoot$ThreadBlock;", "readThreadObjectGcRootRecord", "Lshark/GcRoot$ThreadObject;", "readUnknownGcRootRecord", "Lshark/GcRoot$Unknown;", "readUnreachableGcRootRecord", "Lshark/GcRoot$Unreachable;", "readUnsignedByte", "readUnsignedInt", "readUnsignedShort", "readUtf8", "readValue", "Lshark/ValueHolder;", "type", "readVmInternalGcRootRecord", "Lshark/GcRoot$VmInternal;", "sizeOf", "skip", "", "skipClassDumpConstantPool", "skipClassDumpFields", "skipClassDumpHeader", "skipClassDumpRecord", "skipClassDumpStaticFields", "skipHeapDumpInfoRecord", "skipId", "skipInstanceDumpRecord", "skipObjectArrayDumpRecord", "skipPrimitiveArrayDumpRecord", "Companion", "shark-hprof"})
public final class HprofRecordReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    private long bytesRead;
    private final int identifierByteSize;
    @NotNull
    private final int[] typeSizes;
    private static final int BOOLEAN_SIZE = PrimitiveType.BOOLEAN.getByteSize();
    private static final int CHAR_SIZE = PrimitiveType.CHAR.getByteSize();
    private static final int BYTE_SIZE = PrimitiveType.BYTE.getByteSize();
    private static final int SHORT_SIZE = PrimitiveType.SHORT.getByteSize();
    private static final int INT_SIZE = PrimitiveType.INT.getByteSize();
    private static final int LONG_SIZE = PrimitiveType.LONG.getByteSize();
    private static final int BOOLEAN_TYPE = PrimitiveType.BOOLEAN.getHprofType();
    private static final int CHAR_TYPE = PrimitiveType.CHAR.getHprofType();
    private static final int FLOAT_TYPE = PrimitiveType.FLOAT.getHprofType();
    private static final int DOUBLE_TYPE = PrimitiveType.DOUBLE.getHprofType();
    private static final int BYTE_TYPE = PrimitiveType.BYTE.getHprofType();
    private static final int SHORT_TYPE = PrimitiveType.SHORT.getHprofType();
    private static final int INT_TYPE = PrimitiveType.INT.getHprofType();
    private static final int LONG_TYPE = PrimitiveType.LONG.getHprofType();
    private static final long INT_MASK = 0xFFFFFFFFL;
    private static final int BYTE_MASK = 255;

    public HprofRecordReader(@NotNull HprofHeader header, @NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.identifierByteSize = header.getIdentifierByteSize();
        Map typeSizesMap = MapsKt.plus(PrimitiveType.Companion.getByteSizeByHprofType(), (Pair)TuplesKt.to((Object)2, (Object)this.identifierByteSize));
        Comparable comparable = CollectionsKt.maxOrThrow((Iterable)typeSizesMap.keySet());
        Intrinsics.checkNotNull((Object)comparable);
        int maxKey = ((Number)((Object)comparable)).intValue();
        int n = maxKey + 1;
        int[] nArray = new int[n];
        HprofRecordReader hprofRecordReader = this;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            Integer n3 = (Integer)typeSizesMap.get(n2);
            nArray[n2] = n3 != null ? n3 : 0;
        }
        hprofRecordReader.typeSizes = nArray;
    }

    public final long getBytesRead() {
        return this.bytesRead;
    }

    public final int sizeOf(int type) {
        return this.typeSizes[type];
    }

    @NotNull
    public final HprofRecord.StringRecord readStringRecord(long length) {
        return new HprofRecord.StringRecord(this.readId(), this.readUtf8(length - (long)this.identifierByteSize));
    }

    @NotNull
    public final HprofRecord.LoadClassRecord readLoadClassRecord() {
        return new HprofRecord.LoadClassRecord(this.readInt(), this.readId(), this.readInt(), this.readId());
    }

    @NotNull
    public final HprofRecord.StackFrameRecord readStackFrameRecord() {
        return new HprofRecord.StackFrameRecord(this.readId(), this.readId(), this.readId(), this.readId(), this.readInt(), this.readInt());
    }

    @NotNull
    public final HprofRecord.StackTraceRecord readStackTraceRecord() {
        return new HprofRecord.StackTraceRecord(this.readInt(), this.readInt(), this.readIdArray(this.readInt()));
    }

    @NotNull
    public final GcRoot.Unknown readUnknownGcRootRecord() {
        return new GcRoot.Unknown(this.readId());
    }

    @NotNull
    public final GcRoot.JniGlobal readJniGlobalGcRootRecord() {
        return new GcRoot.JniGlobal(this.readId(), this.readId());
    }

    @NotNull
    public final GcRoot.JniLocal readJniLocalGcRootRecord() {
        return new GcRoot.JniLocal(this.readId(), this.readInt(), this.readInt());
    }

    @NotNull
    public final GcRoot.JavaFrame readJavaFrameGcRootRecord() {
        return new GcRoot.JavaFrame(this.readId(), this.readInt(), this.readInt());
    }

    @NotNull
    public final GcRoot.NativeStack readNativeStackGcRootRecord() {
        return new GcRoot.NativeStack(this.readId(), this.readInt());
    }

    @NotNull
    public final GcRoot.StickyClass readStickyClassGcRootRecord() {
        return new GcRoot.StickyClass(this.readId());
    }

    @NotNull
    public final GcRoot.ThreadBlock readThreadBlockGcRootRecord() {
        return new GcRoot.ThreadBlock(this.readId(), this.readInt());
    }

    @NotNull
    public final GcRoot.MonitorUsed readMonitorUsedGcRootRecord() {
        return new GcRoot.MonitorUsed(this.readId());
    }

    @NotNull
    public final GcRoot.ThreadObject readThreadObjectGcRootRecord() {
        return new GcRoot.ThreadObject(this.readId(), this.readInt(), this.readInt());
    }

    @NotNull
    public final GcRoot.InternedString readInternedStringGcRootRecord() {
        return new GcRoot.InternedString(this.readId());
    }

    @NotNull
    public final GcRoot.Finalizing readFinalizingGcRootRecord() {
        return new GcRoot.Finalizing(this.readId());
    }

    @NotNull
    public final GcRoot.Debugger readDebuggerGcRootRecord() {
        return new GcRoot.Debugger(this.readId());
    }

    @NotNull
    public final GcRoot.ReferenceCleanup readReferenceCleanupGcRootRecord() {
        return new GcRoot.ReferenceCleanup(this.readId());
    }

    @NotNull
    public final GcRoot.VmInternal readVmInternalGcRootRecord() {
        return new GcRoot.VmInternal(this.readId());
    }

    @NotNull
    public final GcRoot.JniMonitor readJniMonitorGcRootRecord() {
        return new GcRoot.JniMonitor(this.readId(), this.readInt(), this.readInt());
    }

    @NotNull
    public final GcRoot.Unreachable readUnreachableGcRootRecord() {
        return new GcRoot.Unreachable(this.readId());
    }

    @NotNull
    public final HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord readInstanceDumpRecord() {
        long id = this.readId();
        int stackTraceSerialNumber = this.readInt();
        long classId = this.readId();
        int remainingBytesInInstance = this.readInt();
        byte[] fieldValues = this.readByteArray(remainingBytesInInstance);
        return new HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord(id, stackTraceSerialNumber, classId, fieldValues);
    }

    @NotNull
    public final HprofRecord.HeapDumpRecord.HeapDumpInfoRecord readHeapDumpInfoRecord() {
        int heapId = this.readInt();
        return new HprofRecord.HeapDumpRecord.HeapDumpInfoRecord(heapId, this.readId());
    }

    @NotNull
    public final HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord readClassDumpRecord() {
        long id = this.readId();
        int stackTraceSerialNumber = this.readInt();
        long superclassId = this.readId();
        long classLoaderId = this.readId();
        long signersId = this.readId();
        long protectionDomainId = this.readId();
        this.readId();
        this.readId();
        int instanceSize = this.readInt();
        int constantPoolCount = this.readUnsignedShort();
        for (int i = 0; i < constantPoolCount; ++i) {
            this.skip(SHORT_SIZE);
            this.skip(this.typeSizes[this.readUnsignedByte()]);
        }
        int staticFieldCount = this.readUnsignedShort();
        ArrayList<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord> staticFields = new ArrayList<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord>(staticFieldCount);
        for (int i = 0; i < staticFieldCount; ++i) {
            long nameStringId = this.readId();
            int type = this.readUnsignedByte();
            ValueHolder value = this.readValue(type);
            staticFields.add(new HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord(nameStringId, type, value));
        }
        int fieldCount = this.readUnsignedShort();
        ArrayList<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord> fields = new ArrayList<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            fields.add(new HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord(this.readId(), this.readUnsignedByte()));
        }
        return new HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord(id, stackTraceSerialNumber, superclassId, classLoaderId, signersId, protectionDomainId, instanceSize, (List<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord>)staticFields, (List<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord>)fields);
    }

    @NotNull
    public final HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord readPrimitiveArrayDumpRecord() {
        HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord primitiveArrayDumpRecord;
        long id = this.readId();
        int stackTraceSerialNumber = this.readInt();
        int arrayLength = this.readInt();
        int type = this.readUnsignedByte();
        if (type == BOOLEAN_TYPE) {
            primitiveArrayDumpRecord = new HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.BooleanArrayDump(id, stackTraceSerialNumber, this.readBooleanArray(arrayLength));
        } else if (type == CHAR_TYPE) {
            primitiveArrayDumpRecord = new HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.CharArrayDump(id, stackTraceSerialNumber, this.readCharArray(arrayLength));
        } else if (type == FLOAT_TYPE) {
            primitiveArrayDumpRecord = new HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.FloatArrayDump(id, stackTraceSerialNumber, this.readFloatArray(arrayLength));
        } else if (type == DOUBLE_TYPE) {
            primitiveArrayDumpRecord = new HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.DoubleArrayDump(id, stackTraceSerialNumber, this.readDoubleArray(arrayLength));
        } else if (type == BYTE_TYPE) {
            primitiveArrayDumpRecord = new HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ByteArrayDump(id, stackTraceSerialNumber, this.readByteArray(arrayLength));
        } else if (type == SHORT_TYPE) {
            primitiveArrayDumpRecord = new HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ShortArrayDump(id, stackTraceSerialNumber, this.readShortArray(arrayLength));
        } else if (type == INT_TYPE) {
            primitiveArrayDumpRecord = new HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.IntArrayDump(id, stackTraceSerialNumber, this.readIntArray(arrayLength));
        } else if (type == LONG_TYPE) {
            primitiveArrayDumpRecord = new HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.LongArrayDump(id, stackTraceSerialNumber, this.readLongArray(arrayLength));
        } else {
            throw new IllegalStateException("Unexpected type " + type);
        }
        return primitiveArrayDumpRecord;
    }

    @NotNull
    public final HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord readObjectArrayDumpRecord() {
        long id = this.readId();
        int stackTraceSerialNumber = this.readInt();
        int arrayLength = this.readInt();
        long arrayClassId = this.readId();
        long[] elementIds = this.readIdArray(arrayLength);
        return new HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord(id, stackTraceSerialNumber, arrayClassId, elementIds);
    }

    public final void skipClassDumpHeader() {
        this.skip(INT_SIZE * 2 + this.identifierByteSize * 7);
        this.skipClassDumpConstantPool();
    }

    public final void skipClassDumpConstantPool() {
        int constantPoolCount = this.readUnsignedShort();
        for (int i = 0; i < constantPoolCount; ++i) {
            this.skip(PrimitiveType.SHORT.getByteSize());
            this.skip(this.sizeOf(this.readUnsignedByte()));
        }
    }

    public final void skipClassDumpStaticFields() {
        int staticFieldCount = this.readUnsignedShort();
        for (int i = 0; i < staticFieldCount; ++i) {
            this.skip(this.identifierByteSize);
            int type = this.readUnsignedByte();
            this.skip(type == 2 ? this.identifierByteSize : ((Number)MapsKt.getValue(PrimitiveType.Companion.getByteSizeByHprofType(), (Object)type)).intValue());
        }
    }

    public final void skipClassDumpFields() {
        int fieldCount = this.readUnsignedShort();
        this.skip((this.identifierByteSize + 1) * fieldCount);
    }

    public final void skipInstanceDumpRecord() {
        this.skip(this.identifierByteSize + INT_SIZE + this.identifierByteSize);
        int remainingBytesInInstance = this.readInt();
        this.skip(remainingBytesInInstance);
    }

    public final void skipClassDumpRecord() {
        this.skip(this.identifierByteSize + INT_SIZE + this.identifierByteSize + this.identifierByteSize + this.identifierByteSize + this.identifierByteSize + this.identifierByteSize + this.identifierByteSize + INT_SIZE);
        int constantPoolCount = this.readUnsignedShort();
        for (int i = 0; i < constantPoolCount; ++i) {
            this.skip(SHORT_SIZE);
            this.skip(this.typeSizes[this.readUnsignedByte()]);
        }
        int staticFieldCount = this.readUnsignedShort();
        for (int i = 0; i < staticFieldCount; ++i) {
            this.skip(this.identifierByteSize);
            int type = this.readUnsignedByte();
            this.skip(this.typeSizes[type]);
        }
        int fieldCount = this.readUnsignedShort();
        this.skip(fieldCount * (this.identifierByteSize + BYTE_SIZE));
    }

    public final void skipObjectArrayDumpRecord() {
        this.skip(this.identifierByteSize + INT_SIZE);
        int arrayLength = this.readInt();
        this.skip(this.identifierByteSize + arrayLength * this.identifierByteSize);
    }

    public final void skipPrimitiveArrayDumpRecord() {
        this.skip(this.identifierByteSize + INT_SIZE);
        int arrayLength = this.readInt();
        int type = this.readUnsignedByte();
        this.skip(arrayLength * this.typeSizes[type]);
    }

    public final void skipHeapDumpInfoRecord() {
        this.skip(this.identifierByteSize + this.identifierByteSize);
    }

    public final void skip(int byteCount) {
        this.bytesRead += (long)byteCount;
        this.source.skip((long)byteCount);
    }

    public final void skipId() {
        this.skip(this.identifierByteSize);
    }

    public final void skip(long byteCount) {
        this.bytesRead += byteCount;
        this.source.skip(byteCount);
    }

    public final long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @NotNull
    public final ValueHolder readValue(int type) {
        ValueHolder valueHolder;
        int n = type;
        if (n == 2) {
            valueHolder = new ValueHolder.ReferenceHolder(this.readId());
        } else if (n == BOOLEAN_TYPE) {
            valueHolder = new ValueHolder.BooleanHolder(this.readBoolean());
        } else if (n == CHAR_TYPE) {
            valueHolder = new ValueHolder.CharHolder(this.readChar());
        } else if (n == FLOAT_TYPE) {
            valueHolder = new ValueHolder.FloatHolder(this.readFloat());
        } else if (n == DOUBLE_TYPE) {
            valueHolder = new ValueHolder.DoubleHolder(this.readDouble());
        } else if (n == BYTE_TYPE) {
            valueHolder = new ValueHolder.ByteHolder(this.readByte());
        } else if (n == SHORT_TYPE) {
            valueHolder = new ValueHolder.ShortHolder(this.readShort());
        } else if (n == INT_TYPE) {
            valueHolder = new ValueHolder.IntHolder(this.readInt());
        } else if (n == LONG_TYPE) {
            valueHolder = new ValueHolder.LongHolder(this.readLong());
        } else {
            throw new IllegalStateException("Unknown type " + type);
        }
        return valueHolder;
    }

    public final short readShort() {
        this.bytesRead += (long)SHORT_SIZE;
        return this.source.readShort();
    }

    public final int readInt() {
        this.bytesRead += (long)INT_SIZE;
        return this.source.readInt();
    }

    @NotNull
    public final long[] readIdArray(int arrayLength) {
        int n = 0;
        long[] lArray = new long[arrayLength];
        while (n < arrayLength) {
            int n2 = n++;
            lArray[n2] = this.readId();
        }
        return lArray;
    }

    @NotNull
    public final boolean[] readBooleanArray(int arrayLength) {
        boolean[] blArray = new boolean[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            int n = i;
            blArray[n] = this.readByte() != 0;
        }
        return blArray;
    }

    @NotNull
    public final char[] readCharArray(int arrayLength) {
        int n = 0;
        char[] cArray = new char[arrayLength];
        while (n < arrayLength) {
            int n2 = n++;
            cArray[n2] = this.readChar();
        }
        return cArray;
    }

    @NotNull
    public final String readString(int byteCount, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.bytesRead += (long)byteCount;
        String string = this.source.readString((long)byteCount, charset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.readString(byteCount.toLong(), charset)");
        return string;
    }

    @NotNull
    public final float[] readFloatArray(int arrayLength) {
        int n = 0;
        float[] fArray = new float[arrayLength];
        while (n < arrayLength) {
            int n2 = n++;
            fArray[n2] = this.readFloat();
        }
        return fArray;
    }

    @NotNull
    public final double[] readDoubleArray(int arrayLength) {
        int n = 0;
        double[] dArray = new double[arrayLength];
        while (n < arrayLength) {
            int n2 = n++;
            dArray[n2] = this.readDouble();
        }
        return dArray;
    }

    @NotNull
    public final short[] readShortArray(int arrayLength) {
        int n = 0;
        short[] sArray = new short[arrayLength];
        while (n < arrayLength) {
            int n2 = n++;
            sArray[n2] = this.readShort();
        }
        return sArray;
    }

    @NotNull
    public final int[] readIntArray(int arrayLength) {
        int n = 0;
        int[] nArray = new int[arrayLength];
        while (n < arrayLength) {
            int n2 = n++;
            nArray[n2] = this.readInt();
        }
        return nArray;
    }

    @NotNull
    public final long[] readLongArray(int arrayLength) {
        int n = 0;
        long[] lArray = new long[arrayLength];
        while (n < arrayLength) {
            int n2 = n++;
            lArray[n2] = this.readLong();
        }
        return lArray;
    }

    public final long readLong() {
        this.bytesRead += (long)LONG_SIZE;
        return this.source.readLong();
    }

    public final byte readByte() {
        this.bytesRead += (long)BYTE_SIZE;
        return this.source.readByte();
    }

    public final boolean readBoolean() {
        this.bytesRead += (long)BOOLEAN_SIZE;
        return this.source.readByte() != 0;
    }

    @NotNull
    public final byte[] readByteArray(int byteCount) {
        this.bytesRead += (long)byteCount;
        byte[] byArray = this.source.readByteArray((long)byteCount);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"source.readByteArray(byteCount.toLong())");
        return byArray;
    }

    public final char readChar() {
        return this.readString(CHAR_SIZE, Charsets.UTF_16BE).charAt(0);
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public final long readId() {
        long l;
        switch (this.identifierByteSize) {
            case 1: {
                l = this.readByte();
                break;
            }
            case 2: {
                l = this.readShort();
                break;
            }
            case 4: {
                l = this.readInt();
                break;
            }
            case 8: {
                l = this.readLong();
                break;
            }
            default: {
                throw new IllegalArgumentException("ID Length must be 1, 2, 4, or 8");
            }
        }
        return l;
    }

    @NotNull
    public final String readUtf8(long byteCount) {
        this.bytesRead += byteCount;
        String string = this.source.readUtf8(byteCount);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.readUtf8(byteCount)");
        return string;
    }

    public final int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lshark/HprofRecordReader$Companion;", "", "()V", "BOOLEAN_SIZE", "", "BOOLEAN_TYPE", "BYTE_MASK", "BYTE_SIZE", "BYTE_TYPE", "CHAR_SIZE", "CHAR_TYPE", "DOUBLE_TYPE", "FLOAT_TYPE", "INT_MASK", "", "INT_SIZE", "INT_TYPE", "LONG_SIZE", "LONG_TYPE", "SHORT_SIZE", "SHORT_TYPE", "shark-hprof"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

