/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import shark.GcRoot;
import shark.HprofHeader;
import shark.HprofRecord;
import shark.HprofRecordTag;
import shark.PrimitiveType;
import shark.SharkLog;
import shark.ValueHolder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\u0010\u0019\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0002\u0010\u0015\n\u0002\u0010\u0016\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 32\u00020\u0001:\u00013B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\f*\u00020\u0003H\u0002J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0018H\u0002J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u001aH\u0002J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u001bH\u0002J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u001cH\u0002J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u001dH\u0002J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u001e\u001a\u00020\f*\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u00020\f*\u00020\u00032\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\f*\u00020\u00032\u0006\u0010\u001f\u001a\u00020$H\u0002J\u0014\u0010%\u001a\u00020\f*\u00020\u00032\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010(\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u001cH\u0002J-\u0010)\u001a\u00020\f*\u00020\u00032\u0006\u0010*\u001a\u00020+2\u0017\u0010,\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0-\u00a2\u0006\u0002\b.H\u0002J\u001c\u0010/\u001a\u00020\f*\u00020\u00032\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u00020'H\u0002J\u0014\u00101\u001a\u00020\f*\u00020\u00032\u0006\u00102\u001a\u00020\u0011H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lshark/HprofWriter;", "Ljava/io/Closeable;", "sink", "Lokio/BufferedSink;", "hprofHeader", "Lshark/HprofHeader;", "(Lokio/BufferedSink;Lshark/HprofHeader;)V", "getHprofHeader", "()Lshark/HprofHeader;", "workBuffer", "Lokio/Buffer;", "close", "", "valuesToBytes", "", "values", "", "Lshark/ValueHolder;", "write", "record", "Lshark/HprofRecord;", "flushHeapBuffer", "array", "", "", "", "", "", "", "", "writeBoolean", "value", "", "writeDouble", "", "writeFloat", "", "writeId", "id", "", "writeIdArray", "writeNonHeapRecord", "tag", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "writeTagHeader", "length", "writeValue", "wrapper", "Companion", "shark-hprof"})
@SourceDebugExtension(value={"SMAP\nHprofWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HprofWriter.kt\nshark/HprofWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SharkLog.kt\nshark/SharkLog\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,471:1\n1855#2,2:472\n1855#2,2:474\n1855#2,2:476\n34#3,3:478\n13607#4,2:481\n13628#4,2:483\n13614#4,2:485\n13621#4,2:487\n13593#4,2:489\n13600#4,2:491\n13607#4,2:493\n*S KotlinDebug\n*F\n+ 1 HprofWriter.kt\nshark/HprofWriter\n*L\n115#1:472,2\n269#1:474,2\n275#1:476,2\n363#1:478,3\n381#1:481,2\n385#1:483,2\n393#1:485,2\n397#1:487,2\n401#1:489,2\n405#1:491,2\n409#1:493,2\n*E\n"})
public final class HprofWriter
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSink sink;
    @NotNull
    private final HprofHeader hprofHeader;
    @NotNull
    private final Buffer workBuffer;

    private HprofWriter(BufferedSink sink, HprofHeader hprofHeader) {
        this.sink = sink;
        this.hprofHeader = hprofHeader;
        this.workBuffer = new Buffer();
    }

    @NotNull
    public final HprofHeader getHprofHeader() {
        return this.hprofHeader;
    }

    public final void write(@NotNull HprofRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        this.write(this.sink, record);
    }

    @NotNull
    public final byte[] valuesToBytes(@NotNull List<? extends ValueHolder> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Buffer valuesBuffer = new Buffer();
        Iterable $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ValueHolder value = (ValueHolder)element$iv;
            boolean bl = false;
            this.writeValue((BufferedSink)valuesBuffer, value);
        }
        byte[] byArray = valuesBuffer.readByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"valuesBuffer.readByteArray()");
        return byArray;
    }

    @Override
    public void close() {
        this.flushHeapBuffer(this.sink);
        this.sink.close();
    }

    private final void writeValue(BufferedSink $this$writeValue, ValueHolder wrapper) {
        ValueHolder valueHolder = wrapper;
        if (valueHolder instanceof ValueHolder.ReferenceHolder) {
            this.writeId($this$writeValue, ((ValueHolder.ReferenceHolder)wrapper).getValue());
        } else if (valueHolder instanceof ValueHolder.BooleanHolder) {
            this.writeBoolean($this$writeValue, ((ValueHolder.BooleanHolder)wrapper).getValue());
        } else if (valueHolder instanceof ValueHolder.CharHolder) {
            char[] cArray = new char[]{((ValueHolder.CharHolder)wrapper).getValue()};
            this.write($this$writeValue, cArray);
        } else if (valueHolder instanceof ValueHolder.FloatHolder) {
            this.writeFloat($this$writeValue, ((ValueHolder.FloatHolder)wrapper).getValue());
        } else if (valueHolder instanceof ValueHolder.DoubleHolder) {
            this.writeDouble($this$writeValue, ((ValueHolder.DoubleHolder)wrapper).getValue());
        } else if (valueHolder instanceof ValueHolder.ByteHolder) {
            $this$writeValue.writeByte((int)((ValueHolder.ByteHolder)wrapper).getValue());
        } else if (valueHolder instanceof ValueHolder.ShortHolder) {
            $this$writeValue.writeShort((int)((ValueHolder.ShortHolder)wrapper).getValue());
        } else if (valueHolder instanceof ValueHolder.IntHolder) {
            $this$writeValue.writeInt(((ValueHolder.IntHolder)wrapper).getValue());
        } else if (valueHolder instanceof ValueHolder.LongHolder) {
            $this$writeValue.writeLong(((ValueHolder.LongHolder)wrapper).getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void write(BufferedSink $this$write, HprofRecord record) {
        HprofRecord hprofRecord = record;
        if (hprofRecord instanceof HprofRecord.StringRecord) {
            this.writeNonHeapRecord($this$write, HprofRecordTag.STRING_IN_UTF8.getTag(), (Function1<? super BufferedSink, Unit>)((Function1)new Function1<BufferedSink, Unit>(this, record){
                final /* synthetic */ HprofWriter this$0;
                final /* synthetic */ HprofRecord $record;
                {
                    this.this$0 = $receiver;
                    this.$record = $record;
                    super(1);
                }

                public final void invoke(@NotNull BufferedSink $this$writeNonHeapRecord) {
                    Intrinsics.checkNotNullParameter((Object)$this$writeNonHeapRecord, (String)"$this$writeNonHeapRecord");
                    HprofWriter.access$writeId(this.this$0, $this$writeNonHeapRecord, ((HprofRecord.StringRecord)this.$record).getId());
                    $this$writeNonHeapRecord.writeUtf8(((HprofRecord.StringRecord)this.$record).getString());
                }
            }));
            return;
        } else if (hprofRecord instanceof HprofRecord.LoadClassRecord) {
            this.writeNonHeapRecord($this$write, HprofRecordTag.LOAD_CLASS.getTag(), (Function1<? super BufferedSink, Unit>)((Function1)new Function1<BufferedSink, Unit>(record, this){
                final /* synthetic */ HprofRecord $record;
                final /* synthetic */ HprofWriter this$0;
                {
                    this.$record = $record;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BufferedSink $this$writeNonHeapRecord) {
                    Intrinsics.checkNotNullParameter((Object)$this$writeNonHeapRecord, (String)"$this$writeNonHeapRecord");
                    $this$writeNonHeapRecord.writeInt(((HprofRecord.LoadClassRecord)this.$record).getClassSerialNumber());
                    HprofWriter.access$writeId(this.this$0, $this$writeNonHeapRecord, ((HprofRecord.LoadClassRecord)this.$record).getId());
                    $this$writeNonHeapRecord.writeInt(((HprofRecord.LoadClassRecord)this.$record).getStackTraceSerialNumber());
                    HprofWriter.access$writeId(this.this$0, $this$writeNonHeapRecord, ((HprofRecord.LoadClassRecord)this.$record).getClassNameStringId());
                }
            }));
            return;
        } else if (hprofRecord instanceof HprofRecord.StackTraceRecord) {
            this.writeNonHeapRecord($this$write, HprofRecordTag.STACK_TRACE.getTag(), (Function1<? super BufferedSink, Unit>)((Function1)new Function1<BufferedSink, Unit>(record, this){
                final /* synthetic */ HprofRecord $record;
                final /* synthetic */ HprofWriter this$0;
                {
                    this.$record = $record;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull BufferedSink $this$writeNonHeapRecord) {
                    Intrinsics.checkNotNullParameter((Object)$this$writeNonHeapRecord, (String)"$this$writeNonHeapRecord");
                    $this$writeNonHeapRecord.writeInt(((HprofRecord.StackTraceRecord)this.$record).getStackTraceSerialNumber());
                    $this$writeNonHeapRecord.writeInt(((HprofRecord.StackTraceRecord)this.$record).getThreadSerialNumber());
                    $this$writeNonHeapRecord.writeInt(((HprofRecord.StackTraceRecord)this.$record).getStackFrameIds().length);
                    HprofWriter.access$writeIdArray(this.this$0, $this$writeNonHeapRecord, ((HprofRecord.StackTraceRecord)this.$record).getStackFrameIds());
                }
            }));
            return;
        } else if (hprofRecord instanceof HprofRecord.HeapDumpRecord.GcRootRecord) {
            Buffer $this$write_u24lambda_u241 = this.workBuffer;
            boolean bl = false;
            GcRoot gcRoot = ((HprofRecord.HeapDumpRecord.GcRootRecord)record).getGcRoot();
            if (gcRoot instanceof GcRoot.Unknown) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_UNKNOWN.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                return;
            } else if (gcRoot instanceof GcRoot.JniGlobal) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_JNI_GLOBAL.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, ((GcRoot.JniGlobal)gcRoot).getJniGlobalRefId());
                return;
            } else if (gcRoot instanceof GcRoot.JniLocal) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_JNI_LOCAL.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                $this$write_u24lambda_u241.writeInt(((GcRoot.JniLocal)gcRoot).getThreadSerialNumber());
                $this$write_u24lambda_u241.writeInt(((GcRoot.JniLocal)gcRoot).getFrameNumber());
                return;
            } else if (gcRoot instanceof GcRoot.JavaFrame) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_JAVA_FRAME.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                $this$write_u24lambda_u241.writeInt(((GcRoot.JavaFrame)gcRoot).getThreadSerialNumber());
                $this$write_u24lambda_u241.writeInt(((GcRoot.JavaFrame)gcRoot).getFrameNumber());
                return;
            } else if (gcRoot instanceof GcRoot.NativeStack) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_NATIVE_STACK.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                $this$write_u24lambda_u241.writeInt(((GcRoot.NativeStack)gcRoot).getThreadSerialNumber());
                return;
            } else if (gcRoot instanceof GcRoot.StickyClass) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_STICKY_CLASS.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                return;
            } else if (gcRoot instanceof GcRoot.ThreadBlock) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_THREAD_BLOCK.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                $this$write_u24lambda_u241.writeInt(((GcRoot.ThreadBlock)gcRoot).getThreadSerialNumber());
                return;
            } else if (gcRoot instanceof GcRoot.MonitorUsed) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_MONITOR_USED.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                return;
            } else if (gcRoot instanceof GcRoot.ThreadObject) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_THREAD_OBJECT.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                $this$write_u24lambda_u241.writeInt(((GcRoot.ThreadObject)gcRoot).getThreadSerialNumber());
                $this$write_u24lambda_u241.writeInt(((GcRoot.ThreadObject)gcRoot).getStackTraceSerialNumber());
                return;
            } else if (gcRoot instanceof GcRoot.ReferenceCleanup) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_REFERENCE_CLEANUP.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                return;
            } else if (gcRoot instanceof GcRoot.VmInternal) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_VM_INTERNAL.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                return;
            } else if (gcRoot instanceof GcRoot.JniMonitor) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_JNI_MONITOR.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                $this$write_u24lambda_u241.writeInt(((GcRoot.JniMonitor)gcRoot).getStackTraceSerialNumber());
                $this$write_u24lambda_u241.writeInt(((GcRoot.JniMonitor)gcRoot).getStackDepth());
                return;
            } else if (gcRoot instanceof GcRoot.InternedString) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_INTERNED_STRING.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                return;
            } else if (gcRoot instanceof GcRoot.Finalizing) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_FINALIZING.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                return;
            } else if (gcRoot instanceof GcRoot.Debugger) {
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_DEBUGGER.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
                return;
            } else {
                if (!(gcRoot instanceof GcRoot.Unreachable)) throw new NoWhenBranchMatchedException();
                $this$write_u24lambda_u241.writeByte(HprofRecordTag.ROOT_UNREACHABLE.getTag());
                this.writeId((BufferedSink)$this$write_u24lambda_u241, gcRoot.getId());
            }
            return;
        } else if (hprofRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord) {
            Object field;
            Buffer $this$write_u24lambda_u244 = this.workBuffer;
            boolean bl = false;
            $this$write_u24lambda_u244.writeByte(HprofRecordTag.CLASS_DUMP.getTag());
            this.writeId((BufferedSink)$this$write_u24lambda_u244, ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getId());
            $this$write_u24lambda_u244.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getStackTraceSerialNumber());
            this.writeId((BufferedSink)$this$write_u24lambda_u244, ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getSuperclassId());
            this.writeId((BufferedSink)$this$write_u24lambda_u244, ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getClassLoaderId());
            this.writeId((BufferedSink)$this$write_u24lambda_u244, ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getSignersId());
            this.writeId((BufferedSink)$this$write_u24lambda_u244, ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getProtectionDomainId());
            this.writeId((BufferedSink)$this$write_u24lambda_u244, 0L);
            this.writeId((BufferedSink)$this$write_u24lambda_u244, 0L);
            $this$write_u24lambda_u244.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getInstanceSize());
            int constantPoolCount = 0;
            $this$write_u24lambda_u244.writeShort(constantPoolCount);
            $this$write_u24lambda_u244.writeShort(((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getStaticFields().size());
            Iterable $this$forEach$iv = ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getStaticFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                field = (HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord)element$iv;
                boolean bl2 = false;
                this.writeId((BufferedSink)$this$write_u24lambda_u244, ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord)field).getNameStringId());
                $this$write_u24lambda_u244.writeByte(((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord)field).getType());
                this.writeValue((BufferedSink)$this$write_u24lambda_u244, ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord)field).getValue());
            }
            $this$write_u24lambda_u244.writeShort(((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getFields().size());
            $this$forEach$iv = ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)record).getFields();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                field = (HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord)element$iv;
                boolean bl3 = false;
                this.writeId((BufferedSink)$this$write_u24lambda_u244, ((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord)field).getNameStringId());
                $this$write_u24lambda_u244.writeByte(((HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord)field).getType());
            }
            return;
        } else if (hprofRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord) {
            Buffer $this$write_u24lambda_u245 = this.workBuffer;
            boolean bl = false;
            $this$write_u24lambda_u245.writeByte(HprofRecordTag.INSTANCE_DUMP.getTag());
            this.writeId((BufferedSink)$this$write_u24lambda_u245, ((HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)record).getId());
            $this$write_u24lambda_u245.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)record).getStackTraceSerialNumber());
            this.writeId((BufferedSink)$this$write_u24lambda_u245, ((HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)record).getClassId());
            $this$write_u24lambda_u245.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)record).getFieldValues().length);
            $this$write_u24lambda_u245.write(((HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)record).getFieldValues());
            return;
        } else if (hprofRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord) {
            Buffer $this$write_u24lambda_u246 = this.workBuffer;
            boolean bl = false;
            $this$write_u24lambda_u246.writeByte(HprofRecordTag.OBJECT_ARRAY_DUMP.getTag());
            this.writeId((BufferedSink)$this$write_u24lambda_u246, ((HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)record).getId());
            $this$write_u24lambda_u246.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)record).getStackTraceSerialNumber());
            $this$write_u24lambda_u246.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)record).getElementIds().length);
            this.writeId((BufferedSink)$this$write_u24lambda_u246, ((HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)record).getArrayClassId());
            this.writeIdArray((BufferedSink)$this$write_u24lambda_u246, ((HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)record).getElementIds());
            return;
        } else if (hprofRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord) {
            Buffer $this$write_u24lambda_u247 = this.workBuffer;
            boolean bl = false;
            $this$write_u24lambda_u247.writeByte(HprofRecordTag.PRIMITIVE_ARRAY_DUMP.getTag());
            this.writeId((BufferedSink)$this$write_u24lambda_u247, ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord)record).getId());
            $this$write_u24lambda_u247.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord)record).getStackTraceSerialNumber());
            HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord constantPoolCount = (HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord)record;
            if (constantPoolCount instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.BooleanArrayDump) {
                $this$write_u24lambda_u247.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.BooleanArrayDump)record).getArray().length);
                $this$write_u24lambda_u247.writeByte(PrimitiveType.BOOLEAN.getHprofType());
                this.write((BufferedSink)$this$write_u24lambda_u247, ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.BooleanArrayDump)record).getArray());
                return;
            } else if (constantPoolCount instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.CharArrayDump) {
                $this$write_u24lambda_u247.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.CharArrayDump)record).getArray().length);
                $this$write_u24lambda_u247.writeByte(PrimitiveType.CHAR.getHprofType());
                this.write((BufferedSink)$this$write_u24lambda_u247, ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.CharArrayDump)record).getArray());
                return;
            } else if (constantPoolCount instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.FloatArrayDump) {
                $this$write_u24lambda_u247.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.FloatArrayDump)record).getArray().length);
                $this$write_u24lambda_u247.writeByte(PrimitiveType.FLOAT.getHprofType());
                this.write((BufferedSink)$this$write_u24lambda_u247, ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.FloatArrayDump)record).getArray());
                return;
            } else if (constantPoolCount instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.DoubleArrayDump) {
                $this$write_u24lambda_u247.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.DoubleArrayDump)record).getArray().length);
                $this$write_u24lambda_u247.writeByte(PrimitiveType.DOUBLE.getHprofType());
                this.write((BufferedSink)$this$write_u24lambda_u247, ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.DoubleArrayDump)record).getArray());
                return;
            } else if (constantPoolCount instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ByteArrayDump) {
                $this$write_u24lambda_u247.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ByteArrayDump)record).getArray().length);
                $this$write_u24lambda_u247.writeByte(PrimitiveType.BYTE.getHprofType());
                $this$write_u24lambda_u247.write(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ByteArrayDump)record).getArray());
                return;
            } else if (constantPoolCount instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ShortArrayDump) {
                $this$write_u24lambda_u247.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ShortArrayDump)record).getArray().length);
                $this$write_u24lambda_u247.writeByte(PrimitiveType.SHORT.getHprofType());
                this.write((BufferedSink)$this$write_u24lambda_u247, ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ShortArrayDump)record).getArray());
                return;
            } else if (constantPoolCount instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.IntArrayDump) {
                $this$write_u24lambda_u247.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.IntArrayDump)record).getArray().length);
                $this$write_u24lambda_u247.writeByte(PrimitiveType.INT.getHprofType());
                this.write((BufferedSink)$this$write_u24lambda_u247, ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.IntArrayDump)record).getArray());
                return;
            } else {
                if (!(constantPoolCount instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.LongArrayDump)) throw new NoWhenBranchMatchedException();
                $this$write_u24lambda_u247.writeInt(((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.LongArrayDump)record).getArray().length);
                $this$write_u24lambda_u247.writeByte(PrimitiveType.LONG.getHprofType());
                this.write((BufferedSink)$this$write_u24lambda_u247, ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.LongArrayDump)record).getArray());
            }
            return;
        } else if (hprofRecord instanceof HprofRecord.HeapDumpRecord.HeapDumpInfoRecord) {
            Buffer $this$write_u24lambda_u248 = this.workBuffer;
            boolean bl = false;
            $this$write_u24lambda_u248.writeByte(HprofRecordTag.HEAP_DUMP_INFO.getTag());
            $this$write_u24lambda_u248.writeInt(((HprofRecord.HeapDumpRecord.HeapDumpInfoRecord)record).getHeapId());
            this.writeId((BufferedSink)$this$write_u24lambda_u248, ((HprofRecord.HeapDumpRecord.HeapDumpInfoRecord)record).getHeapNameStringId());
            return;
        } else {
            SharkLog.Logger logger$iv;
            if (hprofRecord instanceof HprofRecord.HeapDumpEndRecord) {
                throw new IllegalArgumentException("HprofWriter automatically emits HeapDumpEndRecord");
            }
            if (!(hprofRecord instanceof HprofRecord.StackFrameRecord)) return;
            SharkLog this_$iv = SharkLog.INSTANCE;
            boolean $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) return;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            logger2.d("Ignoring writing of StackFrameRecord, not supported yet.");
        }
    }

    private final void writeDouble(BufferedSink $this$writeDouble, double value) {
        $this$writeDouble.writeLong(Double.doubleToLongBits(value));
    }

    private final void writeFloat(BufferedSink $this$writeFloat, float value) {
        $this$writeFloat.writeInt(Float.floatToIntBits(value));
    }

    private final void writeBoolean(BufferedSink $this$writeBoolean, boolean value) {
        $this$writeBoolean.writeByte(value ? 1 : 0);
    }

    private final void writeIdArray(BufferedSink $this$writeIdArray, long[] array) {
        long[] $this$forEach$iv = array;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            long element$iv;
            long it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.writeId($this$writeIdArray, it);
        }
    }

    private final void write(BufferedSink $this$write, boolean[] array) {
        boolean[] $this$forEach$iv = array;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            boolean element$iv;
            boolean it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $this$write.writeByte(it ? 1 : 0);
        }
    }

    private final void write(BufferedSink $this$write, char[] array) {
        $this$write.writeString(new String(array), Charsets.UTF_16BE);
    }

    private final void write(BufferedSink $this$write, float[] array) {
        float[] $this$forEach$iv = array;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            float element$iv;
            float it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.writeFloat($this$write, it);
        }
    }

    private final void write(BufferedSink $this$write, double[] array) {
        double[] $this$forEach$iv = array;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            double element$iv;
            double it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.writeDouble($this$write, it);
        }
    }

    private final void write(BufferedSink $this$write, short[] array) {
        short[] $this$forEach$iv = array;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            short element$iv;
            short it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $this$write.writeShort((int)it);
        }
    }

    private final void write(BufferedSink $this$write, int[] array) {
        int[] $this$forEach$iv = array;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $this$write.writeInt(it);
        }
    }

    private final void write(BufferedSink $this$write, long[] array) {
        long[] $this$forEach$iv = array;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            long element$iv;
            long it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $this$write.writeLong(it);
        }
    }

    private final void writeNonHeapRecord(BufferedSink $this$writeNonHeapRecord, int tag, Function1<? super BufferedSink, Unit> block) {
        this.flushHeapBuffer($this$writeNonHeapRecord);
        block.invoke((Object)this.workBuffer);
        this.writeTagHeader($this$writeNonHeapRecord, tag, this.workBuffer.size());
        $this$writeNonHeapRecord.writeAll((Source)this.workBuffer);
    }

    private final void flushHeapBuffer(BufferedSink $this$flushHeapBuffer) {
        if (this.workBuffer.size() > 0L) {
            this.writeTagHeader($this$flushHeapBuffer, HprofRecordTag.HEAP_DUMP.getTag(), this.workBuffer.size());
            $this$flushHeapBuffer.writeAll((Source)this.workBuffer);
            this.writeTagHeader($this$flushHeapBuffer, HprofRecordTag.HEAP_DUMP_END.getTag(), 0L);
        }
    }

    private final void writeTagHeader(BufferedSink $this$writeTagHeader, int tag, long length) {
        $this$writeTagHeader.writeByte(tag);
        $this$writeTagHeader.writeInt(0);
        $this$writeTagHeader.writeInt((int)length);
    }

    private final void writeId(BufferedSink $this$writeId, long id) {
        switch (this.hprofHeader.getIdentifierByteSize()) {
            case 1: {
                $this$writeId.writeByte((int)id);
                break;
            }
            case 2: {
                $this$writeId.writeShort((int)id);
                break;
            }
            case 4: {
                $this$writeId.writeInt((int)id);
                break;
            }
            case 8: {
                $this$writeId.writeLong(id);
                break;
            }
            default: {
                throw new IllegalArgumentException("ID Length must be 1, 2, 4, or 8");
            }
        }
    }

    public static final /* synthetic */ void access$writeId(HprofWriter $this, BufferedSink $receiver, long id) {
        $this.writeId($receiver, id);
    }

    public static final /* synthetic */ void access$writeIdArray(HprofWriter $this, BufferedSink $receiver, long[] array) {
        $this.writeIdArray($receiver, array);
    }

    public /* synthetic */ HprofWriter(BufferedSink sink, HprofHeader hprofHeader, DefaultConstructorMarker $constructor_marker) {
        this(sink, hprofHeader);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lshark/HprofWriter$Companion;", "", "()V", "openWriterFor", "Lshark/HprofWriter;", "hprofFile", "Ljava/io/File;", "hprofHeader", "Lshark/HprofHeader;", "hprofSink", "Lokio/BufferedSink;", "shark-hprof"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HprofWriter openWriterFor(@NotNull File hprofFile, @NotNull HprofHeader hprofHeader) {
            Intrinsics.checkNotNullParameter((Object)hprofFile, (String)"hprofFile");
            Intrinsics.checkNotNullParameter((Object)hprofHeader, (String)"hprofHeader");
            BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink((OutputStream)new FileOutputStream(hprofFile)));
            Intrinsics.checkNotNullExpressionValue((Object)bufferedSink, (String)"buffer(Okio.sink(hprofFile.outputStream()))");
            return this.openWriterFor(bufferedSink, hprofHeader);
        }

        public static /* synthetic */ HprofWriter openWriterFor$default(Companion companion, File file, HprofHeader hprofHeader, int n, Object object) {
            if ((n & 2) != 0) {
                hprofHeader = new HprofHeader(0L, null, 0, 7, null);
            }
            return companion.openWriterFor(file, hprofHeader);
        }

        @NotNull
        public final HprofWriter openWriterFor(@NotNull BufferedSink hprofSink, @NotNull HprofHeader hprofHeader) {
            Intrinsics.checkNotNullParameter((Object)hprofSink, (String)"hprofSink");
            Intrinsics.checkNotNullParameter((Object)hprofHeader, (String)"hprofHeader");
            hprofSink.writeUtf8(hprofHeader.getVersion().getVersionString());
            hprofSink.writeByte(0);
            hprofSink.writeInt(hprofHeader.getIdentifierByteSize());
            hprofSink.writeLong(hprofHeader.getHeapDumpTimestamp());
            return new HprofWriter(hprofSink, hprofHeader, null);
        }

        public static /* synthetic */ HprofWriter openWriterFor$default(Companion companion, BufferedSink bufferedSink, HprofHeader hprofHeader, int n, Object object) {
            if ((n & 2) != 0) {
                hprofHeader = new HprofHeader(0L, null, 0, 7, null);
            }
            return companion.openWriterFor(bufferedSink, hprofHeader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

