/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import shark.FileSourceProvider;
import shark.HprofHeader;
import shark.HprofRecordReader;
import shark.HprofRecordTag;
import shark.OnHprofRecordTagListener;
import shark.PrimitiveType;
import shark.StreamingSourceProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lshark/StreamingHprofReader;", "", "sourceProvider", "Lshark/StreamingSourceProvider;", "header", "Lshark/HprofHeader;", "(Lshark/StreamingSourceProvider;Lshark/HprofHeader;)V", "readRecords", "", "recordTags", "", "Lshark/HprofRecordTag;", "listener", "Lshark/OnHprofRecordTagListener;", "Companion", "shark-hprof"})
public final class StreamingHprofReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StreamingSourceProvider sourceProvider;
    @NotNull
    private final HprofHeader header;

    private StreamingHprofReader(StreamingSourceProvider sourceProvider, HprofHeader header) {
        this.sourceProvider = sourceProvider;
        this.header = header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long readRecords(@NotNull Set<? extends HprofRecordTag> recordTags, @NotNull OnHprofRecordTagListener listener) {
        long l;
        Intrinsics.checkNotNullParameter(recordTags, (String)"recordTags");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Closeable closeable = (Closeable)this.sourceProvider.openStreamingSource();
        Throwable throwable = null;
        try {
            BufferedSource source = (BufferedSource)closeable;
            boolean bl = false;
            HprofRecordReader reader = new HprofRecordReader(this.header, source);
            reader.skip(this.header.getRecordsPosition());
            int intByteSize = PrimitiveType.INT.getByteSize();
            int identifierByteSize = reader.sizeOf(2);
            while (!source.exhausted()) {
                int tag = reader.readUnsignedByte();
                reader.skip(intByteSize);
                long length = reader.readUnsignedInt();
                int n = tag;
                if (n == HprofRecordTag.STRING_IN_UTF8.getTag()) {
                    if (recordTags.contains((Object)HprofRecordTag.STRING_IN_UTF8)) {
                        listener.onHprofRecord(HprofRecordTag.STRING_IN_UTF8, length, reader);
                        continue;
                    }
                    reader.skip(length);
                    continue;
                }
                if (n == HprofRecordTag.UNLOAD_CLASS.getTag()) {
                    if (recordTags.contains((Object)HprofRecordTag.UNLOAD_CLASS)) {
                        listener.onHprofRecord(HprofRecordTag.UNLOAD_CLASS, length, reader);
                        continue;
                    }
                    reader.skip(length);
                    continue;
                }
                if (n == HprofRecordTag.LOAD_CLASS.getTag()) {
                    if (recordTags.contains((Object)HprofRecordTag.LOAD_CLASS)) {
                        listener.onHprofRecord(HprofRecordTag.LOAD_CLASS, length, reader);
                        continue;
                    }
                    reader.skip(length);
                    continue;
                }
                if (n == HprofRecordTag.STACK_FRAME.getTag()) {
                    if (recordTags.contains((Object)HprofRecordTag.STACK_FRAME)) {
                        listener.onHprofRecord(HprofRecordTag.STACK_FRAME, length, reader);
                        continue;
                    }
                    reader.skip(length);
                    continue;
                }
                if (n == HprofRecordTag.STACK_TRACE.getTag()) {
                    if (recordTags.contains((Object)HprofRecordTag.STACK_TRACE)) {
                        listener.onHprofRecord(HprofRecordTag.STACK_TRACE, length, reader);
                        continue;
                    }
                    reader.skip(length);
                    continue;
                }
                if (n == HprofRecordTag.HEAP_DUMP.getTag() ? true : n == HprofRecordTag.HEAP_DUMP_SEGMENT.getTag()) {
                    long heapDumpStart = reader.getBytesRead();
                    int previousTag = 0;
                    long previousTagPosition = 0L;
                    while (reader.getBytesRead() - heapDumpStart < length) {
                        long heapDumpTagPosition = reader.getBytesRead();
                        int heapDumpTag = reader.readUnsignedByte();
                        int n2 = heapDumpTag;
                        if (n2 == HprofRecordTag.ROOT_UNKNOWN.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_UNKNOWN)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_UNKNOWN, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_JNI_GLOBAL.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_JNI_GLOBAL)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_JNI_GLOBAL, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize + identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_JNI_LOCAL.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_JNI_LOCAL)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_JNI_LOCAL, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize + intByteSize + intByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_JAVA_FRAME.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_JAVA_FRAME)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_JAVA_FRAME, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize + intByteSize + intByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_NATIVE_STACK.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_NATIVE_STACK)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_NATIVE_STACK, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize + intByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_STICKY_CLASS.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_STICKY_CLASS)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_STICKY_CLASS, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_THREAD_BLOCK.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_THREAD_BLOCK)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_THREAD_BLOCK, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize + intByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_MONITOR_USED.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_MONITOR_USED)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_MONITOR_USED, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_THREAD_OBJECT.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_THREAD_OBJECT)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_THREAD_OBJECT, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize + intByteSize + intByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_INTERNED_STRING.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_INTERNED_STRING)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_INTERNED_STRING, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_FINALIZING.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_FINALIZING)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_FINALIZING, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_DEBUGGER.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_DEBUGGER)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_DEBUGGER, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_REFERENCE_CLEANUP.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_REFERENCE_CLEANUP)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_REFERENCE_CLEANUP, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_VM_INTERNAL.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_VM_INTERNAL)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_VM_INTERNAL, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_JNI_MONITOR.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_JNI_MONITOR)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_JNI_MONITOR, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize + intByteSize + intByteSize);
                            }
                        } else if (n2 == HprofRecordTag.ROOT_UNREACHABLE.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.ROOT_UNREACHABLE)) {
                                listener.onHprofRecord(HprofRecordTag.ROOT_UNREACHABLE, -1L, reader);
                            } else {
                                reader.skip(identifierByteSize);
                            }
                        } else if (n2 == HprofRecordTag.CLASS_DUMP.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.CLASS_DUMP)) {
                                listener.onHprofRecord(HprofRecordTag.CLASS_DUMP, -1L, reader);
                            } else {
                                reader.skipClassDumpRecord();
                            }
                        } else if (n2 == HprofRecordTag.INSTANCE_DUMP.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.INSTANCE_DUMP)) {
                                listener.onHprofRecord(HprofRecordTag.INSTANCE_DUMP, -1L, reader);
                            } else {
                                reader.skipInstanceDumpRecord();
                            }
                        } else if (n2 == HprofRecordTag.OBJECT_ARRAY_DUMP.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.OBJECT_ARRAY_DUMP)) {
                                listener.onHprofRecord(HprofRecordTag.OBJECT_ARRAY_DUMP, -1L, reader);
                            } else {
                                reader.skipObjectArrayDumpRecord();
                            }
                        } else if (n2 == HprofRecordTag.PRIMITIVE_ARRAY_DUMP.getTag()) {
                            if (recordTags.contains((Object)HprofRecordTag.PRIMITIVE_ARRAY_DUMP)) {
                                listener.onHprofRecord(HprofRecordTag.PRIMITIVE_ARRAY_DUMP, -1L, reader);
                            } else {
                                reader.skipPrimitiveArrayDumpRecord();
                            }
                        } else {
                            if (n2 == HprofRecordTag.PRIMITIVE_ARRAY_NODATA.getTag()) {
                                throw new UnsupportedOperationException((Object)((Object)HprofRecordTag.PRIMITIVE_ARRAY_NODATA) + " cannot be parsed");
                            }
                            if (n2 == HprofRecordTag.HEAP_DUMP_INFO.getTag()) {
                                if (recordTags.contains((Object)HprofRecordTag.HEAP_DUMP_INFO)) {
                                    listener.onHprofRecord(HprofRecordTag.HEAP_DUMP_INFO, -1L, reader);
                                } else {
                                    reader.skipHeapDumpInfoRecord();
                                }
                            } else {
                                StringBuilder stringBuilder = new StringBuilder().append("Unknown tag ");
                                String string = "0x%02x";
                                Object[] objectArray = new Object[]{heapDumpTag};
                                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                                StringBuilder stringBuilder2 = stringBuilder.append(string2).append(" at ").append(heapDumpTagPosition).append(" after ");
                                string = "0x%02x";
                                objectArray = new Object[]{previousTag};
                                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                                throw new IllegalStateException(stringBuilder2.append(string3).append(" at ").append(previousTagPosition).toString());
                            }
                        }
                        previousTag = heapDumpTag;
                        previousTagPosition = heapDumpTagPosition;
                    }
                    continue;
                }
                if (n == HprofRecordTag.HEAP_DUMP_END.getTag()) {
                    if (!recordTags.contains((Object)HprofRecordTag.HEAP_DUMP_END)) continue;
                    listener.onHprofRecord(HprofRecordTag.HEAP_DUMP_END, length, reader);
                    continue;
                }
                reader.skip(length);
            }
            l = reader.getBytesRead();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return l;
    }

    public /* synthetic */ StreamingHprofReader(StreamingSourceProvider sourceProvider, HprofHeader header, DefaultConstructorMarker $constructor_marker) {
        this(sourceProvider, header);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lshark/StreamingHprofReader$Companion;", "", "()V", "readerFor", "Lshark/StreamingHprofReader;", "hprofFile", "Ljava/io/File;", "hprofHeader", "Lshark/HprofHeader;", "hprofSourceProvider", "Lshark/StreamingSourceProvider;", "shark-hprof"})
    @SourceDebugExtension(value={"SMAP\nStreamingHprofReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingHprofReader.kt\nshark/StreamingHprofReader$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1#2:346\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StreamingHprofReader readerFor(@NotNull File hprofFile, @NotNull HprofHeader hprofHeader) {
            Intrinsics.checkNotNullParameter((Object)hprofFile, (String)"hprofFile");
            Intrinsics.checkNotNullParameter((Object)hprofHeader, (String)"hprofHeader");
            FileSourceProvider sourceProvider = new FileSourceProvider(hprofFile);
            return this.readerFor(sourceProvider, hprofHeader);
        }

        public static /* synthetic */ StreamingHprofReader readerFor$default(Companion companion, File file, HprofHeader hprofHeader, int n, Object object) {
            if ((n & 2) != 0) {
                hprofHeader = HprofHeader.Companion.parseHeaderOf(file);
            }
            return companion.readerFor(file, hprofHeader);
        }

        @NotNull
        public final StreamingHprofReader readerFor(@NotNull StreamingSourceProvider hprofSourceProvider, @NotNull HprofHeader hprofHeader) {
            Intrinsics.checkNotNullParameter((Object)hprofSourceProvider, (String)"hprofSourceProvider");
            Intrinsics.checkNotNullParameter((Object)hprofHeader, (String)"hprofHeader");
            return new StreamingHprofReader(hprofSourceProvider, hprofHeader, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static /* synthetic */ StreamingHprofReader readerFor$default(Companion companion, StreamingSourceProvider streamingSourceProvider, HprofHeader hprofHeader, int n, Object object) {
            if ((n & 2) != 0) {
                HprofHeader hprofHeader2;
                Closeable closeable = (Closeable)streamingSourceProvider.openStreamingSource();
                Throwable throwable = null;
                try {
                    BufferedSource it = (BufferedSource)closeable;
                    boolean bl = false;
                    hprofHeader2 = HprofHeader.Companion.parseHeaderOf(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                hprofHeader = hprofHeader2;
            }
            return companion.readerFor(streamingSourceProvider, hprofHeader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

