/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.HeapGraph;
import shark.HeapObject;
import shark.LibraryLeakReferenceMatcher;
import shark.OnAnalysisProgressListener;
import shark.ReferenceMatcher;
import shark.internal.DominatorTree;
import shark.internal.GcRootProvider;
import shark.internal.Reference;
import shark.internal.ReferencePathNode;
import shark.internal.ReferenceReader;
import shark.internal.hppc.LongScatterSet;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003 !\"B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\f\u0010\u001c\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0018H\u0002J\f\u0010\u001d\u001a\u00020\u001a*\u00020\u0018H\u0002J\u0012\u0010\u001e\u001a\u00020\u001f*\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lshark/internal/PathFinder;", "", "graph", "Lshark/HeapGraph;", "listener", "Lshark/OnAnalysisProgressListener;", "objectReferenceReader", "Lshark/internal/ReferenceReader;", "Lshark/HeapObject;", "referenceMatchers", "", "Lshark/ReferenceMatcher;", "(Lshark/HeapGraph;Lshark/OnAnalysisProgressListener;Lshark/internal/ReferenceReader;Ljava/util/List;)V", "gcRootProvider", "Lshark/internal/GcRootProvider;", "findPathsFromGcRoots", "Lshark/internal/PathFinder$PathFindingResults;", "leakingObjectIds", "", "", "computeRetainedHeapSize", "", "enqueue", "", "Lshark/internal/PathFinder$State;", "node", "Lshark/internal/ReferencePathNode;", "isLowPriority", "enqueueGcRoots", "poll", "toLongScatterSet", "Lshark/internal/hppc/LongScatterSet;", "PathFindingResults", "State", "VisitTracker", "shark"})
public final class PathFinder {
    private final GcRootProvider gcRootProvider;
    private final HeapGraph graph;
    private final OnAnalysisProgressListener listener;
    private final ReferenceReader<HeapObject> objectReferenceReader;

    @NotNull
    public final PathFindingResults findPathsFromGcRoots(@NotNull Set<Long> leakingObjectIds, boolean computeRetainedHeapSize) {
        Intrinsics.checkParameterIsNotNull(leakingObjectIds, (String)"leakingObjectIds");
        this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_PATHS_TO_RETAINED_OBJECTS);
        int estimatedVisitedObjects = RangesKt.coerceAtLeast((int)(this.graph.getInstanceCount() / 2), (int)4);
        State state = new State(this.toLongScatterSet(leakingObjectIds), computeRetainedHeapSize, estimatedVisitedObjects);
        return this.findPathsFromGcRoots(state);
    }

    private final LongScatterSet toLongScatterSet(Set<Long> $this$toLongScatterSet) {
        LongScatterSet longScatterSet = new LongScatterSet(0, 1, null);
        longScatterSet.ensureCapacity($this$toLongScatterSet.size());
        Iterable $this$forEach$iv = $this$toLongScatterSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            longScatterSet.add(it);
        }
        return longScatterSet;
    }

    private final PathFindingResults findPathsFromGcRoots(State $this$findPathsFromGcRoots) {
        this.enqueueGcRoots($this$findPathsFromGcRoots);
        boolean bl = false;
        List shortestPathsToLeakingObjects = new ArrayList();
        while ($this$findPathsFromGcRoots.getQueuesNotEmpty()) {
            ReferencePathNode node = this.poll($this$findPathsFromGcRoots);
            if ($this$findPathsFromGcRoots.getLeakingObjectIds().contains(node.getObjectId())) {
                shortestPathsToLeakingObjects.add(node);
                if (shortestPathsToLeakingObjects.size() == $this$findPathsFromGcRoots.getLeakingObjectIds().size()) {
                    if (!$this$findPathsFromGcRoots.getComputeRetainedHeapSize()) break;
                    this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_DOMINATORS);
                }
            }
            HeapObject heapObject = this.graph.findObjectById(node.getObjectId());
            Sequence<Reference> $this$forEach$iv = this.objectReferenceReader.read(heapObject);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Reference reference = (Reference)element$iv;
                boolean bl2 = false;
                ReferencePathNode.ChildNode newNode = new ReferencePathNode.ChildNode(reference.getValueObjectId(), node, reference.getLazyDetailsResolver());
                this.enqueue($this$findPathsFromGcRoots, newNode, reference.isLowPriority());
            }
        }
        return new PathFindingResults(shortestPathsToLeakingObjects, $this$findPathsFromGcRoots.getVisitTracker() instanceof VisitTracker.Dominated ? ((VisitTracker.Dominated)$this$findPathsFromGcRoots.getVisitTracker()).getDominatorTree() : null);
    }

    private final ReferencePathNode poll(State $this$poll) {
        ReferencePathNode referencePathNode;
        if (!$this$poll.getVisitingLast() && !$this$poll.getToVisitQueue().isEmpty()) {
            ReferencePathNode removedNode = $this$poll.getToVisitQueue().poll();
            $this$poll.getToVisitSet().remove(removedNode.getObjectId());
            ReferencePathNode referencePathNode2 = removedNode;
            referencePathNode = referencePathNode2;
            Intrinsics.checkExpressionValueIsNotNull((Object)referencePathNode2, (String)"removedNode");
        } else {
            $this$poll.setVisitingLast(true);
            ReferencePathNode removedNode = $this$poll.getToVisitLastQueue().poll();
            $this$poll.getToVisitLastSet().remove(removedNode.getObjectId());
            ReferencePathNode referencePathNode3 = removedNode;
            referencePathNode = referencePathNode3;
            Intrinsics.checkExpressionValueIsNotNull((Object)referencePathNode3, (String)"removedNode");
        }
        return referencePathNode;
    }

    /*
     * WARNING - void declaration
     */
    private final void enqueueGcRoots(State $this$enqueueGcRoots) {
        Sequence<GcRootProvider.GcRootReference> $this$forEach$iv = this.gcRootProvider.provideGcRoots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReferencePathNode.RootNode rootNode;
            GcRootProvider.GcRootReference gcRootReference = (GcRootProvider.GcRootReference)element$iv;
            boolean bl = false;
            PathFinder pathFinder = this;
            State state = $this$enqueueGcRoots;
            if (gcRootReference.getMatchedLibraryLeak() != null) {
                void matchedLibraryLeak;
                LibraryLeakReferenceMatcher libraryLeakReferenceMatcher;
                boolean bl2 = false;
                boolean bl3 = false;
                LibraryLeakReferenceMatcher libraryLeakReferenceMatcher2 = libraryLeakReferenceMatcher;
                State state2 = state;
                PathFinder pathFinder2 = pathFinder;
                boolean bl4 = false;
                ReferencePathNode.RootNode.LibraryLeakRootNode libraryLeakRootNode = new ReferencePathNode.RootNode.LibraryLeakRootNode(gcRootReference.getGcRoot(), (LibraryLeakReferenceMatcher)matchedLibraryLeak);
                pathFinder = pathFinder2;
                state = state2;
                rootNode = libraryLeakRootNode;
            } else {
                rootNode = new ReferencePathNode.RootNode.NormalRootNode(gcRootReference.getGcRoot());
            }
            pathFinder.enqueue(state, rootNode, gcRootReference.isLowPriority());
        }
    }

    private final void enqueue(State $this$enqueue, ReferencePathNode node, boolean isLowPriority) {
        long l;
        if (node.getObjectId() == 0L) {
            return;
        }
        ReferencePathNode referencePathNode = node;
        if (referencePathNode instanceof ReferencePathNode.RootNode) {
            l = 0L;
        } else if (referencePathNode instanceof ReferencePathNode.ChildNode) {
            l = ((ReferencePathNode.ChildNode)node).getParent().getObjectId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        long parentObjectId = l;
        boolean alreadyEnqueued = $this$enqueue.getVisitTracker().visited(node.getObjectId(), parentObjectId);
        boolean visitLast = $this$enqueue.getVisitingLast() || isLowPriority;
        if (alreadyEnqueued) {
            boolean bumpPriority;
            boolean bl = bumpPriority = !visitLast && !$this$enqueue.getToVisitSet().contains(node.getObjectId()) && $this$enqueue.getToVisitLastSet().contains(node.getObjectId());
            if (bumpPriority) {
                Object element$iv2;
                block11: {
                    $this$enqueue.getToVisitQueue().add(node);
                    $this$enqueue.getToVisitSet().add(node.getObjectId());
                    Iterable $this$first$iv = $this$enqueue.getToVisitLastQueue();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ReferencePathNode it = (ReferencePathNode)element$iv2;
                        boolean bl2 = false;
                        if (!(it.getObjectId() == node.getObjectId())) continue;
                        break block11;
                    }
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                ReferencePathNode nodeToRemove = (ReferencePathNode)element$iv2;
                $this$enqueue.getToVisitLastQueue().remove(nodeToRemove);
                $this$enqueue.getToVisitLastSet().remove(node.getObjectId());
            }
        } else if (visitLast) {
            $this$enqueue.getToVisitLastQueue().add(node);
            $this$enqueue.getToVisitLastSet().add(node.getObjectId());
        } else {
            $this$enqueue.getToVisitQueue().add(node);
            $this$enqueue.getToVisitSet().add(node.getObjectId());
        }
    }

    public PathFinder(@NotNull HeapGraph graph, @NotNull OnAnalysisProgressListener listener, @NotNull ReferenceReader<HeapObject> objectReferenceReader, @NotNull List<? extends ReferenceMatcher> referenceMatchers) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull(objectReferenceReader, (String)"objectReferenceReader");
        Intrinsics.checkParameterIsNotNull(referenceMatchers, (String)"referenceMatchers");
        this.graph = graph;
        this.listener = listener;
        this.objectReferenceReader = objectReferenceReader;
        this.gcRootProvider = new GcRootProvider(this.graph, referenceMatchers);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lshark/internal/PathFinder$PathFindingResults;", "", "pathsToLeakingObjects", "", "Lshark/internal/ReferencePathNode;", "dominatorTree", "Lshark/internal/DominatorTree;", "(Ljava/util/List;Lshark/internal/DominatorTree;)V", "getDominatorTree", "()Lshark/internal/DominatorTree;", "getPathsToLeakingObjects", "()Ljava/util/List;", "shark"})
    public static final class PathFindingResults {
        @NotNull
        private final List<ReferencePathNode> pathsToLeakingObjects;
        @Nullable
        private final DominatorTree dominatorTree;

        @NotNull
        public final List<ReferencePathNode> getPathsToLeakingObjects() {
            return this.pathsToLeakingObjects;
        }

        @Nullable
        public final DominatorTree getDominatorTree() {
            return this.dominatorTree;
        }

        public PathFindingResults(@NotNull List<? extends ReferencePathNode> pathsToLeakingObjects, @Nullable DominatorTree dominatorTree) {
            Intrinsics.checkParameterIsNotNull(pathsToLeakingObjects, (String)"pathsToLeakingObjects");
            this.pathsToLeakingObjects = pathsToLeakingObjects;
            this.dominatorTree = dominatorTree;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H&\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lshark/internal/PathFinder$VisitTracker;", "", "()V", "visited", "", "objectId", "", "parentObjectId", "Dominated", "Visited", "Lshark/internal/PathFinder$VisitTracker$Dominated;", "Lshark/internal/PathFinder$VisitTracker$Visited;", "shark"})
    public static abstract class VisitTracker {
        public abstract boolean visited(long var1, long var3);

        private VisitTracker() {
        }

        public /* synthetic */ VisitTracker(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lshark/internal/PathFinder$VisitTracker$Dominated;", "Lshark/internal/PathFinder$VisitTracker;", "expectedElements", "", "(I)V", "dominatorTree", "Lshark/internal/DominatorTree;", "getDominatorTree", "()Lshark/internal/DominatorTree;", "visited", "", "objectId", "", "parentObjectId", "shark"})
        public static final class Dominated
        extends VisitTracker {
            @NotNull
            private final DominatorTree dominatorTree;

            @NotNull
            public final DominatorTree getDominatorTree() {
                return this.dominatorTree;
            }

            @Override
            public boolean visited(long objectId, long parentObjectId) {
                return this.dominatorTree.updateDominated(objectId, parentObjectId);
            }

            public Dominated(int expectedElements) {
                super(null);
                this.dominatorTree = new DominatorTree(expectedElements);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lshark/internal/PathFinder$VisitTracker$Visited;", "Lshark/internal/PathFinder$VisitTracker;", "expectedElements", "", "(I)V", "visitedSet", "Lshark/internal/hppc/LongScatterSet;", "visited", "", "objectId", "", "parentObjectId", "shark"})
        public static final class Visited
        extends VisitTracker {
            private final LongScatterSet visitedSet;

            @Override
            public boolean visited(long objectId, long parentObjectId) {
                return !this.visitedSet.add(objectId);
            }

            public Visited(int expectedElements) {
                super(null);
                this.visitedSet = new LongScatterSet(expectedElements);
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\n\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lshark/internal/PathFinder$State;", "", "leakingObjectIds", "Lshark/internal/hppc/LongScatterSet;", "computeRetainedHeapSize", "", "estimatedVisitedObjects", "", "(Lshark/internal/hppc/LongScatterSet;ZI)V", "getComputeRetainedHeapSize", "()Z", "getLeakingObjectIds", "()Lshark/internal/hppc/LongScatterSet;", "queuesNotEmpty", "getQueuesNotEmpty", "toVisitLastQueue", "Ljava/util/Deque;", "Lshark/internal/ReferencePathNode;", "getToVisitLastQueue", "()Ljava/util/Deque;", "toVisitLastSet", "getToVisitLastSet", "toVisitQueue", "getToVisitQueue", "toVisitSet", "getToVisitSet", "visitTracker", "Lshark/internal/PathFinder$VisitTracker;", "getVisitTracker", "()Lshark/internal/PathFinder$VisitTracker;", "visitingLast", "getVisitingLast", "setVisitingLast", "(Z)V", "shark"})
    private static final class State {
        @NotNull
        private final Deque<ReferencePathNode> toVisitQueue;
        @NotNull
        private final Deque<ReferencePathNode> toVisitLastQueue;
        @NotNull
        private final LongScatterSet toVisitSet;
        @NotNull
        private final LongScatterSet toVisitLastSet;
        @NotNull
        private final VisitTracker visitTracker;
        private boolean visitingLast;
        @NotNull
        private final LongScatterSet leakingObjectIds;
        private final boolean computeRetainedHeapSize;

        @NotNull
        public final Deque<ReferencePathNode> getToVisitQueue() {
            return this.toVisitQueue;
        }

        @NotNull
        public final Deque<ReferencePathNode> getToVisitLastQueue() {
            return this.toVisitLastQueue;
        }

        @NotNull
        public final LongScatterSet getToVisitSet() {
            return this.toVisitSet;
        }

        @NotNull
        public final LongScatterSet getToVisitLastSet() {
            return this.toVisitLastSet;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean getQueuesNotEmpty() {
            Collection collection = this.toVisitQueue;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            collection = this.toVisitLastQueue;
            bl = false;
            if (collection.isEmpty()) return false;
            return true;
        }

        @NotNull
        public final VisitTracker getVisitTracker() {
            return this.visitTracker;
        }

        public final boolean getVisitingLast() {
            return this.visitingLast;
        }

        public final void setVisitingLast(boolean bl) {
            this.visitingLast = bl;
        }

        @NotNull
        public final LongScatterSet getLeakingObjectIds() {
            return this.leakingObjectIds;
        }

        public final boolean getComputeRetainedHeapSize() {
            return this.computeRetainedHeapSize;
        }

        public State(@NotNull LongScatterSet leakingObjectIds, boolean computeRetainedHeapSize, int estimatedVisitedObjects) {
            Intrinsics.checkParameterIsNotNull((Object)leakingObjectIds, (String)"leakingObjectIds");
            this.leakingObjectIds = leakingObjectIds;
            this.computeRetainedHeapSize = computeRetainedHeapSize;
            this.toVisitQueue = new ArrayDeque();
            this.toVisitLastQueue = new ArrayDeque();
            this.toVisitSet = new LongScatterSet(0, 1, null);
            this.toVisitLastSet = new LongScatterSet(0, 1, null);
            this.visitTracker = this.computeRetainedHeapSize ? (VisitTracker)new VisitTracker.Dominated(estimatedVisitedObjects) : (VisitTracker)new VisitTracker.Visited(estimatedVisitedObjects);
        }
    }
}

