/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import shark.GcRoot;
import shark.HeapField;
import shark.HeapGraph;
import shark.HeapObject;
import shark.HprofRecord;
import shark.IgnoredReferenceMatcher;
import shark.LeakTraceReference;
import shark.LibraryLeakReferenceMatcher;
import shark.OnAnalysisProgressListener;
import shark.PrimitiveType;
import shark.ReferenceMatcher;
import shark.ReferencePattern;
import shark.internal.PathFinder;
import shark.internal.ReferencePathNode;
import shark.internal.hppc.LongLongScatterMap;
import shark.internal.hppc.LongScatterSet;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u000267B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0007H\u0002J\u0014\u0010\u001d\u001a\u00020\u0018*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u00020\"*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\f\u0010#\u001a\u00020\"*\u00020\u001eH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u001eH\u0002J\f\u0010$\u001a\u00020 *\u00020\u001eH\u0002J\u001c\u0010%\u001a\u00020\"*\u00020\u001e2\u0006\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0018H\u0002J\u0014\u0010(\u001a\u00020\"*\u00020\u001e2\u0006\u0010&\u001a\u00020\u0016H\u0002J$\u0010)\u001a\u00020\"*\u00020\u001e2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0018H\u0002J\u001c\u0010+\u001a\u00020\"*\u00020\u001e2\u0006\u0010,\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0016H\u0002J\u001c\u0010-\u001a\u00020\"*\u00020\u001e2\u0006\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020 H\u0002J\u001c\u00100\u001a\u00020\"*\u00020\u001e2\u0006\u00101\u001a\u0002022\u0006\u0010*\u001a\u00020 H\u0002J\u001c\u00103\u001a\u00020\"*\u00020\u001e2\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020 H\u0002R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lshark/internal/PathFinder;", "", "graph", "Lshark/HeapGraph;", "listener", "Lshark/OnAnalysisProgressListener;", "referenceMatchers", "", "Lshark/ReferenceMatcher;", "(Lshark/HeapGraph;Lshark/OnAnalysisProgressListener;Ljava/util/List;)V", "fieldNameByClassName", "", "", "jniGlobalReferenceMatchers", "staticFieldNameByClassName", "threadNameReferenceMatchers", "determineSizeOfObjectInstances", "", "findPathsFromGcRoots", "Lshark/internal/PathFinder$PathFindingResults;", "leakingObjectIds", "", "", "computeRetainedHeapSize", "", "sortedGcRoots", "Lkotlin/Pair;", "Lshark/HeapObject;", "Lshark/GcRoot;", "checkSeen", "Lshark/internal/PathFinder$State;", "node", "Lshark/internal/ReferencePathNode;", "enqueue", "", "enqueueGcRoots", "poll", "undominate", "objectId", "neverEnqueued", "undominateWithSkips", "updateDominator", "parent", "updateDominatorWithSkips", "parentObjectId", "visitClassRecord", "heapClass", "Lshark/HeapObject$HeapClass;", "visitInstance", "instance", "Lshark/HeapObject$HeapInstance;", "visitObjectArray", "objectArray", "Lshark/HeapObject$HeapObjectArray;", "PathFindingResults", "State", "shark"})
public final class PathFinder {
    private final Map<String, Map<String, ReferenceMatcher>> fieldNameByClassName;
    private final Map<String, Map<String, ReferenceMatcher>> staticFieldNameByClassName;
    private final Map<String, ReferenceMatcher> threadNameReferenceMatchers;
    private final Map<String, ReferenceMatcher> jniGlobalReferenceMatchers;
    private final HeapGraph graph;
    private final OnAnalysisProgressListener listener;

    @NotNull
    public final PathFindingResults findPathsFromGcRoots(@NotNull Set<Long> leakingObjectIds, boolean computeRetainedHeapSize) {
        Intrinsics.checkParameterIsNotNull(leakingObjectIds, (String)"leakingObjectIds");
        this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_PATHS_TO_RETAINED_OBJECTS);
        int sizeOfObjectInstances = this.determineSizeOfObjectInstances(this.graph);
        State state = new State(leakingObjectIds, sizeOfObjectInstances, computeRetainedHeapSize);
        return this.findPathsFromGcRoots(state);
    }

    private final int determineSizeOfObjectInstances(HeapGraph graph) {
        int sizeOfObjectOnArt;
        int objectClassFieldSize;
        HeapObject.HeapClass objectClass = graph.findClassByName("java.lang.Object");
        return objectClass != null ? ((objectClassFieldSize = objectClass.readFieldsByteSize()) == (sizeOfObjectOnArt = graph.getIdentifierByteSize() + PrimitiveType.INT.getByteSize()) ? sizeOfObjectOnArt : 0) : 0;
    }

    private final PathFindingResults findPathsFromGcRoots(@NotNull State $this$findPathsFromGcRoots) {
        this.enqueueGcRoots($this$findPathsFromGcRoots);
        boolean bl = false;
        List shortestPathsToLeakingObjects = new ArrayList();
        while ($this$findPathsFromGcRoots.getQueuesNotEmpty()) {
            HeapObject heapObject;
            ReferencePathNode node = this.poll($this$findPathsFromGcRoots);
            if (this.checkSeen($this$findPathsFromGcRoots, node)) {
                throw (Throwable)new IllegalStateException("Node " + node + " objectId=" + node.getObjectId() + " should not be enqueued when already visited or enqueued");
            }
            if ($this$findPathsFromGcRoots.getLeakingObjectIds().contains(node.getObjectId())) {
                shortestPathsToLeakingObjects.add(node);
                if (shortestPathsToLeakingObjects.size() == $this$findPathsFromGcRoots.getLeakingObjectIds().size()) {
                    if (!$this$findPathsFromGcRoots.getComputeRetainedHeapSize()) break;
                    this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_DOMINATORS);
                }
            }
            if ((heapObject = this.graph.findObjectById(node.getObjectId())) instanceof HeapObject.HeapClass) {
                this.visitClassRecord($this$findPathsFromGcRoots, (HeapObject.HeapClass)heapObject, node);
                continue;
            }
            if (heapObject instanceof HeapObject.HeapInstance) {
                this.visitInstance($this$findPathsFromGcRoots, (HeapObject.HeapInstance)heapObject, node);
                continue;
            }
            if (!(heapObject instanceof HeapObject.HeapObjectArray)) continue;
            this.visitObjectArray($this$findPathsFromGcRoots, (HeapObject.HeapObjectArray)heapObject, node);
        }
        return new PathFindingResults(shortestPathsToLeakingObjects, $this$findPathsFromGcRoots.getDominatedObjectIds());
    }

    private final ReferencePathNode poll(@NotNull State $this$poll) {
        ReferencePathNode referencePathNode;
        if (!$this$poll.getToVisitQueue().isEmpty()) {
            ReferencePathNode removedNode = $this$poll.getToVisitQueue().poll();
            $this$poll.getToVisitSet().remove(removedNode.getObjectId());
            ReferencePathNode referencePathNode2 = removedNode;
            referencePathNode = referencePathNode2;
            Intrinsics.checkExpressionValueIsNotNull((Object)referencePathNode2, (String)"removedNode");
        } else {
            ReferencePathNode removedNode = $this$poll.getToVisitLastQueue().poll();
            $this$poll.getToVisitLastSet().remove(removedNode.getObjectId());
            ReferencePathNode referencePathNode3 = removedNode;
            referencePathNode = referencePathNode3;
            Intrinsics.checkExpressionValueIsNotNull((Object)referencePathNode3, (String)"removedNode");
        }
        return referencePathNode;
    }

    private final boolean checkSeen(@NotNull State $this$checkSeen, ReferencePathNode node) {
        boolean neverSeen = $this$checkSeen.getVisitedSet().add(node.getObjectId());
        return !neverSeen;
    }

    /*
     * WARNING - void declaration
     */
    private final void enqueueGcRoots(@NotNull State $this$enqueueGcRoots) {
        List<Pair<HeapObject, GcRoot>> gcRoots = this.sortedGcRoots();
        boolean bl = false;
        Map threadNames = new LinkedHashMap();
        boolean bl2 = false;
        Map threadsBySerialNumber = new LinkedHashMap();
        Iterable $this$forEach$iv = gcRoots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapObject heapObject;
            GcRoot gcRoot;
            Pair $dstr$objectRecord$gcRoot = (Pair)element$iv;
            boolean bl3 = false;
            HeapObject objectRecord = (HeapObject)$dstr$objectRecord$gcRoot.component1();
            GcRoot gcRoot2 = (GcRoot)$dstr$objectRecord$gcRoot.component2();
            if ($this$enqueueGcRoots.getComputeRetainedHeapSize()) {
                this.undominateWithSkips($this$enqueueGcRoots, gcRoot2.getId());
            }
            if ((gcRoot = gcRoot2) instanceof GcRoot.ThreadObject) {
                Integer n = ((GcRoot.ThreadObject)gcRoot2).getThreadSerialNumber();
                HeapObject.HeapInstance heapInstance = objectRecord.getAsInstance();
                if (heapInstance == null) {
                    Intrinsics.throwNpe();
                }
                threadsBySerialNumber.put(n, TuplesKt.to((Object)heapInstance, (Object)gcRoot2));
                this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.NormalRootNode(gcRoot2.getId(), gcRoot2));
                continue;
            }
            if (gcRoot instanceof GcRoot.JavaFrame) {
                String threadName;
                ReferenceMatcher referenceMatcher;
                void threadInstance;
                Pair threadPair = (Pair)threadsBySerialNumber.get(((GcRoot.JavaFrame)gcRoot2).getThreadSerialNumber());
                if (threadPair == null) {
                    this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.NormalRootNode(gcRoot2.getId(), gcRoot2));
                    continue;
                }
                Pair pair = threadPair;
                heapObject = (HeapObject.HeapInstance)pair.component1();
                GcRoot.ThreadObject threadRoot = (GcRoot.ThreadObject)pair.component2();
                String string = (String)threadNames.get(threadInstance);
                if (string == null) {
                    string = (String)((Function0)new Function0<String>((HeapObject.HeapInstance)threadInstance, this, $this$enqueueGcRoots, threadsBySerialNumber, threadNames){
                        final /* synthetic */ HeapObject.HeapInstance $threadInstance;
                        final /* synthetic */ PathFinder this$0;
                        final /* synthetic */ State $this_enqueueGcRoots$inlined;
                        final /* synthetic */ Map $threadsBySerialNumber$inlined;
                        final /* synthetic */ Map $threadNames$inlined;
                        {
                            this.$threadInstance = heapInstance;
                            this.this$0 = pathFinder;
                            this.$this_enqueueGcRoots$inlined = state;
                            this.$threadsBySerialNumber$inlined = map;
                            this.$threadNames$inlined = map2;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final String invoke() {
                            void var1_1;
                            Object object = this.$threadInstance.get(Reflection.getOrCreateKotlinClass(Thread.class), "name");
                            if (object == null || (object = object.getValue()) == null || (object = object.readAsJavaString()) == null) {
                                object = "";
                            }
                            Object name = object;
                            this.$threadNames$inlined.put(this.$threadInstance, name);
                            return var1_1;
                        }
                    }).invoke();
                }
                if ((referenceMatcher = this.threadNameReferenceMatchers.get(threadName = string)) instanceof IgnoredReferenceMatcher) continue;
                ReferencePathNode.RootNode.NormalRootNode rootNode = new ReferencePathNode.RootNode.NormalRootNode(threadRoot.getId(), gcRoot2);
                LeakTraceReference.ReferenceType refFromParentType = LeakTraceReference.ReferenceType.LOCAL;
                String refFromParentName = "";
                ReferencePathNode.ChildNode childNode2 = referenceMatcher instanceof LibraryLeakReferenceMatcher ? (ReferencePathNode.ChildNode)new ReferencePathNode.ChildNode.LibraryLeakChildNode(gcRoot2.getId(), rootNode, refFromParentType, refFromParentName, (LibraryLeakReferenceMatcher)referenceMatcher) : (ReferencePathNode.ChildNode)new ReferencePathNode.ChildNode.NormalNode(gcRoot2.getId(), rootNode, refFromParentType, refFromParentName);
                this.enqueue($this$enqueueGcRoots, childNode2);
                continue;
            }
            if (gcRoot instanceof GcRoot.JniGlobal) {
                ReferenceMatcher referenceMatcher;
                ReferenceMatcher referenceMatcher2;
                heapObject = objectRecord;
                if (heapObject instanceof HeapObject.HeapClass) {
                    referenceMatcher2 = this.jniGlobalReferenceMatchers.get(((HeapObject.HeapClass)objectRecord).getName());
                } else if (heapObject instanceof HeapObject.HeapInstance) {
                    referenceMatcher2 = this.jniGlobalReferenceMatchers.get(((HeapObject.HeapInstance)objectRecord).getInstanceClassName());
                } else if (heapObject instanceof HeapObject.HeapObjectArray) {
                    referenceMatcher2 = this.jniGlobalReferenceMatchers.get(((HeapObject.HeapObjectArray)objectRecord).getArrayClassName());
                } else if (heapObject instanceof HeapObject.HeapPrimitiveArray) {
                    referenceMatcher2 = this.jniGlobalReferenceMatchers.get(((HeapObject.HeapPrimitiveArray)objectRecord).getArrayClassName());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if ((referenceMatcher = referenceMatcher2) instanceof IgnoredReferenceMatcher) continue;
                if (referenceMatcher instanceof LibraryLeakReferenceMatcher) {
                    this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.LibraryLeakRootNode(gcRoot2.getId(), gcRoot2, (LibraryLeakReferenceMatcher)referenceMatcher));
                    continue;
                }
                this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.NormalRootNode(gcRoot2.getId(), gcRoot2));
                continue;
            }
            this.enqueue($this$enqueueGcRoots, new ReferencePathNode.RootNode.NormalRootNode(gcRoot2.getId(), gcRoot2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<HeapObject, GcRoot>> sortedGcRoots() {
        void $this$mapTo$iv$iv;
        GcRoot gcRoot;
        Iterable $this$filterTo$iv$iv;
        Function1 rootClassName2 = sortedGcRoots.rootClassName.1.INSTANCE;
        Iterable $this$filter$iv = this.graph.getGcRoots();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            gcRoot = (GcRoot)element$iv$iv;
            boolean bl = false;
            if (!this.graph.objectExists(gcRoot.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            gcRoot = (GcRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)this.graph.findObjectById(it.getId()), (Object)it);
            collection.add(pair);
        }
        return CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator<Pair<? extends HeapObject, ? extends GcRoot>>(rootClassName2){
            final /* synthetic */ Function1 $rootClassName;

            public final int compare(Pair<? extends HeapObject, ? extends GcRoot> $dstr$graphObject1$root1, Pair<? extends HeapObject, ? extends GcRoot> $dstr$graphObject2$root2) {
                HeapObject graphObject1 = (HeapObject)$dstr$graphObject1$root1.component1();
                GcRoot root1 = (GcRoot)$dstr$graphObject1$root1.component2();
                HeapObject graphObject2 = (HeapObject)$dstr$graphObject2$root2.component1();
                GcRoot root2 = (GcRoot)$dstr$graphObject2$root2.component2();
                String string = root2.getClass().getName();
                String string2 = root1.getClass().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"root1::class.java.name");
                int gcRootTypeComparison = string.compareTo(string2);
                return gcRootTypeComparison != 0 ? gcRootTypeComparison : ((String)this.$rootClassName.invoke((Object)graphObject1)).compareTo((String)this.$rootClassName.invoke((Object)graphObject2));
            }
            {
                this.$rootClassName = function1;
            }
        });
    }

    private final void visitClassRecord(@NotNull State $this$visitClassRecord, HeapObject.HeapClass heapClass, ReferencePathNode parent) {
        Map map = this.staticFieldNameByClassName.get(heapClass.getName());
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map ignoredStaticFields = map;
        for (HeapField staticField : heapClass.readStaticFields()) {
            ReferencePathNode.ChildNode node;
            ReferencePathNode.ChildNode childNode2;
            ReferenceMatcher referenceMatcher;
            String fieldName;
            if (!staticField.getValue().isNonNullReference() || Intrinsics.areEqual((Object)(fieldName = staticField.getName()), (Object)"$staticOverhead")) continue;
            Long l = staticField.getValue().getAsObjectId();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            long objectId = l;
            if ($this$visitClassRecord.getComputeRetainedHeapSize()) {
                this.undominateWithSkips($this$visitClassRecord, objectId);
            }
            if ((referenceMatcher = (ReferenceMatcher)ignoredStaticFields.get(fieldName)) == null) {
                childNode2 = new ReferencePathNode.ChildNode.NormalNode(objectId, parent, LeakTraceReference.ReferenceType.STATIC_FIELD, fieldName);
            } else if (referenceMatcher instanceof LibraryLeakReferenceMatcher) {
                childNode2 = new ReferencePathNode.ChildNode.LibraryLeakChildNode(objectId, parent, LeakTraceReference.ReferenceType.STATIC_FIELD, fieldName, (LibraryLeakReferenceMatcher)referenceMatcher);
            } else if (referenceMatcher instanceof IgnoredReferenceMatcher) {
                childNode2 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if ((node = childNode2) == null) continue;
            this.enqueue($this$visitClassRecord, node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitInstance(@NotNull State $this$visitInstance, HeapObject.HeapInstance instance, ReferencePathNode parent) {
        List fieldNamesAndValues2;
        LinkedHashMap fieldReferenceMatchers = new LinkedHashMap();
        Sequence $this$forEach$iv = instance.getInstanceClass().getClassHierarchy();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapObject.HeapClass it = (HeapObject.HeapClass)element$iv;
            boolean bl = false;
            Map<String, ReferenceMatcher> referenceMatcherByField = this.fieldNameByClassName.get(it.getName());
            if (referenceMatcherByField == null) continue;
            Object object = referenceMatcherByField;
            boolean bl2 = false;
            Iterator<Map.Entry<String, ReferenceMatcher>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void fieldName;
                Map.Entry<String, ReferenceMatcher> entry;
                Map.Entry<String, ReferenceMatcher> entry2 = entry = iterator.next();
                boolean bl3 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl3 = false;
                ReferenceMatcher referenceMatcher = entry2.getValue();
                if (fieldReferenceMatchers.containsKey(fieldName)) continue;
                ((Map)fieldReferenceMatchers).put(fieldName, referenceMatcher);
            }
        }
        List $this$sortBy$iv = fieldNamesAndValues2 = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)instance.readFields(), (Function1)visitInstance.fieldNamesAndValues.1.INSTANCE));
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            List list = $this$sortBy$iv;
            boolean it = false;
            Comparator bl = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    HeapField it = (HeapField)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (HeapField)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            CollectionsKt.sortWith((List)list, (Comparator)bl);
        }
        Iterable $this$forEach$iv2 = fieldNamesAndValues2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            ReferencePathNode.ChildNode node;
            ReferencePathNode.ChildNode childNode2;
            ReferenceMatcher referenceMatcher;
            HeapField field = (HeapField)element$iv;
            boolean bl = false;
            Long l = field.getValue().getAsObjectId();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            long objectId = l;
            if ($this$visitInstance.getComputeRetainedHeapSize()) {
                this.updateDominatorWithSkips($this$visitInstance, parent.getObjectId(), objectId);
            }
            if ((referenceMatcher = (ReferenceMatcher)fieldReferenceMatchers.get(field.getName())) == null) {
                childNode2 = new ReferencePathNode.ChildNode.NormalNode(objectId, parent, LeakTraceReference.ReferenceType.INSTANCE_FIELD, field.getName());
            } else if (referenceMatcher instanceof LibraryLeakReferenceMatcher) {
                childNode2 = new ReferencePathNode.ChildNode.LibraryLeakChildNode(objectId, parent, LeakTraceReference.ReferenceType.INSTANCE_FIELD, field.getName(), (LibraryLeakReferenceMatcher)referenceMatcher);
            } else if (referenceMatcher instanceof IgnoredReferenceMatcher) {
                childNode2 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if ((node = childNode2) == null) continue;
            this.enqueue($this$visitInstance, node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitObjectArray(@NotNull State $this$visitObjectArray, HeapObject.HeapObjectArray objectArray, ReferencePathNode parent) {
        void $this$filterTo$iv$iv;
        HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord record = objectArray.readRecord();
        long[] $this$filter$iv = record.getElementIds();
        boolean $i$f$filter = false;
        long[] lArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (long element$iv$iv : $this$filterTo$iv$iv) {
            void objectId = element$iv$iv;
            boolean bl = false;
            if (!(objectId != 0L && this.graph.objectExists((long)objectId))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonNullElementIds = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = nonNullElementIds;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void elementId;
            long element$iv$iv;
            int n = index$iv++;
            int n2 = 0;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n3 = n;
            element$iv$iv = ((Number)item$iv).longValue();
            int index = n3;
            boolean bl = false;
            if ($this$visitObjectArray.getComputeRetainedHeapSize()) {
                this.updateDominatorWithSkips($this$visitObjectArray, parent.getObjectId(), (long)elementId);
            }
            String name = String.valueOf(index);
            this.enqueue($this$visitObjectArray, new ReferencePathNode.ChildNode.NormalNode((long)elementId, parent, LeakTraceReference.ReferenceType.ARRAY_ENTRY, name));
        }
    }

    private final void enqueue(@NotNull State $this$enqueue, ReferencePathNode node) {
        boolean visitLast;
        if (node.getObjectId() == 0L) {
            return;
        }
        if ($this$enqueue.getVisitedSet().contains(node.getObjectId())) {
            return;
        }
        if ($this$enqueue.getToVisitSet().contains(node.getObjectId())) {
            return;
        }
        boolean bl = visitLast = node instanceof ReferencePathNode.LibraryLeakNode || node instanceof ReferencePathNode.RootNode && ((ReferencePathNode.RootNode)node).getGcRoot() instanceof GcRoot.ThreadObject || node instanceof ReferencePathNode.ChildNode.NormalNode && ((ReferencePathNode.ChildNode.NormalNode)node).getParent() instanceof ReferencePathNode.RootNode && ((ReferencePathNode.RootNode)((ReferencePathNode.ChildNode.NormalNode)node).getParent()).getGcRoot() instanceof GcRoot.JavaFrame;
        if ($this$enqueue.getToVisitLastSet().contains(node.getObjectId())) {
            Object element$iv2;
            block18: {
                if (visitLast) {
                    return;
                }
                $this$enqueue.getToVisitQueue().add(node);
                $this$enqueue.getToVisitSet().add(node.getObjectId());
                Iterable $this$first$iv = $this$enqueue.getToVisitLastQueue();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ReferencePathNode it = (ReferencePathNode)element$iv2;
                    boolean bl2 = false;
                    if (!(it.getObjectId() == node.getObjectId())) continue;
                    break block18;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ReferencePathNode nodeToRemove = (ReferencePathNode)element$iv2;
            $this$enqueue.getToVisitLastQueue().remove(nodeToRemove);
            $this$enqueue.getToVisitLastSet().remove(node.getObjectId());
            return;
        }
        boolean isLeakingObject = $this$enqueue.getLeakingObjectIds().contains(node.getObjectId());
        if (!isLeakingObject) {
            boolean bl3;
            HeapObject graphObject = this.graph.findObjectById(node.getObjectId());
            if (graphObject instanceof HeapObject.HeapClass) {
                bl3 = false;
            } else if (graphObject instanceof HeapObject.HeapInstance) {
                bl3 = ((HeapObject.HeapInstance)graphObject).isPrimitiveWrapper() ? true : (Intrinsics.areEqual((Object)((HeapObject.HeapInstance)graphObject).getInstanceClassName(), (Object)"java.lang.String") ? true : ((HeapObject.HeapInstance)graphObject).getInstanceClass().getInstanceByteSize() <= $this$enqueue.getSizeOfObjectInstances());
            } else if (graphObject instanceof HeapObject.HeapObjectArray) {
                bl3 = ((HeapObject.HeapObjectArray)graphObject).isPrimitiveWrapperArray();
            } else if (graphObject instanceof HeapObject.HeapPrimitiveArray) {
                bl3 = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean skip = bl3;
            if (skip) {
                return;
            }
        }
        if (visitLast) {
            $this$enqueue.getToVisitLastQueue().add(node);
            $this$enqueue.getToVisitLastSet().add(node.getObjectId());
        } else {
            $this$enqueue.getToVisitQueue().add(node);
            $this$enqueue.getToVisitSet().add(node.getObjectId());
        }
    }

    private final void updateDominatorWithSkips(@NotNull State $this$updateDominatorWithSkips, long parentObjectId, long objectId) {
        HeapObject graphObject = this.graph.findObjectById(objectId);
        if (graphObject instanceof HeapObject.HeapClass) {
            this.undominate($this$updateDominatorWithSkips, objectId, false);
        } else if (graphObject instanceof HeapObject.HeapInstance) {
            if (Intrinsics.areEqual((Object)((HeapObject.HeapInstance)graphObject).getInstanceClassName(), (Object)"java.lang.String")) {
                Long valueId;
                this.updateDominator($this$updateDominatorWithSkips, parentObjectId, objectId, true);
                HeapField heapField = ((HeapObject.HeapInstance)graphObject).get("java.lang.String", "value");
                Long l = heapField != null && (heapField = heapField.getValue()) != null ? heapField.getAsObjectId() : (valueId = null);
                if (valueId != null) {
                    this.updateDominator($this$updateDominatorWithSkips, parentObjectId, valueId, true);
                }
            } else {
                this.updateDominator($this$updateDominatorWithSkips, parentObjectId, objectId, false);
            }
        } else if (graphObject instanceof HeapObject.HeapObjectArray) {
            if (((HeapObject.HeapObjectArray)graphObject).isPrimitiveWrapperArray()) {
                this.updateDominator($this$updateDominatorWithSkips, parentObjectId, objectId, true);
                for (long wrapperId : ((HeapObject.HeapObjectArray)graphObject).readRecord().getElementIds()) {
                    this.updateDominator($this$updateDominatorWithSkips, parentObjectId, wrapperId, true);
                }
            } else {
                this.updateDominator($this$updateDominatorWithSkips, parentObjectId, objectId, false);
            }
        } else {
            this.updateDominator($this$updateDominatorWithSkips, parentObjectId, objectId, false);
        }
    }

    private final void updateDominator(@NotNull State $this$updateDominator, long parent, long objectId, boolean neverEnqueued) {
        long nextDominator;
        int currentDominatorSlot = $this$updateDominator.getDominatedObjectIds().getSlot(objectId);
        if (currentDominatorSlot == -1 && ($this$updateDominator.getVisitedSet().contains(objectId) || $this$updateDominator.getToVisitSet().contains(objectId) || $this$updateDominator.getToVisitLastSet().contains(objectId))) {
            return;
        }
        int parentDominatorSlot = $this$updateDominator.getDominatedObjectIds().getSlot(parent);
        boolean parentIsRetainedObject = $this$updateDominator.getLeakingObjectIds().contains(parent);
        if (!parentIsRetainedObject && parentDominatorSlot == -1) {
            if (neverEnqueued) {
                $this$updateDominator.getVisitedSet().add(objectId);
            }
            if (currentDominatorSlot != -1) {
                $this$updateDominator.getDominatedObjectIds().remove(objectId);
            }
            return;
        }
        long l = nextDominator = parentIsRetainedObject ? parent : $this$updateDominator.getDominatedObjectIds().getSlotValue(parentDominatorSlot);
        if (currentDominatorSlot == -1) {
            $this$updateDominator.getDominatedObjectIds().set(objectId, nextDominator);
        } else {
            int nextDominatorSlot;
            boolean bl = false;
            List parentDominators = new ArrayList();
            boolean bl2 = false;
            List currentDominators = new ArrayList();
            boolean stop = false;
            long dominator = nextDominator;
            while (!stop) {
                parentDominators.add(dominator);
                nextDominatorSlot = $this$updateDominator.getDominatedObjectIds().getSlot(dominator);
                if (nextDominatorSlot == -1) {
                    stop = true;
                    continue;
                }
                dominator = $this$updateDominator.getDominatedObjectIds().getSlotValue(nextDominatorSlot);
            }
            stop = false;
            dominator = $this$updateDominator.getDominatedObjectIds().getSlotValue(currentDominatorSlot);
            while (!stop) {
                currentDominators.add(dominator);
                nextDominatorSlot = $this$updateDominator.getDominatedObjectIds().getSlot(dominator);
                if (nextDominatorSlot == -1) {
                    stop = true;
                    continue;
                }
                dominator = $this$updateDominator.getDominatedObjectIds().getSlotValue(nextDominatorSlot);
            }
            Long sharedDominator = null;
            Iterator iterator = parentDominators.iterator();
            block2: while (iterator.hasNext()) {
                long parentD = ((Number)iterator.next()).longValue();
                Iterator iterator2 = currentDominators.iterator();
                while (iterator2.hasNext()) {
                    long currentD = ((Number)iterator2.next()).longValue();
                    if (currentD != parentD) continue;
                    sharedDominator = currentD;
                    break block2;
                }
            }
            if (sharedDominator == null) {
                $this$updateDominator.getDominatedObjectIds().remove(objectId);
                if (neverEnqueued) {
                    $this$updateDominator.getVisitedSet().add(objectId);
                }
            } else {
                $this$updateDominator.getDominatedObjectIds().set(objectId, sharedDominator.longValue());
            }
        }
    }

    private final void undominateWithSkips(@NotNull State $this$undominateWithSkips, long objectId) {
        HeapObject graphObject = this.graph.findObjectById(objectId);
        if (graphObject instanceof HeapObject.HeapClass) {
            this.undominate($this$undominateWithSkips, objectId, false);
        } else if (graphObject instanceof HeapObject.HeapInstance) {
            if (Intrinsics.areEqual((Object)((HeapObject.HeapInstance)graphObject).getInstanceClassName(), (Object)"java.lang.String")) {
                Long valueId;
                this.undominate($this$undominateWithSkips, objectId, true);
                HeapField heapField = ((HeapObject.HeapInstance)graphObject).get("java.lang.String", "value");
                Long l = heapField != null && (heapField = heapField.getValue()) != null ? heapField.getAsObjectId() : (valueId = null);
                if (valueId != null) {
                    this.undominate($this$undominateWithSkips, valueId, true);
                }
            } else {
                this.undominate($this$undominateWithSkips, objectId, false);
            }
        } else if (graphObject instanceof HeapObject.HeapObjectArray) {
            if (((HeapObject.HeapObjectArray)graphObject).isPrimitiveWrapperArray()) {
                this.undominate($this$undominateWithSkips, objectId, true);
                for (long wrapperId : ((HeapObject.HeapObjectArray)graphObject).readRecord().getElementIds()) {
                    this.undominate($this$undominateWithSkips, wrapperId, true);
                }
            } else {
                this.undominate($this$undominateWithSkips, objectId, false);
            }
        } else {
            this.undominate($this$undominateWithSkips, objectId, false);
        }
    }

    private final void undominate(@NotNull State $this$undominate, long objectId, boolean neverEnqueued) {
        $this$undominate.getDominatedObjectIds().remove(objectId);
        if (neverEnqueued) {
            $this$undominate.getVisitedSet().add(objectId);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PathFinder(@NotNull HeapGraph graph, @NotNull OnAnalysisProgressListener listener, @NotNull List<? extends ReferenceMatcher> referenceMatchers) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull(referenceMatchers, (String)"referenceMatchers");
        this.graph = graph;
        this.listener = listener;
        boolean bl = false;
        Map fieldNameByClassName = new LinkedHashMap();
        boolean bl2 = false;
        Map staticFieldNameByClassName = new LinkedHashMap();
        boolean bl3 = false;
        Map threadNames = new LinkedHashMap();
        boolean bl4 = false;
        Map jniGlobals = new LinkedHashMap();
        Iterable $this$filter$iv = referenceMatchers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReferenceMatcher it = (ReferenceMatcher)element$iv$iv;
            boolean bl5 = false;
            if (!(it instanceof IgnoredReferenceMatcher || it instanceof LibraryLeakReferenceMatcher && (Boolean)((LibraryLeakReferenceMatcher)it).getPatternApplies().invoke((Object)this.graph) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map map;
            Map newMap;
            boolean bl6;
            Map mapOrNull;
            ReferenceMatcher referenceMatcher = (ReferenceMatcher)element$iv;
            boolean bl7 = false;
            ReferencePattern pattern = referenceMatcher.getPattern();
            if (pattern instanceof ReferencePattern.JavaLocalPattern) {
                threadNames.put(((ReferencePattern.JavaLocalPattern)pattern).getThreadName(), referenceMatcher);
                continue;
            }
            if (pattern instanceof ReferencePattern.StaticFieldPattern) {
                Map map2;
                mapOrNull = (Map)staticFieldNameByClassName.get(((ReferencePattern.StaticFieldPattern)pattern).getClassName());
                if (mapOrNull != null) {
                    map2 = mapOrNull;
                } else {
                    bl6 = false;
                    newMap = new LinkedHashMap();
                    staticFieldNameByClassName.put(((ReferencePattern.StaticFieldPattern)pattern).getClassName(), newMap);
                    map2 = newMap;
                }
                map = map2;
                map.put(((ReferencePattern.StaticFieldPattern)pattern).getFieldName(), referenceMatcher);
                continue;
            }
            if (pattern instanceof ReferencePattern.InstanceFieldPattern) {
                Map map3;
                mapOrNull = (Map)fieldNameByClassName.get(((ReferencePattern.InstanceFieldPattern)pattern).getClassName());
                if (mapOrNull != null) {
                    map3 = mapOrNull;
                } else {
                    bl6 = false;
                    newMap = new LinkedHashMap();
                    fieldNameByClassName.put(((ReferencePattern.InstanceFieldPattern)pattern).getClassName(), newMap);
                    map3 = newMap;
                }
                map = map3;
                map.put(((ReferencePattern.InstanceFieldPattern)pattern).getFieldName(), referenceMatcher);
                continue;
            }
            if (!(pattern instanceof ReferencePattern.NativeGlobalVariablePattern)) continue;
            jniGlobals.put(((ReferencePattern.NativeGlobalVariablePattern)pattern).getClassName(), referenceMatcher);
        }
        this.fieldNameByClassName = fieldNameByClassName;
        this.staticFieldNameByClassName = staticFieldNameByClassName;
        this.threadNameReferenceMatchers = threadNames;
        this.jniGlobalReferenceMatchers = jniGlobals;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lshark/internal/PathFinder$PathFindingResults;", "", "pathsToLeakingObjects", "", "Lshark/internal/ReferencePathNode;", "dominatedObjectIds", "Lshark/internal/hppc/LongLongScatterMap;", "(Ljava/util/List;Lshark/internal/hppc/LongLongScatterMap;)V", "getDominatedObjectIds", "()Lshark/internal/hppc/LongLongScatterMap;", "getPathsToLeakingObjects", "()Ljava/util/List;", "shark"})
    public static final class PathFindingResults {
        @NotNull
        private final List<ReferencePathNode> pathsToLeakingObjects;
        @NotNull
        private final LongLongScatterMap dominatedObjectIds;

        @NotNull
        public final List<ReferencePathNode> getPathsToLeakingObjects() {
            return this.pathsToLeakingObjects;
        }

        @NotNull
        public final LongLongScatterMap getDominatedObjectIds() {
            return this.dominatedObjectIds;
        }

        public PathFindingResults(@NotNull List<? extends ReferencePathNode> pathsToLeakingObjects, @NotNull LongLongScatterMap dominatedObjectIds) {
            Intrinsics.checkParameterIsNotNull(pathsToLeakingObjects, (String)"pathsToLeakingObjects");
            Intrinsics.checkParameterIsNotNull((Object)dominatedObjectIds, (String)"dominatedObjectIds");
            this.pathsToLeakingObjects = pathsToLeakingObjects;
            this.dominatedObjectIds = dominatedObjectIds;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001cj\b\u0012\u0004\u0012\u00020\u0004`\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR!\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u001cj\b\u0012\u0004\u0012\u00020\u0004`\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lshark/internal/PathFinder$State;", "", "leakingObjectIds", "", "", "sizeOfObjectInstances", "", "computeRetainedHeapSize", "", "(Ljava/util/Set;IZ)V", "getComputeRetainedHeapSize", "()Z", "dominatedObjectIds", "Lshark/internal/hppc/LongLongScatterMap;", "getDominatedObjectIds", "()Lshark/internal/hppc/LongLongScatterMap;", "getLeakingObjectIds", "()Ljava/util/Set;", "queuesNotEmpty", "getQueuesNotEmpty", "getSizeOfObjectInstances", "()I", "toVisitLastQueue", "Ljava/util/Deque;", "Lshark/internal/ReferencePathNode;", "getToVisitLastQueue", "()Ljava/util/Deque;", "toVisitLastSet", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getToVisitLastSet", "()Ljava/util/HashSet;", "toVisitQueue", "getToVisitQueue", "toVisitSet", "getToVisitSet", "visitedSet", "Lshark/internal/hppc/LongScatterSet;", "getVisitedSet", "()Lshark/internal/hppc/LongScatterSet;", "shark"})
    private static final class State {
        @NotNull
        private final Deque<ReferencePathNode> toVisitQueue;
        @NotNull
        private final Deque<ReferencePathNode> toVisitLastQueue;
        @NotNull
        private final HashSet<Long> toVisitSet;
        @NotNull
        private final HashSet<Long> toVisitLastSet;
        @NotNull
        private final LongScatterSet visitedSet;
        @NotNull
        private final LongLongScatterMap dominatedObjectIds;
        @NotNull
        private final Set<Long> leakingObjectIds;
        private final int sizeOfObjectInstances;
        private final boolean computeRetainedHeapSize;

        @NotNull
        public final Deque<ReferencePathNode> getToVisitQueue() {
            return this.toVisitQueue;
        }

        @NotNull
        public final Deque<ReferencePathNode> getToVisitLastQueue() {
            return this.toVisitLastQueue;
        }

        @NotNull
        public final HashSet<Long> getToVisitSet() {
            return this.toVisitSet;
        }

        @NotNull
        public final HashSet<Long> getToVisitLastSet() {
            return this.toVisitLastSet;
        }

        @NotNull
        public final LongScatterSet getVisitedSet() {
            return this.visitedSet;
        }

        @NotNull
        public final LongLongScatterMap getDominatedObjectIds() {
            return this.dominatedObjectIds;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean getQueuesNotEmpty() {
            Collection collection = this.toVisitQueue;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            collection = this.toVisitLastQueue;
            bl = false;
            if (collection.isEmpty()) return false;
            return true;
        }

        @NotNull
        public final Set<Long> getLeakingObjectIds() {
            return this.leakingObjectIds;
        }

        public final int getSizeOfObjectInstances() {
            return this.sizeOfObjectInstances;
        }

        public final boolean getComputeRetainedHeapSize() {
            return this.computeRetainedHeapSize;
        }

        public State(@NotNull Set<Long> leakingObjectIds, int sizeOfObjectInstances, boolean computeRetainedHeapSize) {
            Intrinsics.checkParameterIsNotNull(leakingObjectIds, (String)"leakingObjectIds");
            this.leakingObjectIds = leakingObjectIds;
            this.sizeOfObjectInstances = sizeOfObjectInstances;
            this.computeRetainedHeapSize = computeRetainedHeapSize;
            this.toVisitQueue = new ArrayDeque();
            this.toVisitLastQueue = new ArrayDeque();
            this.toVisitSet = new HashSet();
            this.toVisitLastSet = new HashSet();
            this.visitedSet = new LongScatterSet();
            this.dominatedObjectIds = new LongLongScatterMap();
        }
    }
}

