/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.ApplicationLeak;
import shark.HeapAnalysis;
import shark.HeapAnalysisException;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapAnalyzer;
import shark.HeapAnalyzer$WhenMappings;
import shark.HeapField;
import shark.HeapGraph;
import shark.HeapObject;
import shark.Hprof;
import shark.HprofHeapGraph;
import shark.LeakTrace;
import shark.LeakTraceObject;
import shark.LeakTraceReference;
import shark.LeakingObjectFinder;
import shark.LibraryLeak;
import shark.LibraryLeakReferenceMatcher;
import shark.MetadataExtractor;
import shark.ObjectInspector;
import shark.ObjectReporter;
import shark.OnAnalysisProgressListener;
import shark.ProguardMapping;
import shark.ReferenceMatcher;
import shark.SharkLog;
import shark.internal.PathFinder;
import shark.internal.ReferencePathNode;
import shark.internal.StringsKt;
import shark.internal.hppc.LongLongScatterMap;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002IJB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JR\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0015JV\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000eH\u0002J*\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u000eH\u0002J(\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"0\u000e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000eH\u0002J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u000e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020(0\u000eH\u0002J\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020(0/H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\u001bH\u0002J$\u00102\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0006\u00103\u001a\u00020&2\u0006\u00104\u001a\u00020\u0011H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0002J.\u00108\u001a\u00020+2\u0006\u00109\u001a\u00020(2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002060\u000e2\u0006\u0010;\u001a\u00020<2\u0006\u0010,\u001a\u00020-H\u0002J,\u0010=\u001a\u00020>*\u00020?2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00107\u001a\u000206H\u0002J,\u0010@\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020A0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0\u000e0\"*\u00020?2\u0006\u0010C\u001a\u00020DH\u0002J\u001c\u0010E\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010\u000e*\u00020?2\u0006\u0010C\u001a\u00020DH\u0002J2\u0010F\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020A0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0\u000e0\"*\u00020?2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002060HH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lshark/HeapAnalyzer;", "", "listener", "Lshark/OnAnalysisProgressListener;", "(Lshark/OnAnalysisProgressListener;)V", "analyze", "Lshark/HeapAnalysis;", "heapDumpFile", "Ljava/io/File;", "graph", "Lshark/HeapGraph;", "leakingObjectFinder", "Lshark/LeakingObjectFinder;", "referenceMatchers", "", "Lshark/ReferenceMatcher;", "computeRetainedHeapSize", "", "objectInspectors", "Lshark/ObjectInspector;", "metadataExtractor", "Lshark/MetadataExtractor;", "proguardMapping", "Lshark/ProguardMapping;", "buildLeakTraceObjects", "Lshark/LeakTraceObject;", "pathHeapObjects", "Lshark/HeapObject;", "buildReferencePath", "Lshark/LeakTraceReference;", "shortestChildPath", "Lshark/internal/ReferencePathNode$ChildNode;", "leakTraceObjects", "computeLeakStatuses", "Lkotlin/Pair;", "Lshark/LeakTraceObject$LeakingStatus;", "", "leakReporters", "Lshark/ObjectReporter;", "deduplicateShortestPaths", "Lshark/internal/ReferencePathNode;", "inputPathResults", "findResultsInTrie", "", "parentNode", "Lshark/HeapAnalyzer$TrieNode$ParentNode;", "outputPathResults", "", "recordClassName", "heap", "resolveStatus", "reporter", "leakingWins", "since", "", "analysisStartNanoTime", "updateTrie", "pathNode", "path", "pathIndex", "", "analyzeGraph", "Lshark/HeapAnalysisSuccess;", "Lshark/HeapAnalyzer$FindLeakInput;", "buildLeakTraces", "Lshark/ApplicationLeak;", "Lshark/LibraryLeak;", "pathFindingResults", "Lshark/internal/PathFinder$PathFindingResults;", "computeRetainedSizes", "findLeaks", "leakingObjectIds", "", "FindLeakInput", "TrieNode", "shark"})
public final class HeapAnalyzer {
    private final OnAnalysisProgressListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HeapAnalysis analyze(@NotNull File heapDumpFile, @NotNull LeakingObjectFinder leakingObjectFinder, @NotNull List<? extends ReferenceMatcher> referenceMatchers, boolean computeRetainedHeapSize, @NotNull List<? extends ObjectInspector> objectInspectors, @NotNull MetadataExtractor metadataExtractor, @Nullable ProguardMapping proguardMapping) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)heapDumpFile, (String)"heapDumpFile");
        Intrinsics.checkParameterIsNotNull((Object)leakingObjectFinder, (String)"leakingObjectFinder");
        Intrinsics.checkParameterIsNotNull(referenceMatchers, (String)"referenceMatchers");
        Intrinsics.checkParameterIsNotNull(objectInspectors, (String)"objectInspectors");
        Intrinsics.checkParameterIsNotNull((Object)metadataExtractor, (String)"metadataExtractor");
        long analysisStartNanoTime = System.nanoTime();
        if (!heapDumpFile.exists()) {
            IllegalArgumentException exception = new IllegalArgumentException("File does not exist: " + heapDumpFile);
            return new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), this.since(analysisStartNanoTime), new HeapAnalysisException(exception));
        }
        try {
            HeapAnalysisSuccess heapAnalysisSuccess;
            this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.PARSING_HEAP_DUMP);
            object = (Closeable)Hprof.Companion.open(heapDumpFile);
            boolean bl = false;
            Throwable throwable = null;
            try {
                Hprof hprof = (Hprof)object;
                boolean bl2 = false;
                HeapGraph graph = HprofHeapGraph.Companion.indexHprof$default((HprofHeapGraph.Companion)HprofHeapGraph.Companion, (Hprof)hprof, (ProguardMapping)proguardMapping, null, (int)4, null);
                FindLeakInput helpers = new FindLeakInput(graph, referenceMatchers, computeRetainedHeapSize, objectInspectors);
                heapAnalysisSuccess = this.analyzeGraph(helpers, metadataExtractor, leakingObjectFinder, heapDumpFile, analysisStartNanoTime);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = heapAnalysisSuccess;
        }
        catch (Throwable exception) {
            object = new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), this.since(analysisStartNanoTime), new HeapAnalysisException(exception));
        }
        return object;
    }

    public static /* synthetic */ HeapAnalysis analyze$default(HeapAnalyzer heapAnalyzer, File file, LeakingObjectFinder leakingObjectFinder, List list, boolean bl, List list2, MetadataExtractor metadataExtractor, ProguardMapping proguardMapping, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            metadataExtractor = MetadataExtractor.Companion.getNO_OP();
        }
        if ((n & 0x40) != 0) {
            proguardMapping = null;
        }
        return heapAnalyzer.analyze(file, leakingObjectFinder, list, bl, list2, metadataExtractor, proguardMapping);
    }

    @NotNull
    public final HeapAnalysis analyze(@NotNull File heapDumpFile, @NotNull HeapGraph graph, @NotNull LeakingObjectFinder leakingObjectFinder, @NotNull List<? extends ReferenceMatcher> referenceMatchers, boolean computeRetainedHeapSize, @NotNull List<? extends ObjectInspector> objectInspectors, @NotNull MetadataExtractor metadataExtractor) {
        HeapAnalysis heapAnalysis;
        Intrinsics.checkParameterIsNotNull((Object)heapDumpFile, (String)"heapDumpFile");
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)leakingObjectFinder, (String)"leakingObjectFinder");
        Intrinsics.checkParameterIsNotNull(referenceMatchers, (String)"referenceMatchers");
        Intrinsics.checkParameterIsNotNull(objectInspectors, (String)"objectInspectors");
        Intrinsics.checkParameterIsNotNull((Object)metadataExtractor, (String)"metadataExtractor");
        long analysisStartNanoTime = System.nanoTime();
        try {
            FindLeakInput helpers = new FindLeakInput(graph, referenceMatchers, computeRetainedHeapSize, objectInspectors);
            heapAnalysis = this.analyzeGraph(helpers, metadataExtractor, leakingObjectFinder, heapDumpFile, analysisStartNanoTime);
        }
        catch (Throwable exception) {
            heapAnalysis = new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), this.since(analysisStartNanoTime), new HeapAnalysisException(exception));
        }
        return heapAnalysis;
    }

    public static /* synthetic */ HeapAnalysis analyze$default(HeapAnalyzer heapAnalyzer, File file, HeapGraph heapGraph, LeakingObjectFinder leakingObjectFinder, List list, boolean bl, List list2, MetadataExtractor metadataExtractor, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            metadataExtractor = MetadataExtractor.Companion.getNO_OP();
        }
        return heapAnalyzer.analyze(file, heapGraph, leakingObjectFinder, list, bl, list2, metadataExtractor);
    }

    /*
     * WARNING - void declaration
     */
    private final HeapAnalysisSuccess analyzeGraph(@NotNull FindLeakInput $this$analyzeGraph, MetadataExtractor metadataExtractor, LeakingObjectFinder leakingObjectFinder, File heapDumpFile, long analysisStartNanoTime) {
        void applicationLeaks;
        this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.EXTRACTING_METADATA);
        Map<String, String> metadata = metadataExtractor.extractMetadata($this$analyzeGraph.getGraph());
        this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_RETAINED_OBJECTS);
        Set<Long> leakingObjectIds = leakingObjectFinder.findLeakingObjectIds($this$analyzeGraph.getGraph());
        Pair<List<ApplicationLeak>, List<LibraryLeak>> pair = this.findLeaks($this$analyzeGraph, leakingObjectIds);
        List list = (List)pair.component1();
        List libraryLeaks = (List)pair.component2();
        return new HeapAnalysisSuccess(heapDumpFile, System.currentTimeMillis(), this.since(analysisStartNanoTime), metadata, (List<ApplicationLeak>)applicationLeaks, libraryLeaks);
    }

    private final Pair<List<ApplicationLeak>, List<LibraryLeak>> findLeaks(@NotNull FindLeakInput $this$findLeaks, Set<Long> leakingObjectIds) {
        PathFinder pathFinder = new PathFinder($this$findLeaks.getGraph(), this.listener, $this$findLeaks.getReferenceMatchers());
        PathFinder.PathFindingResults pathFindingResults = pathFinder.findPathsFromGcRoots(leakingObjectIds, $this$findLeaks.getComputeRetainedHeapSize());
        SharkLog this_$iv = SharkLog.INSTANCE;
        boolean $i$f$d = false;
        SharkLog.Logger logger = this_$iv.getLogger();
        if (logger == null) {
        } else {
            SharkLog.Logger logger$iv;
            SharkLog.Logger logger2 = logger$iv = logger;
            boolean bl = false;
            String string = "Found " + leakingObjectIds.size() + " retained objects";
            logger2.d(string);
        }
        return this.buildLeakTraces($this$findLeaks, pathFindingResults);
    }

    private final List<ReferencePathNode> deduplicateShortestPaths(List<? extends ReferencePathNode> inputPathResults) {
        TrieNode.ParentNode rootTrieNode = new TrieNode.ParentNode(0L);
        for (ReferencePathNode referencePathNode : inputPathResults) {
            boolean bl = false;
            List path = new ArrayList();
            ReferencePathNode leakNode = referencePathNode;
            while (leakNode instanceof ReferencePathNode.ChildNode) {
                path.add(0, leakNode.getObjectId());
                leakNode = ((ReferencePathNode.ChildNode)leakNode).getParent();
            }
            path.add(0, leakNode.getObjectId());
            this.updateTrie(referencePathNode, path, 0, rootTrieNode);
        }
        boolean bl = false;
        List list = new ArrayList();
        this.findResultsInTrie(rootTrieNode, list);
        return list;
    }

    private final void updateTrie(ReferencePathNode pathNode, List<Long> path, int pathIndex, TrieNode.ParentNode parentNode) {
        long objectId = ((Number)path.get(pathIndex)).longValue();
        if (pathIndex == CollectionsKt.getLastIndex(path)) {
            parentNode.getChildren().put(objectId, new TrieNode.LeafNode(objectId, pathNode));
        } else {
            TrieNode childNode2;
            TrieNode trieNode = parentNode.getChildren().get(objectId);
            if (trieNode == null) {
                trieNode = childNode2 = (TrieNode)((Function0)new Function0<TrieNode.ParentNode>(objectId, parentNode){
                    final /* synthetic */ long $objectId;
                    final /* synthetic */ TrieNode.ParentNode $parentNode;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final TrieNode.ParentNode invoke() {
                        void var1_1;
                        TrieNode.ParentNode newChildNode = new TrieNode.ParentNode(this.$objectId);
                        this.$parentNode.getChildren().put(this.$objectId, newChildNode);
                        return var1_1;
                    }
                    {
                        this.$objectId = l;
                        this.$parentNode = parentNode;
                        super(0);
                    }
                }).invoke();
            }
            if (childNode2 instanceof TrieNode.ParentNode) {
                this.updateTrie(pathNode, path, pathIndex + 1, (TrieNode.ParentNode)childNode2);
            }
        }
    }

    private final void findResultsInTrie(TrieNode.ParentNode parentNode, List<ReferencePathNode> outputPathResults) {
        Iterable $this$forEach$iv = parentNode.getChildren().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrieNode childNode2 = (TrieNode)element$iv;
            boolean bl = false;
            TrieNode trieNode = childNode2;
            if (trieNode instanceof TrieNode.ParentNode) {
                this.findResultsInTrie((TrieNode.ParentNode)childNode2, outputPathResults);
                continue;
            }
            if (!(trieNode instanceof TrieNode.LeafNode)) continue;
            Collection collection = outputPathResults;
            ReferencePathNode referencePathNode = ((TrieNode.LeafNode)childNode2).getPathNode();
            boolean bl2 = false;
            collection.add(referencePathNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> computeRetainedSizes(@NotNull FindLeakInput $this$computeRetainedSizes, PathFinder.PathFindingResults pathFindingResults) {
        Number number;
        Collection collection;
        Iterator iterator;
        Object $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        if (!$this$computeRetainedSizes.getComputeRetainedHeapSize()) {
            return null;
        }
        List<ReferencePathNode> pathsToLeakingInstances = pathFindingResults.getPathsToLeakingObjects();
        LongLongScatterMap dominatedInstances = pathFindingResults.getDominatedObjectIds();
        this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.COMPUTING_NATIVE_RETAINED_SIZE);
        boolean bl = false;
        Map nativeSizes2 = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), (Function1)computeRetainedSizes.nativeSizes.1.INSTANCE);
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)$this$computeRetainedSizes.getGraph().getInstances(), (Function1)computeRetainedSizes.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapObject allocationRegistryRecord;
            HeapField allocationRegistryIdField;
            HeapObject thunkRecord;
            Long referentId;
            HeapObject.HeapInstance cleaner = (HeapObject.HeapInstance)element$iv;
            boolean bl2 = false;
            HeapField thunkField = cleaner.get("sun.misc.Cleaner", "thunk");
            HeapField heapField = thunkField;
            Long thunkId = heapField != null && (heapField = heapField.getValue()) != null ? heapField.getAsNonNullObjectId() : null;
            HeapField heapField2 = cleaner.get("java.lang.ref.Reference", "referent");
            Long l = heapField2 != null && (heapField2 = heapField2.getValue()) != null ? heapField2.getAsNonNullObjectId() : (referentId = null);
            if (thunkId == null || referentId == null || !((thunkRecord = thunkField.getValue().getAsObject()) instanceof HeapObject.HeapInstance) || !((HeapObject.HeapInstance)thunkRecord).instanceOf("libcore.util.NativeAllocationRegistry$CleanerThunk") || (allocationRegistryIdField = ((HeapObject.HeapInstance)thunkRecord).get("libcore.util.NativeAllocationRegistry$CleanerThunk", "this$0")) == null || !allocationRegistryIdField.getValue().isNonNullReference() || !((allocationRegistryRecord = allocationRegistryIdField.getValue().getAsObject()) instanceof HeapObject.HeapInstance) || !((HeapObject.HeapInstance)allocationRegistryRecord).instanceOf("libcore.util.NativeAllocationRegistry")) continue;
            int nativeSize = ((Number)MapsKt.getValue((Map)nativeSizes2, (Object)referentId)).intValue();
            Object object = ((HeapObject.HeapInstance)allocationRegistryRecord).get("libcore.util.NativeAllocationRegistry", "size");
            nativeSizes2.put(referentId, nativeSize += object != null && (object = object.getValue()) != null && (object = object.getAsLong()) != null ? (int)((Long)object).longValue() : 0);
        }
        this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.COMPUTING_RETAINED_SIZE);
        Map sizeByDominator2 = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), (Function1)computeRetainedSizes.sizeByDominator.1.INSTANCE);
        boolean bl3 = false;
        Set leakingInstanceIds = new LinkedHashSet();
        Iterable $this$forEach$iv2 = pathsToLeakingInstances;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            HeapObject.HeapInstance instanceRecord;
            ReferencePathNode pathNode = (ReferencePathNode)element$iv;
            boolean bl4 = false;
            long leakingInstanceObjectId = pathNode.getObjectId();
            leakingInstanceIds.add(leakingInstanceObjectId);
            if ($this$computeRetainedSizes.getGraph().findObjectById(leakingInstanceObjectId).getAsInstance() == null) {
                Intrinsics.throwNpe();
            }
            HeapObject.HeapClass heapClass = instanceRecord.getInstanceClass();
            int retainedSize = ((Number)MapsKt.getValue((Map)sizeByDominator2, (Object)leakingInstanceObjectId)).intValue();
            sizeByDominator2.put(leakingInstanceObjectId, retainedSize += heapClass.getInstanceByteSize());
        }
        dominatedInstances.forEach(new LongLongScatterMap.ForEachCallback($this$computeRetainedSizes, leakingInstanceIds, sizeByDominator2, nativeSizes2){
            final /* synthetic */ FindLeakInput $this_computeRetainedSizes;
            final /* synthetic */ Set $leakingInstanceIds;
            final /* synthetic */ Map $sizeByDominator;
            final /* synthetic */ Map $nativeSizes;

            public void onEntry(long instanceId, long dominatorId) {
                if (!this.$leakingInstanceIds.contains(instanceId)) {
                    int n;
                    int currentSize = ((Number)MapsKt.getValue((Map)this.$sizeByDominator, (Object)dominatorId)).intValue();
                    int nativeSize = ((Number)MapsKt.getValue((Map)this.$nativeSizes, (Object)instanceId)).intValue();
                    HeapObject objectRecord = this.$this_computeRetainedSizes.getGraph().findObjectById(instanceId);
                    if (objectRecord instanceof HeapObject.HeapInstance) {
                        n = ((HeapObject.HeapInstance)objectRecord).getByteSize();
                    } else if (objectRecord instanceof HeapObject.HeapObjectArray) {
                        n = ((HeapObject.HeapObjectArray)objectRecord).readByteSize();
                    } else if (objectRecord instanceof HeapObject.HeapPrimitiveArray) {
                        n = ((HeapObject.HeapPrimitiveArray)objectRecord).readByteSize();
                    } else {
                        if (objectRecord instanceof HeapObject.HeapClass) {
                            throw (Throwable)new IllegalStateException("Unexpected class record " + objectRecord);
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    int shallowSize = n;
                    this.$sizeByDominator.put(dominatorId, currentSize + nativeSize + shallowSize);
                }
            }
            {
                this.$this_computeRetainedSizes = $receiver;
                this.$leakingInstanceIds = $captured_local_variable$1;
                this.$sizeByDominator = $captured_local_variable$2;
                this.$nativeSizes = $captured_local_variable$3;
            }
        });
        Ref.BooleanRef sizedMoved = new Ref.BooleanRef();
        do {
            sizedMoved.element = false;
            $this$map$iv = pathsToLeakingInstances;
            $i$f$map = false;
            Iterable element$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                ReferencePathNode instanceRecord = (ReferencePathNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                number = it.getObjectId();
                collection.add(number);
            }
            Iterable $this$forEach$iv3 = (List)destination$iv$iv;
            boolean $i$f$forEach3 = false;
            $this$mapTo$iv$iv = $this$forEach$iv3.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv.next();
                long leakingInstanceId = ((Number)element$iv2).longValue();
                boolean bl6 = false;
                int dominatorSlot = dominatedInstances.getSlot(leakingInstanceId);
                if (dominatorSlot == -1) continue;
                long dominator = dominatedInstances.getSlotValue(dominatorSlot);
                int retainedSize = ((Number)MapsKt.getValue((Map)sizeByDominator2, (Object)leakingInstanceId)).intValue();
                if (retainedSize <= 0) continue;
                sizeByDominator2.put(leakingInstanceId, 0);
                int dominatorRetainedSize = ((Number)MapsKt.getValue((Map)sizeByDominator2, (Object)dominator)).intValue();
                sizeByDominator2.put(dominator, retainedSize + dominatorRetainedSize);
                sizedMoved.element = true;
            }
        } while (sizedMoved.element);
        dominatedInstances.release();
        $this$map$iv = pathsToLeakingInstances;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void pathNode;
            Object item$iv$iv = iterator.next();
            ReferencePathNode dominatorSlot = (ReferencePathNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            Object v = sizeByDominator2.get(pathNode.getObjectId());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            number = ((Number)v).intValue();
            collection.add(number);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<ApplicationLeak>, List<LibraryLeak>> buildLeakTraces(@NotNull FindLeakInput $this$buildLeakTraces, PathFinder.PathFindingResults pathFindingResults) {
        void $this$mapTo$iv$iv;
        List leakTraces22;
        void $this$mapTo$iv$iv2;
        List pathHeapObjects;
        Object object;
        int n;
        Object object2;
        Object object3;
        SharkLog.Logger logger$iv;
        boolean $i$f$d;
        SharkLog this_$iv;
        List<Integer> retainedSizes = this.computeRetainedSizes($this$buildLeakTraces, pathFindingResults);
        this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.BUILDING_LEAK_TRACES);
        boolean bl = false;
        Map applicationLeaksMap = new LinkedHashMap();
        boolean bl2 = false;
        Map libraryLeaksMap = new LinkedHashMap();
        List<ReferencePathNode> deduplicatedPaths = this.deduplicateShortestPaths(pathFindingResults.getPathsToLeakingObjects());
        if (deduplicatedPaths.size() != pathFindingResults.getPathsToLeakingObjects().size()) {
            this_$iv = SharkLog.INSTANCE;
            $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                logger$iv = logger;
                object3 = logger$iv;
                boolean bl3 = false;
                object2 = "Found " + pathFindingResults.getPathsToLeakingObjects().size() + " paths to retained objects," + " down to " + deduplicatedPaths.size() + " after removing duplicated paths";
                object3.d((String)object2);
            }
        } else {
            this_$iv = SharkLog.INSTANCE;
            $i$f$d = false;
            SharkLog.Logger logger = this_$iv.getLogger();
            if (logger == null) {
            } else {
                logger$iv = logger;
                object3 = logger$iv;
                boolean bl4 = false;
                object2 = "Found " + deduplicatedPaths.size() + " paths to retained objects";
                object3.d((String)object2);
            }
        }
        Iterable $this$forEachIndexed$iv = deduplicatedPaths;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Object object4;
            void $this$getOrPut$iv;
            Object matcher;
            ReferencePathNode.LibraryLeakNode firstLibraryLeakNode;
            ReferencePathNode.LibraryLeakNode libraryLeakNode;
            void retainedObjectNode;
            int n2 = index$iv++;
            boolean bl5 = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            n = n2;
            object = (ReferencePathNode)item$iv;
            int index = n;
            boolean bl6 = false;
            boolean bl7 = false;
            pathHeapObjects = new ArrayList();
            boolean bl8 = false;
            List shortestChildPath = new ArrayList();
            ReferencePathNode node = retainedObjectNode;
            while (node instanceof ReferencePathNode.ChildNode) {
                shortestChildPath.add(0, node);
                pathHeapObjects.add(0, $this$buildLeakTraces.getGraph().findObjectById(node.getObjectId()));
                node = ((ReferencePathNode.ChildNode)node).getParent();
            }
            void v2 = node;
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type shark.internal.ReferencePathNode.RootNode");
            }
            ReferencePathNode.RootNode rootNode = (ReferencePathNode.RootNode)v2;
            pathHeapObjects.add(0, $this$buildLeakTraces.getGraph().findObjectById(rootNode.getObjectId()));
            List<LeakTraceObject> leakTraceObjects = this.buildLeakTraceObjects($this$buildLeakTraces.getObjectInspectors(), pathHeapObjects);
            List<LeakTraceReference> referencePath = this.buildReferencePath(shortestChildPath, leakTraceObjects);
            List<Integer> list = retainedSizes;
            LeakTrace leakTrace = new LeakTrace(LeakTrace.GcRootType.Companion.fromGcRoot(rootNode.getGcRoot()), referencePath, (LeakTraceObject)CollectionsKt.last(leakTraceObjects), list != null ? list.get(index) : null);
            if (rootNode instanceof ReferencePathNode.LibraryLeakNode) {
                libraryLeakNode = (ReferencePathNode.LibraryLeakNode)((Object)rootNode);
            } else {
                Object v5;
                block20: {
                    Iterable $this$firstOrNull$iv = shortestChildPath;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ReferencePathNode.ChildNode it = (ReferencePathNode.ChildNode)element$iv;
                        boolean bl9 = false;
                        if (!(it instanceof ReferencePathNode.LibraryLeakNode)) continue;
                        v5 = element$iv;
                        break block20;
                    }
                    v5 = null;
                }
                libraryLeakNode = firstLibraryLeakNode = (ReferencePathNode.LibraryLeakNode)v5;
            }
            if (firstLibraryLeakNode != null) {
                Object object5;
                matcher = firstLibraryLeakNode.getMatcher();
                String signature2 = StringsKt.createSHA1Hash(((LibraryLeakReferenceMatcher)matcher).getPattern().toString());
                Object $this$getOrPut$iv2 = libraryLeaksMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv2.get(signature2);
                if (value$iv == null) {
                    boolean bl10 = false;
                    Object object6 = matcher;
                    boolean bl11 = false;
                    List list2 = new ArrayList();
                    Pair answer$iv = TuplesKt.to((Object)object6, (Object)list2);
                    $this$getOrPut$iv2.put(signature2, answer$iv);
                    object5 = answer$iv;
                } else {
                    object5 = value$iv;
                }
                $this$getOrPut$iv2 = (List)((Pair)object5).getSecond();
                $i$f$getOrPut = false;
                $this$getOrPut$iv2.add(leakTrace);
                continue;
            }
            matcher = applicationLeaksMap;
            String key$iv = leakTrace.getSignature();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl12 = false;
                boolean bl13 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object4 = answer$iv;
            } else {
                object4 = value$iv;
            }
            Collection collection = (List)object4;
            boolean bl14 = false;
            collection.add(leakTrace);
        }
        Map $this$map$iv = applicationLeaksMap;
        boolean $i$f$map = false;
        Map bl4 = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var13_24 = $this$mapTo$iv$iv2;
        n = 0;
        object = var13_24.entrySet().iterator();
        while (object.hasNext()) {
            void $dstr$_u24__u24$leakTraces;
            Map.Entry item$iv$iv;
            Map.Entry bl6 = item$iv$iv = (Map.Entry)object.next();
            object3 = destination$iv$iv;
            boolean bl15 = false;
            pathHeapObjects = $dstr$_u24__u24$leakTraces;
            boolean node = false;
            leakTraces22 = (List)pathHeapObjects.getValue();
            object2 = new ApplicationLeak(leakTraces22);
            object3.add(object2);
        }
        List applicationLeaks = (List)destination$iv$iv;
        Map $this$map$iv2 = libraryLeaksMap;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        void var14_27 = $this$mapTo$iv$iv;
        boolean bl16 = false;
        Iterator iterator = var14_27.entrySet().iterator();
        while (iterator.hasNext()) {
            void matcher;
            Pair pair;
            void $dstr$_u24__u24$pair;
            Map.Entry item$iv$iv;
            Map.Entry bl15 = item$iv$iv = iterator.next();
            object3 = destination$iv$iv2;
            boolean bl17 = false;
            LibraryLeakReferenceMatcher node = $dstr$_u24__u24$pair;
            boolean leakTraces22 = false;
            Pair pair2 = pair = (Pair)node.getValue();
            node = (LibraryLeakReferenceMatcher)pair2.component1();
            leakTraces22 = (List)pair2.component2();
            object2 = new LibraryLeak(leakTraces22, matcher.getPattern(), matcher.getDescription());
            object3.add(object2);
        }
        List libraryLeaks = (List)destination$iv$iv2;
        return TuplesKt.to((Object)applicationLeaks, (Object)libraryLeaks);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LeakTraceObject> buildLeakTraceObjects(List<? extends ObjectInspector> objectInspectors, List<? extends HeapObject> pathHeapObjects) {
        void $this$mapIndexedTo$iv$iv;
        Object element$iv2;
        Object object;
        Collection collection;
        Iterator $this$mapTo$iv$iv;
        Iterable $this$map$iv = pathHeapObjects;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void heapObject;
            Object item$iv$iv = iterator.next();
            HeapObject heapObject2 = (HeapObject)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new ObjectReporter((HeapObject)heapObject);
            collection.add(object);
        }
        List leakReporters = (List)destination$iv$iv;
        Iterable $this$forEach$iv = objectInspectors;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ObjectInspector inspector = (ObjectInspector)element$iv2;
            boolean bl = false;
            Iterable $this$forEach$iv2 = leakReporters;
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                ObjectReporter reporter = (ObjectReporter)element$iv3;
                boolean bl2 = false;
                inspector.inspect(reporter);
            }
        }
        List<Pair<LeakTraceObject.LeakingStatus, String>> leakStatuses = this.computeLeakStatuses(leakReporters);
        Iterable $this$mapIndexed$iv = pathHeapObjects;
        boolean $i$f$mapIndexed = false;
        element$iv2 = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void leakStatus;
            void heapObject;
            void index;
            int n = index$iv$iv++;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            HeapObject heapObject3 = (HeapObject)item$iv$iv;
            int n3 = n2;
            collection = collection2;
            boolean bl3 = false;
            ObjectReporter leakReporter = (ObjectReporter)leakReporters.get((int)index);
            Pair<LeakTraceObject.LeakingStatus, String> pair = leakStatuses.get((int)index);
            LeakTraceObject.LeakingStatus leakingStatus = (LeakTraceObject.LeakingStatus)((Object)pair.component1());
            String leakStatusReason = (String)pair.component2();
            String className = this.recordClassName((HeapObject)heapObject);
            LeakTraceObject.ObjectType objectType = heapObject instanceof HeapObject.HeapClass ? LeakTraceObject.ObjectType.CLASS : (heapObject instanceof HeapObject.HeapObjectArray || heapObject instanceof HeapObject.HeapPrimitiveArray ? LeakTraceObject.ObjectType.ARRAY : LeakTraceObject.ObjectType.INSTANCE);
            object = new LeakTraceObject(objectType, className, (Set<String>)leakReporter.getLabels(), (LeakTraceObject.LeakingStatus)leakStatus, leakStatusReason);
            collection.add(object);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LeakTraceReference> buildReferencePath(List<? extends ReferencePathNode.ChildNode> shortestChildPath, List<LeakTraceObject> leakTraceObjects) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = shortestChildPath;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void childNode2;
            void index;
            int n = index$iv$iv++;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            ReferencePathNode.ChildNode childNode3 = (ReferencePathNode.ChildNode)item$iv$iv;
            int n3 = n2;
            Collection collection2 = collection;
            boolean bl2 = false;
            LeakTraceReference leakTraceReference = new LeakTraceReference(leakTraceObjects.get((int)index), childNode2.getRefFromParentType(), childNode2.getRefFromParentName());
            collection2.add(leakTraceReference);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<LeakTraceObject.LeakingStatus, String>> computeLeakStatuses(List<ObjectReporter> leakReporters) {
        LeakTraceObject.LeakingStatus leakStatus;
        int index;
        Sequence $this$first$iv;
        String leakStatusReason;
        int i;
        void lastNotLeakingElementIndex;
        LeakTraceObject.LeakingStatus $this$mapTo$iv$iv;
        void firstLeakingElementIndex;
        Pair resolvedStatusPair;
        int lastElementIndex = leakReporters.size() - 1;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        Ref.IntRef intRef2 = new Ref.IntRef();
        intRef2.element = lastElementIndex;
        ArrayList<Pair> leakStatuses = new ArrayList<Pair>();
        boolean bl = false;
        for (ObjectReporter reporter : (Iterable)leakReporters) {
            Pair pair;
            void index2;
            block28: {
                Pair statusPair;
                block27: {
                    Pair pair2 = this.resolveStatus(reporter, index2 == lastElementIndex);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    statusPair = pair2;
                    boolean bl4 = false;
                    if (index2 != lastElementIndex) break block27;
                    switch (HeapAnalyzer$WhenMappings.$EnumSwitchMapping$0[((LeakTraceObject.LeakingStatus)((Object)statusPair.getFirst())).ordinal()]) {
                        case 1: {
                            pair = statusPair;
                            break block28;
                        }
                        case 2: {
                            pair = TuplesKt.to((Object)((Object)LeakTraceObject.LeakingStatus.LEAKING), (Object)"This is the leaking object");
                            break block28;
                        }
                        case 3: {
                            pair = TuplesKt.to((Object)((Object)LeakTraceObject.LeakingStatus.LEAKING), (Object)("This is the leaking object. Conflicts with " + (String)statusPair.getSecond()));
                            break block28;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                pair = statusPair;
            }
            resolvedStatusPair = pair;
            leakStatuses.add(resolvedStatusPair);
            Pair pair3 = resolvedStatusPair;
            LeakTraceObject.LeakingStatus leakStatus2 = (LeakTraceObject.LeakingStatus)((Object)pair3.component1());
            if (leakStatus2 == LeakTraceObject.LeakingStatus.NOT_LEAKING) {
                lastNotLeakingElementIndex.element = index2;
                firstLeakingElementIndex.element = lastElementIndex;
            } else if (leakStatus2 == LeakTraceObject.LeakingStatus.LEAKING && firstLeakingElementIndex.element == lastElementIndex) {
                firstLeakingElementIndex.element = index2;
            }
            ++index2;
        }
        Pair $this$map$iv22 = (Pair)leakReporters;
        boolean $i$f$map = false;
        resolvedStatusPair = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void reporter;
            Object item$iv$iv = iterator.next();
            ObjectReporter bl4 = (ObjectReporter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            String string = StringsKt.lastSegment(this.recordClassName(reporter.getHeapObject()), '.');
            collection.add(string);
        }
        List simpleClassNames = (List)destination$iv$iv;
        int $this$map$iv22 = 0;
        int n = lastNotLeakingElementIndex.element;
        while ($this$map$iv22 < n) {
            Pair pair;
            Object element$iv2;
            block25: {
                Pair $i$f$mapTo2 = (Pair)leakStatuses.get(i);
                $this$mapTo$iv$iv = (LeakTraceObject.LeakingStatus)((Object)$i$f$mapTo2.component1());
                leakStatusReason = (String)$i$f$mapTo2.component2();
                $this$first$iv = SequencesKt.generateSequence((Object)(i + 1), (Function1)((Function1)new Function1<Integer, Integer>((Ref.IntRef)lastNotLeakingElementIndex){
                    final /* synthetic */ Ref.IntRef $lastNotLeakingElementIndex;

                    @Nullable
                    public final Integer invoke(int index) {
                        return index < this.$lastNotLeakingElementIndex.element ? Integer.valueOf(index + 1) : null;
                    }
                    {
                        this.$lastNotLeakingElementIndex = intRef;
                        super(1);
                    }
                }));
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    index = ((Number)element$iv2).intValue();
                    boolean bl6 = false;
                    if (!((LeakTraceObject.LeakingStatus)((Object)((Pair)leakStatuses.get(index)).getFirst()) == LeakTraceObject.LeakingStatus.NOT_LEAKING)) continue;
                    break block25;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            int nextNotLeakingIndex2 = ((Number)element$iv2).intValue();
            String nextNotLeakingName = (String)simpleClassNames.get(nextNotLeakingIndex2);
            switch (HeapAnalyzer$WhenMappings.$EnumSwitchMapping$1[leakStatus.ordinal()]) {
                case 1: {
                    pair = TuplesKt.to((Object)((Object)LeakTraceObject.LeakingStatus.NOT_LEAKING), (Object)(nextNotLeakingName + "\u2193 is not leaking"));
                    break;
                }
                case 2: {
                    pair = TuplesKt.to((Object)((Object)LeakTraceObject.LeakingStatus.NOT_LEAKING), (Object)(nextNotLeakingName + "\u2193 is not leaking and " + leakStatusReason));
                    break;
                }
                case 3: {
                    pair = TuplesKt.to((Object)((Object)LeakTraceObject.LeakingStatus.NOT_LEAKING), (Object)(nextNotLeakingName + "\u2193 is not leaking. Conflicts with " + leakStatusReason));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            leakStatuses.set(i, pair);
            ++i;
        }
        if (firstLeakingElementIndex.element < lastElementIndex - 1 && (i = lastElementIndex - 1) >= (n = firstLeakingElementIndex.element + 1)) {
            while (true) {
                Pair pair;
                Object element$iv3;
                block26: {
                    Pair nextNotLeakingIndex2 = (Pair)leakStatuses.get(i);
                    leakStatus = (LeakTraceObject.LeakingStatus)((Object)nextNotLeakingIndex2.component1());
                    leakStatusReason = (String)nextNotLeakingIndex2.component2();
                    $this$first$iv = SequencesKt.generateSequence((Object)(i - 1), (Function1)((Function1)new Function1<Integer, Integer>((Ref.IntRef)firstLeakingElementIndex){
                        final /* synthetic */ Ref.IntRef $firstLeakingElementIndex;

                        @Nullable
                        public final Integer invoke(int index) {
                            return index > this.$firstLeakingElementIndex.element ? Integer.valueOf(index - 1) : null;
                        }
                        {
                            this.$firstLeakingElementIndex = intRef;
                            super(1);
                        }
                    }));
                    boolean $i$f$first = false;
                    for (Object element$iv3 : $this$first$iv) {
                        index = ((Number)element$iv3).intValue();
                        boolean bl7 = false;
                        if (!((LeakTraceObject.LeakingStatus)((Object)((Pair)leakStatuses.get(index)).getFirst()) == LeakTraceObject.LeakingStatus.LEAKING)) continue;
                        break block26;
                    }
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                int previousLeakingIndex2 = ((Number)element$iv3).intValue();
                String previousLeakingName = (String)simpleClassNames.get(previousLeakingIndex2);
                switch (HeapAnalyzer$WhenMappings.$EnumSwitchMapping$2[leakStatus.ordinal()]) {
                    case 1: {
                        pair = TuplesKt.to((Object)((Object)LeakTraceObject.LeakingStatus.LEAKING), (Object)(previousLeakingName + "\u2191 is leaking"));
                        break;
                    }
                    case 2: {
                        pair = TuplesKt.to((Object)((Object)LeakTraceObject.LeakingStatus.LEAKING), (Object)(previousLeakingName + "\u2191 is leaking and " + leakStatusReason));
                        break;
                    }
                    case 3: {
                        throw (Throwable)new IllegalStateException("Should never happen");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                leakStatuses.set(i, pair);
                if (i == n) break;
                --i;
            }
        }
        return leakStatuses;
    }

    private final Pair<LeakTraceObject.LeakingStatus, String> resolveStatus(ObjectReporter reporter, boolean leakingWins) {
        LeakTraceObject.LeakingStatus status = LeakTraceObject.LeakingStatus.UNKNOWN;
        String reason = "";
        Collection collection = reporter.getNotLeakingReasons();
        boolean bl = false;
        if (!collection.isEmpty()) {
            status = LeakTraceObject.LeakingStatus.NOT_LEAKING;
            reason = CollectionsKt.joinToString$default((Iterable)reporter.getNotLeakingReasons(), (CharSequence)" and ", null, null, (int)0, null, null, (int)62, null);
        }
        Set<String> leakingReasons = reporter.getLeakingReasons();
        Collection collection2 = leakingReasons;
        boolean bl2 = false;
        if (!collection2.isEmpty()) {
            String winReasons = CollectionsKt.joinToString$default((Iterable)leakingReasons, (CharSequence)" and ", null, null, (int)0, null, null, (int)62, null);
            if (status == LeakTraceObject.LeakingStatus.NOT_LEAKING) {
                if (leakingWins) {
                    status = LeakTraceObject.LeakingStatus.LEAKING;
                    reason = winReasons + ". Conflicts with " + reason;
                } else {
                    reason = reason + ". Conflicts with " + winReasons;
                }
            } else {
                status = LeakTraceObject.LeakingStatus.LEAKING;
                reason = winReasons;
            }
        }
        return TuplesKt.to((Object)((Object)status), (Object)reason);
    }

    private final String recordClassName(HeapObject heap) {
        String string;
        HeapObject heapObject = heap;
        if (heapObject instanceof HeapObject.HeapClass) {
            string = ((HeapObject.HeapClass)heap).getName();
        } else if (heapObject instanceof HeapObject.HeapInstance) {
            string = ((HeapObject.HeapInstance)heap).getInstanceClassName();
        } else if (heapObject instanceof HeapObject.HeapObjectArray) {
            string = ((HeapObject.HeapObjectArray)heap).getArrayClassName();
        } else if (heapObject instanceof HeapObject.HeapPrimitiveArray) {
            string = ((HeapObject.HeapPrimitiveArray)heap).getArrayClassName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final long since(long analysisStartNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - analysisStartNanoTime);
    }

    public HeapAnalyzer(@NotNull OnAnalysisProgressListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listener = listener;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lshark/HeapAnalyzer$FindLeakInput;", "", "graph", "Lshark/HeapGraph;", "referenceMatchers", "", "Lshark/ReferenceMatcher;", "computeRetainedHeapSize", "", "objectInspectors", "Lshark/ObjectInspector;", "(Lshark/HeapGraph;Ljava/util/List;ZLjava/util/List;)V", "getComputeRetainedHeapSize", "()Z", "getGraph", "()Lshark/HeapGraph;", "getObjectInspectors", "()Ljava/util/List;", "getReferenceMatchers", "shark"})
    private static final class FindLeakInput {
        @NotNull
        private final HeapGraph graph;
        @NotNull
        private final List<ReferenceMatcher> referenceMatchers;
        private final boolean computeRetainedHeapSize;
        @NotNull
        private final List<ObjectInspector> objectInspectors;

        @NotNull
        public final HeapGraph getGraph() {
            return this.graph;
        }

        @NotNull
        public final List<ReferenceMatcher> getReferenceMatchers() {
            return this.referenceMatchers;
        }

        public final boolean getComputeRetainedHeapSize() {
            return this.computeRetainedHeapSize;
        }

        @NotNull
        public final List<ObjectInspector> getObjectInspectors() {
            return this.objectInspectors;
        }

        public FindLeakInput(@NotNull HeapGraph graph, @NotNull List<? extends ReferenceMatcher> referenceMatchers, boolean computeRetainedHeapSize, @NotNull List<? extends ObjectInspector> objectInspectors) {
            Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
            Intrinsics.checkParameterIsNotNull(referenceMatchers, (String)"referenceMatchers");
            Intrinsics.checkParameterIsNotNull(objectInspectors, (String)"objectInspectors");
            this.graph = graph;
            this.referenceMatchers = referenceMatchers;
            this.computeRetainedHeapSize = computeRetainedHeapSize;
            this.objectInspectors = objectInspectors;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lshark/HeapAnalyzer$TrieNode;", "", "()V", "objectId", "", "getObjectId", "()J", "LeafNode", "ParentNode", "Lshark/HeapAnalyzer$TrieNode$ParentNode;", "Lshark/HeapAnalyzer$TrieNode$LeafNode;", "shark"})
    public static abstract class TrieNode {
        public abstract long getObjectId();

        private TrieNode() {
        }

        public /* synthetic */ TrieNode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lshark/HeapAnalyzer$TrieNode$ParentNode;", "Lshark/HeapAnalyzer$TrieNode;", "objectId", "", "(J)V", "children", "", "getChildren", "()Ljava/util/Map;", "getObjectId", "()J", "toString", "", "shark"})
        public static final class ParentNode
        extends TrieNode {
            @NotNull
            private final Map<Long, TrieNode> children;
            private final long objectId;

            @NotNull
            public final Map<Long, TrieNode> getChildren() {
                return this.children;
            }

            @NotNull
            public String toString() {
                return "ParentNode(objectId=" + this.getObjectId() + ", children=" + this.children + ')';
            }

            @Override
            public long getObjectId() {
                return this.objectId;
            }

            public ParentNode(long objectId) {
                super(null);
                Map map;
                this.objectId = objectId;
                ParentNode parentNode = this;
                boolean bl = false;
                parentNode.children = map = (Map)new LinkedHashMap();
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lshark/HeapAnalyzer$TrieNode$LeafNode;", "Lshark/HeapAnalyzer$TrieNode;", "objectId", "", "pathNode", "Lshark/internal/ReferencePathNode;", "(JLshark/internal/ReferencePathNode;)V", "getObjectId", "()J", "getPathNode", "()Lshark/internal/ReferencePathNode;", "shark"})
        public static final class LeafNode
        extends TrieNode {
            private final long objectId;
            @NotNull
            private final ReferencePathNode pathNode;

            @Override
            public long getObjectId() {
                return this.objectId;
            }

            @NotNull
            public final ReferencePathNode getPathNode() {
                return this.pathNode;
            }

            public LeafNode(long objectId, @NotNull ReferencePathNode pathNode) {
                Intrinsics.checkParameterIsNotNull((Object)pathNode, (String)"pathNode");
                super(null);
                this.objectId = objectId;
                this.pathNode = pathNode;
            }
        }
    }
}

