/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0003*\u00020\u0003H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0003H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0000\"\u0010\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"UTF_8", "Ljava/nio/charset/Charset;", "createHash", "", "text", "algorithm", "createSHA1Hash", "getBytes", "", "lastSegment", "segmentingChar", "", "shark"})
public final class StringsKt {
    @JvmField
    @NotNull
    public static final Charset UTF_8;

    @NotNull
    public static final String lastSegment(@NotNull String $this$lastSegment, char segmentingChar) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$lastSegment, (String)"$this$lastSegment");
        int separator = kotlin.text.StringsKt.lastIndexOf$default((CharSequence)$this$lastSegment, (char)segmentingChar, (int)0, (boolean)false, (int)6, null);
        if (separator == -1) {
            string = $this$lastSegment;
        } else {
            String string2 = $this$lastSegment;
            int n = separator + 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    @NotNull
    public static final String createSHA1Hash(@NotNull String $this$createSHA1Hash) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createSHA1Hash, (String)"$this$createSHA1Hash");
        return StringsKt.createHash($this$createSHA1Hash, "SHA-1");
    }

    private static final String createHash(String text, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(StringsKt.getBytes(text));
            byte[] messageDigest = digest.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : messageDigest) {
                hexString.append(Integer.toHexString(0xFF & b));
            }
            String string = hexString.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hexString.toString()");
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)((Object)new AssertionError((Object)("Unable to construct MessageDigest for " + algorithm)));
        }
    }

    @NotNull
    public static final byte[] getBytes(@NotNull String $this$getBytes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getBytes, (String)"$this$getBytes");
        String string = $this$getBytes;
        Charset charset = UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    static {
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-8\")");
        UTF_8 = charset;
    }
}

