/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.GcRoot;
import shark.HeapField;
import shark.HeapGraph;
import shark.HeapObject;
import shark.IgnoredReferenceMatcher;
import shark.OnAnalysisProgressListener;
import shark.internal.AndroidNativeSizeMapper;
import shark.internal.ChainingInstanceReferenceReader;
import shark.internal.ClassReferenceReader;
import shark.internal.DelegatingObjectReferenceReader;
import shark.internal.DominatorTree;
import shark.internal.FieldInstanceReferenceReader;
import shark.internal.JavaLocalReferenceReader;
import shark.internal.ObjectArrayReferenceReader;
import shark.internal.PathFinder;
import shark.internal.ShallowSizeCalculator;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J`\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J:\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001c\u001a\u00020\u00142\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u0019\u00a8\u0006\u001f"}, d2={"Lshark/internal/ObjectDominators;", "", "()V", "buildDominatorTree", "", "", "Lshark/internal/ObjectDominators$DominatorNode;", "graph", "Lshark/HeapGraph;", "ignoredRefs", "", "Lshark/IgnoredReferenceMatcher;", "printTree", "", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tree", "objectId", "minSize", "", "depth", "prefix", "", "isLast", "", "printStringContent", "renderDominatorTree", "minRetainedSize", "threadName", "DominatorNode", "shark"})
public final class ObjectDominators {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String renderDominatorTree(@NotNull HeapGraph graph, @NotNull List<IgnoredReferenceMatcher> ignoredRefs, int minRetainedSize, @Nullable String threadName, boolean printStringContent) {
        Collection collection;
        Iterator iterator;
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull(ignoredRefs, (String)"ignoredRefs");
        StringBuilder stringBuilder = new StringBuilder();
        Map<Long, DominatorNode> dominatorTree = this.buildDominatorTree(graph, ignoredRefs);
        DominatorNode root = (DominatorNode)MapsKt.getValue(dominatorTree, (Object)0L);
        stringBuilder.append("Total retained: " + root.getRetainedSize() + " bytes in " + root.getRetainedCount() + " objects. Root dominators: " + root.getDominatedObjectIds().size() + "\n\n");
        if (threadName != null) {
            Object e;
            boolean bl;
            Iterable $this$first$iv = graph.getGcRoots();
            boolean $i$f$first = false;
            iterator = $this$first$iv.iterator();
            do {
                if (!iterator.hasNext()) {
                    throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                e = iterator.next();
                GcRoot gcRoot = (GcRoot)e;
                boolean bl2 = false;
                if (gcRoot instanceof GcRoot.ThreadObject && graph.objectExists(gcRoot.getId())) {
                    HeapObject.HeapInstance heapInstance = graph.findObjectById(gcRoot.getId()).getAsInstance();
                    if (heapInstance == null) {
                        Intrinsics.throwNpe();
                    }
                    HeapField heapField = heapInstance.get("java.lang.Thread", "name");
                    if (heapField == null) {
                        Intrinsics.throwNpe();
                    }
                    if (Intrinsics.areEqual((Object)heapField.getValue().readAsJavaString(), (Object)threadName)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            collection = SetsKt.setOf((Object)((GcRoot)e).getId());
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = root.getDominatedObjectIds();
            boolean $i$f$filter = false;
            iterator = $this$filter$iv;
            Collection collection2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                long it = ((Number)element$iv$iv).longValue();
                boolean bl = false;
                if (!(((DominatorNode)MapsKt.getValue(dominatorTree, (Object)it)).getRetainedSize() > minRetainedSize)) continue;
                collection2.add(element$iv$iv);
            }
            collection = (List)collection2;
        }
        Collection rootIds = collection;
        Iterable $this$forEach$iv = rootIds;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String string = stringBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringBuilder.toString()");
                return string;
            }
            Object t = iterator.next();
            long objectId = ((Number)t).longValue();
            boolean bl = false;
            this.printTree(stringBuilder, graph, dominatorTree, objectId, minRetainedSize, 0, "", true, printStringContent);
            stringBuilder.append("\n");
        }
    }

    public static /* synthetic */ String renderDominatorTree$default(ObjectDominators objectDominators, HeapGraph heapGraph, List list, int n, String string, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        return objectDominators.renderDominatorTree(heapGraph, list, n, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void printTree(StringBuilder stringBuilder, HeapGraph graph, Map<Long, DominatorNode> tree, long objectId, int minSize, int depth, String prefix, boolean isLast, boolean printStringContent) {
        void $this$filterTo$iv$iv;
        String string;
        DominatorNode node = (DominatorNode)MapsKt.getValue(tree, (Object)objectId);
        HeapObject heapObject = graph.findObjectById(objectId);
        HeapObject heapObject2 = heapObject;
        if (heapObject2 instanceof HeapObject.HeapClass) {
            string = "class " + ((HeapObject.HeapClass)heapObject).getName();
        } else if (heapObject2 instanceof HeapObject.HeapInstance) {
            string = ((HeapObject.HeapInstance)heapObject).getInstanceClassName();
        } else if (heapObject2 instanceof HeapObject.HeapObjectArray) {
            string = ((HeapObject.HeapObjectArray)heapObject).getArrayClassName();
        } else if (heapObject2 instanceof HeapObject.HeapPrimitiveArray) {
            string = ((HeapObject.HeapPrimitiveArray)heapObject).getArrayClassName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String className = string;
        String anchor = depth == 0 ? "" : (isLast ? "\u2570\u2500" : "\u251c\u2500");
        String size = node.getRetainedSize() != node.getShallowSize() ? node.getRetainedSize() + " bytes (" + node.getShallowSize() + " self)" : node.getShallowSize() + " bytes";
        String count = node.getRetainedCount() > 1 ? "" + ' ' + node.getRetainedCount() + " objects" : "";
        String stringContent = printStringContent && heapObject instanceof HeapObject.HeapInstance && Intrinsics.areEqual((Object)((HeapObject.HeapInstance)heapObject).getInstanceClassName(), (Object)"java.lang.String") ? " \"" + ((HeapObject.HeapInstance)heapObject).readAsJavaString() + '\"' : "";
        stringBuilder.append(prefix + anchor + className + " #" + heapObject.getObjectIndex() + " Retained: " + size + count + stringContent + '\n');
        String newPrefix = depth == 0 ? "" : (isLast ? prefix + "  " : prefix + "\u2502 ");
        Iterable $this$filter$iv = node.getDominatedObjectIds();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            long it = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            if (!(((DominatorNode)MapsKt.getValue(tree, (Object)it)).getRetainedSize() > minSize)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List largeChildren = (List)destination$iv$iv;
        int lastIndex = CollectionsKt.getLastIndex(node.getDominatedObjectIds());
        Iterable $this$forEachIndexed$iv = largeChildren;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void objectId2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            long bl2 = ((Number)item$iv).longValue();
            int index = n2;
            boolean bl3 = false;
            this.printTree(stringBuilder, graph, tree, (long)objectId2, minSize, depth + 1, newPrefix, index == lastIndex, printStringContent);
        }
        if (largeChildren.size() < node.getDominatedObjectIds().size()) {
            stringBuilder.append(newPrefix + "\u2570\u2504\n");
        }
    }

    private final Map<Long, DominatorNode> buildDominatorTree(HeapGraph graph, List<IgnoredReferenceMatcher> ignoredRefs) {
        DelegatingObjectReferenceReader referenceReader = new DelegatingObjectReferenceReader(new ClassReferenceReader(graph, CollectionsKt.emptyList()), new ChainingInstanceReferenceReader(CollectionsKt.listOf((Object)new JavaLocalReferenceReader(graph, CollectionsKt.emptyList())), new FieldInstanceReferenceReader(graph, CollectionsKt.emptyList())), new ObjectArrayReferenceReader());
        PathFinder pathFinder = new PathFinder(graph, OnAnalysisProgressListener.Companion.getNO_OP(), referenceReader, ignoredRefs);
        AndroidNativeSizeMapper nativeSizeMapper = new AndroidNativeSizeMapper(graph);
        Map<Long, Integer> nativeSizes = nativeSizeMapper.mapNativeSizes();
        ShallowSizeCalculator shallowSizeCalculator = new ShallowSizeCalculator(graph);
        boolean bl = false;
        PathFinder.PathFindingResults result = pathFinder.findPathsFromGcRoots(SetsKt.emptySet(), true);
        DominatorTree dominatorTree = result.getDominatorTree();
        if (dominatorTree == null) {
            Intrinsics.throwNpe();
        }
        return dominatorTree.buildFullDominatorTree((Function1<? super Long, Integer>)((Function1)new Function1<Long, Integer>(nativeSizes, shallowSizeCalculator){
            final /* synthetic */ Map $nativeSizes;
            final /* synthetic */ ShallowSizeCalculator $shallowSizeCalculator;

            public final int invoke(long objectId) {
                Integer n = (Integer)this.$nativeSizes.get(objectId);
                int nativeSize = n != null ? n : 0;
                int shallowSize = this.$shallowSizeCalculator.computeShallowSize(objectId);
                return nativeSize + shallowSize;
            }
            {
                this.$nativeSizes = map;
                this.$shallowSizeCalculator = shallowSizeCalculator;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J7\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lshark/internal/ObjectDominators$DominatorNode;", "", "shallowSize", "", "retainedSize", "retainedCount", "dominatedObjectIds", "", "", "(IIILjava/util/List;)V", "getDominatedObjectIds", "()Ljava/util/List;", "getRetainedCount", "()I", "getRetainedSize", "getShallowSize", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "shark"})
    public static final class DominatorNode {
        private final int shallowSize;
        private final int retainedSize;
        private final int retainedCount;
        @NotNull
        private final List<Long> dominatedObjectIds;

        public final int getShallowSize() {
            return this.shallowSize;
        }

        public final int getRetainedSize() {
            return this.retainedSize;
        }

        public final int getRetainedCount() {
            return this.retainedCount;
        }

        @NotNull
        public final List<Long> getDominatedObjectIds() {
            return this.dominatedObjectIds;
        }

        public DominatorNode(int shallowSize, int retainedSize, int retainedCount, @NotNull List<Long> dominatedObjectIds) {
            Intrinsics.checkParameterIsNotNull(dominatedObjectIds, (String)"dominatedObjectIds");
            this.shallowSize = shallowSize;
            this.retainedSize = retainedSize;
            this.retainedCount = retainedCount;
            this.dominatedObjectIds = dominatedObjectIds;
        }

        public final int component1() {
            return this.shallowSize;
        }

        public final int component2() {
            return this.retainedSize;
        }

        public final int component3() {
            return this.retainedCount;
        }

        @NotNull
        public final List<Long> component4() {
            return this.dominatedObjectIds;
        }

        @NotNull
        public final DominatorNode copy(int shallowSize, int retainedSize, int retainedCount, @NotNull List<Long> dominatedObjectIds) {
            Intrinsics.checkParameterIsNotNull(dominatedObjectIds, (String)"dominatedObjectIds");
            return new DominatorNode(shallowSize, retainedSize, retainedCount, dominatedObjectIds);
        }

        public static /* synthetic */ DominatorNode copy$default(DominatorNode dominatorNode, int n, int n2, int n3, List list, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = dominatorNode.shallowSize;
            }
            if ((n4 & 2) != 0) {
                n2 = dominatorNode.retainedSize;
            }
            if ((n4 & 4) != 0) {
                n3 = dominatorNode.retainedCount;
            }
            if ((n4 & 8) != 0) {
                list = dominatorNode.dominatedObjectIds;
            }
            return dominatorNode.copy(n, n2, n3, list);
        }

        @NotNull
        public String toString() {
            return "DominatorNode(shallowSize=" + this.shallowSize + ", retainedSize=" + this.retainedSize + ", retainedCount=" + this.retainedCount + ", dominatedObjectIds=" + this.dominatedObjectIds + ")";
        }

        public int hashCode() {
            List<Long> list = this.dominatedObjectIds;
            return ((this.shallowSize * 31 + this.retainedSize) * 31 + this.retainedCount) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DominatorNode)) break block3;
                    DominatorNode dominatorNode = (DominatorNode)object;
                    if (this.shallowSize != dominatorNode.shallowSize || this.retainedSize != dominatorNode.retainedSize || this.retainedCount != dominatorNode.retainedCount || !Intrinsics.areEqual(this.dominatedObjectIds, dominatorNode.dominatedObjectIds)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

