/*
 * Decompiled with CFR 0.152.
 */
package shark;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import shark.HeapObject;
import shark.Reference;
import shark.ReferenceReader;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lshark/DelegatingObjectReferenceReader;", "Lshark/ReferenceReader;", "Lshark/HeapObject;", "classReferenceReader", "Lshark/HeapObject$HeapClass;", "instanceReferenceReader", "Lshark/HeapObject$HeapInstance;", "objectArrayReferenceReader", "Lshark/HeapObject$HeapObjectArray;", "(Lshark/ReferenceReader;Lshark/ReferenceReader;Lshark/ReferenceReader;)V", "read", "Lkotlin/sequences/Sequence;", "Lshark/Reference;", "source", "shark"})
public final class DelegatingObjectReferenceReader
implements ReferenceReader<HeapObject> {
    @NotNull
    private final ReferenceReader<HeapObject.HeapClass> classReferenceReader;
    @NotNull
    private final ReferenceReader<HeapObject.HeapInstance> instanceReferenceReader;
    @NotNull
    private final ReferenceReader<HeapObject.HeapObjectArray> objectArrayReferenceReader;

    public DelegatingObjectReferenceReader(@NotNull ReferenceReader<HeapObject.HeapClass> classReferenceReader, @NotNull ReferenceReader<HeapObject.HeapInstance> instanceReferenceReader, @NotNull ReferenceReader<HeapObject.HeapObjectArray> objectArrayReferenceReader) {
        Intrinsics.checkNotNullParameter(classReferenceReader, (String)"classReferenceReader");
        Intrinsics.checkNotNullParameter(instanceReferenceReader, (String)"instanceReferenceReader");
        Intrinsics.checkNotNullParameter(objectArrayReferenceReader, (String)"objectArrayReferenceReader");
        this.classReferenceReader = classReferenceReader;
        this.instanceReferenceReader = instanceReferenceReader;
        this.objectArrayReferenceReader = objectArrayReferenceReader;
    }

    @Override
    @NotNull
    public Sequence<Reference> read(@NotNull HeapObject source) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        HeapObject heapObject = source;
        if (heapObject instanceof HeapObject.HeapClass) {
            sequence = this.classReferenceReader.read((HeapObject.HeapClass)source);
        } else if (heapObject instanceof HeapObject.HeapInstance) {
            sequence = this.instanceReferenceReader.read((HeapObject.HeapInstance)source);
        } else if (heapObject instanceof HeapObject.HeapObjectArray) {
            sequence = this.objectArrayReferenceReader.read((HeapObject.HeapObjectArray)source);
        } else if (heapObject instanceof HeapObject.HeapPrimitiveArray) {
            sequence = SequencesKt.emptySequence();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sequence;
    }
}

