/*
 * Decompiled with CFR 0.152.
 */
package shark;

import androidx.collection.LongLongMap;
import androidx.collection.LongSet;
import androidx.collection.MutableLongLongMap;
import androidx.collection.MutableLongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import shark.ObjectDominators;
import shark.internal.hppc.LongLongScatterMap;
import shark.internal.hppc.LongScatterSet;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0086\u0002J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lshark/DominatorTree;", "", "expectedElements", "", "(I)V", "dominated", "Lshark/internal/hppc/LongLongScatterMap;", "buildFullDominatorTree", "", "", "Lshark/ObjectDominators$DominatorNode;", "objectSizeCalculator", "Lshark/DominatorTree$ObjectSizeCalculator;", "computeRetainedSizes", "Landroidx/collection/LongLongMap;", "retainedObjectIds", "Landroidx/collection/LongSet;", "contains", "", "objectId", "get", "dominatedObjectId", "updateDominated", "parentObjectId", "updateDominatedAsRoot", "MutableDominatorNode", "ObjectSizeCalculator", "shark"})
@SourceDebugExtension(value={"SMAP\nDominatorTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DominatorTree.kt\nshark/DominatorTree\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 IntIntPairUtils.kt\nshark/internal/IntIntPairUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 LongSet.kt\nandroidx/collection/LongSet\n+ 7 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n*L\n1#1,250:1\n215#2,2:251\n215#2:253\n216#2:256\n9#3:254\n13#3:255\n5#3:294\n1549#4:257\n1620#4,3:258\n1549#4:261\n1620#4,3:262\n1855#4:265\n1002#4,2:266\n1856#4:268\n1238#4,4:271\n442#5:269\n392#5:270\n361#5,7:303\n361#5,7:310\n262#6,4:275\n232#6,7:279\n243#6,3:287\n246#6,2:291\n266#6:293\n267#6:295\n249#6,6:296\n268#6:302\n1810#7:286\n1672#7:290\n*S KotlinDebug\n*F\n+ 1 DominatorTree.kt\nshark/DominatorTree\n*L\n137#1:251,2\n149#1:253\n149#1:256\n152#1:254\n153#1:255\n187#1:294\n160#1:257\n160#1:258,3\n162#1:261\n162#1:262,3\n165#1:265\n166#1:266,2\n165#1:268\n169#1:271,4\n169#1:269\n169#1:270\n126#1:303,7\n131#1:310,7\n186#1:275,4\n186#1:279,7\n186#1:287,3\n186#1:291,2\n186#1:293\n186#1:295\n186#1:296,6\n186#1:302\n186#1:286\n186#1:290\n*E\n"})
public final class DominatorTree {
    @NotNull
    private final LongLongScatterMap dominated;

    public DominatorTree(int expectedElements) {
        this.dominated = new LongLongScatterMap(expectedElements);
    }

    public /* synthetic */ DominatorTree(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        this(n);
    }

    public final boolean contains(long objectId) {
        return this.dominated.containsKey(objectId);
    }

    public final long get(long dominatedObjectId) {
        return this.dominated.get(dominatedObjectId);
    }

    public final boolean updateDominatedAsRoot(long objectId) {
        return this.updateDominated(objectId, 0L);
    }

    public final boolean updateDominated(long objectId, long parentObjectId) {
        boolean hasDominator;
        int dominatedSlot = this.dominated.getSlot(objectId);
        boolean bl = hasDominator = dominatedSlot != -1;
        if (!hasDominator || parentObjectId == 0L) {
            this.dominated.set(objectId, parentObjectId);
        } else {
            long currentDominator = this.dominated.getSlotValue(dominatedSlot);
            if (currentDominator != 0L) {
                int nextDominatorSlot;
                LongScatterSet currentDominators = new LongScatterSet(0, 1, null);
                long dominator = currentDominator;
                while (dominator != 0L) {
                    currentDominators.add(dominator);
                    nextDominatorSlot = this.dominated.getSlot(dominator);
                    if (nextDominatorSlot == -1) {
                        throw new IllegalStateException("Did not find dominator for " + dominator + " when going through the dominator chain for " + currentDominator + ": " + currentDominators);
                    }
                    dominator = this.dominated.getSlotValue(nextDominatorSlot);
                }
                dominator = parentObjectId;
                while (dominator != 0L && !currentDominators.contains(dominator)) {
                    nextDominatorSlot = this.dominated.getSlot(dominator);
                    if (nextDominatorSlot == -1) {
                        throw new IllegalStateException("Did not find dominator for " + dominator + " when going through the dominator chain for " + parentObjectId);
                    }
                    dominator = this.dominated.getSlotValue(nextDominatorSlot);
                }
                this.dominated.set(objectId, dominator);
            }
        }
        return hasDominator;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Long, ObjectDominators.DominatorNode> buildFullDominatorTree(@NotNull ObjectSizeCalculator objectSizeCalculator) {
        void $this$mapValuesTo$iv$iv;
        boolean bl;
        Collection<Object> collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Map.Entry element$iv;
        Intrinsics.checkNotNullParameter((Object)objectSizeCalculator, (String)"objectSizeCalculator");
        Map dominators = new LinkedHashMap();
        this.dominated.forEach((arg_0, arg_1) -> DominatorTree.buildFullDominatorTree$lambda$2(dominators, arg_0, arg_1));
        MutableLongSet allReachableObjectIds = new MutableLongSet(dominators.size());
        Map $this$forEach$iv = dominators;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            long key = ((Number)entry2.getKey()).longValue();
            if (key == 0L) continue;
            allReachableObjectIds.plusAssign(key);
        }
        LongLongMap retainedSizes = this.computeRetainedSizes((LongSet)allReachableObjectIds, arg_0 -> DominatorTree.buildFullDominatorTree$lambda$4(objectSizeCalculator, dominators, arg_0));
        Map $this$forEach$iv2 = dominators;
        boolean $i$f$forEach232 = false;
        Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            long retainedPacked;
            Map.Entry bl2 = element$iv = iterator2.next();
            boolean bl22 = false;
            long objectId = ((Number)bl2.getKey()).longValue();
            MutableDominatorNode node = (MutableDominatorNode)bl2.getValue();
            if (objectId == 0L) continue;
            long $this$unpackAsFirstInt$iv = retainedPacked = retainedSizes.get(objectId);
            boolean $i$f$getUnpackAsFirstInt = false;
            int retainedSize = (int)($this$unpackAsFirstInt$iv >> 32);
            long $this$unpackAsSecondInt$iv = retainedPacked;
            boolean $i$f$getUnpackAsSecondInt = false;
            int retainedCount = (int)($this$unpackAsSecondInt$iv & 0xFFFFFFFFL);
            node.setRetainedSize(retainedSize);
            node.setRetainedCount(retainedCount);
        }
        MutableDominatorNode rootDominator = (MutableDominatorNode)MapsKt.getValue((Map)dominators, (Object)0L);
        Iterable $i$f$forEach232 = rootDominator.getDominated();
        Object object = rootDominator;
        boolean bl3 = false;
        element$iv = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator objectId = $this$mapTo$iv$iv.iterator();
        while (objectId.hasNext()) {
            void it;
            item$iv$iv = objectId.next();
            long node = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv;
            bl = false;
            Object v = dominators.get((long)it);
            Intrinsics.checkNotNull(v);
            collection.add(((MutableDominatorNode)v).getRetainedSize());
        }
        ((MutableDominatorNode)object).setRetainedSize(CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv)));
        $this$map$iv = rootDominator.getDominated();
        object = rootDominator;
        boolean bl4 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        objectId = $this$mapTo$iv$iv.iterator();
        while (objectId.hasNext()) {
            item$iv$iv = objectId.next();
            long it = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv;
            bl = false;
            Object v = dominators.get(it);
            Intrinsics.checkNotNull(v);
            collection.add(((MutableDominatorNode)v).getRetainedCount());
        }
        ((MutableDominatorNode)object).setRetainedCount(CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv)));
        Iterable $this$forEach$iv3 = dominators.values();
        boolean bl5 = false;
        for (Object element$iv3 : $this$forEach$iv3) {
            MutableDominatorNode node = (MutableDominatorNode)element$iv3;
            boolean bl6 = false;
            List<Long> $this$sortBy$iv = node.getDominated();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() <= 1) continue;
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(dominators){
                final /* synthetic */ Map $dominators$inlined;
                {
                    this.$dominators$inlined = map;
                }

                public final int compare(T a, T b) {
                    long it = ((Number)a).longValue();
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(-((MutableDominatorNode)MapsKt.getValue((Map)this.$dominators$inlined, (Object)it)).getRetainedSize());
                    it = ((Number)b).longValue();
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-((MutableDominatorNode)MapsKt.getValue((Map)this.$dominators$inlined, (Object)it)).getRetainedSize()));
                }
            });
        }
        Map $this$mapValues$iv = dominators;
        boolean bl7 = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry bl8 = (Map.Entry)element$iv$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl32 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object = object2;
            boolean bl42 = false;
            MutableDominatorNode node = (MutableDominatorNode)entry.getValue();
            ObjectDominators.DominatorNode dominatorNode = new ObjectDominators.DominatorNode(node.getShallowSize(), node.getRetainedSize(), node.getRetainedCount(), node.getDominated());
            object.put(collection, dominatorNode);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LongLongMap computeRetainedSizes(@NotNull LongSet retainedObjectIds, @NotNull ObjectSizeCalculator objectSizeCalculator) {
        Intrinsics.checkNotNullParameter((Object)retainedObjectIds, (String)"retainedObjectIds");
        Intrinsics.checkNotNullParameter((Object)objectSizeCalculator, (String)"objectSizeCalculator");
        MutableLongLongMap nodeRetainedSizes = new MutableLongLongMap(retainedObjectIds.getSize());
        LongSet this_$iv = retainedObjectIds;
        boolean $i$f$forEach = false;
        long[] k$iv = this_$iv.elements;
        LongSet this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndex = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void $this$packedWith$iv;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            long objectId = k$iv[index$iv];
                            boolean bl2 = false;
                            boolean bl3 = false;
                            int that$iv = 0;
                            boolean $i$f$packedWith = false;
                            nodeRetainedSizes.set(objectId, (long)$this$packedWith$iv << 32 | (long)that$iv & 0xFFFFFFFFL);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this.dominated.forEach(new LongLongScatterMap.ForEachCallback(nodeRetainedSizes, objectSizeCalculator, this){
            final /* synthetic */ MutableLongLongMap $nodeRetainedSizes;
            final /* synthetic */ ObjectSizeCalculator $objectSizeCalculator;
            final /* synthetic */ DominatorTree this$0;
            {
                this.$nodeRetainedSizes = $nodeRetainedSizes;
                this.$objectSizeCalculator = $objectSizeCalculator;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void onEntry(long key, long value) {
                void $this$packedWith$iv;
                int instanceSize = -1;
                int n = -1;
                int that$iv = -1;
                boolean $i$f$packedWith = false;
                long missing = (long)$this$packedWith$iv << 32 | (long)that$iv & 0xFFFFFFFFL;
                long packedRetained = this.$nodeRetainedSizes.getOrDefault(key, missing);
                if (packedRetained != missing) {
                    void $this$packedWith$iv22;
                    long $this$unpackAsFirstInt$iv = packedRetained;
                    boolean $i$f$getUnpackAsFirstInt = false;
                    int currentRetainedSize = (int)($this$unpackAsFirstInt$iv >> 32);
                    long $this$unpackAsSecondInt$iv22 = packedRetained;
                    boolean $i$f$getUnpackAsSecondInt = false;
                    int currentRetainedCount = (int)($this$unpackAsSecondInt$iv22 & 0xFFFFFFFFL);
                    instanceSize = this.$objectSizeCalculator.computeSize(key);
                    int $this$unpackAsSecondInt$iv22 = currentRetainedSize + instanceSize;
                    int that$iv2 = currentRetainedCount + 1;
                    boolean $i$f$packedWith2 = false;
                    this.$nodeRetainedSizes.set(key, (long)$this$packedWith$iv22 << 32 | (long)that$iv2 & 0xFFFFFFFFL);
                }
                if (value != 0L) {
                    void $this$forEach$iv;
                    boolean $i$f$forEach;
                    long dominator = 0L;
                    dominator = value;
                    Object[] $this$packedWith$iv22 = new Long[]{key};
                    List dominatedByNextNode = CollectionsKt.mutableListOf((Object[])$this$packedWith$iv22);
                    while (dominator != 0L) {
                        if (this.$nodeRetainedSizes.containsKey(dominator)) {
                            void $this$packedWith$iv3;
                            long dominatorRetained;
                            void $this$forEach$iv2;
                            Iterable $this$packedWith$iv22 = dominatedByNextNode;
                            DominatorTree dominatorTree = this.this$0;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv2) {
                                long objectId = ((Number)element$iv).longValue();
                                boolean bl = false;
                                DominatorTree.access$getDominated$p(dominatorTree).set(objectId, dominator);
                            }
                            if (instanceSize == -1) {
                                instanceSize = this.$objectSizeCalculator.computeSize(key);
                            }
                            long $this$unpackAsFirstInt$iv = dominatorRetained = this.$nodeRetainedSizes.get(dominator);
                            boolean $i$f$getUnpackAsFirstInt = false;
                            int currentRetainedSize = (int)($this$unpackAsFirstInt$iv >> 32);
                            long $this$unpackAsSecondInt$iv32 = dominatorRetained;
                            boolean $i$f$getUnpackAsSecondInt = false;
                            int currentRetainedCount = (int)($this$unpackAsSecondInt$iv32 & 0xFFFFFFFFL);
                            int $this$unpackAsSecondInt$iv32 = currentRetainedSize + instanceSize;
                            int that$iv3 = currentRetainedCount + 1;
                            boolean $i$f$packedWith3 = false;
                            this.$nodeRetainedSizes.set(dominator, (long)$this$packedWith$iv3 << 32 | (long)that$iv3 & 0xFFFFFFFFL);
                            dominatedByNextNode.clear();
                        } else {
                            ((Collection)dominatedByNextNode).add(dominator);
                        }
                        dominator = DominatorTree.access$getDominated$p(this.this$0).get(dominator);
                    }
                    Iterable dominatorRetained = dominatedByNextNode;
                    DominatorTree dominatorTree = this.this$0;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        long objectId = ((Number)element$iv).longValue();
                        boolean bl = false;
                        DominatorTree.access$getDominated$p(dominatorTree).set(objectId, 0L);
                    }
                }
            }
        });
        this.dominated.release();
        return (LongLongMap)nodeRetainedSizes;
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildFullDominatorTree$lambda$2(Map $dominators, long key, long value) {
        Object object;
        void $this$getOrPut$iv;
        void $this$getOrPut$iv2;
        Intrinsics.checkNotNullParameter((Object)$dominators, (String)"$dominators");
        Object object2 = $dominators;
        Object key$iv = key;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv2.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            MutableDominatorNode answer$iv = new MutableDominatorNode();
            $this$getOrPut$iv2.put(key$iv, answer$iv);
        }
        key$iv = $dominators;
        Long key$iv2 = value;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(key$iv2);
        if (value$iv2 == null) {
            boolean bl = false;
            MutableDominatorNode answer$iv = new MutableDominatorNode();
            $this$getOrPut$iv.put(key$iv2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        object2 = (MutableDominatorNode)object;
        Long l = key;
        ((Collection)((MutableDominatorNode)object2).getDominated()).add(l);
    }

    private static final int buildFullDominatorTree$lambda$4(ObjectSizeCalculator $objectSizeCalculator, Map $dominators, long objectId) {
        Intrinsics.checkNotNullParameter((Object)$objectSizeCalculator, (String)"$objectSizeCalculator");
        Intrinsics.checkNotNullParameter((Object)$dominators, (String)"$dominators");
        int shallowSize = $objectSizeCalculator.computeSize(objectId);
        ((MutableDominatorNode)MapsKt.getValue((Map)$dominators, (Object)objectId)).setShallowSize(shallowSize);
        return shallowSize;
    }

    public DominatorTree() {
        this(0, 1, null);
    }

    public static final /* synthetic */ LongLongScatterMap access$getDominated$p(DominatorTree $this) {
        return $this.dominated;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u0014"}, d2={"Lshark/DominatorTree$MutableDominatorNode;", "", "()V", "dominated", "", "", "getDominated", "()Ljava/util/List;", "retainedCount", "", "getRetainedCount", "()I", "setRetainedCount", "(I)V", "retainedSize", "getRetainedSize", "setRetainedSize", "shallowSize", "getShallowSize", "setShallowSize", "shark"})
    private static final class MutableDominatorNode {
        private int shallowSize;
        private int retainedSize;
        private int retainedCount;
        @NotNull
        private final List<Long> dominated = new ArrayList();

        public final int getShallowSize() {
            return this.shallowSize;
        }

        public final void setShallowSize(int n) {
            this.shallowSize = n;
        }

        public final int getRetainedSize() {
            return this.retainedSize;
        }

        public final void setRetainedSize(int n) {
            this.retainedSize = n;
        }

        public final int getRetainedCount() {
            return this.retainedCount;
        }

        public final void setRetainedCount(int n) {
            this.retainedCount = n;
        }

        @NotNull
        public final List<Long> getDominated() {
            return this.dominated;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lshark/DominatorTree$ObjectSizeCalculator;", "", "computeSize", "", "objectId", "", "shark"})
    public static interface ObjectSizeCalculator {
        public int computeSize(long var1);
    }
}

