/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.AndroidReferenceReaderFactory;
import shark.ApplicationLeak;
import shark.CloseableHeapGraph;
import shark.ConstantMemoryMetricsDualSourceProvider;
import shark.DualSourceProvider;
import shark.FileSourceProvider;
import shark.HeapAnalysis;
import shark.HeapAnalysisException;
import shark.HeapAnalysisFailure;
import shark.HeapAnalysisSuccess;
import shark.HeapGraph;
import shark.HprofHeapGraph;
import shark.KeyedWeakReferenceFinder;
import shark.LeakTraceObject;
import shark.LeakTracer;
import shark.LeakingObjectFinder;
import shark.LeaksAndUnreachableObjects;
import shark.LibraryLeak;
import shark.MatchingGcRootProvider;
import shark.MetadataExtractor;
import shark.ObjectInspector;
import shark.OnAnalysisProgressListener;
import shark.PrioritizingShortestPathFinder;
import shark.ProguardMapping;
import shark.RealLeakTracerFactory;
import shark.ReferenceMatcher;
import shark.internal.KeyedWeakReferenceMirror;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JR\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0015JX\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lshark/HeapAnalyzer;", "", "listener", "Lshark/OnAnalysisProgressListener;", "(Lshark/OnAnalysisProgressListener;)V", "analyze", "Lshark/HeapAnalysis;", "heapDumpFile", "Ljava/io/File;", "graph", "Lshark/HeapGraph;", "leakingObjectFinder", "Lshark/LeakingObjectFinder;", "referenceMatchers", "", "Lshark/ReferenceMatcher;", "computeRetainedHeapSize", "", "objectInspectors", "Lshark/ObjectInspector;", "metadataExtractor", "Lshark/MetadataExtractor;", "proguardMapping", "Lshark/ProguardMapping;", "since", "", "analysisStartNanoTime", "shark"})
@SourceDebugExtension(value={"SMAP\nHeapAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapAnalyzer.kt\nshark/HeapAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1774#2,4:208\n*S KotlinDebug\n*F\n+ 1 HeapAnalyzer.kt\nshark/HeapAnalyzer\n*L\n166#1:208,4\n*E\n"})
public final class HeapAnalyzer {
    @NotNull
    private final OnAnalysisProgressListener listener;

    public HeapAnalyzer(@NotNull OnAnalysisProgressListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Use the non deprecated analyze method instead")
    @NotNull
    public final HeapAnalysis analyze(@NotNull File heapDumpFile, @NotNull LeakingObjectFinder leakingObjectFinder, @NotNull List<? extends ReferenceMatcher> referenceMatchers, boolean computeRetainedHeapSize, @NotNull List<? extends ObjectInspector> objectInspectors, @NotNull MetadataExtractor metadataExtractor, @Nullable ProguardMapping proguardMapping) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)heapDumpFile, (String)"heapDumpFile");
        Intrinsics.checkNotNullParameter((Object)leakingObjectFinder, (String)"leakingObjectFinder");
        Intrinsics.checkNotNullParameter(referenceMatchers, (String)"referenceMatchers");
        Intrinsics.checkNotNullParameter(objectInspectors, (String)"objectInspectors");
        Intrinsics.checkNotNullParameter((Object)metadataExtractor, (String)"metadataExtractor");
        if (!heapDumpFile.exists()) {
            IllegalArgumentException exception = new IllegalArgumentException("File does not exist: " + heapDumpFile);
            return new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), 0L, 0L, new HeapAnalysisException(exception), 4, null);
        }
        this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.PARSING_HEAP_DUMP);
        ConstantMemoryMetricsDualSourceProvider sourceProvider = new ConstantMemoryMetricsDualSourceProvider((DualSourceProvider)new FileSourceProvider(heapDumpFile));
        try {
            HeapAnalysis heapAnalysis;
            object = (Closeable)HprofHeapGraph.Companion.openHeapGraph$default((HprofHeapGraph.Companion)HprofHeapGraph.Companion, (DualSourceProvider)((DualSourceProvider)sourceProvider), (ProguardMapping)proguardMapping, null, (int)2, null);
            Throwable throwable = null;
            try {
                HeapAnalysis heapAnalysis2;
                CloseableHeapGraph graph = (CloseableHeapGraph)object;
                boolean bl = false;
                HeapAnalysis result = this.analyze(heapDumpFile, (HeapGraph)graph, leakingObjectFinder, referenceMatchers, computeRetainedHeapSize, objectInspectors, metadataExtractor);
                boolean bl2 = false;
                if (result instanceof HeapAnalysisSuccess) {
                    Intrinsics.checkNotNull((Object)graph, (String)"null cannot be cast to non-null type shark.HprofHeapGraph");
                    String lruCacheStats = ((HprofHeapGraph)graph).lruCacheStats();
                    String randomAccessStats = "RandomAccess[bytes=" + sourceProvider.getRandomAccessByteReads() + ",reads=" + sourceProvider.getRandomAccessReadCount() + ",travel=" + sourceProvider.getRandomAccessByteTravel() + ",range=" + sourceProvider.getByteTravelRange() + ",size=" + heapDumpFile.length() + ']';
                    String stats = lruCacheStats + ' ' + randomAccessStats;
                    heapAnalysis2 = HeapAnalysisSuccess.copy$default((HeapAnalysisSuccess)result, null, 0L, 0L, 0L, MapsKt.plus(((HeapAnalysisSuccess)result).getMetadata(), (Pair)TuplesKt.to((Object)"Stats", (Object)stats)), null, null, null, 239, null);
                } else {
                    heapAnalysis2 = result;
                }
                heapAnalysis = heapAnalysis2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = heapAnalysis;
        }
        catch (Throwable throwable) {
            object = new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), 0L, 0L, new HeapAnalysisException(throwable), 4, null);
        }
        return object;
    }

    public static /* synthetic */ HeapAnalysis analyze$default(HeapAnalyzer heapAnalyzer, File file, LeakingObjectFinder leakingObjectFinder, List list, boolean bl, List list2, MetadataExtractor metadataExtractor, ProguardMapping proguardMapping, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            metadataExtractor = MetadataExtractor.Companion.getNO_OP();
        }
        if ((n & 0x40) != 0) {
            proguardMapping = null;
        }
        return heapAnalyzer.analyze(file, leakingObjectFinder, list, bl, list2, metadataExtractor, proguardMapping);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HeapAnalysis analyze(@NotNull File heapDumpFile, @NotNull HeapGraph graph, @NotNull LeakingObjectFinder leakingObjectFinder, @NotNull List<? extends ReferenceMatcher> referenceMatchers, boolean computeRetainedHeapSize, @NotNull List<? extends ObjectInspector> objectInspectors, @NotNull MetadataExtractor metadataExtractor) {
        HeapAnalysis heapAnalysis;
        Intrinsics.checkNotNullParameter((Object)heapDumpFile, (String)"heapDumpFile");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)leakingObjectFinder, (String)"leakingObjectFinder");
        Intrinsics.checkNotNullParameter(referenceMatchers, (String)"referenceMatchers");
        Intrinsics.checkNotNullParameter(objectInspectors, (String)"objectInspectors");
        Intrinsics.checkNotNullParameter((Object)metadataExtractor, (String)"metadataExtractor");
        long analysisStartNanoTime = System.nanoTime();
        try {
            int n;
            void $this$count$iv;
            LeakTracer leakTracer = new RealLeakTracerFactory(new PrioritizingShortestPathFinder.Factory(arg_0 -> HeapAnalyzer.analyze$lambda$2(this, arg_0), new AndroidReferenceReaderFactory(referenceMatchers), new MatchingGcRootProvider(referenceMatchers), computeRetainedHeapSize), objectInspectors, arg_0 -> HeapAnalyzer.analyze$lambda$3(this, arg_0)).createFor(graph);
            this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.EXTRACTING_METADATA);
            Map metadata = metadataExtractor.extractMetadata(graph);
            Iterable iterable = KeyedWeakReferenceFinder.INSTANCE.findKeyedWeakReferences$shark(graph);
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    KeyedWeakReferenceMirror it = (KeyedWeakReferenceMirror)element$iv;
                    boolean bl = false;
                    if (!(it.isRetained() && !it.getHasReferent()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int retainedClearedWeakRefCount = n;
            Map metadataWithCount = retainedClearedWeakRefCount > 0 ? MapsKt.plus(metadata, (Pair)TuplesKt.to((Object)"Count of retained yet cleared", (Object)(retainedClearedWeakRefCount + " KeyedWeakReference instances"))) : metadata;
            this.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_RETAINED_OBJECTS);
            Set<Long> leakingObjectIds = leakingObjectFinder.findLeakingObjectIds(graph);
            LeaksAndUnreachableObjects leaksAndUnreachableObjects = leakTracer.traceObjects(leakingObjectIds);
            List<ApplicationLeak> applicationLeaks = leaksAndUnreachableObjects.component1();
            List<LibraryLeak> libraryLeaks = leaksAndUnreachableObjects.component2();
            List<LeakTraceObject> unreachableObjects = leaksAndUnreachableObjects.component3();
            heapAnalysis = new HeapAnalysisSuccess(heapDumpFile, System.currentTimeMillis(), 0L, this.since(analysisStartNanoTime), metadataWithCount, applicationLeaks, libraryLeaks, unreachableObjects, 4, null);
        }
        catch (Throwable exception) {
            heapAnalysis = new HeapAnalysisFailure(heapDumpFile, System.currentTimeMillis(), 0L, this.since(analysisStartNanoTime), new HeapAnalysisException(exception), 4, null);
        }
        return heapAnalysis;
    }

    public static /* synthetic */ HeapAnalysis analyze$default(HeapAnalyzer heapAnalyzer, File file, HeapGraph heapGraph, LeakingObjectFinder leakingObjectFinder, List list, boolean bl, List list2, MetadataExtractor metadataExtractor, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            metadataExtractor = MetadataExtractor.Companion.getNO_OP();
        }
        return heapAnalyzer.analyze(file, heapGraph, leakingObjectFinder, list, bl, list2, metadataExtractor);
    }

    private final long since(long analysisStartNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - analysisStartNanoTime);
    }

    private static final void analyze$lambda$2(HeapAnalyzer this$0, PrioritizingShortestPathFinder.Event event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PrioritizingShortestPathFinder.Event event2 = event;
        if (Intrinsics.areEqual((Object)event2, (Object)PrioritizingShortestPathFinder.Event.StartedFindingDominators.INSTANCE)) {
            this$0.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_DOMINATORS);
        } else if (Intrinsics.areEqual((Object)event2, (Object)PrioritizingShortestPathFinder.Event.StartedFindingPathsToRetainedObjects.INSTANCE)) {
            this$0.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.FINDING_PATHS_TO_RETAINED_OBJECTS);
        }
    }

    private static final void analyze$lambda$3(HeapAnalyzer this$0, RealLeakTracerFactory.Event event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RealLeakTracerFactory.Event event2 = event;
        if (Intrinsics.areEqual((Object)event2, (Object)RealLeakTracerFactory.Event.StartedBuildingLeakTraces.INSTANCE)) {
            this$0.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.BUILDING_LEAK_TRACES);
        } else if (Intrinsics.areEqual((Object)event2, (Object)RealLeakTracerFactory.Event.StartedComputingJavaHeapRetainedSize.INSTANCE)) {
            this$0.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.COMPUTING_RETAINED_SIZE);
        } else if (Intrinsics.areEqual((Object)event2, (Object)RealLeakTracerFactory.Event.StartedComputingNativeRetainedSize.INSTANCE)) {
            this$0.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.COMPUTING_NATIVE_RETAINED_SIZE);
        } else if (Intrinsics.areEqual((Object)event2, (Object)RealLeakTracerFactory.Event.StartedInspectingObjects.INSTANCE)) {
            this$0.listener.onAnalysisProgress(OnAnalysisProgressListener.Step.INSPECTING_OBJECTS);
        }
    }
}

