/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.internal.StringsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\n\b\u0086\b\u0018\u0000 32\u00020\u0001:\u0003345BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010&\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0019J^\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u00c6\u0001\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020\fH\u00d6\u0001J\b\u0010.\u001a\u00020\u0005H\u0016J/\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020*2\b\b\u0002\u0010\u001e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b2R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010\u00a8\u00066"}, d2={"Lshark/LeakTraceObject;", "Ljava/io/Serializable;", "type", "Lshark/LeakTraceObject$ObjectType;", "className", "", "labels", "", "leakingStatus", "Lshark/LeakTraceObject$LeakingStatus;", "leakingStatusReason", "retainedHeapByteSize", "", "retainedObjectCount", "(Lshark/LeakTraceObject$ObjectType;Ljava/lang/String;Ljava/util/Set;Lshark/LeakTraceObject$LeakingStatus;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getClassName", "()Ljava/lang/String;", "classSimpleName", "getClassSimpleName", "getLabels", "()Ljava/util/Set;", "getLeakingStatus", "()Lshark/LeakTraceObject$LeakingStatus;", "getLeakingStatusReason", "getRetainedHeapByteSize", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getRetainedObjectCount", "getType", "()Lshark/LeakTraceObject$ObjectType;", "typeName", "getTypeName", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Lshark/LeakTraceObject$ObjectType;Ljava/lang/String;Ljava/util/Set;Lshark/LeakTraceObject$LeakingStatus;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lshark/LeakTraceObject;", "equals", "", "other", "", "hashCode", "toString", "firstLinePrefix", "additionalLinesPrefix", "showLeakingStatus", "toString$shark", "Companion", "LeakingStatus", "ObjectType", "shark"})
public final class LeakTraceObject
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectType type;
    @NotNull
    private final String className;
    @NotNull
    private final Set<String> labels;
    @NotNull
    private final LeakingStatus leakingStatus;
    @NotNull
    private final String leakingStatusReason;
    @Nullable
    private final Integer retainedHeapByteSize;
    @Nullable
    private final Integer retainedObjectCount;
    private static final long serialVersionUID = -3616216391305196341L;

    public LeakTraceObject(@NotNull ObjectType type, @NotNull String className, @NotNull Set<String> labels, @NotNull LeakingStatus leakingStatus, @NotNull String leakingStatusReason, @Nullable Integer retainedHeapByteSize, @Nullable Integer retainedObjectCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)((Object)leakingStatus), (String)"leakingStatus");
        Intrinsics.checkNotNullParameter((Object)leakingStatusReason, (String)"leakingStatusReason");
        this.type = type;
        this.className = className;
        this.labels = labels;
        this.leakingStatus = leakingStatus;
        this.leakingStatusReason = leakingStatusReason;
        this.retainedHeapByteSize = retainedHeapByteSize;
        this.retainedObjectCount = retainedObjectCount;
    }

    @NotNull
    public final ObjectType getType() {
        return this.type;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final Set<String> getLabels() {
        return this.labels;
    }

    @NotNull
    public final LeakingStatus getLeakingStatus() {
        return this.leakingStatus;
    }

    @NotNull
    public final String getLeakingStatusReason() {
        return this.leakingStatusReason;
    }

    @Nullable
    public final Integer getRetainedHeapByteSize() {
        return this.retainedHeapByteSize;
    }

    @Nullable
    public final Integer getRetainedObjectCount() {
        return this.retainedObjectCount;
    }

    @NotNull
    public final String getClassSimpleName() {
        return StringsKt.lastSegment(this.className, '.');
    }

    @NotNull
    public final String getTypeName() {
        String string = this.type.name();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        return string2;
    }

    @NotNull
    public String toString() {
        String firstLinePrefix = "";
        String additionalLinesPrefix = "\u200b  ";
        return LeakTraceObject.toString$shark$default(this, firstLinePrefix, additionalLinesPrefix, true, null, 8, null);
    }

    @NotNull
    public final String toString$shark(@NotNull String firstLinePrefix, @NotNull String additionalLinesPrefix, boolean showLeakingStatus, @NotNull String typeName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)firstLinePrefix, (String)"firstLinePrefix");
        Intrinsics.checkNotNullParameter((Object)additionalLinesPrefix, (String)"additionalLinesPrefix");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        switch (WhenMappings.$EnumSwitchMapping$0[this.leakingStatus.ordinal()]) {
            case 1: {
                string = "UNKNOWN";
                break;
            }
            case 2: {
                string = "NO (" + this.leakingStatusReason + ')';
                break;
            }
            case 3: {
                string = "YES (" + this.leakingStatusReason + ')';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String leakStatus = string;
        String result = "";
        result = result + firstLinePrefix + this.className + ' ' + typeName;
        if (showLeakingStatus) {
            result = result + '\n' + additionalLinesPrefix + "Leaking: " + leakStatus;
        }
        if (this.retainedHeapByteSize != null) {
            String humanReadableRetainedHeapSize = LeakTraceObject.Companion.humanReadableByteCount(this.retainedHeapByteSize.intValue());
            result = result + '\n' + additionalLinesPrefix + "Retaining " + humanReadableRetainedHeapSize + " in " + this.retainedObjectCount + " objects";
        }
        for (String label : this.labels) {
            result = result + '\n' + additionalLinesPrefix + label;
        }
        return result;
    }

    public static /* synthetic */ String toString$shark$default(LeakTraceObject leakTraceObject, String string, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = leakTraceObject.getTypeName();
        }
        return leakTraceObject.toString$shark(string, string2, bl, string3);
    }

    @NotNull
    public final ObjectType component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.className;
    }

    @NotNull
    public final Set<String> component3() {
        return this.labels;
    }

    @NotNull
    public final LeakingStatus component4() {
        return this.leakingStatus;
    }

    @NotNull
    public final String component5() {
        return this.leakingStatusReason;
    }

    @Nullable
    public final Integer component6() {
        return this.retainedHeapByteSize;
    }

    @Nullable
    public final Integer component7() {
        return this.retainedObjectCount;
    }

    @NotNull
    public final LeakTraceObject copy(@NotNull ObjectType type, @NotNull String className, @NotNull Set<String> labels, @NotNull LeakingStatus leakingStatus, @NotNull String leakingStatusReason, @Nullable Integer retainedHeapByteSize, @Nullable Integer retainedObjectCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)((Object)leakingStatus), (String)"leakingStatus");
        Intrinsics.checkNotNullParameter((Object)leakingStatusReason, (String)"leakingStatusReason");
        return new LeakTraceObject(type, className, labels, leakingStatus, leakingStatusReason, retainedHeapByteSize, retainedObjectCount);
    }

    public static /* synthetic */ LeakTraceObject copy$default(LeakTraceObject leakTraceObject, ObjectType objectType, String string, Set set, LeakingStatus leakingStatus, String string2, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            objectType = leakTraceObject.type;
        }
        if ((n3 & 2) != 0) {
            string = leakTraceObject.className;
        }
        if ((n3 & 4) != 0) {
            set = leakTraceObject.labels;
        }
        if ((n3 & 8) != 0) {
            leakingStatus = leakTraceObject.leakingStatus;
        }
        if ((n3 & 0x10) != 0) {
            string2 = leakTraceObject.leakingStatusReason;
        }
        if ((n3 & 0x20) != 0) {
            n = leakTraceObject.retainedHeapByteSize;
        }
        if ((n3 & 0x40) != 0) {
            n2 = leakTraceObject.retainedObjectCount;
        }
        return leakTraceObject.copy(objectType, string, set, leakingStatus, string2, n, n2);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.className.hashCode();
        result = result * 31 + ((Object)this.labels).hashCode();
        result = result * 31 + this.leakingStatus.hashCode();
        result = result * 31 + this.leakingStatusReason.hashCode();
        result = result * 31 + (this.retainedHeapByteSize == null ? 0 : ((Object)this.retainedHeapByteSize).hashCode());
        result = result * 31 + (this.retainedObjectCount == null ? 0 : ((Object)this.retainedObjectCount).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LeakTraceObject)) {
            return false;
        }
        LeakTraceObject leakTraceObject = (LeakTraceObject)other;
        if (this.type != leakTraceObject.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.className, (Object)leakTraceObject.className)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.labels, leakTraceObject.labels)) {
            return false;
        }
        if (this.leakingStatus != leakTraceObject.leakingStatus) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.leakingStatusReason, (Object)leakTraceObject.leakingStatusReason)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.retainedHeapByteSize, (Object)leakTraceObject.retainedHeapByteSize)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.retainedObjectCount, (Object)leakTraceObject.retainedObjectCount);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lshark/LeakTraceObject$Companion;", "", "()V", "serialVersionUID", "", "humanReadableByteCount", "", "bytes", "shark"})
    public static final class Companion {
        private Companion() {
        }

        private final String humanReadableByteCount(long bytes) {
            int unit = 1000;
            if (bytes < (long)unit) {
                return bytes + " B";
            }
            int exp = (int)(Math.log(bytes) / Math.log(unit));
            char pre = "kMGTPE".charAt(exp - 1);
            String string = "%.1f %sB";
            Object[] objectArray = new Object[]{(double)bytes / Math.pow(unit, exp), Character.valueOf(pre)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lshark/LeakTraceObject$LeakingStatus;", "", "(Ljava/lang/String;I)V", "NOT_LEAKING", "LEAKING", "UNKNOWN", "shark"})
    public static final class LeakingStatus
    extends Enum<LeakingStatus> {
        public static final /* enum */ LeakingStatus NOT_LEAKING = new LeakingStatus();
        public static final /* enum */ LeakingStatus LEAKING = new LeakingStatus();
        public static final /* enum */ LeakingStatus UNKNOWN = new LeakingStatus();
        private static final /* synthetic */ LeakingStatus[] $VALUES;

        public static LeakingStatus[] values() {
            return (LeakingStatus[])$VALUES.clone();
        }

        public static LeakingStatus valueOf(String value) {
            return Enum.valueOf(LeakingStatus.class, value);
        }

        static {
            $VALUES = leakingStatusArray = new LeakingStatus[]{LeakingStatus.NOT_LEAKING, LeakingStatus.LEAKING, LeakingStatus.UNKNOWN};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lshark/LeakTraceObject$ObjectType;", "", "(Ljava/lang/String;I)V", "CLASS", "ARRAY", "INSTANCE", "shark"})
    public static final class ObjectType
    extends Enum<ObjectType> {
        public static final /* enum */ ObjectType CLASS = new ObjectType();
        public static final /* enum */ ObjectType ARRAY = new ObjectType();
        public static final /* enum */ ObjectType INSTANCE = new ObjectType();
        private static final /* synthetic */ ObjectType[] $VALUES;

        public static ObjectType[] values() {
            return (ObjectType[])$VALUES.clone();
        }

        public static ObjectType valueOf(String value) {
            return Enum.valueOf(ObjectType.class, value);
        }

        static {
            $VALUES = objectTypeArray = new ObjectType[]{ObjectType.CLASS, ObjectType.ARRAY, ObjectType.INSTANCE};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LeakingStatus.values().length];
            try {
                nArray[LeakingStatus.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LeakingStatus.NOT_LEAKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LeakingStatus.LEAKING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

