/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.ActualMatchingReferenceReaderFactory;
import shark.AndroidObjectSizeCalculator;
import shark.DominatorTree;
import shark.GcRoot;
import shark.HeapField;
import shark.HeapGraph;
import shark.HeapObject;
import shark.IgnoredReferenceMatcher;
import shark.MatchingGcRootProvider;
import shark.PathFindingResults;
import shark.PrioritizingShortestPathFinder;
import shark.ShortestPathFinder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ(\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ`\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J:\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001e\u001a\u00020\u00162\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001b\u00a8\u0006\""}, d2={"Lshark/ObjectDominators;", "", "()V", "buildDominatorTree", "", "", "Lshark/ObjectDominators$DominatorNode;", "graph", "Lshark/HeapGraph;", "ignoredRefs", "", "Lshark/IgnoredReferenceMatcher;", "buildOfflineDominatorTree", "Lshark/ObjectDominators$OfflineDominatorNode;", "printTree", "", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tree", "objectId", "minSize", "", "depth", "prefix", "", "isLast", "", "printStringContent", "renderDominatorTree", "minRetainedSize", "threadName", "DominatorNode", "OfflineDominatorNode", "shark"})
@SourceDebugExtension(value={"SMAP\nObjectDominators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectDominators.kt\nshark/ObjectDominators\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,177:1\n223#2,2:178\n766#2:180\n857#2,2:181\n1855#2,2:183\n766#2:185\n857#2,2:186\n1864#2,3:188\n1238#2,4:193\n442#3:191\n392#3:192\n*S KotlinDebug\n*F\n+ 1 ObjectDominators.kt\nshark/ObjectDominators\n*L\n51#1:178,2\n59#1:180\n59#1:181,2\n63#1:183,2\n123#1:185\n123#1:186,2\n126#1:188,3\n143#1:193,4\n143#1:191\n143#1:192\n*E\n"})
public final class ObjectDominators {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String renderDominatorTree(@NotNull HeapGraph graph, @NotNull List<IgnoredReferenceMatcher> ignoredRefs, int minRetainedSize, @Nullable String threadName, boolean printStringContent) {
        void $this$forEach$iv;
        Iterable $this$filter$iv;
        Collection collection;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(ignoredRefs, (String)"ignoredRefs");
        StringBuilder stringBuilder = new StringBuilder();
        Map<Long, DominatorNode> dominatorTree = this.buildDominatorTree(graph, ignoredRefs);
        DominatorNode root = (DominatorNode)MapsKt.getValue(dominatorTree, (Object)0L);
        stringBuilder.append("Total retained: " + root.getRetainedSize() + " bytes in " + root.getRetainedCount() + " objects. Root dominators: " + root.getDominatedObjectIds().size() + "\n\n");
        if (threadName != null) {
            Object e;
            boolean bl;
            Iterable $this$first$iv = graph.getGcRoots();
            boolean $i$f$first = false;
            iterator = $this$first$iv.iterator();
            do {
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                e = iterator.next();
                GcRoot gcRoot = (GcRoot)e;
                boolean bl2 = false;
                if (gcRoot instanceof GcRoot.ThreadObject && graph.objectExists(gcRoot.getId())) {
                    HeapObject.HeapInstance heapInstance = graph.findObjectById(gcRoot.getId()).getAsInstance();
                    Intrinsics.checkNotNull((Object)heapInstance);
                    HeapField heapField = heapInstance.get("java.lang.Thread", "name");
                    Intrinsics.checkNotNull((Object)heapField);
                    if (Intrinsics.areEqual((Object)heapField.getValue().readAsJavaString(), (Object)threadName)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            collection = SetsKt.setOf((Object)((GcRoot)e).getId());
        } else {
            void $this$filterTo$iv$iv;
            $this$filter$iv = root.getDominatedObjectIds();
            boolean $i$f$filter = false;
            iterator = $this$filter$iv;
            Collection collection2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                long it = ((Number)element$iv$iv).longValue();
                boolean bl = false;
                if (!(((DominatorNode)MapsKt.getValue(dominatorTree, (Object)it)).getRetainedSize() > minRetainedSize)) continue;
                collection2.add(element$iv$iv);
            }
            collection = (List)collection2;
        }
        Collection rootIds = collection;
        $this$filter$iv = rootIds;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
                return string;
            }
            Object t = iterator.next();
            long objectId = ((Number)t).longValue();
            boolean bl = false;
            this.printTree(stringBuilder, graph, dominatorTree, objectId, minRetainedSize, 0, "", true, printStringContent);
            stringBuilder.append("\n");
        }
    }

    public static /* synthetic */ String renderDominatorTree$default(ObjectDominators objectDominators, HeapGraph heapGraph, List list, int n, String string, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        return objectDominators.renderDominatorTree(heapGraph, list, n, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void printTree(StringBuilder stringBuilder, HeapGraph graph, Map<Long, DominatorNode> tree, long objectId, int minSize, int depth, String prefix, boolean isLast, boolean printStringContent) {
        long it;
        void $this$filterTo$iv$iv;
        String string;
        DominatorNode node = (DominatorNode)MapsKt.getValue(tree, (Object)objectId);
        HeapObject heapObject = graph.findObjectById(objectId);
        HeapObject heapObject2 = heapObject;
        if (heapObject2 instanceof HeapObject.HeapClass) {
            string = "class " + ((HeapObject.HeapClass)heapObject).getName();
        } else if (heapObject2 instanceof HeapObject.HeapInstance) {
            string = ((HeapObject.HeapInstance)heapObject).getInstanceClassName();
        } else if (heapObject2 instanceof HeapObject.HeapObjectArray) {
            string = ((HeapObject.HeapObjectArray)heapObject).getArrayClassName();
        } else if (heapObject2 instanceof HeapObject.HeapPrimitiveArray) {
            string = ((HeapObject.HeapPrimitiveArray)heapObject).getArrayClassName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String className = string;
        String anchor = depth == 0 ? "" : (isLast ? "\u2570\u2500" : "\u251c\u2500");
        String size = node.getRetainedSize() != node.getShallowSize() ? node.getRetainedSize() + " bytes (" + node.getShallowSize() + " self)" : node.getShallowSize() + " bytes";
        String count = node.getRetainedCount() > 1 ? "" + ' ' + node.getRetainedCount() + " objects" : "";
        String stringContent = printStringContent && heapObject instanceof HeapObject.HeapInstance && Intrinsics.areEqual((Object)((HeapObject.HeapInstance)heapObject).getInstanceClassName(), (Object)"java.lang.String") ? " \"" + ((HeapObject.HeapInstance)heapObject).readAsJavaString() + '\"' : "";
        stringBuilder.append(prefix + anchor + className + " #" + heapObject.getObjectIndex() + " Retained: " + size + count + stringContent + '\n');
        String newPrefix = depth == 0 ? "" : (isLast ? prefix + "  " : prefix + "\u2502 ");
        Iterable $this$filter$iv = node.getDominatedObjectIds();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = ((Number)element$iv$iv).longValue();
            boolean bl = false;
            if (!(((DominatorNode)MapsKt.getValue(tree, (Object)it)).getRetainedSize() > minSize)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List largeChildren = (List)destination$iv$iv;
        int lastIndex = CollectionsKt.getLastIndex(node.getDominatedObjectIds());
        Iterable $this$forEachIndexed$iv = largeChildren;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void objectId2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = ((Number)item$iv).longValue();
            int index = n;
            boolean bl = false;
            this.printTree(stringBuilder, graph, tree, (long)objectId2, minSize, depth + 1, newPrefix, index == lastIndex, printStringContent);
        }
        if (largeChildren.size() < node.getDominatedObjectIds().size()) {
            stringBuilder.append(newPrefix + "\u2570\u2504\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Long, OfflineDominatorNode> buildOfflineDominatorTree(@NotNull HeapGraph graph, @NotNull List<IgnoredReferenceMatcher> ignoredRefs) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(ignoredRefs, (String)"ignoredRefs");
        Map<Long, DominatorNode> $this$mapValues$iv = this.buildDominatorTree(graph, ignoredRefs);
        boolean $i$f$mapValues = false;
        Map<Long, DominatorNode> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            long objectId = ((Number)entry2.getKey()).longValue();
            DominatorNode node = (DominatorNode)entry2.getValue();
            if (objectId == 0L) {
                string = "root";
            } else {
                HeapObject heapObject = graph.findObjectById(objectId);
                if (heapObject instanceof HeapObject.HeapClass) {
                    string = "class " + ((HeapObject.HeapClass)heapObject).getName();
                } else if (heapObject instanceof HeapObject.HeapInstance) {
                    string = ((HeapObject.HeapInstance)heapObject).getInstanceClassName();
                } else if (heapObject instanceof HeapObject.HeapObjectArray) {
                    string = ((HeapObject.HeapObjectArray)heapObject).getArrayClassName();
                } else if (heapObject instanceof HeapObject.HeapPrimitiveArray) {
                    string = ((HeapObject.HeapPrimitiveArray)heapObject).getArrayClassName();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String name = string;
            OfflineDominatorNode offlineDominatorNode = new OfflineDominatorNode(node, name);
            map3.put(k, offlineDominatorNode);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final Map<Long, DominatorNode> buildDominatorTree(@NotNull HeapGraph graph, @NotNull List<IgnoredReferenceMatcher> ignoredRefs) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(ignoredRefs, (String)"ignoredRefs");
        ShortestPathFinder pathFinder = new PrioritizingShortestPathFinder.Factory(ObjectDominators::buildDominatorTree$lambda$6, new ActualMatchingReferenceReaderFactory(CollectionsKt.emptyList()), new MatchingGcRootProvider(ignoredRefs), true).createFor(graph);
        AndroidObjectSizeCalculator objectSizeCalculator = new AndroidObjectSizeCalculator(graph);
        PathFindingResults result = pathFinder.findShortestPathsFromGcRoots(SetsKt.emptySet());
        DominatorTree dominatorTree = result.getDominatorTree();
        Intrinsics.checkNotNull((Object)dominatorTree);
        return dominatorTree.buildFullDominatorTree(objectSizeCalculator);
    }

    private static final void buildDominatorTree$lambda$6(PrioritizingShortestPathFinder.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J7\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001c"}, d2={"Lshark/ObjectDominators$DominatorNode;", "Ljava/io/Serializable;", "shallowSize", "", "retainedSize", "retainedCount", "dominatedObjectIds", "", "", "(IIILjava/util/List;)V", "getDominatedObjectIds", "()Ljava/util/List;", "getRetainedCount", "()I", "getRetainedSize", "getShallowSize", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "shark"})
    public static final class DominatorNode
    implements Serializable {
        private final int shallowSize;
        private final int retainedSize;
        private final int retainedCount;
        @NotNull
        private final List<Long> dominatedObjectIds;

        public DominatorNode(int shallowSize, int retainedSize, int retainedCount, @NotNull List<Long> dominatedObjectIds) {
            Intrinsics.checkNotNullParameter(dominatedObjectIds, (String)"dominatedObjectIds");
            this.shallowSize = shallowSize;
            this.retainedSize = retainedSize;
            this.retainedCount = retainedCount;
            this.dominatedObjectIds = dominatedObjectIds;
        }

        public final int getShallowSize() {
            return this.shallowSize;
        }

        public final int getRetainedSize() {
            return this.retainedSize;
        }

        public final int getRetainedCount() {
            return this.retainedCount;
        }

        @NotNull
        public final List<Long> getDominatedObjectIds() {
            return this.dominatedObjectIds;
        }

        public final int component1() {
            return this.shallowSize;
        }

        public final int component2() {
            return this.retainedSize;
        }

        public final int component3() {
            return this.retainedCount;
        }

        @NotNull
        public final List<Long> component4() {
            return this.dominatedObjectIds;
        }

        @NotNull
        public final DominatorNode copy(int shallowSize, int retainedSize, int retainedCount, @NotNull List<Long> dominatedObjectIds) {
            Intrinsics.checkNotNullParameter(dominatedObjectIds, (String)"dominatedObjectIds");
            return new DominatorNode(shallowSize, retainedSize, retainedCount, dominatedObjectIds);
        }

        public static /* synthetic */ DominatorNode copy$default(DominatorNode dominatorNode, int n, int n2, int n3, List list, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = dominatorNode.shallowSize;
            }
            if ((n4 & 2) != 0) {
                n2 = dominatorNode.retainedSize;
            }
            if ((n4 & 4) != 0) {
                n3 = dominatorNode.retainedCount;
            }
            if ((n4 & 8) != 0) {
                list = dominatorNode.dominatedObjectIds;
            }
            return dominatorNode.copy(n, n2, n3, list);
        }

        @NotNull
        public String toString() {
            return "DominatorNode(shallowSize=" + this.shallowSize + ", retainedSize=" + this.retainedSize + ", retainedCount=" + this.retainedCount + ", dominatedObjectIds=" + this.dominatedObjectIds + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.shallowSize);
            result = result * 31 + Integer.hashCode(this.retainedSize);
            result = result * 31 + Integer.hashCode(this.retainedCount);
            result = result * 31 + ((Object)this.dominatedObjectIds).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DominatorNode)) {
                return false;
            }
            DominatorNode dominatorNode = (DominatorNode)other;
            if (this.shallowSize != dominatorNode.shallowSize) {
                return false;
            }
            if (this.retainedSize != dominatorNode.retainedSize) {
                return false;
            }
            if (this.retainedCount != dominatorNode.retainedCount) {
                return false;
            }
            return Intrinsics.areEqual(this.dominatedObjectIds, dominatorNode.dominatedObjectIds);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lshark/ObjectDominators$OfflineDominatorNode;", "Ljava/io/Serializable;", "node", "Lshark/ObjectDominators$DominatorNode;", "name", "", "(Lshark/ObjectDominators$DominatorNode;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getNode", "()Lshark/ObjectDominators$DominatorNode;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "shark"})
    public static final class OfflineDominatorNode
    implements Serializable {
        @NotNull
        private final DominatorNode node;
        @NotNull
        private final String name;

        public OfflineDominatorNode(@NotNull DominatorNode node, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.node = node;
            this.name = name;
        }

        @NotNull
        public final DominatorNode getNode() {
            return this.node;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final DominatorNode component1() {
            return this.node;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final OfflineDominatorNode copy(@NotNull DominatorNode node, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new OfflineDominatorNode(node, name);
        }

        public static /* synthetic */ OfflineDominatorNode copy$default(OfflineDominatorNode offlineDominatorNode, DominatorNode dominatorNode, String string, int n, Object object) {
            if ((n & 1) != 0) {
                dominatorNode = offlineDominatorNode.node;
            }
            if ((n & 2) != 0) {
                string = offlineDominatorNode.name;
            }
            return offlineDominatorNode.copy(dominatorNode, string);
        }

        @NotNull
        public String toString() {
            return "OfflineDominatorNode(node=" + this.node + ", name=" + this.name + ')';
        }

        public int hashCode() {
            int result = this.node.hashCode();
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OfflineDominatorNode)) {
                return false;
            }
            OfflineDominatorNode offlineDominatorNode = (OfflineDominatorNode)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)offlineDominatorNode.node)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)offlineDominatorNode.name);
        }
    }
}

