/*
 * Decompiled with CFR 0.152.
 */
package shark;

import androidx.collection.LongList;
import androidx.collection.LongListKt;
import androidx.collection.LongLongMap;
import androidx.collection.LongSet;
import androidx.collection.MutableLongList;
import androidx.collection.MutableLongLongMap;
import androidx.collection.MutableLongSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.AndroidObjectSizeCalculator;
import shark.ByteSize;
import shark.ByteSizeKt;
import shark.DominatorTree;
import shark.FirstHeapTraversal;
import shark.GcRootProvider;
import shark.GcRootReference;
import shark.HeapDiff;
import shark.HeapGraph;
import shark.HeapObject;
import shark.HeapTraversalInput;
import shark.HeapTraversalOutput;
import shark.InitialState;
import shark.Reference;
import shark.ReferenceLocationType;
import shark.ReferenceReader;
import shark.Retained;
import shark.RetainedKt;
import shark.ShortestPathObjectNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 (2\u00020\u0001:\u0006()*+,-B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ>\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u001e\u0010\u001b\u001a\u00020\u000f*\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\f\u0010$\u001a\u00020%*\u00020\u0010H\u0002J\u001c\u0010&\u001a\u00020\t*\u00020\u00102\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lshark/ObjectGrowthDetector;", "", "gcRootProvider", "Lshark/GcRootProvider;", "referenceReaderFactory", "Lshark/ReferenceReader$Factory;", "Lshark/HeapObject;", "(Lshark/GcRootProvider;Lshark/ReferenceReader$Factory;)V", "findGrowingObjects", "Lshark/HeapTraversalOutput;", "heapGraph", "Lshark/HeapGraph;", "previousTraversal", "Lshark/HeapTraversalInput;", "enqueue", "", "Lshark/ObjectGrowthDetector$TraversalState;", "parentPathNode", "Lshark/ShortestPathObjectNode;", "previousPathNode", "objectIds", "", "nodeAndEdgeName", "", "isLowPriority", "", "isLeafObject", "enqueueRoots", "previousTree", "increase", "", "Landroidx/collection/MutableLongLongMap;", "objectId", "addedValue1", "", "addedValue2", "poll", "Lshark/ObjectGrowthDetector$Node;", "traverseHeapDiffingShortestPaths", "graph", "Companion", "DequeuedNode", "Edge", "EdgeKey", "Node", "TraversalState", "shark"})
@SourceDebugExtension(value={"SMAP\nObjectGrowthDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectGrowthDetector.kt\nshark/ObjectGrowthDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 LongList.kt\nandroidx/collection/MutableLongList\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 LongList.kt\nandroidx/collection/LongList\n+ 8 IntIntPairUtils.kt\nshark/internal/IntIntPairUtilsKt\n+ 9 ByteSize.kt\nshark/ByteSizeKt\n+ 10 ByteSize.kt\nshark/ByteSize\n+ 11 Retained.kt\nshark/RetainedKt\n+ 12 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 13 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 14 Retained.kt\nshark/Retained\n*L\n1#1,514:1\n13607#2:515\n13608#2:520\n13607#2,2:562\n1295#3:516\n1296#3:519\n674#3:553\n704#3,4:554\n1295#3:590\n1296#3:593\n713#4,2:517\n713#4,2:591\n1194#5,2:521\n1222#5,4:523\n1603#5,9:543\n1855#5:552\n1855#5,2:558\n1856#5:565\n1612#5:566\n1855#5:567\n1856#5:583\n1194#5,2:584\n1222#5,4:586\n204#6,3:527\n207#6:536\n204#6,3:594\n207#6:609\n266#7,6:530\n253#7,6:597\n266#7,6:603\n9#8:537\n13#8:538\n5#8:542\n9#8:568\n13#8:569\n5#8:573\n9#8:576\n13#8:580\n5#8:582\n57#9:539\n57#9:570\n57#9:577\n34#10:540\n34#10:571\n37#10:578\n22#11:541\n22#11:572\n22#11:581\n37#12,2:560\n1#13:564\n38#14:574\n32#14:575\n35#14:579\n*S KotlinDebug\n*F\n+ 1 ObjectGrowthDetector.kt\nshark/ObjectGrowthDetector\n*L\n114#1:515\n114#1:520\n338#1:562,2\n130#1:516\n130#1:519\n294#1:553\n294#1:554,4\n402#1:590\n402#1:593\n174#1:517,2\n416#1:591,2\n200#1:521,2\n200#1:523,4\n269#1:543,9\n269#1:552\n299#1:558,2\n269#1:565\n269#1:566\n347#1:567\n347#1:583\n398#1:584,2\n398#1:586,4\n203#1:527,3\n203#1:536\n420#1:594,3\n420#1:609\n207#1:530,6\n423#1:597,6\n429#1:603,6\n244#1:537\n245#1:538\n256#1:542\n360#1:568\n361#1:569\n365#1:573\n374#1:576\n374#1:580\n373#1:582\n251#1:539\n362#1:570\n374#1:577\n251#1:540\n362#1:571\n374#1:578\n256#1:541\n365#1:572\n373#1:581\n318#1:560,2\n269#1:564\n370#1:574\n374#1:575\n374#1:579\n*E\n"})
public final class ObjectGrowthDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GcRootProvider gcRootProvider;
    @NotNull
    private final ReferenceReader.Factory<HeapObject> referenceReaderFactory;

    public ObjectGrowthDetector(@NotNull GcRootProvider gcRootProvider, @NotNull ReferenceReader.Factory<HeapObject> referenceReaderFactory) {
        Intrinsics.checkNotNullParameter((Object)gcRootProvider, (String)"gcRootProvider");
        Intrinsics.checkNotNullParameter(referenceReaderFactory, (String)"referenceReaderFactory");
        this.gcRootProvider = gcRootProvider;
        this.referenceReaderFactory = referenceReaderFactory;
    }

    @NotNull
    public final HeapTraversalOutput findGrowingObjects(@NotNull HeapGraph heapGraph, @NotNull HeapTraversalInput previousTraversal) {
        Intrinsics.checkNotNullParameter((Object)heapGraph, (String)"heapGraph");
        Intrinsics.checkNotNullParameter((Object)previousTraversal, (String)"previousTraversal");
        if (!(!(previousTraversal instanceof HeapDiff) || ((HeapDiff)previousTraversal).isGrowing())) {
            boolean $i$a$-check-ObjectGrowthDetector$findGrowingObjects$22 = false;
            String $i$a$-check-ObjectGrowthDetector$findGrowingObjects$22 = "Previous HeapGrowth traversal was not growing, there's no reason to run this again. previousTraversal:" + previousTraversal;
            throw new IllegalStateException($i$a$-check-ObjectGrowthDetector$findGrowingObjects$22.toString());
        }
        int estimatedVisitedObjects = RangesKt.coerceAtLeast((int)(heapGraph.getInstanceCount() / 2), (int)4);
        TraversalState state = new TraversalState(estimatedVisitedObjects);
        return this.traverseHeapDiffingShortestPaths(state, heapGraph, previousTraversal);
    }

    public static /* synthetic */ HeapTraversalOutput findGrowingObjects$default(ObjectGrowthDetector objectGrowthDetector, HeapGraph heapGraph, HeapTraversalInput heapTraversalInput, int n, Object object) {
        if ((n & 2) != 0) {
            heapTraversalInput = new InitialState(0, 1, null);
        }
        return objectGrowthDetector.findGrowingObjects(heapGraph, heapTraversalInput);
    }

    /*
     * WARNING - void declaration
     */
    private final HeapTraversalOutput traverseHeapDiffingShortestPaths(TraversalState $this$traverseHeapDiffingShortestPaths, HeapGraph graph, HeapTraversalInput previousTraversal) {
        HeapTraversalOutput heapTraversalOutput;
        ShortestPathObjectNode shortestPathObjectNode;
        HeapTraversalInput heapTraversalInput = previousTraversal;
        if (heapTraversalInput instanceof InitialState) {
            shortestPathObjectNode = null;
        } else if (heapTraversalInput instanceof HeapTraversalOutput) {
            shortestPathObjectNode = ((HeapTraversalOutput)previousTraversal).getShortestPathTree();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ShortestPathObjectNode previousTree = shortestPathObjectNode;
        boolean firstTraversal = previousTree == null;
        boolean secondTraversal = previousTraversal instanceof FirstHeapTraversal;
        ReferenceReader<HeapObject> objectReferenceReader = this.referenceReaderFactory.createFor(graph);
        this.enqueueRoots($this$traverseHeapDiffingShortestPaths, previousTree, graph);
        while ($this$traverseHeapDiffingShortestPaths.getQueuesNotEmpty()) {
            int edgesEnqueued;
            int n;
            Map map;
            Object $this$associateBy$iv;
            int n2;
            Node node = this.poll($this$traverseHeapDiffingShortestPaths);
            DequeuedNode dequeuedNode = new DequeuedNode(node);
            $this$traverseHeapDiffingShortestPaths.getDequeuedNodes().add(dequeuedNode);
            ShortestPathObjectNode current = dequeuedNode.getShortestPathNode();
            int countOfVisitedObjectForCurrentNode = 0;
            Map edgesByNodeName = new LinkedHashMap();
            long[] $this$forEach$iv = node.getObjectIds();
            boolean $i$f$forEach = false;
            int n3 = $this$forEach$iv.length;
            for (int i = 0; i < n3; ++i) {
                long element$iv;
                long objectId = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                boolean added = $this$traverseHeapDiffingShortestPaths.getVisitedSet().add(objectId);
                if (!added) continue;
                ++countOfVisitedObjectForCurrentNode;
                if (node.isLeafObject()) continue;
                HeapObject heapObject = graph.findObjectById(objectId);
                Sequence<Reference> refs = objectReferenceReader.read(heapObject);
                Sequence<Reference> $this$forEach$iv2 = refs;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void this_$iv;
                    String string;
                    Reference reference = (Reference)element$iv2;
                    n2 = 0;
                    $this$traverseHeapDiffingShortestPaths.getDominatorTree().updateDominated(reference.getValueObjectId(), objectId);
                    if ($this$traverseHeapDiffingShortestPaths.getVisitedSet().contains(reference.getValueObjectId())) continue;
                    Reference.LazyDetails details = reference.getLazyDetailsResolver().resolve();
                    String refType = details.getLocationType().name();
                    HeapObject.HeapClass heapClass = graph.findObjectById(details.getLocationClassObjectId()).getAsClass();
                    Intrinsics.checkNotNull((Object)heapClass);
                    String owningClassSimpleName = heapClass.getSimpleName();
                    String refName = details.getLocationType() == ReferenceLocationType.ARRAY_ENTRY ? "[x]" : details.getName();
                    HeapObject referencedObject = graph.findObjectById(reference.getValueObjectId());
                    if (referencedObject instanceof HeapObject.HeapClass) {
                        string = "class " + ((HeapObject.HeapClass)referencedObject).getName();
                    } else if (referencedObject instanceof HeapObject.HeapInstance) {
                        string = "instance of " + ((HeapObject.HeapInstance)referencedObject).getInstanceClassName();
                    } else if (referencedObject instanceof HeapObject.HeapObjectArray) {
                        string = "array of " + ((HeapObject.HeapObjectArray)referencedObject).getArrayClassName();
                    } else if (referencedObject instanceof HeapObject.HeapPrimitiveArray) {
                        StringBuilder stringBuilder = new StringBuilder().append("array of ");
                        String string2 = ((HeapObject.HeapPrimitiveArray)referencedObject).getPrimitiveType().name().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        string = stringBuilder.append(string2).toString();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    String referencedObjectName = string;
                    String nodeAndEdgeName = refType + ' ' + owningClassSimpleName + '.' + refName + " -> " + referencedObjectName;
                    EdgeKey edgeKey = new EdgeKey(nodeAndEdgeName, reference.isLowPriority());
                    Edge edge = (Edge)edgesByNodeName.get(edgeKey);
                    if (edge == null) {
                        edgesByNodeName.put(edgeKey, new Edge(LongListKt.mutableLongListOf((long)reference.getValueObjectId()), reference.isLeafObject()));
                        continue;
                    }
                    edge.setLeafObject(edge.isLeafObject() && reference.isLeafObject());
                    if (edge.getNonVisitedDistinctObjectIds().contains(reference.getValueObjectId())) continue;
                    MutableLongList mutableLongList = edge.getNonVisitedDistinctObjectIds();
                    long element$iv3 = reference.getValueObjectId();
                    boolean $i$f$plusAssign = false;
                    this_$iv.add(element$iv3);
                }
            }
            if (countOfVisitedObjectForCurrentNode > 0) {
                ShortestPathObjectNode parent = node.getParentPathNode();
                parent.addChild$shark(current);
                if (firstTraversal) {
                    parent.setGrowing$shark(true);
                }
                if (Intrinsics.areEqual((Object)current.getName(), (Object)parent.getName())) {
                    Object linkedListStartNode = current;
                    while (true) {
                        String string = ((ShortestPathObjectNode)linkedListStartNode).getName();
                        ShortestPathObjectNode shortestPathObjectNode2 = ((ShortestPathObjectNode)linkedListStartNode).getParent();
                        Intrinsics.checkNotNull((Object)shortestPathObjectNode2);
                        if (!Intrinsics.areEqual((Object)string, (Object)shortestPathObjectNode2.getName())) break;
                        Intrinsics.checkNotNull((Object)((ShortestPathObjectNode)linkedListStartNode).getParent());
                    }
                    Object object = linkedListStartNode;
                    ((ShortestPathObjectNode)object).setSelfObjectCount$shark(((ShortestPathObjectNode)object).getSelfObjectCount() + countOfVisitedObjectForCurrentNode);
                } else {
                    current.setSelfObjectCount$shark(countOfVisitedObjectForCurrentNode);
                }
            }
            if (node.getPreviousPathNode() != null) {
                void $this$associateByTo$iv$iv;
                ShortestPathObjectNode previousPathNode;
                boolean bl = false;
                $this$associateBy$iv = previousPathNode.getChildren();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Object bl2 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ShortestPathObjectNode $i$f$forEach2 = (ShortestPathObjectNode)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl3 = false;
                    map2.put(it.getName(), element$iv$iv);
                }
                map = destination$iv$iv;
            } else {
                map = null;
            }
            Map previousNodeChildrenMapOrNull = map;
            Map $this$count$iv = edgesByNodeName;
            int $i$f$count = 0;
            if ($this$count$iv.isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                $this$associateBy$iv = $this$count$iv.entrySet().iterator();
                while ($this$associateBy$iv.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry capacity$iv = element$iv = (Map.Entry)$this$associateBy$iv.next();
                    boolean bl = false;
                    EdgeKey edgeKey = (EdgeKey)capacity$iv.getKey();
                    Edge edge = (Edge)capacity$iv.getValue();
                    Map map3 = previousNodeChildrenMapOrNull;
                    ShortestPathObjectNode previousPathNodeChildOrNull = map3 != null ? (ShortestPathObjectNode)map3.get(edgeKey.getNodeAndEdgeName()) : null;
                    long[] nonVisitedDistinctObjectIdsArray = new long[edge.getNonVisitedDistinctObjectIds().getSize()];
                    LongList this_$iv = (LongList)edge.getNonVisitedDistinctObjectIds();
                    boolean $i$f$forEachIndexed = false;
                    long[] content$iv = this_$iv.content;
                    int i$iv = 0;
                    n2 = this_$iv._size;
                    while (i$iv < n2) {
                        void objectId;
                        long details = content$iv[i$iv];
                        int index = i$iv++;
                        boolean bl4 = false;
                        nonVisitedDistinctObjectIdsArray[index] = objectId;
                    }
                    this.enqueue($this$traverseHeapDiffingShortestPaths, current, previousPathNodeChildOrNull, nonVisitedDistinctObjectIdsArray, edgeKey.getNodeAndEdgeName(), edgeKey.isLowPriority(), edge.isLeafObject());
                    if (!true) continue;
                    ++count$iv;
                }
                n = count$iv;
            }
            if ((edgesEnqueued = n) <= 0) continue;
            current.createChildrenBackingList$shark(edgesEnqueued);
        }
        if (previousTraversal instanceof InitialState) {
            AndroidObjectSizeCalculator objectSizeCalculator = new AndroidObjectSizeCalculator(graph);
            MutableLongLongMap retainedSizeAndCountMap = new MutableLongLongMap($this$traverseHeapDiffingShortestPaths.getDequeuedNodes().size());
            for (DequeuedNode node : CollectionsKt.asReversedMutable($this$traverseHeapDiffingShortestPaths.getDequeuedNodes())) {
                long nodeRetainedSize = ByteSizeKt.getZERO_BYTES();
                int nodeRetainedCount = 0;
                for (long objectId : node.getObjectIds()) {
                    void other$iv;
                    long packedSizeAndCount;
                    int objectShallowSize = objectSizeCalculator.computeSize(objectId);
                    long $this$unpackAsFirstInt$iv = packedSizeAndCount = this.increase(retainedSizeAndCountMap, objectId, objectShallowSize, 1);
                    boolean $i$f$getUnpackAsFirstInt = false;
                    int retainedSize = (int)($this$unpackAsFirstInt$iv >> 32);
                    long $this$unpackAsSecondInt$iv = packedSizeAndCount;
                    boolean $i$f$getUnpackAsSecondInt = false;
                    int retainedCount = (int)($this$unpackAsSecondInt$iv & 0xFFFFFFFFL);
                    long dominatorObjectId = $this$traverseHeapDiffingShortestPaths.getDominatorTree().get(objectId);
                    if (dominatorObjectId != 0L) {
                        this.increase(retainedSizeAndCountMap, dominatorObjectId, retainedSize, retainedCount);
                    }
                    int $this$bytes$iv22 = retainedSize;
                    boolean $i$f$getBytes = false;
                    long $this$bytes$iv22 = ByteSize.constructor-impl($this$bytes$iv22);
                    boolean bl = false;
                    nodeRetainedSize = ByteSize.constructor-impl(nodeRetainedSize + other$iv);
                    nodeRetainedCount += retainedCount;
                }
                if (!node.getShortestPathNode().getGrowing$shark()) continue;
                boolean bl = false;
                int $this$packedWith$iv$iv = (int)nodeRetainedSize;
                boolean $i$f$packedWith = false;
                node.getShortestPathNode().setRetained-TNQ5ngk$shark(Retained.constructor-impl((long)$this$packedWith$iv$iv << 32 | (long)nodeRetainedCount & 0xFFFFFFFFL));
                node.getShortestPathNode().setRetainedIncrease-TNQ5ngk$shark(RetainedKt.getZERO_RETAINED());
            }
            heapTraversalOutput = new FirstHeapTraversal($this$traverseHeapDiffingShortestPaths.getTree(), (InitialState)previousTraversal);
        } else {
            void $this$mapNotNullTo$iv$iv;
            MutableLongSet reportedGrowingNodeObjectIdsForRetainedSize = new MutableLongSet(0, 1, null);
            Iterable $this$mapNotNull$iv = $this$traverseHeapDiffingShortestPaths.getDequeuedNodes();
            boolean $i$f$mapNotNull = false;
            Iterable nodeRetainedSize = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator $i$f$packedWith = $this$forEach$iv$iv$iv.iterator();
            while ($i$f$packedWith.hasNext()) {
                ShortestPathObjectNode shortestPathObjectNode3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = $i$f$packedWith.next();
                boolean bl = false;
                DequeuedNode node = (DequeuedNode)element$iv$iv;
                boolean bl5 = false;
                ShortestPathObjectNode previousPathNode = node.getPreviousPathNode();
                if (previousPathNode == null || !previousPathNode.getGrowing$shark()) {
                    shortestPathObjectNode3 = null;
                } else {
                    Sequence previouslyGrowingChildren;
                    Object object;
                    ShortestPathObjectNode shortestPathNode = node.getShortestPathNode();
                    if (secondTraversal) {
                        object = CollectionsKt.asSequence((Iterable)previousPathNode.getChildren());
                    } else {
                        Object[] objectArray = previousPathNode.getGrowingChildrenArray$shark();
                        object = previouslyGrowingChildren = objectArray != null ? ArraysKt.asSequence((Object[])objectArray) : null;
                    }
                    if (previouslyGrowingChildren == null) {
                        shortestPathObjectNode3 = null;
                    } else {
                        void $this$associateByTo$iv$iv;
                        Sequence $this$associateBy$iv = previouslyGrowingChildren;
                        boolean $i$f$associateBy = false;
                        Sequence $i$f$getBytes = $this$associateBy$iv;
                        Map destination$iv$iv2 = new LinkedHashMap();
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
                            void it;
                            ShortestPathObjectNode index = (ShortestPathObjectNode)element$iv$iv2;
                            Map map = destination$iv$iv2;
                            boolean bl6 = false;
                            map.put(it.getName(), element$iv$iv2);
                        }
                        Map previousGrowingChildrenByName = destination$iv$iv2;
                        ArrayList growingChildren = new ArrayList(shortestPathNode.getChildren().size());
                        int[] growingChildrenIncreases = new int[shortestPathNode.getChildren().size()];
                        Iterable $this$forEach$iv = shortestPathNode.getChildren();
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ShortestPathObjectNode previousChild;
                            int childrenIncrease;
                            ShortestPathObjectNode child = (ShortestPathObjectNode)element$iv;
                            boolean bl7 = false;
                            if ((ShortestPathObjectNode)previousGrowingChildrenByName.get(child.getName()) == null || (childrenIncrease = child.getSelfObjectCount() - previousChild.getSelfObjectCount()) < previousTraversal.getScenarioLoopsPerGraph()) continue;
                            growingChildrenIncreases[growingChildren.size()] = childrenIncrease;
                            ((Collection)growingChildren).add(child);
                        }
                        if (growingChildren.isEmpty()) {
                            shortestPathObjectNode3 = null;
                        } else {
                            boolean parentGrowing;
                            Collection $this$toTypedArray$iv = growingChildren;
                            boolean $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            shortestPathNode.setGrowingChildrenArray$shark(thisCollection$iv.toArray(new ShortestPathObjectNode[0]));
                            int[] nArray = Arrays.copyOf(growingChildrenIncreases, growingChildren.size());
                            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
                            shortestPathNode.setGrowingChildrenIncreasesArray$shark(nArray);
                            shortestPathNode.setGrowing$shark(true);
                            ShortestPathObjectNode shortestPathObjectNode4 = shortestPathNode.getParent();
                            boolean bl8 = parentGrowing = shortestPathObjectNode4 != null ? shortestPathObjectNode4.getGrowing$shark() : false;
                            if (parentGrowing) {
                                shortestPathObjectNode3 = null;
                            } else {
                                long[] $this$forEach$iv3 = node.getObjectIds();
                                boolean $i$f$forEach4 = false;
                                int child = $this$forEach$iv3.length;
                                for (int element$iv = 0; element$iv < child; ++element$iv) {
                                    long element$iv4;
                                    long objectId = element$iv4 = $this$forEach$iv3[element$iv];
                                    boolean bl9 = false;
                                    reportedGrowingNodeObjectIdsForRetainedSize.add(objectId);
                                }
                                shortestPathObjectNode3 = shortestPathNode;
                            }
                        }
                    }
                }
                if (shortestPathObjectNode3 == null) continue;
                ShortestPathObjectNode it$iv$iv = shortestPathObjectNode3;
                boolean bl10 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List reportedGrowingNodes = (List)destination$iv$iv;
            AndroidObjectSizeCalculator objectSizeCalculator = new AndroidObjectSizeCalculator(graph);
            LongLongMap retainedMap = $this$traverseHeapDiffingShortestPaths.getDominatorTree().computeRetainedSizes((LongSet)reportedGrowingNodeObjectIdsForRetainedSize, objectSizeCalculator);
            Iterable $this$forEach$iv = $this$traverseHeapDiffingShortestPaths.getDequeuedNodes();
            boolean $i$f$forEach5 = false;
            for (Object element$iv : $this$forEach$iv) {
                long l;
                DequeuedNode node = (DequeuedNode)element$iv;
                boolean bl = false;
                ShortestPathObjectNode shortestPathNode = node.getShortestPathNode();
                if (!shortestPathNode.getGrowing$shark() || shortestPathNode.getParent() != null && shortestPathNode.getParent().getGrowing$shark()) continue;
                long heapSize = ByteSizeKt.getZERO_BYTES();
                int objectCount = 0;
                for (long objectId : node.getObjectIds()) {
                    void other$iv;
                    long packed;
                    long $this$unpackAsFirstInt$iv = packed = retainedMap.get(objectId);
                    boolean $i$f$getUnpackAsFirstInt = false;
                    int additionalByteSize = (int)($this$unpackAsFirstInt$iv >> 32);
                    long $this$unpackAsSecondInt$iv = packed;
                    boolean $i$f$getUnpackAsSecondInt = false;
                    int additionalObjectCount = (int)($this$unpackAsSecondInt$iv & 0xFFFFFFFFL);
                    int $this$bytes$iv = additionalByteSize;
                    boolean $i$f$getBytes = false;
                    $this$unpackAsSecondInt$iv = ByteSize.constructor-impl($this$bytes$iv);
                    boolean bl11 = false;
                    heapSize = ByteSize.constructor-impl(heapSize + other$iv);
                    objectCount += additionalObjectCount;
                }
                boolean bl12 = false;
                int $this$packedWith$iv$iv = (int)heapSize;
                boolean $i$f$packedWith2 = false;
                shortestPathNode.setRetained-TNQ5ngk$shark(Retained.constructor-impl((long)$this$packedWith$iv$iv << 32 | (long)objectCount & 0xFFFFFFFFL));
                ShortestPathObjectNode shortestPathObjectNode5 = node.getPreviousPathNode();
                long previousRetained = shortestPathObjectNode5 != null ? shortestPathObjectNode5.getRetained-bh0qJVg() : RetainedKt.getUNKNOWN_RETAINED();
                boolean bl13 = false;
                if (Retained.equals-impl0(previousRetained, RetainedKt.getUNKNOWN_RETAINED())) {
                    l = RetainedKt.getZERO_RETAINED();
                } else {
                    void objectCount$iv;
                    void heapSize$iv;
                    long other$iv;
                    void $this$bytes$iv$iv;
                    boolean bl14 = false;
                    long $this$unpackAsFirstInt$iv$iv = previousRetained;
                    boolean $i$f$getUnpackAsFirstInt = false;
                    int n = (int)($this$unpackAsFirstInt$iv$iv >> 32);
                    boolean $i$f$getBytes = false;
                    long bl9 = ByteSize.constructor-impl((long)$this$bytes$iv$iv);
                    boolean bl15 = false;
                    other$iv = ByteSize.constructor-impl(heapSize - other$iv);
                    int n4 = 0;
                    long $this$unpackAsSecondInt$iv$iv = previousRetained;
                    boolean $i$f$getUnpackAsSecondInt = false;
                    n4 = objectCount - (int)($this$unpackAsSecondInt$iv$iv & 0xFFFFFFFFL);
                    $i$f$Retained-5mcd9r4 = false;
                    int $this$packedWith$iv$iv2 = (int)heapSize$iv;
                    boolean $i$f$packedWith3 = false;
                    l = Retained.constructor-impl((long)$this$packedWith$iv$iv2 << 32 | (long)objectCount$iv & 0xFFFFFFFFL);
                }
                shortestPathNode.setRetainedIncrease-TNQ5ngk$shark(l);
            }
            heapTraversalOutput = new HeapDiff(previousTraversal.getTraversalCount() + 1, $this$traverseHeapDiffingShortestPaths.getTree(), reportedGrowingNodes, previousTraversal);
        }
        return heapTraversalOutput;
    }

    private final Node poll(TraversalState $this$poll) {
        Node node;
        if (!$this$poll.getVisitingLast() && !$this$poll.getToVisitQueue().isEmpty()) {
            Node node2 = $this$poll.getToVisitQueue().poll();
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"{\n      toVisitQueue.poll()\n    }");
            node = node2;
        } else {
            $this$poll.setVisitingLast(true);
            Node node3 = $this$poll.getToVisitLastQueue().poll();
            Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"{\n      visitingLast = t\u2026sitLastQueue.poll()\n    }");
            node = node3;
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    private final void enqueueRoots(TraversalState $this$enqueueRoots, ShortestPathObjectNode previousTree, HeapGraph heapGraph) {
        int n;
        LongList this_$iv;
        Map map;
        ShortestPathObjectNode shortestPathObjectNode = previousTree;
        if (shortestPathObjectNode != null) {
            void $this$associateByTo$iv$iv;
            ShortestPathObjectNode tree = shortestPathObjectNode;
            boolean bl = false;
            Iterable $this$associateBy$iv = tree.getChildren();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                ShortestPathObjectNode shortestPathObjectNode2 = (ShortestPathObjectNode)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl2 = false;
                map2.put(it.getName(), element$iv$iv);
            }
            map = destination$iv$iv;
        } else {
            map = null;
        }
        Map previousTreeRootMap = map;
        Map edgesByNodeName = new LinkedHashMap();
        Sequence<GcRootReference> $this$forEach$iv = this.gcRootProvider.provideGcRoots(heapGraph);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GcRootReference gcRootReference = (GcRootReference)element$iv;
            boolean bl = false;
            long objectId = gcRootReference.getGcRoot().getId();
            if (objectId == 0L) continue;
            String name = "GcRoot(" + gcRootReference.getGcRoot().getClass().getSimpleName() + ')';
            EdgeKey edgeKey = new EdgeKey(name, gcRootReference.isLowPriority());
            MutableLongList edgeObjectIds = (MutableLongList)edgesByNodeName.get(edgeKey);
            if (edgeObjectIds == null) {
                edgesByNodeName.put(edgeKey, LongListKt.mutableLongListOf((long)objectId));
                continue;
            }
            if (edgeObjectIds.contains(objectId)) continue;
            this_$iv = edgeObjectIds;
            boolean $i$f$plusAssign = false;
            this_$iv.add(objectId);
        }
        Map $this$count$iv = edgesByNodeName;
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator = $this$count$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                EdgeKey edgeKey = (EdgeKey)entry.getKey();
                MutableLongList edgeObjectIds = (MutableLongList)entry.getValue();
                Map map3 = previousTreeRootMap;
                ShortestPathObjectNode previousPathNode = map3 != null ? (ShortestPathObjectNode)map3.get(edgeKey.getNodeAndEdgeName()) : null;
                this_$iv = (LongList)edgeObjectIds;
                boolean $i$f$forEach2 = false;
                long[] content$iv = this_$iv.content;
                int n2 = this_$iv._size;
                for (int i$iv = 0; i$iv < n2; ++i$iv) {
                    long objectId = content$iv[i$iv];
                    boolean bl3 = false;
                    $this$enqueueRoots.getDominatorTree().updateDominatedAsRoot(objectId);
                }
                long[] edgeObjectIdsArray = new long[edgeObjectIds.getSize()];
                LongList this_$iv2 = (LongList)edgeObjectIds;
                boolean $i$f$forEachIndexed = false;
                long[] content$iv2 = this_$iv2.content;
                int i$iv = 0;
                int n3 = this_$iv2._size;
                while (i$iv < n3) {
                    void objectId;
                    long l = content$iv2[i$iv];
                    int index = i$iv++;
                    boolean bl4 = false;
                    edgeObjectIdsArray[index] = objectId;
                }
                this.enqueue($this$enqueueRoots, $this$enqueueRoots.getTree(), previousPathNode, edgeObjectIdsArray, edgeKey.getNodeAndEdgeName(), edgeKey.isLowPriority(), false);
                if (!true) continue;
                ++count$iv;
            }
            n = count$iv;
        }
        int enqueuedCount = n;
        $this$enqueueRoots.getTree().createChildrenBackingList$shark(enqueuedCount);
    }

    private final void enqueue(TraversalState $this$enqueue, ShortestPathObjectNode parentPathNode, ShortestPathObjectNode previousPathNode, long[] objectIds, String nodeAndEdgeName, boolean isLowPriority, boolean isLeafObject) {
        Node node = new Node(objectIds, parentPathNode, nodeAndEdgeName, previousPathNode, isLeafObject);
        if (isLowPriority || $this$enqueue.getVisitingLast()) {
            ((Collection)$this$enqueue.getToVisitLastQueue()).add(node);
        } else {
            ((Collection)$this$enqueue.getToVisitQueue()).add(node);
        }
    }

    private final long increase(MutableLongLongMap $this$increase, long objectId, int addedValue1, int addedValue2) {
        long l;
        long missing = 0L;
        long packedValue = $this$increase.getOrDefault(objectId, 0L);
        if (packedValue == missing) {
            long newPackedValue = (long)addedValue1 << 32 | (long)addedValue2 & 0xFFFFFFFFL;
            $this$increase.put(objectId, newPackedValue);
            l = newPackedValue;
        } else {
            int existingValue1 = (int)(packedValue >> 32);
            int existingValue2 = (int)(packedValue & 0xFFFFFFFFL);
            int newValue1 = existingValue1 + addedValue1;
            int newValue2 = existingValue2 + addedValue2;
            long newPackedValue = (long)newValue1 << 32 | (long)newValue2 & 0xFFFFFFFFL;
            $this$increase.put(objectId, newPackedValue);
            l = newPackedValue;
        }
        return l;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lshark/ObjectGrowthDetector$Companion;", "", "()V", "shark"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lshark/ObjectGrowthDetector$DequeuedNode;", "", "node", "Lshark/ObjectGrowthDetector$Node;", "(Lshark/ObjectGrowthDetector$Node;)V", "objectIds", "", "getObjectIds", "()[J", "previousPathNode", "Lshark/ShortestPathObjectNode;", "getPreviousPathNode", "()Lshark/ShortestPathObjectNode;", "shortestPathNode", "getShortestPathNode", "shark"})
    private static final class DequeuedNode {
        @NotNull
        private final long[] objectIds;
        @NotNull
        private final ShortestPathObjectNode shortestPathNode;
        @Nullable
        private final ShortestPathObjectNode previousPathNode;

        public DequeuedNode(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.objectIds = node.getObjectIds();
            this.shortestPathNode = new ShortestPathObjectNode(node.getNodeAndEdgeName(), node.getParentPathNode());
            this.previousPathNode = node.getPreviousPathNode();
        }

        @NotNull
        public final long[] getObjectIds() {
            return this.objectIds;
        }

        @NotNull
        public final ShortestPathObjectNode getShortestPathNode() {
            return this.shortestPathNode;
        }

        @Nullable
        public final ShortestPathObjectNode getPreviousPathNode() {
            return this.previousPathNode;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lshark/ObjectGrowthDetector$Edge;", "", "nonVisitedDistinctObjectIds", "Landroidx/collection/MutableLongList;", "isLeafObject", "", "(Landroidx/collection/MutableLongList;Z)V", "()Z", "setLeafObject", "(Z)V", "getNonVisitedDistinctObjectIds", "()Landroidx/collection/MutableLongList;", "shark"})
    private static final class Edge {
        @NotNull
        private final MutableLongList nonVisitedDistinctObjectIds;
        private boolean isLeafObject;

        public Edge(@NotNull MutableLongList nonVisitedDistinctObjectIds, boolean isLeafObject) {
            Intrinsics.checkNotNullParameter((Object)nonVisitedDistinctObjectIds, (String)"nonVisitedDistinctObjectIds");
            this.nonVisitedDistinctObjectIds = nonVisitedDistinctObjectIds;
            this.isLeafObject = isLeafObject;
        }

        @NotNull
        public final MutableLongList getNonVisitedDistinctObjectIds() {
            return this.nonVisitedDistinctObjectIds;
        }

        public final boolean isLeafObject() {
            return this.isLeafObject;
        }

        public final void setLeafObject(boolean bl) {
            this.isLeafObject = bl;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lshark/ObjectGrowthDetector$EdgeKey;", "", "nodeAndEdgeName", "", "isLowPriority", "", "(Ljava/lang/String;Z)V", "()Z", "getNodeAndEdgeName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "shark"})
    private static final class EdgeKey {
        @NotNull
        private final String nodeAndEdgeName;
        private final boolean isLowPriority;

        public EdgeKey(@NotNull String nodeAndEdgeName, boolean isLowPriority) {
            Intrinsics.checkNotNullParameter((Object)nodeAndEdgeName, (String)"nodeAndEdgeName");
            this.nodeAndEdgeName = nodeAndEdgeName;
            this.isLowPriority = isLowPriority;
        }

        @NotNull
        public final String getNodeAndEdgeName() {
            return this.nodeAndEdgeName;
        }

        public final boolean isLowPriority() {
            return this.isLowPriority;
        }

        @NotNull
        public final String component1() {
            return this.nodeAndEdgeName;
        }

        public final boolean component2() {
            return this.isLowPriority;
        }

        @NotNull
        public final EdgeKey copy(@NotNull String nodeAndEdgeName, boolean isLowPriority) {
            Intrinsics.checkNotNullParameter((Object)nodeAndEdgeName, (String)"nodeAndEdgeName");
            return new EdgeKey(nodeAndEdgeName, isLowPriority);
        }

        public static /* synthetic */ EdgeKey copy$default(EdgeKey edgeKey, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = edgeKey.nodeAndEdgeName;
            }
            if ((n & 2) != 0) {
                bl = edgeKey.isLowPriority;
            }
            return edgeKey.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "EdgeKey(nodeAndEdgeName=" + this.nodeAndEdgeName + ", isLowPriority=" + this.isLowPriority + ')';
        }

        public int hashCode() {
            int result = this.nodeAndEdgeName.hashCode();
            int n = this.isLowPriority ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EdgeKey)) {
                return false;
            }
            EdgeKey edgeKey = (EdgeKey)other;
            if (!Intrinsics.areEqual((Object)this.nodeAndEdgeName, (Object)edgeKey.nodeAndEdgeName)) {
                return false;
            }
            return this.isLowPriority == edgeKey.isLowPriority;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lshark/ObjectGrowthDetector$Node;", "", "objectIds", "", "parentPathNode", "Lshark/ShortestPathObjectNode;", "nodeAndEdgeName", "", "previousPathNode", "isLeafObject", "", "([JLshark/ShortestPathObjectNode;Ljava/lang/String;Lshark/ShortestPathObjectNode;Z)V", "()Z", "getNodeAndEdgeName", "()Ljava/lang/String;", "getObjectIds", "()[J", "getParentPathNode", "()Lshark/ShortestPathObjectNode;", "getPreviousPathNode", "shark"})
    private static final class Node {
        @NotNull
        private final long[] objectIds;
        @NotNull
        private final ShortestPathObjectNode parentPathNode;
        @NotNull
        private final String nodeAndEdgeName;
        @Nullable
        private final ShortestPathObjectNode previousPathNode;
        private final boolean isLeafObject;

        public Node(@NotNull long[] objectIds, @NotNull ShortestPathObjectNode parentPathNode, @NotNull String nodeAndEdgeName, @Nullable ShortestPathObjectNode previousPathNode, boolean isLeafObject) {
            Intrinsics.checkNotNullParameter((Object)objectIds, (String)"objectIds");
            Intrinsics.checkNotNullParameter((Object)parentPathNode, (String)"parentPathNode");
            Intrinsics.checkNotNullParameter((Object)nodeAndEdgeName, (String)"nodeAndEdgeName");
            this.objectIds = objectIds;
            this.parentPathNode = parentPathNode;
            this.nodeAndEdgeName = nodeAndEdgeName;
            this.previousPathNode = previousPathNode;
            this.isLeafObject = isLeafObject;
        }

        @NotNull
        public final long[] getObjectIds() {
            return this.objectIds;
        }

        @NotNull
        public final ShortestPathObjectNode getParentPathNode() {
            return this.parentPathNode;
        }

        @NotNull
        public final String getNodeAndEdgeName() {
            return this.nodeAndEdgeName;
        }

        @Nullable
        public final ShortestPathObjectNode getPreviousPathNode() {
            return this.previousPathNode;
        }

        public final boolean isLeafObject() {
            return this.isLeafObject;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lshark/ObjectGrowthDetector$TraversalState;", "", "estimatedVisitedObjects", "", "(I)V", "dequeuedNodes", "", "Lshark/ObjectGrowthDetector$DequeuedNode;", "getDequeuedNodes", "()Ljava/util/List;", "dominatorTree", "Lshark/DominatorTree;", "getDominatorTree", "()Lshark/DominatorTree;", "queuesNotEmpty", "", "getQueuesNotEmpty", "()Z", "toVisitLastQueue", "Ljava/util/Deque;", "Lshark/ObjectGrowthDetector$Node;", "getToVisitLastQueue", "()Ljava/util/Deque;", "toVisitQueue", "getToVisitQueue", "tree", "Lshark/ShortestPathObjectNode;", "getTree", "()Lshark/ShortestPathObjectNode;", "visitedSet", "Landroidx/collection/MutableLongSet;", "getVisitedSet", "()Landroidx/collection/MutableLongSet;", "visitingLast", "getVisitingLast", "setVisitingLast", "(Z)V", "shark"})
    private static final class TraversalState {
        private boolean visitingLast;
        @NotNull
        private final Deque<Node> toVisitQueue = new ArrayDeque();
        @NotNull
        private final Deque<Node> toVisitLastQueue = new ArrayDeque();
        @NotNull
        private final MutableLongSet visitedSet;
        @NotNull
        private final List<DequeuedNode> dequeuedNodes;
        @NotNull
        private final DominatorTree dominatorTree;
        @NotNull
        private final ShortestPathObjectNode tree;

        /*
         * WARNING - void declaration
         */
        public TraversalState(int estimatedVisitedObjects) {
            void $this$tree_u24lambda_u240;
            ShortestPathObjectNode shortestPathObjectNode;
            this.visitedSet = new MutableLongSet(estimatedVisitedObjects);
            this.dequeuedNodes = new ArrayList();
            this.dominatorTree = new DominatorTree(estimatedVisitedObjects);
            ShortestPathObjectNode shortestPathObjectNode2 = shortestPathObjectNode = new ShortestPathObjectNode("root", null);
            TraversalState traversalState = this;
            boolean bl = false;
            $this$tree_u24lambda_u240.setSelfObjectCount$shark(1);
            traversalState.tree = shortestPathObjectNode;
        }

        public final boolean getVisitingLast() {
            return this.visitingLast;
        }

        public final void setVisitingLast(boolean bl) {
            this.visitingLast = bl;
        }

        @NotNull
        public final Deque<Node> getToVisitQueue() {
            return this.toVisitQueue;
        }

        @NotNull
        public final Deque<Node> getToVisitLastQueue() {
            return this.toVisitLastQueue;
        }

        @NotNull
        public final MutableLongSet getVisitedSet() {
            return this.visitedSet;
        }

        @NotNull
        public final List<DequeuedNode> getDequeuedNodes() {
            return this.dequeuedNodes;
        }

        @NotNull
        public final DominatorTree getDominatorTree() {
            return this.dominatorTree;
        }

        @NotNull
        public final ShortestPathObjectNode getTree() {
            return this.tree;
        }

        public final boolean getQueuesNotEmpty() {
            return !((Collection)this.toVisitQueue).isEmpty() || !((Collection)this.toVisitLastQueue).isEmpty();
        }
    }
}

