/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.FilteringLeakingObjectFinder;
import shark.HeapGraph;
import shark.HeapObject;
import shark.KeyedWeakReferenceFinder;
import shark.ObjectInspector;
import shark.ObjectInspectors;
import shark.ObjectReporter;
import shark.internal.KeyedWeakReferenceMirror;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003R1\u0010\u0004\u001a\u001f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0005X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0013"}, d2={"Lshark/ObjectInspectors;", "", "Lshark/ObjectInspector;", "(Ljava/lang/String;I)V", "leakingObjectFilter", "Lkotlin/Function1;", "Lshark/HeapObject;", "Lkotlin/ParameterName;", "name", "heapObject", "", "getLeakingObjectFilter$shark", "()Lkotlin/jvm/functions/Function1;", "KEYED_WEAK_REFERENCE", "CLASSLOADER", "CLASS", "ANONYMOUS_CLASS", "THREAD", "Companion", "shark"})
public abstract class ObjectInspectors
extends Enum<ObjectInspectors>
implements ObjectInspector {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private final Function1<HeapObject, Boolean> leakingObjectFilter;
    @NotNull
    private static final String ANONYMOUS_CLASS_NAME_PATTERN = "^.+\\$\\d+$";
    @NotNull
    private static final Regex ANONYMOUS_CLASS_NAME_PATTERN_REGEX;
    @NotNull
    private static final List<FilteringLeakingObjectFinder.LeakingObjectFilter> jdkLeakingObjectFilters;
    public static final /* enum */ ObjectInspectors KEYED_WEAK_REFERENCE;
    public static final /* enum */ ObjectInspectors CLASSLOADER;
    public static final /* enum */ ObjectInspectors CLASS;
    public static final /* enum */ ObjectInspectors ANONYMOUS_CLASS;
    public static final /* enum */ ObjectInspectors THREAD;
    private static final /* synthetic */ ObjectInspectors[] $VALUES;

    private ObjectInspectors() {
    }

    @Nullable
    public Function1<HeapObject, Boolean> getLeakingObjectFilter$shark() {
        return this.leakingObjectFilter;
    }

    public static ObjectInspectors[] values() {
        return (ObjectInspectors[])$VALUES.clone();
    }

    public static ObjectInspectors valueOf(String value) {
        return Enum.valueOf(ObjectInspectors.class, value);
    }

    public /* synthetic */ ObjectInspectors(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        KEYED_WEAK_REFERENCE = new KEYED_WEAK_REFERENCE("KEYED_WEAK_REFERENCE", 0);
        CLASSLOADER = new CLASSLOADER("CLASSLOADER", 1);
        CLASS = new CLASS("CLASS", 2);
        ANONYMOUS_CLASS = new ANONYMOUS_CLASS("ANONYMOUS_CLASS", 3);
        THREAD = new THREAD("THREAD", 4);
        $VALUES = objectInspectorsArray = new ObjectInspectors[]{ObjectInspectors.KEYED_WEAK_REFERENCE, ObjectInspectors.CLASSLOADER, ObjectInspectors.CLASS, ObjectInspectors.ANONYMOUS_CLASS, ObjectInspectors.THREAD};
        Companion = new Companion(null);
        ANONYMOUS_CLASS_NAME_PATTERN_REGEX = new Regex(ANONYMOUS_CLASS_NAME_PATTERN);
        EnumSet<ObjectInspectors> enumSet = EnumSet.allOf(ObjectInspectors.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"allOf(ObjectInspectors::class.java)");
        jdkLeakingObjectFilters = Companion.createLeakingObjectFilters((Set<? extends ObjectInspectors>)enumSet);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lshark/ObjectInspectors$ANONYMOUS_CLASS;", "Lshark/ObjectInspectors;", "inspect", "", "reporter", "Lshark/ObjectReporter;", "shark"})
    static final class ANONYMOUS_CLASS
    extends ObjectInspectors {
        /*
         * WARNING - void declaration
         */
        ANONYMOUS_CLASS() {
            void var1_1;
        }

        @Override
        public void inspect(@NotNull ObjectReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            HeapObject heapObject = reporter.getHeapObject();
            if (heapObject instanceof HeapObject.HeapInstance) {
                HeapObject.HeapClass instanceClass = ((HeapObject.HeapInstance)heapObject).getInstanceClass();
                CharSequence charSequence = instanceClass.getName();
                if (ANONYMOUS_CLASS_NAME_PATTERN_REGEX.matches(charSequence)) {
                    HeapObject.HeapClass heapClass = instanceClass.getSuperclass();
                    Intrinsics.checkNotNull((Object)heapClass);
                    HeapObject.HeapClass parentClassRecord = heapClass;
                    if (Intrinsics.areEqual((Object)parentClassRecord.getName(), (Object)"java.lang.Object")) {
                        try {
                            String string;
                            Class<?> actualClass = Class.forName(instanceClass.getName());
                            Class<?>[] interfaces = actualClass.getInterfaces();
                            Collection collection = reporter.getLabels();
                            Intrinsics.checkNotNullExpressionValue(interfaces, (String)"interfaces");
                            if (!(interfaces.length == 0)) {
                                Class<?> implementedInterface = interfaces[0];
                                string = "Anonymous class implementing " + implementedInterface.getName();
                            } else {
                                string = "Anonymous subclass of java.lang.Object";
                            }
                            String string2 = string;
                            collection.add(string2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    } else {
                        ((Collection)reporter.getLabels()).add("Anonymous subclass of " + parentClassRecord.getName());
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lshark/ObjectInspectors$CLASS;", "Lshark/ObjectInspectors;", "inspect", "", "reporter", "Lshark/ObjectReporter;", "shark"})
    static final class CLASS
    extends ObjectInspectors {
        /*
         * WARNING - void declaration
         */
        CLASS() {
            void var1_1;
        }

        @Override
        public void inspect(@NotNull ObjectReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (reporter.getHeapObject() instanceof HeapObject.HeapClass) {
                ((Collection)reporter.getNotLeakingReasons()).add("a class is never leaking");
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lshark/ObjectInspectors$CLASSLOADER;", "Lshark/ObjectInspectors;", "inspect", "", "reporter", "Lshark/ObjectReporter;", "shark"})
    static final class CLASSLOADER
    extends ObjectInspectors {
        /*
         * WARNING - void declaration
         */
        CLASSLOADER() {
            void var1_1;
        }

        @Override
        public void inspect(@NotNull ObjectReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            reporter.whenInstanceOf((KClass<? extends Object>)Reflection.getOrCreateKotlinClass(ClassLoader.class), (Function2<? super ObjectReporter, ? super HeapObject.HeapInstance, Unit>)((Function2)inspect.1.INSTANCE));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lshark/ObjectInspectors$Companion;", "", "()V", "ANONYMOUS_CLASS_NAME_PATTERN", "", "ANONYMOUS_CLASS_NAME_PATTERN_REGEX", "Lkotlin/text/Regex;", "jdkDefaults", "", "Lshark/ObjectInspector;", "getJdkDefaults", "()Ljava/util/List;", "jdkLeakingObjectFilters", "Lshark/FilteringLeakingObjectFinder$LeakingObjectFilter;", "getJdkLeakingObjectFilters", "createLeakingObjectFilters", "inspectors", "", "Lshark/ObjectInspectors;", "shark"})
    @SourceDebugExtension(value={"SMAP\nObjectInspectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectInspectors.kt\nshark/ObjectInspectors$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1603#2,9:157\n1855#2:166\n1856#2:168\n1612#2:169\n1549#2:170\n1620#2,3:171\n1#3:167\n*S KotlinDebug\n*F\n+ 1 ObjectInspectors.kt\nshark/ObjectInspectors$Companion\n*L\n150#1:157,9\n150#1:166\n150#1:168\n150#1:169\n151#1:170\n151#1:171,3\n150#1:167\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ObjectInspector> getJdkDefaults() {
            return ArraysKt.toList((Object[])ObjectInspectors.values());
        }

        @NotNull
        public final List<FilteringLeakingObjectFinder.LeakingObjectFilter> getJdkLeakingObjectFilters() {
            return jdkLeakingObjectFilters;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<FilteringLeakingObjectFinder.LeakingObjectFilter> createLeakingObjectFilters(@NotNull Set<? extends ObjectInspectors> inspectors) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(inspectors, (String)"inspectors");
            Iterable $this$mapNotNull$iv = inspectors;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Function1 function1 = $this$forEach$iv$iv$iv.iterator();
            while (function1.hasNext()) {
                Function1<HeapObject, Boolean> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = function1.next();
                boolean bl = false;
                ObjectInspectors it = (ObjectInspectors)element$iv$iv;
                boolean bl2 = false;
                if (it.getLeakingObjectFilter$shark() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void filter;
                function1 = (Function1)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(arg_0 -> Companion.createLeakingObjectFilters$lambda$2$lambda$1((Function1)filter, arg_0));
            }
            return (List)destination$iv$iv;
        }

        private static final boolean createLeakingObjectFilters$lambda$2$lambda$1(Function1 $filter, HeapObject heapObject) {
            Intrinsics.checkNotNullParameter((Object)$filter, (String)"$filter");
            Intrinsics.checkNotNullParameter((Object)heapObject, (String)"heapObject");
            return (Boolean)$filter.invoke((Object)heapObject);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lshark/ObjectInspectors$KEYED_WEAK_REFERENCE;", "Lshark/ObjectInspectors;", "leakingObjectFilter", "Lkotlin/Function1;", "Lshark/HeapObject;", "", "getLeakingObjectFilter$shark", "()Lkotlin/jvm/functions/Function1;", "inspect", "", "reporter", "Lshark/ObjectReporter;", "shark"})
    @SourceDebugExtension(value={"SMAP\nObjectInspectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectInspectors.kt\nshark/ObjectInspectors$KEYED_WEAK_REFERENCE\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1855#2,2:157\n*S KotlinDebug\n*F\n+ 1 ObjectInspectors.kt\nshark/ObjectInspectors$KEYED_WEAK_REFERENCE\n*L\n45#1:157,2\n*E\n"})
    static final class KEYED_WEAK_REFERENCE
    extends ObjectInspectors {
        @NotNull
        private final Function1<HeapObject, Boolean> leakingObjectFilter = leakingObjectFilter.1.INSTANCE;

        /*
         * WARNING - void declaration
         */
        KEYED_WEAK_REFERENCE() {
            void var1_1;
        }

        @Override
        @NotNull
        public Function1<HeapObject, Boolean> getLeakingObjectFilter$shark() {
            return this.leakingObjectFilter;
        }

        @Override
        public void inspect(@NotNull ObjectReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            HeapGraph graph = reporter.getHeapObject().getGraph();
            List<KeyedWeakReferenceMirror> references = KeyedWeakReferenceFinder.INSTANCE.findKeyedWeakReferences$shark(graph);
            long objectId = reporter.getHeapObject().getObjectId();
            Iterable $this$forEach$iv = references;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KeyedWeakReferenceMirror ref = (KeyedWeakReferenceMirror)element$iv;
                boolean bl = false;
                if (ref.getReferent().getValue() != objectId) continue;
                ((Collection)reporter.getLeakingReasons()).add(((CharSequence)ref.getDescription()).length() > 0 ? "ObjectWatcher was watching this because " + ref.getDescription() : "ObjectWatcher was watching this");
                ((Collection)reporter.getLabels()).add("key = " + ref.getKey());
                if (ref.getWatchDurationMillis() != null) {
                    ((Collection)reporter.getLabels()).add("watchDurationMillis = " + ref.getWatchDurationMillis());
                }
                if (ref.getRetainedDurationMillis() == null) continue;
                ((Collection)reporter.getLabels()).add("retainedDurationMillis = " + ref.getRetainedDurationMillis());
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lshark/ObjectInspectors$THREAD;", "Lshark/ObjectInspectors;", "inspect", "", "reporter", "Lshark/ObjectReporter;", "shark"})
    static final class THREAD
    extends ObjectInspectors {
        /*
         * WARNING - void declaration
         */
        THREAD() {
            void var1_1;
        }

        @Override
        public void inspect(@NotNull ObjectReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            reporter.whenInstanceOf((KClass<? extends Object>)Reflection.getOrCreateKotlinClass(Thread.class), (Function2<? super ObjectReporter, ? super HeapObject.HeapInstance, Unit>)((Function2)inspect.1.INSTANCE));
        }
    }
}

