/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import shark.DominatorTree;
import shark.GcRootProvider;
import shark.GcRootReference;
import shark.HeapGraph;
import shark.HeapObject;
import shark.LibraryLeakReferenceMatcher;
import shark.PathFindingResults;
import shark.Reference;
import shark.ReferenceReader;
import shark.ShortestPathFinder;
import shark.internal.ReferencePathNode;
import shark.internal.ReferencePathNodeKt;
import shark.internal.hppc.LongScatterSet;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u001f !\"B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J$\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\f\u0010\u001a\u001a\u00020\u0014*\u00020\u0015H\u0002J\f\u0010\u001b\u001a\u00020\u000f*\u00020\u0015H\u0002J\f\u0010\u001c\u001a\u00020\u0017*\u00020\u0015H\u0002J\u0012\u0010\u001d\u001a\u00020\u001e*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lshark/PrioritizingShortestPathFinder;", "Lshark/ShortestPathFinder;", "graph", "Lshark/HeapGraph;", "listener", "Lshark/PrioritizingShortestPathFinder$Event$Listener;", "objectReferenceReader", "Lshark/ReferenceReader;", "Lshark/HeapObject;", "gcRootProvider", "Lshark/GcRootProvider;", "computeRetainedHeapSize", "", "(Lshark/HeapGraph;Lshark/PrioritizingShortestPathFinder$Event$Listener;Lshark/ReferenceReader;Lshark/GcRootProvider;Z)V", "findShortestPathsFromGcRoots", "Lshark/PathFindingResults;", "leakingObjectIds", "", "", "enqueue", "", "Lshark/PrioritizingShortestPathFinder$State;", "node", "Lshark/internal/ReferencePathNode;", "isLowPriority", "isLeafObject", "enqueueGcRoots", "findPathsFromGcRoots", "poll", "toLongScatterSet", "Lshark/internal/hppc/LongScatterSet;", "Event", "Factory", "State", "VisitTracker", "shark"})
@SourceDebugExtension(value={"SMAP\nPrioritizingShortestPathFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrioritizingShortestPathFinder.kt\nshark/PrioritizingShortestPathFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,299:1\n1855#2,2:300\n223#2,2:306\n1295#3,2:302\n1295#3,2:304\n*S KotlinDebug\n*F\n+ 1 PrioritizingShortestPathFinder.kt\nshark/PrioritizingShortestPathFinder\n*L\n159#1:300,2\n280#1:306,2\n188#1:302,2\n221#1:304,2\n*E\n"})
public final class PrioritizingShortestPathFinder
implements ShortestPathFinder {
    @NotNull
    private final HeapGraph graph;
    @NotNull
    private final Event.Listener listener;
    @NotNull
    private final ReferenceReader<HeapObject> objectReferenceReader;
    @NotNull
    private final GcRootProvider gcRootProvider;
    private final boolean computeRetainedHeapSize;

    private PrioritizingShortestPathFinder(HeapGraph graph, Event.Listener listener, ReferenceReader<HeapObject> objectReferenceReader, GcRootProvider gcRootProvider, boolean computeRetainedHeapSize) {
        this.graph = graph;
        this.listener = listener;
        this.objectReferenceReader = objectReferenceReader;
        this.gcRootProvider = gcRootProvider;
        this.computeRetainedHeapSize = computeRetainedHeapSize;
    }

    @Override
    @NotNull
    public PathFindingResults findShortestPathsFromGcRoots(@NotNull Set<Long> leakingObjectIds) {
        Intrinsics.checkNotNullParameter(leakingObjectIds, (String)"leakingObjectIds");
        this.listener.onEvent(Event.StartedFindingPathsToRetainedObjects.INSTANCE);
        int estimatedVisitedObjects = RangesKt.coerceAtLeast((int)(this.graph.getInstanceCount() / 2), (int)4);
        State state = new State(this.toLongScatterSet(leakingObjectIds), this.computeRetainedHeapSize, estimatedVisitedObjects);
        return this.findPathsFromGcRoots(state);
    }

    private final LongScatterSet toLongScatterSet(Set<Long> $this$toLongScatterSet) {
        LongScatterSet longScatterSet = new LongScatterSet(0, 1, null);
        longScatterSet.ensureCapacity($this$toLongScatterSet.size());
        Iterable $this$forEach$iv = $this$toLongScatterSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            longScatterSet.add(it);
        }
        return longScatterSet;
    }

    private final PathFindingResults findPathsFromGcRoots(State $this$findPathsFromGcRoots) {
        this.enqueueGcRoots($this$findPathsFromGcRoots);
        List shortestPathsToLeakingObjects = new ArrayList();
        while ($this$findPathsFromGcRoots.getQueuesNotEmpty()) {
            HeapObject heapObject;
            ReferencePathNode node = this.poll($this$findPathsFromGcRoots);
            if ($this$findPathsFromGcRoots.getLeakingObjectIds().contains(node.getObjectId())) {
                shortestPathsToLeakingObjects.add(node);
                if (shortestPathsToLeakingObjects.size() == $this$findPathsFromGcRoots.getLeakingObjectIds().size()) {
                    if (!$this$findPathsFromGcRoots.getComputeRetainedHeapSize()) break;
                    this.listener.onEvent(Event.StartedFindingDominators.INSTANCE);
                }
            }
            try {
                heapObject = this.graph.findObjectById(node.getObjectId());
            }
            catch (IllegalArgumentException objectIdNotFound) {
                throw new RuntimeException(ReferencePathNodeKt.invalidObjectIdErrorMessage(this.graph, node), objectIdNotFound);
            }
            HeapObject heapObject2 = heapObject;
            Sequence<Reference> $this$forEach$iv = this.objectReferenceReader.read(heapObject2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Reference reference = (Reference)element$iv;
                boolean bl = false;
                ReferencePathNode.ChildNode newNode = new ReferencePathNode.ChildNode(reference.getValueObjectId(), node, reference.getLazyDetailsResolver());
                this.enqueue($this$findPathsFromGcRoots, newNode, reference.isLowPriority(), reference.isLeafObject());
            }
        }
        return new PathFindingResults(shortestPathsToLeakingObjects, $this$findPathsFromGcRoots.getVisitTracker() instanceof VisitTracker.Dominated ? ((VisitTracker.Dominated)$this$findPathsFromGcRoots.getVisitTracker()).getDominatorTree() : null);
    }

    /*
     * WARNING - void declaration
     */
    private final ReferencePathNode poll(State $this$poll) {
        ReferencePathNode referencePathNode;
        if (!$this$poll.getVisitingLast() && !$this$poll.getToVisitQueue().isEmpty()) {
            ReferencePathNode removedNode = $this$poll.getToVisitQueue().poll();
            $this$poll.getToVisitSet().remove(removedNode.getObjectId());
            ReferencePathNode referencePathNode2 = removedNode;
            Intrinsics.checkNotNullExpressionValue((Object)referencePathNode2, (String)"{\n      val removedNode \u2026)\n      removedNode\n    }");
            referencePathNode = referencePathNode2;
        } else {
            void var3_3;
            $this$poll.setVisitingLast(true);
            ReferencePathNode removedNode = $this$poll.getToVisitLastQueue().poll();
            $this$poll.getToVisitLastSet().remove(removedNode.getObjectId());
            void var2_5 = var3_3;
            Intrinsics.checkNotNullExpressionValue((Object)var2_5, (String)"{\n      visitingLast = t\u2026)\n      removedNode\n    }");
            referencePathNode = var2_5;
        }
        return referencePathNode;
    }

    /*
     * WARNING - void declaration
     */
    private final void enqueueGcRoots(State $this$enqueueGcRoots) {
        Sequence<GcRootReference> $this$forEach$iv = this.gcRootProvider.provideGcRoots(this.graph);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ReferencePathNode.RootNode rootNode;
            GcRootReference gcRootReference = (GcRootReference)element$iv;
            boolean bl = false;
            PrioritizingShortestPathFinder prioritizingShortestPathFinder = this;
            State state = $this$enqueueGcRoots;
            if (gcRootReference.getMatchedLibraryLeak() != null) {
                void matchedLibraryLeak;
                State state2 = state;
                PrioritizingShortestPathFinder prioritizingShortestPathFinder2 = prioritizingShortestPathFinder;
                boolean bl2 = false;
                ReferencePathNode.RootNode.LibraryLeakRootNode libraryLeakRootNode = new ReferencePathNode.RootNode.LibraryLeakRootNode(gcRootReference.getGcRoot(), (LibraryLeakReferenceMatcher)matchedLibraryLeak);
                prioritizingShortestPathFinder = prioritizingShortestPathFinder2;
                state = state2;
                rootNode = libraryLeakRootNode;
            } else {
                rootNode = new ReferencePathNode.RootNode.NormalRootNode(gcRootReference.getGcRoot());
            }
            prioritizingShortestPathFinder.enqueue(state, rootNode, gcRootReference.isLowPriority(), false);
        }
    }

    private final void enqueue(State $this$enqueue, ReferencePathNode node, boolean isLowPriority, boolean isLeafObject) {
        long l;
        if (node.getObjectId() == 0L) {
            return;
        }
        ReferencePathNode referencePathNode = node;
        if (referencePathNode instanceof ReferencePathNode.RootNode) {
            l = 0L;
        } else if (referencePathNode instanceof ReferencePathNode.ChildNode) {
            l = ((ReferencePathNode.ChildNode)node).getParent().getObjectId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        long parentObjectId = l;
        boolean alreadyEnqueued = $this$enqueue.getVisitTracker().visited(node.getObjectId(), parentObjectId);
        if (isLeafObject && !$this$enqueue.getLeakingObjectIds().contains(node.getObjectId())) {
            return;
        }
        boolean visitLast = $this$enqueue.getVisitingLast() || isLowPriority;
        if (alreadyEnqueued) {
            boolean bumpPriority;
            boolean bl = bumpPriority = !visitLast && !$this$enqueue.getToVisitSet().contains(node.getObjectId()) && $this$enqueue.getToVisitLastSet().contains(node.getObjectId());
            if (bumpPriority) {
                Object element$iv2;
                block12: {
                    $this$enqueue.getToVisitQueue().add(node);
                    $this$enqueue.getToVisitSet().add(node.getObjectId());
                    Iterable $this$first$iv = $this$enqueue.getToVisitLastQueue();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ReferencePathNode it = (ReferencePathNode)element$iv2;
                        boolean bl2 = false;
                        if (!(it.getObjectId() == node.getObjectId())) continue;
                        break block12;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                ReferencePathNode nodeToRemove = (ReferencePathNode)element$iv2;
                $this$enqueue.getToVisitLastQueue().remove(nodeToRemove);
                $this$enqueue.getToVisitLastSet().remove(node.getObjectId());
            }
        } else if (visitLast) {
            $this$enqueue.getToVisitLastQueue().add(node);
            $this$enqueue.getToVisitLastSet().add(node.getObjectId());
        } else {
            $this$enqueue.getToVisitQueue().add(node);
            $this$enqueue.getToVisitSet().add(node.getObjectId());
        }
    }

    public /* synthetic */ PrioritizingShortestPathFinder(HeapGraph graph, Event.Listener listener, ReferenceReader objectReferenceReader, GcRootProvider gcRootProvider, boolean computeRetainedHeapSize, DefaultConstructorMarker $constructor_marker) {
        this(graph, listener, objectReferenceReader, gcRootProvider, computeRetainedHeapSize);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lshark/PrioritizingShortestPathFinder$Event;", "", "Listener", "StartedFindingDominators", "StartedFindingPathsToRetainedObjects", "Lshark/PrioritizingShortestPathFinder$Event$StartedFindingDominators;", "Lshark/PrioritizingShortestPathFinder$Event$StartedFindingPathsToRetainedObjects;", "shark"})
    public static interface Event {

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lshark/PrioritizingShortestPathFinder$Event$Listener;", "", "onEvent", "", "event", "Lshark/PrioritizingShortestPathFinder$Event;", "shark"})
        public static interface Listener {
            public void onEvent(@NotNull Event var1);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lshark/PrioritizingShortestPathFinder$Event$StartedFindingDominators;", "Lshark/PrioritizingShortestPathFinder$Event;", "()V", "shark"})
        public static final class StartedFindingDominators
        implements Event {
            @NotNull
            public static final StartedFindingDominators INSTANCE = new StartedFindingDominators();

            private StartedFindingDominators() {
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lshark/PrioritizingShortestPathFinder$Event$StartedFindingPathsToRetainedObjects;", "Lshark/PrioritizingShortestPathFinder$Event;", "()V", "shark"})
        public static final class StartedFindingPathsToRetainedObjects
        implements Event {
            @NotNull
            public static final StartedFindingPathsToRetainedObjects INSTANCE = new StartedFindingPathsToRetainedObjects();

            private StartedFindingPathsToRetainedObjects() {
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lshark/PrioritizingShortestPathFinder$Factory;", "Lshark/ShortestPathFinder$Factory;", "listener", "Lshark/PrioritizingShortestPathFinder$Event$Listener;", "referenceReaderFactory", "Lshark/ReferenceReader$Factory;", "Lshark/HeapObject;", "gcRootProvider", "Lshark/GcRootProvider;", "computeRetainedHeapSize", "", "(Lshark/PrioritizingShortestPathFinder$Event$Listener;Lshark/ReferenceReader$Factory;Lshark/GcRootProvider;Z)V", "createFor", "Lshark/ShortestPathFinder;", "heapGraph", "Lshark/HeapGraph;", "shark"})
    public static final class Factory
    implements ShortestPathFinder.Factory {
        @NotNull
        private final Event.Listener listener;
        @NotNull
        private final ReferenceReader.Factory<HeapObject> referenceReaderFactory;
        @NotNull
        private final GcRootProvider gcRootProvider;
        private final boolean computeRetainedHeapSize;

        public Factory(@NotNull Event.Listener listener, @NotNull ReferenceReader.Factory<HeapObject> referenceReaderFactory, @NotNull GcRootProvider gcRootProvider, boolean computeRetainedHeapSize) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Intrinsics.checkNotNullParameter(referenceReaderFactory, (String)"referenceReaderFactory");
            Intrinsics.checkNotNullParameter((Object)gcRootProvider, (String)"gcRootProvider");
            this.listener = listener;
            this.referenceReaderFactory = referenceReaderFactory;
            this.gcRootProvider = gcRootProvider;
            this.computeRetainedHeapSize = computeRetainedHeapSize;
        }

        @Override
        @NotNull
        public ShortestPathFinder createFor(@NotNull HeapGraph heapGraph) {
            Intrinsics.checkNotNullParameter((Object)heapGraph, (String)"heapGraph");
            return new PrioritizingShortestPathFinder(heapGraph, this.listener, this.referenceReaderFactory.createFor(heapGraph), this.gcRootProvider, this.computeRetainedHeapSize, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\n\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lshark/PrioritizingShortestPathFinder$State;", "", "leakingObjectIds", "Lshark/internal/hppc/LongScatterSet;", "computeRetainedHeapSize", "", "estimatedVisitedObjects", "", "(Lshark/internal/hppc/LongScatterSet;ZI)V", "getComputeRetainedHeapSize", "()Z", "getLeakingObjectIds", "()Lshark/internal/hppc/LongScatterSet;", "queuesNotEmpty", "getQueuesNotEmpty", "toVisitLastQueue", "Ljava/util/Deque;", "Lshark/internal/ReferencePathNode;", "getToVisitLastQueue", "()Ljava/util/Deque;", "toVisitLastSet", "getToVisitLastSet", "toVisitQueue", "getToVisitQueue", "toVisitSet", "getToVisitSet", "visitTracker", "Lshark/PrioritizingShortestPathFinder$VisitTracker;", "getVisitTracker", "()Lshark/PrioritizingShortestPathFinder$VisitTracker;", "visitingLast", "getVisitingLast", "setVisitingLast", "(Z)V", "shark"})
    private static final class State {
        @NotNull
        private final LongScatterSet leakingObjectIds;
        private final boolean computeRetainedHeapSize;
        @NotNull
        private final Deque<ReferencePathNode> toVisitQueue;
        @NotNull
        private final Deque<ReferencePathNode> toVisitLastQueue;
        @NotNull
        private final LongScatterSet toVisitSet;
        @NotNull
        private final LongScatterSet toVisitLastSet;
        @NotNull
        private final VisitTracker visitTracker;
        private boolean visitingLast;

        public State(@NotNull LongScatterSet leakingObjectIds, boolean computeRetainedHeapSize, int estimatedVisitedObjects) {
            Intrinsics.checkNotNullParameter((Object)leakingObjectIds, (String)"leakingObjectIds");
            this.leakingObjectIds = leakingObjectIds;
            this.computeRetainedHeapSize = computeRetainedHeapSize;
            this.toVisitQueue = new ArrayDeque();
            this.toVisitLastQueue = new ArrayDeque();
            this.toVisitSet = new LongScatterSet(0, 1, null);
            this.toVisitLastSet = new LongScatterSet(0, 1, null);
            this.visitTracker = this.computeRetainedHeapSize ? (VisitTracker)new VisitTracker.Dominated(estimatedVisitedObjects) : (VisitTracker)new VisitTracker.Visited(estimatedVisitedObjects);
        }

        @NotNull
        public final LongScatterSet getLeakingObjectIds() {
            return this.leakingObjectIds;
        }

        public final boolean getComputeRetainedHeapSize() {
            return this.computeRetainedHeapSize;
        }

        @NotNull
        public final Deque<ReferencePathNode> getToVisitQueue() {
            return this.toVisitQueue;
        }

        @NotNull
        public final Deque<ReferencePathNode> getToVisitLastQueue() {
            return this.toVisitLastQueue;
        }

        @NotNull
        public final LongScatterSet getToVisitSet() {
            return this.toVisitSet;
        }

        @NotNull
        public final LongScatterSet getToVisitLastSet() {
            return this.toVisitLastSet;
        }

        public final boolean getQueuesNotEmpty() {
            return !((Collection)this.toVisitQueue).isEmpty() || !((Collection)this.toVisitLastQueue).isEmpty();
        }

        @NotNull
        public final VisitTracker getVisitTracker() {
            return this.visitTracker;
        }

        public final boolean getVisitingLast() {
            return this.visitingLast;
        }

        public final void setVisitingLast(boolean bl) {
            this.visitingLast = bl;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H&\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lshark/PrioritizingShortestPathFinder$VisitTracker;", "", "()V", "visited", "", "objectId", "", "parentObjectId", "Dominated", "Visited", "Lshark/PrioritizingShortestPathFinder$VisitTracker$Dominated;", "Lshark/PrioritizingShortestPathFinder$VisitTracker$Visited;", "shark"})
    private static abstract class VisitTracker {
        private VisitTracker() {
        }

        public abstract boolean visited(long var1, long var3);

        public /* synthetic */ VisitTracker(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lshark/PrioritizingShortestPathFinder$VisitTracker$Dominated;", "Lshark/PrioritizingShortestPathFinder$VisitTracker;", "expectedElements", "", "(I)V", "dominatorTree", "Lshark/DominatorTree;", "getDominatorTree", "()Lshark/DominatorTree;", "visited", "", "objectId", "", "parentObjectId", "shark"})
        public static final class Dominated
        extends VisitTracker {
            @NotNull
            private final DominatorTree dominatorTree;

            public Dominated(int expectedElements) {
                super(null);
                this.dominatorTree = new DominatorTree(expectedElements);
            }

            @NotNull
            public final DominatorTree getDominatorTree() {
                return this.dominatorTree;
            }

            @Override
            public boolean visited(long objectId, long parentObjectId) {
                return this.dominatorTree.updateDominated(objectId, parentObjectId);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lshark/PrioritizingShortestPathFinder$VisitTracker$Visited;", "Lshark/PrioritizingShortestPathFinder$VisitTracker;", "expectedElements", "", "(I)V", "visitedSet", "Lshark/internal/hppc/LongScatterSet;", "visited", "", "objectId", "", "parentObjectId", "shark"})
        public static final class Visited
        extends VisitTracker {
            @NotNull
            private final LongScatterSet visitedSet;

            public Visited(int expectedElements) {
                super(null);
                this.visitedSet = new LongScatterSet(expectedElements);
            }

            @Override
            public boolean visited(long objectId, long parentObjectId) {
                return !this.visitedSet.add(objectId);
            }
        }
    }
}

