/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import shark.HeapField;
import shark.HeapGraph;
import shark.HeapObject;
import shark.ObjectArrayReferenceReader;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lshark/internal/ShallowSizeCalculator;", "", "graph", "Lshark/HeapGraph;", "(Lshark/HeapGraph;)V", "computeShallowSize", "", "objectId", "", "shark"})
@SourceDebugExtension(value={"SMAP\nShallowSizeCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShallowSizeCalculator.kt\nshark/internal/ShallowSizeCalculator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,66:1\n1314#2,2:67\n12940#2,3:69\n*S KotlinDebug\n*F\n+ 1 ShallowSizeCalculator.kt\nshark/internal/ShallowSizeCalculator\n*L\n47#1:67,2\n50#1:69,3\n*E\n"})
public final class ShallowSizeCalculator {
    @NotNull
    private final HeapGraph graph;

    public ShallowSizeCalculator(@NotNull HeapGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.graph = graph;
    }

    public final int computeShallowSize(long objectId) {
        int n;
        HeapObject heapObject = this.graph.findObjectById(objectId);
        if (heapObject instanceof HeapObject.HeapInstance) {
            if (Intrinsics.areEqual((Object)((HeapObject.HeapInstance)heapObject).getInstanceClassName(), (Object)"java.lang.String")) {
                HeapField heapField = ((HeapObject.HeapInstance)heapObject).get("java.lang.String", "value");
                Long valueObjectId = heapField != null && (heapField = heapField.getValue()) != null ? heapField.getAsNonNullObjectId() : null;
                n = ((HeapObject.HeapInstance)heapObject).getByteSize() + (valueObjectId != null ? this.computeShallowSize(valueObjectId) : 0);
            } else {
                n = ((HeapObject.HeapInstance)heapObject).getByteSize();
            }
        } else if (heapObject instanceof HeapObject.HeapObjectArray) {
            if (ObjectArrayReferenceReader.Companion.isSkippablePrimitiveWrapperArray$shark((HeapObject.HeapObjectArray)heapObject)) {
                Long firstNonNullElement;
                int shallowSize;
                long[] elementIds;
                block16: {
                    Long l;
                    elementIds = ((HeapObject.HeapObjectArray)heapObject).readRecord().getElementIds();
                    shallowSize = elementIds.length * this.graph.getIdentifierByteSize();
                    long[] $this$firstOrNull$iv = elementIds;
                    boolean $i$f$firstOrNull = false;
                    int n2 = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n2; ++i) {
                        long element$iv;
                        long it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!(it != 0L)) continue;
                        l = element$iv;
                        break block16;
                    }
                    l = firstNonNullElement = null;
                }
                if (firstNonNullElement != null) {
                    int sizeOfOneElement = this.computeShallowSize(firstNonNullElement);
                    long[] $this$count$iv = elementIds;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    int n3 = $this$count$iv.length;
                    for (int i = 0; i < n3; ++i) {
                        long element$iv;
                        long it = element$iv = $this$count$iv[i];
                        boolean bl = false;
                        if (!(it != 0L)) continue;
                        ++count$iv;
                    }
                    int countOfNonNullElements = count$iv;
                    n = shallowSize + sizeOfOneElement * countOfNonNullElements;
                } else {
                    n = shallowSize;
                }
            } else {
                n = ((HeapObject.HeapObjectArray)heapObject).getByteSize();
            }
        } else if (heapObject instanceof HeapObject.HeapPrimitiveArray) {
            n = ((HeapObject.HeapPrimitiveArray)heapObject).getByteSize();
        } else if (heapObject instanceof HeapObject.HeapClass) {
            n = heapObject.getRecordSize();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }
}

