/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.mockwebserver;

import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.spdy.IncomingStreamHandler;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import com.squareup.okhttp.internal.spdy.SpdyStream;
import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.QueueDispatcher;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import com.squareup.okhttp.mockwebserver.SocketPolicy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class MockWebServer {
    private static final byte[] NPN_PROTOCOLS = new byte[]{6, 115, 112, 100, 121, 47, 51, 8, 104, 116, 116, 112, 47, 49, 46, 49};
    private static final byte[] SPDY3 = new byte[]{115, 112, 100, 121, 47, 51};
    private static final byte[] HTTP_20_DRAFT_04 = new byte[]{72, 84, 84, 80, 45, 100, 114, 97, 102, 116, 45, 48, 52, 47, 50, 46, 48};
    private static final byte[] HTTP_11 = new byte[]{104, 116, 116, 112, 47, 49, 46, 49};
    private static final X509TrustManager UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
            throw new AssertionError();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new AssertionError();
        }
    };
    private static final Logger logger = Logger.getLogger(MockWebServer.class.getName());
    private final BlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue<RecordedRequest>();
    private final Map<Socket, Boolean> openClientSockets = new ConcurrentHashMap<Socket, Boolean>();
    private final Map<SpdyConnection, Boolean> openSpdyConnections = new ConcurrentHashMap<SpdyConnection, Boolean>();
    private final AtomicInteger requestCount = new AtomicInteger();
    private int bodyLimit = Integer.MAX_VALUE;
    private ServerSocket serverSocket;
    private SSLSocketFactory sslSocketFactory;
    private ExecutorService executor;
    private boolean tunnelProxy;
    private Dispatcher dispatcher = new QueueDispatcher();
    private int port = -1;
    private boolean npnEnabled = true;

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Cannot retrieve port before calling play()");
        }
        return this.port;
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Proxy toProxyAddress() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getHostName(), this.getPort()));
    }

    public URL getUrl(String path) {
        try {
            return this.sslSocketFactory != null ? new URL("https://" + this.getHostName() + ":" + this.getPort() + path) : new URL("http://" + this.getHostName() + ":" + this.getPort() + path);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getCookieDomain() {
        String hostName = this.getHostName();
        return hostName.contains(".") ? hostName : ".local";
    }

    public void setBodyLimit(int maxBodyLength) {
        this.bodyLimit = maxBodyLength;
    }

    public void setNpnEnabled(boolean npnEnabled) {
        this.npnEnabled = npnEnabled;
    }

    public void useHttps(SSLSocketFactory sslSocketFactory, boolean tunnelProxy) {
        this.sslSocketFactory = sslSocketFactory;
        this.tunnelProxy = tunnelProxy;
    }

    public RecordedRequest takeRequest() throws InterruptedException {
        return this.requestQueue.take();
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public void enqueue(MockResponse response) {
        ((QueueDispatcher)this.dispatcher).enqueueResponse(response.clone());
    }

    public void play() throws IOException {
        this.play(0);
    }

    public void play(int port) throws IOException {
        if (this.executor != null) {
            throw new IllegalStateException("play() already called");
        }
        this.executor = Executors.newCachedThreadPool();
        this.serverSocket = new ServerSocket(port);
        this.serverSocket.setReuseAddress(true);
        this.port = this.serverSocket.getLocalPort();
        this.executor.execute(MockWebServer.namedRunnable("MockWebServer-accept-" + port, new Runnable(){

            @Override
            public void run() {
                try {
                    this.acceptConnections();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "MockWebServer connection failed", e);
                }
                Util.closeQuietly((Closeable)MockWebServer.this.serverSocket);
                Iterator s = MockWebServer.this.openClientSockets.keySet().iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Socket)((Socket)s.next()));
                    s.remove();
                }
                s = MockWebServer.this.openSpdyConnections.keySet().iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Closeable)((Closeable)s.next()));
                    s.remove();
                }
                MockWebServer.this.executor.shutdown();
            }

            private void acceptConnections() throws Exception {
                while (true) {
                    Socket socket;
                    try {
                        socket = MockWebServer.this.serverSocket.accept();
                    }
                    catch (SocketException e) {
                        return;
                    }
                    SocketPolicy socketPolicy = MockWebServer.this.dispatcher.peekSocketPolicy();
                    if (socketPolicy == SocketPolicy.DISCONNECT_AT_START) {
                        MockWebServer.this.dispatchBookkeepingRequest(0, socket);
                        socket.close();
                        continue;
                    }
                    MockWebServer.this.openClientSockets.put(socket, true);
                    MockWebServer.this.serveConnection(socket);
                }
            }
        }));
    }

    public void shutdown() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    private void serveConnection(final Socket raw) {
        String name = "MockWebServer-" + raw.getRemoteSocketAddress();
        this.executor.execute(MockWebServer.namedRunnable(name, new Runnable(){
            int sequenceNumber = 0;

            @Override
            public void run() {
                try {
                    this.processConnection();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "MockWebServer connection failed", e);
                }
            }

            public void processConnection() throws Exception {
                Socket socket;
                Transport transport = Transport.HTTP_11;
                if (MockWebServer.this.sslSocketFactory != null) {
                    SocketPolicy socketPolicy;
                    if (MockWebServer.this.tunnelProxy) {
                        this.createTunnel();
                    }
                    if ((socketPolicy = MockWebServer.this.dispatcher.peekSocketPolicy()) == SocketPolicy.FAIL_HANDSHAKE) {
                        MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, raw);
                        MockWebServer.this.processHandshakeFailure(raw);
                        return;
                    }
                    socket = MockWebServer.this.sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
                    SSLSocket sslSocket = (SSLSocket)socket;
                    sslSocket.setUseClientMode(false);
                    MockWebServer.this.openClientSockets.put(socket, true);
                    if (MockWebServer.this.npnEnabled) {
                        Platform.get().setNpnProtocols(sslSocket, NPN_PROTOCOLS);
                    }
                    sslSocket.startHandshake();
                    if (MockWebServer.this.npnEnabled) {
                        byte[] selectedProtocol = Platform.get().getNpnSelectedProtocol(sslSocket);
                        if (selectedProtocol == null || Arrays.equals(selectedProtocol, HTTP_11)) {
                            transport = Transport.HTTP_11;
                        } else if (Arrays.equals(selectedProtocol, HTTP_20_DRAFT_04)) {
                            transport = Transport.HTTP_20_DRAFT_04;
                        } else if (Arrays.equals(selectedProtocol, SPDY3)) {
                            transport = Transport.SPDY_3;
                        } else {
                            throw new IllegalStateException("Unexpected transport: " + new String(selectedProtocol, Util.US_ASCII));
                        }
                    }
                    MockWebServer.this.openClientSockets.remove(raw);
                } else {
                    socket = raw;
                }
                if (transport == Transport.SPDY_3 || transport == Transport.HTTP_20_DRAFT_04) {
                    SpdySocketHandler spdySocketHandler = new SpdySocketHandler(socket);
                    SpdyConnection.Builder builder = new SpdyConnection.Builder(false, socket).handler((IncomingStreamHandler)spdySocketHandler);
                    if (transport == Transport.SPDY_3) {
                        builder.spdy3();
                    } else {
                        builder.http20Draft04();
                    }
                    SpdyConnection spdyConnection = builder.build();
                    MockWebServer.this.openSpdyConnections.put(spdyConnection, Boolean.TRUE);
                    MockWebServer.this.openClientSockets.remove(socket);
                    spdyConnection.sendConnectionHeader();
                    return;
                }
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
                while (this.processOneRequest(socket, in, out)) {
                }
                if (this.sequenceNumber == 0) {
                    logger.warning("MockWebServer connection didn't make a request");
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
                socket.close();
                MockWebServer.this.openClientSockets.remove(socket);
            }

            private void createTunnel() throws IOException, InterruptedException {
                SocketPolicy socketPolicy;
                do {
                    socketPolicy = MockWebServer.this.dispatcher.peekSocketPolicy();
                    if (this.processOneRequest(raw, raw.getInputStream(), raw.getOutputStream())) continue;
                    throw new IllegalStateException("Tunnel without any CONNECT!");
                } while (socketPolicy != SocketPolicy.UPGRADE_TO_SSL_AT_END);
            }

            private boolean processOneRequest(Socket socket, InputStream in, OutputStream out) throws IOException, InterruptedException {
                RecordedRequest request = MockWebServer.this.readRequest(socket, in, out, this.sequenceNumber);
                if (request == null) {
                    return false;
                }
                MockWebServer.this.requestCount.incrementAndGet();
                MockWebServer.this.requestQueue.add(request);
                MockResponse response = MockWebServer.this.dispatcher.dispatch(request);
                MockWebServer.this.writeResponse(out, response);
                if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AT_END) {
                    in.close();
                    out.close();
                } else if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_INPUT_AT_END) {
                    socket.shutdownInput();
                } else if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_OUTPUT_AT_END) {
                    socket.shutdownOutput();
                }
                logger.info("Received request: " + request + " and responded: " + response);
                ++this.sequenceNumber;
                return true;
            }
        }));
    }

    private void processHandshakeFailure(Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{UNTRUSTED_TRUST_MANAGER}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
        try {
            socket.startHandshake();
            throw new AssertionError();
        }
        catch (IOException expected) {
            socket.close();
            return;
        }
    }

    private void dispatchBookkeepingRequest(int sequenceNumber, Socket socket) throws InterruptedException {
        this.requestCount.incrementAndGet();
        this.dispatcher.dispatch(new RecordedRequest(null, null, null, -1L, null, sequenceNumber, socket));
    }

    private RecordedRequest readRequest(Socket socket, InputStream in, OutputStream out, int sequenceNumber) throws IOException {
        String header;
        String request;
        try {
            request = this.readAsciiUntilCrlf(in);
        }
        catch (IOException streamIsClosed) {
            return null;
        }
        if (request.length() == 0) {
            return null;
        }
        ArrayList<String> headers = new ArrayList<String>();
        long contentLength = -1L;
        boolean chunked = false;
        boolean expectContinue = false;
        while ((header = this.readAsciiUntilCrlf(in)).length() != 0) {
            headers.add(header);
            String lowercaseHeader = header.toLowerCase(Locale.US);
            if (contentLength == -1L && lowercaseHeader.startsWith("content-length:")) {
                contentLength = Long.parseLong(header.substring(15).trim());
            }
            if (lowercaseHeader.startsWith("transfer-encoding:") && lowercaseHeader.substring(18).trim().equals("chunked")) {
                chunked = true;
            }
            if (!lowercaseHeader.startsWith("expect:") || !lowercaseHeader.substring(7).trim().equals("100-continue")) continue;
            expectContinue = true;
        }
        if (expectContinue) {
            out.write("HTTP/1.1 100 Continue\r\n".getBytes(Util.US_ASCII));
            out.write("Content-Length: 0\r\n".getBytes(Util.US_ASCII));
            out.write("\r\n".getBytes(Util.US_ASCII));
            out.flush();
        }
        boolean hasBody = false;
        TruncatingOutputStream requestBody = new TruncatingOutputStream();
        ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
        if (contentLength != -1L) {
            hasBody = true;
            this.transfer(contentLength, in, requestBody);
        } else if (chunked) {
            hasBody = true;
            while (true) {
                int chunkSize;
                if ((chunkSize = Integer.parseInt(this.readAsciiUntilCrlf(in).trim(), 16)) == 0) {
                    this.readEmptyLine(in);
                    break;
                }
                chunkSizes.add(chunkSize);
                this.transfer(chunkSize, in, requestBody);
                this.readEmptyLine(in);
            }
        }
        if (request.startsWith("OPTIONS ") || request.startsWith("GET ") || request.startsWith("HEAD ") || request.startsWith("DELETE ") || request.startsWith("TRACE ") || request.startsWith("CONNECT ")) {
            if (hasBody) {
                throw new IllegalArgumentException("Request must not have a body: " + request);
            }
        } else if (!request.startsWith("POST ") && !request.startsWith("PUT ")) {
            throw new UnsupportedOperationException("Unexpected method: " + request);
        }
        return new RecordedRequest(request, headers, chunkSizes, requestBody.numBytesReceived, requestBody.toByteArray(), sequenceNumber, socket);
    }

    private void writeResponse(OutputStream out, MockResponse response) throws IOException {
        int read;
        out.write((response.getStatus() + "\r\n").getBytes(Util.US_ASCII));
        for (String header : response.getHeaders()) {
            out.write((header + "\r\n").getBytes(Util.US_ASCII));
        }
        out.write("\r\n".getBytes(Util.US_ASCII));
        out.flush();
        InputStream in = response.getBodyStream();
        if (in == null) {
            return;
        }
        int bytesPerSecond = response.getBytesPerSecond();
        byte[] buffer = bytesPerSecond >= 1452 ? new byte[1452] : new byte[bytesPerSecond];
        long delayMs = bytesPerSecond == Integer.MAX_VALUE ? 0L : (long)(1000 * buffer.length / bytesPerSecond);
        long sinceDelay = 0L;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            out.flush();
            if ((sinceDelay += (long)read) < (long)buffer.length || delayMs <= 0L) continue;
            sinceDelay %= (long)buffer.length;
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                throw new AssertionError();
            }
        }
    }

    private void transfer(long length, InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        while (length > 0L) {
            int count = in.read(buffer, 0, (int)Math.min((long)buffer.length, length));
            if (count == -1) {
                return;
            }
            out.write(buffer, 0, count);
            length -= (long)count;
        }
    }

    private String readAsciiUntilCrlf(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        while (true) {
            int c;
            if ((c = in.read()) == 10 && builder.length() > 0 && builder.charAt(builder.length() - 1) == '\r') {
                builder.deleteCharAt(builder.length() - 1);
                return builder.toString();
            }
            if (c == -1) {
                return builder.toString();
            }
            builder.append((char)c);
        }
    }

    private void readEmptyLine(InputStream in) throws IOException {
        String line = this.readAsciiUntilCrlf(in);
        if (line.length() != 0) {
            throw new IllegalStateException("Expected empty but was: " + line);
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        if (dispatcher == null) {
            throw new NullPointerException();
        }
        this.dispatcher = dispatcher;
    }

    private static Runnable namedRunnable(final String name, final Runnable runnable) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String originalName = Thread.currentThread().getName();
                Thread.currentThread().setName(name);
                try {
                    runnable.run();
                }
                finally {
                    Thread.currentThread().setName(originalName);
                }
            }
        };
    }

    static enum Transport {
        HTTP_11,
        SPDY_3,
        HTTP_20_DRAFT_04;

    }

    private class SpdySocketHandler
    implements IncomingStreamHandler {
        private final Socket socket;

        private SpdySocketHandler(Socket socket) {
            this.socket = socket;
        }

        public void receive(SpdyStream stream) throws IOException {
            MockResponse response;
            RecordedRequest request = this.readRequest(stream);
            MockWebServer.this.requestQueue.add(request);
            try {
                response = MockWebServer.this.dispatcher.dispatch(request);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            this.writeResponse(stream, response);
            logger.info("Received request: " + request + " and responded: " + response);
        }

        private RecordedRequest readRequest(SpdyStream stream) throws IOException {
            int count;
            List spdyHeaders = stream.getRequestHeaders();
            ArrayList<String> httpHeaders = new ArrayList<String>();
            String method = "<:method omitted>";
            String path = "<:path omitted>";
            String version = "<:version omitted>";
            Iterator i = spdyHeaders.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String value = (String)i.next();
                if (":method".equals(name)) {
                    method = value;
                    continue;
                }
                if (":path".equals(name)) {
                    path = value;
                    continue;
                }
                if (":version".equals(name)) {
                    version = value;
                    continue;
                }
                httpHeaders.add(name + ": " + value);
            }
            InputStream bodyIn = stream.getInputStream();
            ByteArrayOutputStream bodyOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((count = bodyIn.read(buffer)) != -1) {
                bodyOut.write(buffer, 0, count);
            }
            bodyIn.close();
            String requestLine = method + ' ' + path + ' ' + version;
            List<Integer> chunkSizes = Collections.emptyList();
            return new RecordedRequest(requestLine, httpHeaders, chunkSizes, bodyOut.size(), bodyOut.toByteArray(), 0, this.socket);
        }

        private void writeResponse(SpdyStream stream, MockResponse response) throws IOException {
            ArrayList<String> spdyHeaders = new ArrayList<String>();
            String[] statusParts = response.getStatus().split(" ", 2);
            if (statusParts.length != 2) {
                throw new AssertionError((Object)("Unexpected status: " + response.getStatus()));
            }
            spdyHeaders.add(":status");
            spdyHeaders.add(statusParts[1]);
            spdyHeaders.add(":version");
            spdyHeaders.add(statusParts[0]);
            for (String header : response.getHeaders()) {
                String[] headerParts = header.split(":", 2);
                if (headerParts.length != 2) {
                    throw new AssertionError((Object)("Unexpected header: " + header));
                }
                spdyHeaders.add(headerParts[0].toLowerCase(Locale.US).trim());
                spdyHeaders.add(headerParts[1].trim());
            }
            byte[] body = response.getBody();
            stream.reply(spdyHeaders, body.length > 0);
            if (body.length > 0) {
                stream.getOutputStream().write(body);
                stream.getOutputStream().close();
            }
        }
    }

    private class TruncatingOutputStream
    extends ByteArrayOutputStream {
        private long numBytesReceived = 0L;

        private TruncatingOutputStream() {
        }

        @Override
        public void write(byte[] buffer, int offset, int len) {
            this.numBytesReceived += (long)len;
            super.write(buffer, offset, Math.min(len, MockWebServer.this.bodyLimit - this.count));
        }

        @Override
        public void write(int oneByte) {
            ++this.numBytesReceived;
            if (this.count < MockWebServer.this.bodyLimit) {
                super.write(oneByte);
            }
        }
    }
}

