/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.internal.SslContextBuilder;
import com.squareup.okhttp.internal.spdy.IncomingStreamHandler;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import com.squareup.okhttp.internal.spdy.SpdyStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.npn.NextProtoNego;

public final class SpdyServer
implements IncomingStreamHandler {
    private final File baseDirectory;
    private SSLSocketFactory sslSocketFactory;

    public SpdyServer(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void useHttps(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    private void run() throws Exception {
        ServerSocket serverSocket = new ServerSocket(8888);
        serverSocket.setReuseAddress(true);
        while (true) {
            Socket socket = serverSocket.accept();
            if (this.sslSocketFactory != null) {
                socket = this.doSsl(socket);
            }
            new SpdyConnection.Builder(false, socket).handler((IncomingStreamHandler)this).build();
        }
    }

    private Socket doSsl(Socket socket) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        sslSocket.setUseClientMode(false);
        NextProtoNego.put((SSLSocket)sslSocket, (NextProtoNego.Provider)new NextProtoNego.ServerProvider(){

            public void unsupported() {
                System.out.println("UNSUPPORTED");
            }

            public List<String> protocols() {
                return Arrays.asList("spdy/3");
            }

            public void protocolSelected(String protocol) {
                System.out.println("PROTOCOL SELECTED: " + protocol);
            }
        });
        return sslSocket;
    }

    public void receive(SpdyStream stream) throws IOException {
        List requestHeaders = stream.getRequestHeaders();
        String path = null;
        for (int i = 0; i < requestHeaders.size(); i += 2) {
            String s = (String)requestHeaders.get(i);
            if (!":path".equals(s)) continue;
            path = (String)requestHeaders.get(i + 1);
            break;
        }
        if (path == null) {
            throw new AssertionError();
        }
        File file = new File(this.baseDirectory + path);
        if (file.isDirectory()) {
            this.serveDirectory(stream, file.list());
        } else if (file.exists()) {
            this.serveFile(stream, file);
        } else {
            this.send404(stream, path);
        }
    }

    private void send404(SpdyStream stream, String path) throws IOException {
        List<String> responseHeaders = Arrays.asList(":status", "404", ":version", "HTTP/1.1", "content-type", "text/plain");
        stream.reply(responseHeaders, true);
        OutputStream out = stream.getOutputStream();
        String text = "Not found: " + path;
        out.write(text.getBytes("UTF-8"));
        out.close();
    }

    private void serveDirectory(SpdyStream stream, String[] files) throws IOException {
        List<String> responseHeaders = Arrays.asList(":status", "200", ":version", "HTTP/1.1", "content-type", "text/html; charset=UTF-8");
        stream.reply(responseHeaders, true);
        OutputStream out = stream.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        for (String file : files) {
            writer.write("<a href='" + file + "'>" + file + "</a><br>");
        }
        ((Writer)writer).close();
    }

    private void serveFile(SpdyStream stream, File file) throws IOException {
        int count;
        FileInputStream in = new FileInputStream(file);
        byte[] buffer = new byte[8192];
        stream.reply(Arrays.asList(":status", "200", ":version", "HTTP/1.1", "content-type", this.contentType(file)), true);
        OutputStream out = stream.getOutputStream();
        while ((count = ((InputStream)in).read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.close();
    }

    private String contentType(File file) {
        return file.getName().endsWith(".html") ? "text/html" : "text/plain";
    }

    public static void main(String ... args) throws Exception {
        if (args.length != 1 || args[0].startsWith("-")) {
            System.out.println("Usage: SpdyServer <base directory>");
            return;
        }
        SpdyServer server = new SpdyServer(new File(args[0]));
        SSLContext sslContext = new SslContextBuilder(InetAddress.getLocalHost().getHostName()).build();
        server.useHttps(sslContext.getSocketFactory());
        server.run();
    }
}

