/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.mockwebserver;

import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class QueueDispatcher
extends Dispatcher {
    protected final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue<MockResponse>();
    private MockResponse failFastResponse;

    @Override
    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        String requestLine = request.getRequestLine();
        if (requestLine != null && requestLine.equals("GET /favicon.ico HTTP/1.1")) {
            System.out.println("served " + requestLine);
            return new MockResponse().setResponseCode(404);
        }
        if (this.failFastResponse != null && this.responseQueue.peek() == null) {
            return this.failFastResponse;
        }
        return this.responseQueue.take();
    }

    @Override
    public MockResponse peek() {
        MockResponse peek = (MockResponse)this.responseQueue.peek();
        if (peek != null) {
            return peek;
        }
        if (this.failFastResponse != null) {
            return this.failFastResponse;
        }
        return super.peek();
    }

    public void enqueueResponse(MockResponse response) {
        this.responseQueue.add(response);
    }

    public void setFailFast(boolean failFast) {
        MockResponse failFastResponse = failFast ? new MockResponse().setResponseCode(404) : null;
        this.setFailFast(failFastResponse);
    }

    public void setFailFast(MockResponse failFastResponse) {
        this.failFastResponse = failFastResponse;
    }
}

