/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.mockwebserver;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.NamedRunnable;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.IncomingStreamHandler;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import com.squareup.okhttp.internal.spdy.SpdyStream;
import com.squareup.okhttp.internal.ws.RealWebSocket;
import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.PushPromise;
import com.squareup.okhttp.mockwebserver.QueueDispatcher;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import com.squareup.okhttp.mockwebserver.SocketPolicy;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class MockWebServer {
    private static final X509TrustManager UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
            throw new AssertionError();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new AssertionError();
        }
    };
    private static final Logger logger = Logger.getLogger(MockWebServer.class.getName());
    private final BlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue<RecordedRequest>();
    private final Set<Socket> openClientSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<SpdyConnection> openSpdyConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger requestCount = new AtomicInteger();
    private long bodyLimit = Long.MAX_VALUE;
    private ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
    private ServerSocket serverSocket;
    private SSLSocketFactory sslSocketFactory;
    private ExecutorService executor;
    private boolean tunnelProxy;
    private Dispatcher dispatcher = new QueueDispatcher();
    private int port = -1;
    private InetSocketAddress inetSocketAddress;
    private boolean protocolNegotiationEnabled = true;
    private List<Protocol> protocols = Util.immutableList((Object[])new Protocol[]{Protocol.HTTP_2, Protocol.SPDY_3, Protocol.HTTP_1_1});

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        if (serverSocketFactory == null) {
            throw new IllegalArgumentException("null serverSocketFactory");
        }
        this.serverSocketFactory = serverSocketFactory;
    }

    public int getPort() {
        if (this.port == -1) {
            throw new IllegalStateException("Call start() before getPort()");
        }
        return this.port;
    }

    public String getHostName() {
        if (this.inetSocketAddress == null) {
            throw new IllegalStateException("Call start() before getHostName()");
        }
        return this.inetSocketAddress.getHostName();
    }

    public Proxy toProxyAddress() {
        if (this.inetSocketAddress == null) {
            throw new IllegalStateException("Call start() before toProxyAddress()");
        }
        InetSocketAddress address = new InetSocketAddress(this.inetSocketAddress.getAddress(), this.getPort());
        return new Proxy(Proxy.Type.HTTP, address);
    }

    public URL getUrl(String path) {
        try {
            return this.sslSocketFactory != null ? new URL("https://" + this.getHostName() + ":" + this.getPort() + path) : new URL("http://" + this.getHostName() + ":" + this.getPort() + path);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getCookieDomain() {
        String hostName = this.getHostName();
        return hostName.contains(".") ? hostName : ".local";
    }

    public void setBodyLimit(long maxBodyLength) {
        this.bodyLimit = maxBodyLength;
    }

    public void setProtocolNegotiationEnabled(boolean protocolNegotiationEnabled) {
        this.protocolNegotiationEnabled = protocolNegotiationEnabled;
    }

    public void setProtocols(List<Protocol> protocols) {
        if (!(protocols = Util.immutableList(protocols)).contains(Protocol.HTTP_1_1)) {
            throw new IllegalArgumentException("protocols doesn't contain http/1.1: " + protocols);
        }
        if (protocols.contains(null)) {
            throw new IllegalArgumentException("protocols must not contain null");
        }
        this.protocols = protocols;
    }

    public void useHttps(SSLSocketFactory sslSocketFactory, boolean tunnelProxy) {
        this.sslSocketFactory = sslSocketFactory;
        this.tunnelProxy = tunnelProxy;
    }

    public RecordedRequest takeRequest() throws InterruptedException {
        return this.requestQueue.take();
    }

    public RecordedRequest takeRequest(long timeout, TimeUnit unit) throws InterruptedException {
        return this.requestQueue.poll(timeout, unit);
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public void enqueue(MockResponse response) {
        ((QueueDispatcher)this.dispatcher).enqueueResponse(response.clone());
    }

    public void play() throws IOException {
        this.start();
    }

    public void play(int port) throws IOException {
        this.start(port);
    }

    public void start() throws IOException {
        this.start(0);
    }

    public void start(int port) throws IOException {
        this.start(InetAddress.getByName("localhost"), port);
    }

    public void start(InetAddress inetAddress, int port) throws IOException {
        this.start(new InetSocketAddress(inetAddress, port));
    }

    private void start(InetSocketAddress inetSocketAddress) throws IOException {
        if (this.executor != null) {
            throw new IllegalStateException("start() already called");
        }
        this.executor = Executors.newCachedThreadPool(Util.threadFactory((String)"MockWebServer", (boolean)false));
        this.inetSocketAddress = inetSocketAddress;
        this.serverSocket = this.serverSocketFactory.createServerSocket();
        this.serverSocket.setReuseAddress(inetSocketAddress.getPort() != 0);
        this.serverSocket.bind(inetSocketAddress, 50);
        this.port = this.serverSocket.getLocalPort();
        this.executor.execute((Runnable)new NamedRunnable("MockWebServer %s", new Object[]{this.port}){

            protected void execute() {
                try {
                    logger.info(MockWebServer.this + " starting to accept connections");
                    this.acceptConnections();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, MockWebServer.this + " failed unexpectedly", e);
                }
                Util.closeQuietly((ServerSocket)MockWebServer.this.serverSocket);
                Iterator s = MockWebServer.this.openClientSockets.iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Socket)((Socket)s.next()));
                    s.remove();
                }
                s = MockWebServer.this.openSpdyConnections.iterator();
                while (s.hasNext()) {
                    Util.closeQuietly((Closeable)((Closeable)s.next()));
                    s.remove();
                }
                MockWebServer.this.executor.shutdown();
            }

            private void acceptConnections() throws Exception {
                while (true) {
                    Socket socket;
                    try {
                        socket = MockWebServer.this.serverSocket.accept();
                    }
                    catch (SocketException e) {
                        logger.info(MockWebServer.this + " done accepting connections: " + e.getMessage());
                        return;
                    }
                    SocketPolicy socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy();
                    if (socketPolicy == SocketPolicy.DISCONNECT_AT_START) {
                        MockWebServer.this.dispatchBookkeepingRequest(0, socket);
                        socket.close();
                        continue;
                    }
                    MockWebServer.this.openClientSockets.add(socket);
                    MockWebServer.this.serveConnection(socket);
                }
            }
        });
    }

    public void shutdown() throws IOException {
        if (this.serverSocket == null) {
            throw new IllegalStateException("shutdown() before start()");
        }
        this.serverSocket.close();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new IOException("Gave up waiting for executor to shut down");
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
    }

    private void serveConnection(final Socket raw) {
        this.executor.execute((Runnable)new NamedRunnable("MockWebServer %s", new Object[]{raw.getRemoteSocketAddress()}){
            int sequenceNumber;
            {
                super(x0, x1);
                this.sequenceNumber = 0;
            }

            protected void execute() {
                try {
                    this.processConnection();
                }
                catch (IOException e) {
                    logger.info(MockWebServer.this + " connection from " + raw.getInetAddress() + " failed: " + e);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, MockWebServer.this + " connection from " + raw.getInetAddress() + " crashed", e);
                }
            }

            public void processConnection() throws Exception {
                Socket socket;
                Protocol protocol = Protocol.HTTP_1_1;
                if (MockWebServer.this.sslSocketFactory != null) {
                    SocketPolicy socketPolicy;
                    if (MockWebServer.this.tunnelProxy) {
                        this.createTunnel();
                    }
                    if ((socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy()) == SocketPolicy.FAIL_HANDSHAKE) {
                        MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, raw);
                        MockWebServer.this.processHandshakeFailure(raw);
                        return;
                    }
                    socket = MockWebServer.this.sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
                    SSLSocket sslSocket = (SSLSocket)socket;
                    sslSocket.setUseClientMode(false);
                    MockWebServer.this.openClientSockets.add(socket);
                    if (MockWebServer.this.protocolNegotiationEnabled) {
                        Platform.get().configureTlsExtensions(sslSocket, null, MockWebServer.this.protocols);
                    }
                    sslSocket.startHandshake();
                    if (MockWebServer.this.protocolNegotiationEnabled) {
                        String protocolString = Platform.get().getSelectedProtocol(sslSocket);
                        protocol = protocolString != null ? Protocol.get((String)protocolString) : Protocol.HTTP_1_1;
                    }
                    MockWebServer.this.openClientSockets.remove(raw);
                } else {
                    socket = raw;
                }
                if (protocol != Protocol.HTTP_1_1) {
                    SpdySocketHandler spdySocketHandler = new SpdySocketHandler(socket, protocol);
                    SpdyConnection spdyConnection = new SpdyConnection.Builder(false, socket).protocol(protocol).handler((IncomingStreamHandler)spdySocketHandler).build();
                    MockWebServer.this.openSpdyConnections.add(spdyConnection);
                    MockWebServer.this.openClientSockets.remove(socket);
                    return;
                }
                BufferedSource source = Okio.buffer((Source)Okio.source((Socket)socket));
                BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)socket));
                while (this.processOneRequest(socket, source, sink)) {
                }
                if (this.sequenceNumber == 0) {
                    logger.warning(MockWebServer.this + " connection from " + raw.getInetAddress() + " didn't make a request");
                }
                source.close();
                sink.close();
                socket.close();
                MockWebServer.this.openClientSockets.remove(socket);
            }

            private void createTunnel() throws IOException, InterruptedException {
                SocketPolicy socketPolicy;
                BufferedSource source = Okio.buffer((Source)Okio.source((Socket)raw));
                BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)raw));
                do {
                    socketPolicy = MockWebServer.this.dispatcher.peek().getSocketPolicy();
                    if (this.processOneRequest(raw, source, sink)) continue;
                    throw new IllegalStateException("Tunnel without any CONNECT!");
                } while (socketPolicy != SocketPolicy.UPGRADE_TO_SSL_AT_END);
            }

            private boolean processOneRequest(Socket socket, BufferedSource source, BufferedSink sink) throws IOException, InterruptedException {
                boolean responseWantsWebSockets;
                RecordedRequest request = MockWebServer.this.readRequest(socket, source, sink, this.sequenceNumber);
                if (request == null) {
                    return false;
                }
                MockWebServer.this.requestCount.incrementAndGet();
                MockWebServer.this.requestQueue.add(request);
                MockResponse response = MockWebServer.this.dispatcher.dispatch(request);
                if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                    socket.close();
                    return false;
                }
                if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                    if (source.exhausted()) {
                        return false;
                    }
                    throw new ProtocolException("unexpected data");
                }
                boolean requestWantsWebSockets = "Upgrade".equalsIgnoreCase(request.getHeader("Connection")) && "websocket".equalsIgnoreCase(request.getHeader("Upgrade"));
                boolean bl = responseWantsWebSockets = response.getWebSocketListener() != null;
                if (requestWantsWebSockets && responseWantsWebSockets) {
                    MockWebServer.this.handleWebSocketUpgrade(socket, source, sink, request, response);
                } else {
                    MockWebServer.this.writeHttpResponse(socket, sink, response);
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(MockWebServer.this + " received request: " + request + " and responded: " + response);
                }
                if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AT_END) {
                    socket.close();
                    return false;
                }
                if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_INPUT_AT_END) {
                    socket.shutdownInput();
                } else if (response.getSocketPolicy() == SocketPolicy.SHUTDOWN_OUTPUT_AT_END) {
                    socket.shutdownOutput();
                }
                ++this.sequenceNumber;
                return true;
            }
        });
    }

    private void processHandshakeFailure(Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{UNTRUSTED_TRUST_MANAGER}, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        SSLSocket socket = (SSLSocket)sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
        try {
            socket.startHandshake();
            throw new AssertionError();
        }
        catch (IOException expected) {
            socket.close();
            return;
        }
    }

    private void dispatchBookkeepingRequest(int sequenceNumber, Socket socket) throws InterruptedException {
        this.requestCount.incrementAndGet();
        this.dispatcher.dispatch(new RecordedRequest(null, null, null, -1L, null, sequenceNumber, socket));
    }

    private RecordedRequest readRequest(Socket socket, BufferedSource source, BufferedSink sink, int sequenceNumber) throws IOException {
        String header;
        String request;
        try {
            request = source.readUtf8LineStrict();
        }
        catch (IOException streamIsClosed) {
            return null;
        }
        if (request.length() == 0) {
            return null;
        }
        Headers.Builder headers = new Headers.Builder();
        long contentLength = -1L;
        boolean chunked = false;
        boolean expectContinue = false;
        while ((header = source.readUtf8LineStrict()).length() != 0) {
            headers.add(header);
            String lowercaseHeader = header.toLowerCase(Locale.US);
            if (contentLength == -1L && lowercaseHeader.startsWith("content-length:")) {
                contentLength = Long.parseLong(header.substring(15).trim());
            }
            if (lowercaseHeader.startsWith("transfer-encoding:") && lowercaseHeader.substring(18).trim().equals("chunked")) {
                chunked = true;
            }
            if (!lowercaseHeader.startsWith("expect:") || !lowercaseHeader.substring(7).trim().equals("100-continue")) continue;
            expectContinue = true;
        }
        if (expectContinue) {
            sink.writeUtf8("HTTP/1.1 100 Continue\r\n");
            sink.writeUtf8("Content-Length: 0\r\n");
            sink.writeUtf8("\r\n");
            sink.flush();
        }
        boolean hasBody = false;
        TruncatingBuffer requestBody = new TruncatingBuffer(this.bodyLimit);
        ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
        MockResponse throttlePolicy = this.dispatcher.peek();
        if (contentLength != -1L) {
            hasBody = contentLength > 0L;
            this.throttledTransfer(throttlePolicy, socket, source, Okio.buffer((Sink)requestBody), contentLength);
        } else if (chunked) {
            hasBody = true;
            while (true) {
                int chunkSize;
                if ((chunkSize = Integer.parseInt(source.readUtf8LineStrict().trim(), 16)) == 0) {
                    this.readEmptyLine(source);
                    break;
                }
                chunkSizes.add(chunkSize);
                this.throttledTransfer(throttlePolicy, socket, source, Okio.buffer((Sink)requestBody), chunkSize);
                this.readEmptyLine(source);
            }
        }
        if (request.startsWith("OPTIONS ") || request.startsWith("GET ") || request.startsWith("HEAD ") || request.startsWith("TRACE ") || request.startsWith("CONNECT ")) {
            if (hasBody) {
                throw new IllegalArgumentException("Request must not have a body: " + request);
            }
        } else if (!(request.startsWith("POST ") || request.startsWith("PUT ") || request.startsWith("PATCH ") || request.startsWith("DELETE "))) {
            throw new UnsupportedOperationException("Unexpected method: " + request);
        }
        return new RecordedRequest(request, headers.build(), chunkSizes, requestBody.receivedByteCount, requestBody.buffer, sequenceNumber, socket);
    }

    private void handleWebSocketUpgrade(Socket socket, BufferedSource source, BufferedSink sink, RecordedRequest request, MockResponse response) throws IOException {
        String key = request.getHeader("Sec-WebSocket-Key");
        String acceptKey = Util.shaBase64((String)(key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11"));
        response.setHeader("Sec-WebSocket-Accept", acceptKey);
        this.writeHttpResponse(socket, sink, response);
        final WebSocketListener listener = response.getWebSocketListener();
        final CountDownLatch connectionClose = new CountDownLatch(1);
        ThreadPoolExecutor replyExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), Util.threadFactory((String)String.format("MockWebServer %s WebSocket", request.getPath()), (boolean)true));
        replyExecutor.allowCoreThreadTimeOut(true);
        final RealWebSocket webSocket = new RealWebSocket(false, source, sink, new SecureRandom(), replyExecutor, listener, request.getPath()){

            protected void closeConnection() throws IOException {
                connectionClose.countDown();
            }
        };
        String scheme = request.getTlsVersion() != null ? "https" : "http";
        String authority = request.getHeader("Host");
        final Request fancyRequest = new Request.Builder().url(scheme + "://" + authority + "/").headers(request.getHeaders()).build();
        final Response fancyResponse = new Response.Builder().code(Integer.parseInt(response.getStatus().split(" ")[1])).message(response.getStatus().split(" ", 3)[2]).headers(response.getHeaders()).request(fancyRequest).protocol(Protocol.HTTP_1_1).build();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    listener.onOpen((WebSocket)webSocket, fancyRequest, fancyResponse);
                }
                catch (IOException e) {
                    connectionClose.countDown();
                }
            }
        }, "MockWebServer WebSocket Writer " + request.getPath()).start();
        while (webSocket.readMessage()) {
        }
        try {
            connectionClose.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Util.closeQuietly((Closeable)sink);
        Util.closeQuietly((Closeable)source);
    }

    private void writeHttpResponse(Socket socket, BufferedSink sink, MockResponse response) throws IOException {
        sink.writeUtf8(response.getStatus());
        sink.writeUtf8("\r\n");
        Headers headers = response.getHeaders();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            sink.writeUtf8(headers.name(i));
            sink.writeUtf8(": ");
            sink.writeUtf8(headers.value(i));
            sink.writeUtf8("\r\n");
        }
        sink.writeUtf8("\r\n");
        sink.flush();
        Buffer body = response.getBody();
        if (body == null) {
            return;
        }
        this.sleepIfDelayed(response);
        this.throttledTransfer(response, socket, (BufferedSource)body, sink, Long.MAX_VALUE);
    }

    private void sleepIfDelayed(MockResponse response) {
        long delayMs = response.getBodyDelay(TimeUnit.MILLISECONDS);
        if (delayMs != 0L) {
            try {
                Thread.sleep(delayMs);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void throttledTransfer(MockResponse throttlePolicy, Socket socket, BufferedSource source, BufferedSink sink, long byteCount) throws IOException {
        if (byteCount == 0L) {
            return;
        }
        Buffer buffer = new Buffer();
        long bytesPerPeriod = throttlePolicy.getThrottleBytesPerPeriod();
        long periodDelayMs = throttlePolicy.getThrottlePeriod(TimeUnit.MILLISECONDS);
        while (!socket.isClosed()) {
            int b = 0;
            while ((long)b < bytesPerPeriod) {
                long toRead = Math.min(Math.min(2048L, byteCount), bytesPerPeriod - (long)b);
                long read = source.read(buffer, toRead);
                if (read == -1L) {
                    return;
                }
                sink.write(buffer, read);
                sink.flush();
                b = (int)((long)b + read);
                if ((byteCount -= read) != 0L) continue;
                return;
            }
            if (periodDelayMs == 0L) continue;
            try {
                Thread.sleep(periodDelayMs);
            }
            catch (InterruptedException e) {
                throw new AssertionError();
            }
        }
    }

    private void readEmptyLine(BufferedSource source) throws IOException {
        String line = source.readUtf8LineStrict();
        if (line.length() != 0) {
            throw new IllegalStateException("Expected empty but was: " + line);
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        if (dispatcher == null) {
            throw new NullPointerException();
        }
        this.dispatcher = dispatcher;
    }

    public String toString() {
        return "MockWebServer[" + this.port + "]";
    }

    private class SpdySocketHandler
    implements IncomingStreamHandler {
        private final Socket socket;
        private final Protocol protocol;
        private final AtomicInteger sequenceNumber = new AtomicInteger();

        private SpdySocketHandler(Socket socket, Protocol protocol) {
            this.socket = socket;
            this.protocol = protocol;
        }

        public void receive(SpdyStream stream) throws IOException {
            MockResponse response;
            RecordedRequest request = this.readRequest(stream);
            MockWebServer.this.requestQueue.add(request);
            try {
                response = MockWebServer.this.dispatcher.dispatch(request);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            this.writeResponse(stream, response);
            if (logger.isLoggable(Level.INFO)) {
                logger.info(MockWebServer.this + " received request: " + request + " and responded: " + response + " protocol is " + this.protocol.toString());
            }
        }

        private RecordedRequest readRequest(SpdyStream stream) throws IOException {
            List spdyHeaders = stream.getRequestHeaders();
            Headers.Builder httpHeaders = new Headers.Builder();
            String method = "<:method omitted>";
            String path = "<:path omitted>";
            String version = this.protocol == Protocol.SPDY_3 ? "<:version omitted>" : "HTTP/1.1";
            int size = spdyHeaders.size();
            for (int i = 0; i < size; ++i) {
                ByteString name = ((Header)spdyHeaders.get((int)i)).name;
                String value = ((Header)spdyHeaders.get((int)i)).value.utf8();
                if (name.equals((Object)Header.TARGET_METHOD)) {
                    method = value;
                    continue;
                }
                if (name.equals((Object)Header.TARGET_PATH)) {
                    path = value;
                    continue;
                }
                if (name.equals((Object)Header.VERSION)) {
                    version = value;
                    continue;
                }
                httpHeaders.add(name.utf8(), value);
            }
            Buffer body = new Buffer();
            body.writeAll(stream.getSource());
            body.close();
            String requestLine = method + ' ' + path + ' ' + version;
            List<Integer> chunkSizes = Collections.emptyList();
            return new RecordedRequest(requestLine, httpHeaders.build(), chunkSizes, body.size(), body, this.sequenceNumber.getAndIncrement(), this.socket);
        }

        private void writeResponse(SpdyStream stream, MockResponse response) throws IOException {
            if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                return;
            }
            ArrayList<Header> spdyHeaders = new ArrayList<Header>();
            String[] statusParts = response.getStatus().split(" ", 2);
            if (statusParts.length != 2) {
                throw new AssertionError((Object)("Unexpected status: " + response.getStatus()));
            }
            spdyHeaders.add(new Header(Header.RESPONSE_STATUS, statusParts[1]));
            if (this.protocol == Protocol.SPDY_3) {
                spdyHeaders.add(new Header(Header.VERSION, statusParts[0]));
            }
            Headers headers = response.getHeaders();
            int size = headers.size();
            for (int i = 0; i < size; ++i) {
                spdyHeaders.add(new Header(headers.name(i), headers.value(i)));
            }
            Buffer body = response.getBody();
            boolean closeStreamAfterHeaders = body != null || !response.getPushPromises().isEmpty();
            stream.reply(spdyHeaders, closeStreamAfterHeaders);
            this.pushPromises(stream, response.getPushPromises());
            if (body != null) {
                BufferedSink sink = Okio.buffer((Sink)stream.getSink());
                MockWebServer.this.sleepIfDelayed(response);
                MockWebServer.this.throttledTransfer(response, this.socket, (BufferedSource)body, sink, MockWebServer.this.bodyLimit);
                sink.close();
            } else if (closeStreamAfterHeaders) {
                stream.close(ErrorCode.NO_ERROR);
            }
        }

        private void pushPromises(SpdyStream stream, List<PushPromise> promises) throws IOException {
            for (PushPromise pushPromise : promises) {
                ArrayList<Header> pushedHeaders = new ArrayList<Header>();
                pushedHeaders.add(new Header(stream.getConnection().getProtocol() == Protocol.SPDY_3 ? Header.TARGET_HOST : Header.TARGET_AUTHORITY, MockWebServer.this.getUrl(pushPromise.getPath()).getHost()));
                pushedHeaders.add(new Header(Header.TARGET_METHOD, pushPromise.getMethod()));
                pushedHeaders.add(new Header(Header.TARGET_PATH, pushPromise.getPath()));
                Headers pushPromiseHeaders = pushPromise.getHeaders();
                int size = pushPromiseHeaders.size();
                for (int i = 0; i < size; ++i) {
                    pushedHeaders.add(new Header(pushPromiseHeaders.name(i), pushPromiseHeaders.value(i)));
                }
                String requestLine = pushPromise.getMethod() + ' ' + pushPromise.getPath() + " HTTP/1.1";
                List<Integer> chunkSizes = Collections.emptyList();
                MockWebServer.this.requestQueue.add(new RecordedRequest(requestLine, pushPromise.getHeaders(), chunkSizes, 0L, new Buffer(), this.sequenceNumber.getAndIncrement(), this.socket));
                boolean hasBody = pushPromise.getResponse().getBody() != null;
                SpdyStream pushedStream = stream.getConnection().pushStream(stream.getId(), pushedHeaders, hasBody);
                this.writeResponse(pushedStream, pushPromise.getResponse());
            }
        }
    }

    private static class TruncatingBuffer
    implements Sink {
        private final Buffer buffer = new Buffer();
        private long remainingByteCount;
        private long receivedByteCount;

        TruncatingBuffer(long bodyLimit) {
            this.remainingByteCount = bodyLimit;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            long toSkip;
            long toRead = Math.min(this.remainingByteCount, byteCount);
            if (toRead > 0L) {
                source.read(this.buffer, toRead);
            }
            if ((toSkip = byteCount - toRead) > 0L) {
                source.skip(toSkip);
            }
            this.remainingByteCount -= toRead;
            this.receivedByteCount += byteCount;
        }

        public void flush() throws IOException {
        }

        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() throws IOException {
        }
    }
}

