/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.WebSocketListener;
import okhttp3.internal.InternalKtKt;
import okhttp3.internal.http2.Settings;
import okhttp3.mockwebserver.PushPromise;
import okhttp3.mockwebserver.SocketPolicy;
import okhttp3.mockwebserver.internal.duplex.DuplexResponseBody;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b \u0018\u0000 [2\u00020\u0001:\u0001[B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020%J\u0016\u00100\u001a\u00020\u00002\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u000204J\u0016\u00105\u001a\u00020\u00002\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u000204J\u0006\u00106\u001a\u00020\u0000J\b\u00107\u001a\u00020\u0000H\u0016J\b\u00108\u001a\u0004\u0018\u00010\u0004J\u000e\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\bJ\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\bJ\u0006\u0010>\u001a\u00020\u0013J\u0006\u0010?\u001a\u00020#J\u0006\u0010@\u001a\u00020%J\u000e\u0010A\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\bJ\u0006\u0010B\u001a\u00020<J\u000e\u0010C\u001a\u00020\u00002\u0006\u00102\u001a\u00020%J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020%J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010D\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\bJ\u0016\u0010G\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020%2\u0006\u0010H\u001a\u00020\u0013J\u0016\u0010G\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0013J\u0016\u0010I\u001a\u00020\u00002\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u000204J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020<J\u0016\u0010K\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\bJ\u000e\u0010L\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0013J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010+\u001a\u00020<J\u001e\u0010R\u001a\u00020\u00002\u0006\u0010S\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\bJ\b\u0010U\u001a\u00020%H\u0016J\u000e\u0010V\u001a\u00020\u00002\u0006\u0010W\u001a\u00020\u0019J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010Y\u001a\u00020\u00002\u0006\u0010Z\u001a\u00020,R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010-\u001a\u0004\u0018\u00010,2\b\u0010\t\u001a\u0004\u0018\u00010,@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006\\"}, d2={"Lokhttp3/mockwebserver/MockResponse;", "", "()V", "body", "Lokio/Buffer;", "bodyDelayAmount", "", "bodyDelayUnit", "Ljava/util/concurrent/TimeUnit;", "<set-?>", "Lokhttp3/mockwebserver/internal/duplex/DuplexResponseBody;", "duplexResponseBody", "getDuplexResponseBody", "()Lokhttp3/mockwebserver/internal/duplex/DuplexResponseBody;", "headers", "Lokhttp3/Headers$Builder;", "headersDelayAmount", "headersDelayUnit", "http2ErrorCode", "", "isDuplex", "", "()Z", "promises", "", "Lokhttp3/mockwebserver/PushPromise;", "pushPromises", "", "getPushPromises", "()Ljava/util/List;", "Lokhttp3/internal/http2/Settings;", "settings", "getSettings", "()Lokhttp3/internal/http2/Settings;", "socketPolicy", "Lokhttp3/mockwebserver/SocketPolicy;", "status", "", "throttleBytesPerPeriod", "getThrottleBytesPerPeriod", "()J", "throttlePeriodAmount", "throttlePeriodUnit", "trailers", "Lokhttp3/WebSocketListener;", "webSocketListener", "getWebSocketListener", "()Lokhttp3/WebSocketListener;", "addHeader", "header", "name", "value", "", "addHeaderLenient", "clearHeaders", "clone", "getBody", "getBodyDelay", "unit", "getHeaders", "Lokhttp3/Headers;", "getHeadersDelay", "getHttp2ErrorCode", "getSocketPolicy", "getStatus", "getThrottlePeriod", "getTrailers", "removeHeader", "setBody", "setBodyDelay", "delay", "setChunkedBody", "maxChunkSize", "setHeader", "setHeaders", "setHeadersDelay", "setHttp2ErrorCode", "setResponseCode", "code", "setSocketPolicy", "setStatus", "setTrailers", "throttleBody", "bytesPerPeriod", "period", "toString", "withPush", "promise", "withSettings", "withWebSocketUpgrade", "listener", "Companion", "mockwebserver"})
public final class MockResponse
implements Cloneable {
    private String status = "";
    private Headers.Builder headers = new Headers.Builder();
    private Headers.Builder trailers = new Headers.Builder();
    private Buffer body;
    private long throttleBytesPerPeriod = Long.MAX_VALUE;
    private long throttlePeriodAmount = 1L;
    private TimeUnit throttlePeriodUnit = TimeUnit.SECONDS;
    private SocketPolicy socketPolicy = SocketPolicy.KEEP_OPEN;
    private int http2ErrorCode = -1;
    private long bodyDelayAmount;
    private TimeUnit bodyDelayUnit = TimeUnit.MILLISECONDS;
    private long headersDelayAmount;
    private TimeUnit headersDelayUnit = TimeUnit.MILLISECONDS;
    private List<PushPromise> promises;
    @NotNull
    private Settings settings;
    @Nullable
    private WebSocketListener webSocketListener;
    @Nullable
    private DuplexResponseBody duplexResponseBody;
    private static final String CHUNKED_BODY_HEADER = "Transfer-encoding: chunked";
    public static final Companion Companion = new Companion(null);

    public final long getThrottleBytesPerPeriod() {
        return this.throttleBytesPerPeriod;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @Nullable
    public final WebSocketListener getWebSocketListener() {
        return this.webSocketListener;
    }

    @Nullable
    public final DuplexResponseBody getDuplexResponseBody() {
        return this.duplexResponseBody;
    }

    public final boolean isDuplex() {
        return this.duplexResponseBody != null;
    }

    @NotNull
    public final List<PushPromise> getPushPromises() {
        return this.promises;
    }

    @NotNull
    public MockResponse clone() {
        Object object = super.clone();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type okhttp3.mockwebserver.MockResponse");
        }
        MockResponse result = (MockResponse)object;
        result.headers = this.headers.build().newBuilder();
        result.promises = CollectionsKt.toMutableList((Collection)this.promises);
        return result;
    }

    @NotNull
    public final String getStatus() {
        return this.status;
    }

    @NotNull
    public final MockResponse setResponseCode(int code) {
        int n = code;
        int n2 = n;
        String reason = 100 <= n2 && 199 >= n2 ? "Informational" : (200 <= (n2 = n) && 299 >= n2 ? "OK" : (300 <= (n2 = n) && 399 >= n2 ? "Redirection" : (400 <= (n2 = n) && 499 >= n2 ? "Client Error" : (500 <= (n2 = n) && 599 >= n2 ? "Server Error" : "Mock Response"))));
        return this.setStatus("HTTP/1.1 " + code + ' ' + reason);
    }

    @NotNull
    public final MockResponse setStatus(@NotNull String status) {
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        this.status = status;
        return this;
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headers.build();
    }

    @NotNull
    public final Headers getTrailers() {
        return this.trailers.build();
    }

    @NotNull
    public final MockResponse clearHeaders() {
        this.headers = new Headers.Builder();
        return this;
    }

    @NotNull
    public final MockResponse addHeader(@NotNull String header) {
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        this.headers.add(header);
        return this;
    }

    @NotNull
    public final MockResponse addHeader(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.headers.add(name, value.toString());
        return this;
    }

    @NotNull
    public final MockResponse addHeaderLenient(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        InternalKtKt.addHeaderLenient((Headers.Builder)this.headers, (String)name, (String)value.toString());
        return this;
    }

    @NotNull
    public final MockResponse setHeader(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.removeHeader(name);
        return this.addHeader(name, value);
    }

    @NotNull
    public final MockResponse setHeaders(@NotNull Headers headers) {
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        this.headers = headers.newBuilder();
        return this;
    }

    @NotNull
    public final MockResponse setTrailers(@NotNull Headers trailers) {
        Intrinsics.checkParameterIsNotNull((Object)trailers, (String)"trailers");
        this.trailers = trailers.newBuilder();
        return this;
    }

    @NotNull
    public final MockResponse removeHeader(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.headers.removeAll(name);
        return this;
    }

    @Nullable
    public final Buffer getBody() {
        Buffer buffer = this.body;
        return buffer != null ? buffer.clone() : null;
    }

    @NotNull
    public final MockResponse setBody(@NotNull Buffer body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        this.setHeader("Content-Length", body.size());
        this.body = body.clone();
        return this;
    }

    @NotNull
    public final MockResponse setBody(@NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        return this.setBody(new Buffer().writeUtf8(body));
    }

    @NotNull
    public final MockResponse setBody(@NotNull DuplexResponseBody duplexResponseBody) {
        Intrinsics.checkParameterIsNotNull((Object)duplexResponseBody, (String)"duplexResponseBody");
        this.duplexResponseBody = duplexResponseBody;
        return this;
    }

    @NotNull
    public final MockResponse setChunkedBody(@NotNull Buffer body, int maxChunkSize) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        this.removeHeader("Content-Length");
        this.headers.add(CHUNKED_BODY_HEADER);
        Buffer bytesOut = new Buffer();
        while (!body.exhausted()) {
            long l = body.size();
            long l2 = maxChunkSize;
            boolean bl = false;
            long chunkSize = Math.min(l, l2);
            bytesOut.writeHexadecimalUnsignedLong(chunkSize);
            bytesOut.writeUtf8("\r\n");
            bytesOut.write(body, chunkSize);
            bytesOut.writeUtf8("\r\n");
        }
        bytesOut.writeUtf8("0\r\n");
        this.body = bytesOut;
        return this;
    }

    @NotNull
    public final MockResponse setChunkedBody(@NotNull String body, int maxChunkSize) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        return this.setChunkedBody(new Buffer().writeUtf8(body), maxChunkSize);
    }

    @NotNull
    public final SocketPolicy getSocketPolicy() {
        return this.socketPolicy;
    }

    @NotNull
    public final MockResponse setSocketPolicy(@NotNull SocketPolicy socketPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)socketPolicy), (String)"socketPolicy");
        this.socketPolicy = socketPolicy;
        return this;
    }

    public final int getHttp2ErrorCode() {
        return this.http2ErrorCode;
    }

    @NotNull
    public final MockResponse setHttp2ErrorCode(int http2ErrorCode) {
        this.http2ErrorCode = http2ErrorCode;
        return this;
    }

    @NotNull
    public final MockResponse throttleBody(long bytesPerPeriod, long period, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        this.throttleBytesPerPeriod = bytesPerPeriod;
        this.throttlePeriodAmount = period;
        this.throttlePeriodUnit = unit;
        return this;
    }

    public final long getThrottlePeriod(@NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        return unit.convert(this.throttlePeriodAmount, this.throttlePeriodUnit);
    }

    @NotNull
    public final MockResponse setBodyDelay(long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        this.bodyDelayAmount = delay;
        this.bodyDelayUnit = unit;
        return this;
    }

    public final long getBodyDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        return unit.convert(this.bodyDelayAmount, this.bodyDelayUnit);
    }

    @NotNull
    public final MockResponse setHeadersDelay(long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        this.headersDelayAmount = delay;
        this.headersDelayUnit = unit;
        return this;
    }

    public final long getHeadersDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        return unit.convert(this.headersDelayAmount, this.headersDelayUnit);
    }

    @NotNull
    public final MockResponse withPush(@NotNull PushPromise promise) {
        Intrinsics.checkParameterIsNotNull((Object)promise, (String)"promise");
        this.promises.add(promise);
        return this;
    }

    @NotNull
    public final MockResponse withSettings(@NotNull Settings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.settings = settings;
        return this;
    }

    @NotNull
    public final MockResponse withWebSocketUpgrade(@NotNull WebSocketListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.setStatus("HTTP/1.1 101 Switching Protocols");
        this.setHeader("Connection", "Upgrade");
        this.setHeader("Upgrade", "websocket");
        this.body = null;
        this.webSocketListener = listener;
        return this;
    }

    @NotNull
    public String toString() {
        return this.status;
    }

    public MockResponse() {
        List list;
        MockResponse mockResponse = this;
        boolean bl = false;
        mockResponse.promises = list = (List)new ArrayList();
        this.settings = new Settings();
        this.setResponseCode(200);
        this.setHeader("Content-Length", 0L);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/mockwebserver/MockResponse$Companion;", "", "()V", "CHUNKED_BODY_HEADER", "", "mockwebserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

