//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Connection](index.md)

# Connection

[jvm]\
interface [Connection](index.md)

The sockets and streams of an HTTP, HTTPS, or HTTPS+HTTP/2 connection. May be used for multiple HTTP request/response exchanges. Connections may be direct to the origin server or via a proxy.

Typically instances of this class are created, connected and exercised automatically by the HTTP client. Applications may use this class to monitor HTTP connections as members of a [connection pool](../-connection-pool/index.md).

Do not confuse this class with the misnamed `HttpURLConnection`, which isn't so much a connection as a single request/response exchange.

##  Modern TLS

There are trade-offs when selecting which options to include when negotiating a secure connection to a remote host. Newer TLS options are quite useful:

- 
   Server Name Indication (SNI) enables one IP address to negotiate secure connections for     multiple domain names.
- 
   Application Layer Protocol Negotiation (ALPN) enables the HTTPS port (443) to be used to     negotiate HTTP/2.

Unfortunately, older HTTPS servers refuse to connect when such options are presented. Rather than avoiding these options entirely, this class allows a connection to be attempted with modern options and then retried without them should the attempt fail.

##  Connection Reuse

Each connection can carry a varying number of streams, depending on the underlying protocol being used. HTTP/1.x connections can carry either zero or one streams. HTTP/2 connections can carry any number of streams, dynamically configured with `SETTINGS_MAX_CONCURRENT_STREAMS`. A connection currently carrying zero streams is an idle stream. We keep it alive because reusing an existing connection is typically faster than establishing a new one.

When a single logical call requires multiple streams due to redirects or authorization challenges, we prefer to use the same physical connection for all streams in the sequence. There are potential performance and behavior consequences to this preference. To support this feature, this class separates *allocations* from *streams*. An allocation is created by a call, used for one or more streams, and then released. An allocated connection won't be stolen by other calls while a redirect or authorization challenge is being handled.

When the maximum concurrent streams limit is reduced, some allocations will be rescinded. Attempting to create new streams on these allocations will fail.

Note that an allocation may be released before its stream is completed. This is intended to make bookkeeping easier for the caller: releasing the allocation as soon as the terminal stream has been found. But only complete the stream once its data stream has been exhausted.

## Functions

| Name | Summary |
|---|---|
| [handshake](handshake.md) | [jvm]<br>abstract fun [handshake](handshake.md)(): [Handshake](../-handshake/index.md)?<br>Returns the TLS handshake used to establish this connection, or null if the connection is not HTTPS. |
| [protocol](protocol.md) | [jvm]<br>abstract fun [protocol](protocol.md)(): Protocol<br>Returns the protocol negotiated by this connection, or Protocol.HTTP_1_1 if no protocol has been negotiated. This method returns Protocol.HTTP_1_1 even if the remote peer is using Protocol.HTTP_1_0. |
| [route](route.md) | [jvm]<br>abstract fun [route](route.md)(): [Route](../-route/index.md)<br>Returns the route used by this connection. |
| [socket](socket.md) | [jvm]<br>abstract fun [socket](socket.md)(): [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html)<br>Returns the socket that this connection is using. Returns an [SSL socket](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocket.html) if this connection is HTTPS. If this is an HTTP/2 connection the socket may be shared by multiple concurrent calls. |
