/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal.http2.Settings;
import okhttp3.mockwebserver.PushPromise;
import okhttp3.mockwebserver.SocketPolicy;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b'\u0018\u0000 c2\u00020\u0001:\u0001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020)J\u0016\u0010:\u001a\u00020\u00002\u0006\u0010<\u001a\u00020)2\u0006\u0010\t\u001a\u00020=J\u0016\u0010>\u001a\u00020\u00002\u0006\u0010<\u001a\u00020)2\u0006\u0010\t\u001a\u00020=J\u0006\u0010?\u001a\u00020\u0000J\b\u0010@\u001a\u00020\u0000H\u0016J\b\u0010A\u001a\u0004\u0018\u00010\u0004J\u000e\u0010B\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\bJ\r\u0010\f\u001a\u00020\nH\u0007\u00a2\u0006\u0002\bDJ\u000e\u0010E\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\bJ\r\u0010\u0016\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\bFJ\r\u0010&\u001a\u00020$H\u0007\u00a2\u0006\u0002\bGJ\r\u0010+\u001a\u00020)H\u0007\u00a2\u0006\u0002\bHJ\u000e\u0010I\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\bJ\r\u00104\u001a\u00020\nH\u0007\u00a2\u0006\u0002\bJJ\u000e\u0010K\u001a\u00020\u00002\u0006\u0010<\u001a\u00020)J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020)J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\bJ\u0016\u0010O\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020)2\u0006\u0010P\u001a\u00020\u0014J\u0016\u0010O\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u0014J\u0016\u0010Q\u001a\u00020\u00002\u0006\u0010<\u001a\u00020)2\u0006\u0010\t\u001a\u00020=J\u000e\u0010R\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010S\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\bJ\u000e\u0010T\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010V\u001a\u00020\u0014J\u000e\u0010W\u001a\u00020\u00002\u0006\u0010%\u001a\u00020$J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010*\u001a\u00020)J\u000e\u0010Y\u001a\u00020\u00002\u0006\u00103\u001a\u00020\nJ\u001e\u0010Z\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00062\u0006\u0010\\\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\bJ\b\u0010]\u001a\u00020)H\u0016J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u001bJ\u000e\u0010`\u001a\u00020\u00002\u0006\u0010!\u001a\u00020 J\u000e\u0010a\u001a\u00020\u00002\u0006\u0010b\u001a\u000206R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000b\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0015\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010!\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R$\u0010%\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020$@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b%\u0010(R$\u0010*\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020)@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b*\u0010-R\u001e\u0010.\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00103\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010\r\"\u0004\b3\u0010\u000eR\u000e\u00105\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00107\u001a\u0004\u0018\u0001062\b\u0010\u0013\u001a\u0004\u0018\u000106@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109\u00a8\u0006d"}, d2={"Lokhttp3/mockwebserver/MockResponse;", "", "()V", "body", "Lokio/Buffer;", "bodyDelayAmount", "", "bodyDelayUnit", "Ljava/util/concurrent/TimeUnit;", "value", "Lokhttp3/Headers;", "headers", "getHeaders", "()Lokhttp3/Headers;", "(Lokhttp3/Headers;)V", "headersBuilder", "Lokhttp3/Headers$Builder;", "headersDelayAmount", "headersDelayUnit", "<set-?>", "", "http2ErrorCode", "getHttp2ErrorCode", "()I", "(I)V", "promises", "", "Lokhttp3/mockwebserver/PushPromise;", "pushPromises", "", "getPushPromises", "()Ljava/util/List;", "Lokhttp3/internal/http2/Settings;", "settings", "getSettings", "()Lokhttp3/internal/http2/Settings;", "Lokhttp3/mockwebserver/SocketPolicy;", "socketPolicy", "getSocketPolicy", "()Lokhttp3/mockwebserver/SocketPolicy;", "(Lokhttp3/mockwebserver/SocketPolicy;)V", "", "status", "getStatus", "()Ljava/lang/String;", "(Ljava/lang/String;)V", "throttleBytesPerPeriod", "getThrottleBytesPerPeriod", "()J", "throttlePeriodAmount", "throttlePeriodUnit", "trailers", "getTrailers", "trailersBuilder", "Lokhttp3/WebSocketListener;", "webSocketListener", "getWebSocketListener", "()Lokhttp3/WebSocketListener;", "addHeader", "header", "name", "", "addHeaderLenient", "clearHeaders", "clone", "getBody", "getBodyDelay", "unit", "-deprecated_getHeaders", "getHeadersDelay", "-deprecated_getHttp2ErrorCode", "-deprecated_getSocketPolicy", "-deprecated_getStatus", "getThrottlePeriod", "-deprecated_getTrailers", "removeHeader", "setBody", "setBodyDelay", "delay", "setChunkedBody", "maxChunkSize", "setHeader", "setHeaders", "setHeadersDelay", "setHttp2ErrorCode", "setResponseCode", "code", "setSocketPolicy", "setStatus", "setTrailers", "throttleBody", "bytesPerPeriod", "period", "toString", "withPush", "promise", "withSettings", "withWebSocketUpgrade", "listener", "Companion", "mockwebserver-deprecated"})
public final class MockResponse
implements Cloneable {
    @NotNull
    private String status = "";
    private Headers.Builder headersBuilder = new Headers.Builder();
    private Headers.Builder trailersBuilder = new Headers.Builder();
    private Buffer body;
    private long throttleBytesPerPeriod = Long.MAX_VALUE;
    private long throttlePeriodAmount = 1L;
    private TimeUnit throttlePeriodUnit = TimeUnit.SECONDS;
    @NotNull
    private SocketPolicy socketPolicy = SocketPolicy.KEEP_OPEN;
    private int http2ErrorCode = -1;
    private long bodyDelayAmount;
    private TimeUnit bodyDelayUnit = TimeUnit.MILLISECONDS;
    private long headersDelayAmount;
    private TimeUnit headersDelayUnit = TimeUnit.MILLISECONDS;
    private List<PushPromise> promises;
    @NotNull
    private Settings settings;
    @Nullable
    private WebSocketListener webSocketListener;
    private static final String CHUNKED_BODY_HEADER = "Transfer-encoding: chunked";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getStatus() {
        return this.status;
    }

    @JvmName(name="status")
    public final void status(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.status = string;
    }

    @NotNull
    public final Headers getHeaders() {
        return this.headersBuilder.build();
    }

    @JvmName(name="headers")
    public final void headers(@NotNull Headers value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.headersBuilder = value.newBuilder();
    }

    @NotNull
    public final Headers getTrailers() {
        return this.trailersBuilder.build();
    }

    @JvmName(name="trailers")
    public final void trailers(@NotNull Headers value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.trailersBuilder = value.newBuilder();
    }

    public final long getThrottleBytesPerPeriod() {
        return this.throttleBytesPerPeriod;
    }

    @NotNull
    public final SocketPolicy getSocketPolicy() {
        return this.socketPolicy;
    }

    @JvmName(name="socketPolicy")
    public final void socketPolicy(@NotNull SocketPolicy socketPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)socketPolicy), (String)"<set-?>");
        this.socketPolicy = socketPolicy;
    }

    public final int getHttp2ErrorCode() {
        return this.http2ErrorCode;
    }

    @JvmName(name="http2ErrorCode")
    public final void http2ErrorCode(int n) {
        this.http2ErrorCode = n;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @Nullable
    public final WebSocketListener getWebSocketListener() {
        return this.webSocketListener;
    }

    @NotNull
    public final List<PushPromise> getPushPromises() {
        return this.promises;
    }

    @NotNull
    public MockResponse clone() {
        Object object = super.clone();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type okhttp3.mockwebserver.MockResponse");
        }
        MockResponse result = (MockResponse)object;
        result.headersBuilder = this.headersBuilder.build().newBuilder();
        result.promises = CollectionsKt.toMutableList((Collection)this.promises);
        return result;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="status"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getStatus")
    @NotNull
    public final String -deprecated_getStatus() {
        return this.status;
    }

    @NotNull
    public final MockResponse setStatus(@NotNull String status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.status = status;
        return mockResponse;
    }

    @NotNull
    public final MockResponse setResponseCode(int code) {
        int n = code;
        int n2 = n;
        String reason = 100 <= n2 && 199 >= n2 ? "Informational" : (200 <= (n2 = n) && 299 >= n2 ? "OK" : (300 <= (n2 = n) && 399 >= n2 ? "Redirection" : (400 <= (n2 = n) && 499 >= n2 ? "Client Error" : (500 <= (n2 = n) && 599 >= n2 ? "Server Error" : "Mock Response"))));
        MockResponse mockResponse = this;
        n2 = 0;
        boolean bl = false;
        MockResponse $this$apply = mockResponse;
        boolean bl2 = false;
        $this$apply.status = "HTTP/1.1 " + code + ' ' + reason;
        return mockResponse;
    }

    @NotNull
    public final MockResponse clearHeaders() {
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.headersBuilder = new Headers.Builder();
        return mockResponse;
    }

    @NotNull
    public final MockResponse addHeader(@NotNull String header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.headersBuilder.add(header);
        return mockResponse;
    }

    @NotNull
    public final MockResponse addHeader(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.headersBuilder.add(name, value.toString());
        return mockResponse;
    }

    @NotNull
    public final MockResponse addHeaderLenient(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        Internal.addHeaderLenient((Headers.Builder)$this$apply.headersBuilder, (String)name, (String)value.toString());
        return mockResponse;
    }

    @NotNull
    public final MockResponse setHeader(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.removeHeader(name);
        $this$apply.addHeader(name, value);
        return mockResponse;
    }

    @NotNull
    public final MockResponse removeHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.headersBuilder.removeAll(name);
        return mockResponse;
    }

    @Nullable
    public final Buffer getBody() {
        Buffer buffer = this.body;
        return buffer != null ? buffer.clone() : null;
    }

    @NotNull
    public final MockResponse setBody(@NotNull Buffer body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.setHeader("Content-Length", body.size());
        $this$apply.body = body.clone();
        return mockResponse;
    }

    @NotNull
    public final MockResponse setBody(@NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.setBody(new Buffer().writeUtf8(body));
    }

    @NotNull
    public final MockResponse setChunkedBody(@NotNull Buffer body, int maxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.removeHeader("Content-Length");
        $this$apply.headersBuilder.add(CHUNKED_BODY_HEADER);
        Buffer bytesOut = new Buffer();
        while (!body.exhausted()) {
            long l = body.size();
            long l2 = maxChunkSize;
            boolean bl4 = false;
            long chunkSize = Math.min(l, l2);
            bytesOut.writeHexadecimalUnsignedLong(chunkSize);
            bytesOut.writeUtf8("\r\n");
            bytesOut.write(body, chunkSize);
            bytesOut.writeUtf8("\r\n");
        }
        bytesOut.writeUtf8("0\r\n");
        $this$apply.body = bytesOut;
        return mockResponse;
    }

    @NotNull
    public final MockResponse setChunkedBody(@NotNull String body, int maxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.setChunkedBody(new Buffer().writeUtf8(body), maxChunkSize);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="headers"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getHeaders")
    @NotNull
    public final Headers -deprecated_getHeaders() {
        return this.getHeaders();
    }

    @NotNull
    public final MockResponse setHeaders(@NotNull Headers headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.headers(headers);
        return mockResponse;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="trailers"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getTrailers")
    @NotNull
    public final Headers -deprecated_getTrailers() {
        return this.getTrailers();
    }

    @NotNull
    public final MockResponse setTrailers(@NotNull Headers trailers) {
        Intrinsics.checkNotNullParameter((Object)trailers, (String)"trailers");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.trailers(trailers);
        return mockResponse;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="socketPolicy"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getSocketPolicy")
    @NotNull
    public final SocketPolicy -deprecated_getSocketPolicy() {
        return this.socketPolicy;
    }

    @NotNull
    public final MockResponse setSocketPolicy(@NotNull SocketPolicy socketPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)socketPolicy), (String)"socketPolicy");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.socketPolicy = socketPolicy;
        return mockResponse;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(imports={}, expression="http2ErrorCode"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_getHttp2ErrorCode")
    public final int -deprecated_getHttp2ErrorCode() {
        return this.http2ErrorCode;
    }

    @NotNull
    public final MockResponse setHttp2ErrorCode(int http2ErrorCode) {
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.http2ErrorCode = http2ErrorCode;
        return mockResponse;
    }

    @NotNull
    public final MockResponse throttleBody(long bytesPerPeriod, long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.throttleBytesPerPeriod = bytesPerPeriod;
        $this$apply.throttlePeriodAmount = period;
        $this$apply.throttlePeriodUnit = unit;
        return mockResponse;
    }

    public final long getThrottlePeriod(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return unit.convert(this.throttlePeriodAmount, this.throttlePeriodUnit);
    }

    @NotNull
    public final MockResponse setBodyDelay(long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.bodyDelayAmount = delay;
        $this$apply.bodyDelayUnit = unit;
        return mockResponse;
    }

    public final long getBodyDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return unit.convert(this.bodyDelayAmount, this.bodyDelayUnit);
    }

    @NotNull
    public final MockResponse setHeadersDelay(long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.headersDelayAmount = delay;
        $this$apply.headersDelayUnit = unit;
        return mockResponse;
    }

    public final long getHeadersDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return unit.convert(this.headersDelayAmount, this.headersDelayUnit);
    }

    @NotNull
    public final MockResponse withPush(@NotNull PushPromise promise) {
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.promises.add(promise);
        return mockResponse;
    }

    @NotNull
    public final MockResponse withSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.settings = settings;
        return mockResponse;
    }

    @NotNull
    public final MockResponse withWebSocketUpgrade(@NotNull WebSocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        MockResponse mockResponse = this;
        boolean bl = false;
        boolean bl2 = false;
        MockResponse $this$apply = mockResponse;
        boolean bl3 = false;
        $this$apply.status = "HTTP/1.1 101 Switching Protocols";
        $this$apply.setHeader("Connection", "Upgrade");
        $this$apply.setHeader("Upgrade", "websocket");
        $this$apply.body = null;
        $this$apply.webSocketListener = listener;
        return mockResponse;
    }

    @NotNull
    public String toString() {
        return this.status;
    }

    public MockResponse() {
        boolean bl = false;
        this.promises = new ArrayList();
        this.settings = new Settings();
        this.setResponseCode(200);
        this.setHeader("Content-Length", 0L);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/mockwebserver/MockResponse$Companion;", "", "()V", "CHUNKED_BODY_HEADER", "", "mockwebserver-deprecated"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

