//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Call](index.md)/[execute](execute.md)

# execute

[jvm]\
abstract fun [execute](execute.md)(): [Response](../-response/index.md)

Invokes the request immediately, and blocks until the response can be processed or is in error.

To avoid leaking resources callers should close the [Response](../-response/index.md) which in turn will close the underlying [ResponseBody](../-response-body/index.md).

// ensure the response (and underlying response body) is closed\
try (Response response = client.newCall(request).execute()) {\
  ...\
}

The caller may read the response body with the response's [Response.body](../-response/body.md) method. To avoid leaking resources callers must [close the response body](../-response-body/index.md) or the response.

Note that transport-layer success (receiving a HTTP response code, headers and body) does not necessarily indicate application-layer success: response may still indicate an unhappy HTTP response code like 404 or 500.

## Throws

| | |
|---|---|
| [java.io.IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html) | if the request could not be executed due to cancellation, a connectivity     problem or timeout. Because networks can fail during an exchange, it is possible that the     remote server accepted the request before the failure. |
| [kotlin.IllegalStateException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-state-exception/index.html) | when the call has already been executed. |
