//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Callback](index.md)

# Callback

[jvm]\
interface [Callback](index.md)

## Functions

| Name | Summary |
|---|---|
| [onFailure](on-failure.md) | [jvm]<br>abstract fun [onFailure](on-failure.md)(call: [Call](../-call/index.md), e: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html))<br>Called when the request could not be executed due to cancellation, a connectivity problem or timeout. Because networks can fail during an exchange, it is possible that the remote server accepted the request before the failure. |
| [onResponse](on-response.md) | [jvm]<br>abstract fun [onResponse](on-response.md)(call: [Call](../-call/index.md), response: [Response](../-response/index.md))<br>Called when the HTTP response was successfully returned by the remote server. The callback may proceed to read the response body with [Response.body](../-response/body.md). The response is still live until its response body is [closed](../-response-body/index.md). The recipient of the callback may consume the response body on another thread. |
