//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[OkHttpClient](../index.md)/[Builder](index.md)/[sslSocketFactory](ssl-socket-factory.md)

# sslSocketFactory

[jvm]\
fun [sslSocketFactory](ssl-socket-factory.md)(sslSocketFactory: [SSLSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocketFactory.html), trustManager: [X509TrustManager](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/X509TrustManager.html)): [OkHttpClient.Builder](index.md)

Sets the socket factory and trust manager used to secure HTTPS connections. If unset, the system defaults will be used.

Most applications should not call this method, and instead use the system defaults. Those classes include special optimizations that can be lost if the implementations are decorated.

If necessary, you can create and configure the defaults yourself with the following code:

TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(\
TrustManagerFactory.getDefaultAlgorithm());\
trustManagerFactory.init((KeyStore) null);\
TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();\
if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {\
    throw new IllegalStateException("Unexpected default trust managers:"\
        + Arrays.toString(trustManagers));\
}\
X509TrustManager trustManager = (X509TrustManager) trustManagers[0];\
\
SSLContext sslContext = SSLContext.getInstance("TLS");\
sslContext.init(null, new TrustManager[] { trustManager }, null);\
SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();\
\
OkHttpClient client = new OkHttpClient.Builder()\
    .sslSocketFactory(sslSocketFactory, trustManager)\
    .build();

##  TrustManagers on Android are Weird!

Trust managers targeting Android must also define a method that has this signature:

    @SuppressWarnings("unused")\
    public List&lt;X509Certificate&gt; checkServerTrusted(\
        X509Certificate[] chain, String authType, String host) throws CertificateException {\
    }

This method works like [X509TrustManager.checkServerTrusted](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/X509TrustManager.html#checkServerTrusted-kotlin.Array[java.security.cert.X509Certificate]-kotlin.String-) but it receives the hostname of the server as an extra parameter. Regardless of what checks this method performs, OkHttp will always check that the server's certificates match its hostname using the [HostnameVerifier](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/HostnameVerifier.html). See android.net.http.X509TrustManagerExtensions for more information.
