//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Request](index.md)

# Request

[common]\
expect class [Request](index.md)

An HTTP request. Instances of this class are immutable if their [body](body.md) is null or itself immutable.

[jvm, nonJvm]\
actual class [Request](index.md)

## Constructors

| | |
|---|---|
| [Request](-request.md) | [jvm]<br>fun [Request](-request.md)(url: [HttpUrl](../-http-url/index.md), headers: [Headers](../-headers/index.md) = Headers.headersOf(), method: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;&quot;, body: [RequestBody](../-request-body/index.md)? = null)<br>Constructs a new request. |
| [Request](-request.md) | [nonJvm]<br>fun [Request](-request.md)(url: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), headers: [Headers](../-headers/index.md) = Headers.headersOf(), method: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;&quot;, body: [RequestBody](../-request-body/index.md)? = null)<br>Constructs a new request. |

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect open class [Builder](-builder/index.md)<br>[jvm, nonJvm]<br>actual open class [Builder](-builder/index.md) |

## Functions

| Name | Summary |
|---|---|
| [header](header.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>[jvm, nonJvm]<br>actual fun [header](header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [headers](headers.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [headers](headers.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;<br>[jvm, nonJvm]<br>actual fun [headers](headers.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
| [newBuilder](new-builder.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [newBuilder](new-builder.md)(): [Request.Builder](-builder/index.md)<br>[jvm, nonJvm]<br>actual fun [newBuilder](new-builder.md)(): [Request.Builder](-builder/index.md) |
| [tag](tag.md) | [common]<br>expect inline fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(): [T](tag.md)?<br>Returns the tag attached with [T](tag.md) as a key, or null if no tag is attached with that key.<br>[jvm, nonJvm]<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;reifiedTag&quot;)<br>actual inline fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(): [T](tag.md)?<br>[nonJvm]<br>actual inline fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(): [T](tag.md)?<br>[jvm, nonJvm]<br>actual fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](tag.md)&gt;): [T](tag.md)?<br>[jvm, common]<br>[jvm]<br>fun &lt;[T](tag.md)&gt; [tag](tag.md)(type: [Class](https://docs.oracle.com/javase/8/docs/api/java/lang/Class.html)&lt;out [T](tag.md)&gt;): [T](tag.md)?<br>[common]<br>expect fun &lt;[T](tag.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [tag](tag.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;[T](tag.md)&gt;): [T](tag.md)?<br>Returns the tag attached with [type](tag.md) as a key, or null if no tag is attached with that key. |
| toString | [jvm, nonJvm]<br>[jvm]<br>open override fun [toString]([jvm]to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>open override fun [toString]([non-jvm]to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [body](body.md) | [common]<br>expect val [body](body.md): [RequestBody](../-request-body/index.md)?<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;body&quot;)<br>actual val [body](body.md): [RequestBody](../-request-body/index.md)?<br>[nonJvm]<br>actual val [body](body.md): [RequestBody](../-request-body/index.md)? |
| [cacheControl](cache-control.md) | [common]<br>expect val [cacheControl](cache-control.md): [CacheControl](../-cache-control/index.md)<br>Returns the cache control directives for this response. This is never null, even if this response contains no Cache-Control header.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;cacheControl&quot;)<br>actual val [cacheControl](cache-control.md): [CacheControl](../-cache-control/index.md)<br>[nonJvm]<br>actual val [cacheControl](cache-control.md): [CacheControl](../-cache-control/index.md) |
| [headers](headers.md) | [common]<br>expect val [headers](headers.md): [Headers](../-headers/index.md)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;headers&quot;)<br>actual val [headers](headers.md): [Headers](../-headers/index.md)<br>[nonJvm]<br>actual val [headers](headers.md): [Headers](../-headers/index.md) |
| [isHttps](is-https.md) | [common]<br>expect val [isHttps](is-https.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm, nonJvm]<br>actual val [isHttps](is-https.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [method](method.md) | [common]<br>expect val [method](method.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;method&quot;)<br>actual val [method](method.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>actual val [method](method.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [url](url.md) | [common]<br>expect val [url](url.md): HttpUrlRepresentation<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;url&quot;)<br>actual val [url](url.md): HttpUrlRepresentation<br>[nonJvm]<br>actual val [url](url.md): HttpUrlRepresentation |
