//[okhttp](../../../index.md)/[okhttp3](../index.md)/[MultipartReader](index.md)

# MultipartReader

[jvm]\
class [MultipartReader](index.md)constructor(source: [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html), val boundary: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)

Reads a stream of [RFC 2046](http://www.ietf.org/rfc/rfc2046.txt) multipart body parts. Callers read parts one-at-a-time until [nextPart](next-part.md) returns null. After calling [nextPart](next-part.md) any preceding parts should not be read.

Typical use loops over the parts in sequence:

val response: Response = call.execute()\
val multipartReader = MultipartReader(response.body!!)\
\
multipartReader.use {\
  while (true) {\
    val part = multipartReader.nextPart() ?: break\
    process(part.headers, part.body)\
  }\
}

Note that [nextPart](next-part.md) will skip any unprocessed data from the preceding part. If the preceding part is particularly large or if the underlying source is particularly slow, the [nextPart](next-part.md) call may be slow!

Closing a part **does not** close this multipart reader; callers must explicitly close this with [close](close.md).

## Constructors

| | |
|---|---|
| [MultipartReader](-multipart-reader.md) | [jvm]<br>fun [MultipartReader](-multipart-reader.md)(response: [ResponseBody](../-response-body/index.md)) |
| [MultipartReader](-multipart-reader.md) | [jvm]<br>fun [MultipartReader](-multipart-reader.md)(source: [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html), boundary: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) |

## Types

| Name | Summary |
|---|---|
| [Part](-part/index.md) | [jvm]<br>class [Part](-part/index.md)(val headers: [Headers](../-headers/index.md), val body: [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html)) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)<br>A single part in a multipart body. |

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [jvm]<br>open override fun [close](close.md)() |
| [nextPart](next-part.md) | [jvm]<br>fun [nextPart](next-part.md)(): [MultipartReader.Part](-part/index.md)? |

## Properties

| Name | Summary |
|---|---|
| [boundary](boundary.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;boundary&quot;)<br>val [boundary](boundary.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
