//[logging-interceptor](../../../index.md)/[okhttp3.logging](../index.md)/[HttpLoggingInterceptor](index.md)

# HttpLoggingInterceptor

[jvm]\
class [HttpLoggingInterceptor](index.md)@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)constructor(logger: [HttpLoggingInterceptor.Logger](-logger/index.md) = Logger.DEFAULT) : Interceptor

An OkHttp interceptor which logs request and response information. Can be applied as an application interceptor or as a OkHttpClient.networkInterceptors.

The format of the logs created by this class should not be considered stable and may change slightly between releases. If you need a stable logging format, use your own interceptor.

## Constructors

| | |
|---|---|
| [HttpLoggingInterceptor](-http-logging-interceptor.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [HttpLoggingInterceptor](-http-logging-interceptor.md)(logger: [HttpLoggingInterceptor.Logger](-logger/index.md) = Logger.DEFAULT) |

## Types

| Name | Summary |
|---|---|
| [Level](-level/index.md) | [jvm]<br>enum [Level](-level/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[HttpLoggingInterceptor.Level](-level/index.md)&gt; |
| [Logger](-logger/index.md) | [jvm]<br>fun interface [Logger](-logger/index.md) |

## Functions

| Name | Summary |
|---|---|
| [intercept](intercept.md) | [jvm]<br>open override fun [intercept](intercept.md)(chain: Interceptor.Chain): Response |
| [redactHeader](redact-header.md) | [jvm]<br>fun [redactHeader](redact-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) |
| [setLevel](set-level.md) | [jvm]<br>fun [setLevel](set-level.md)(level: [HttpLoggingInterceptor.Level](-level/index.md)): [HttpLoggingInterceptor](index.md)<br>Sets the level and returns this. |

## Properties

| Name | Summary |
|---|---|
| [level](level.md) | [jvm]<br>@[Volatile](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-volatile/index.html)<br>@set:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;level&quot;)<br>var [level](level.md): [HttpLoggingInterceptor.Level](-level/index.md) |
