//[mockwebserver3-junit5](../../../index.md)/[mockwebserver3.junit5.internal](../index.md)/[MockWebServerExtension](index.md)

# MockWebServerExtension

[jvm]\
class [MockWebServerExtension](index.md) : BeforeEachCallback, AfterEachCallback, ParameterResolver

Runs MockWebServer for the duration of a single test method.

Specifically while junit instances passes into test constructor are typically shares amongst all tests, a fresh instance will be received here. Use with @BeforeAll and @AfterAll, is not supported.

There are 3 ids for instances

- 
   The test instance default (passed into constructor)
- 
   The test lifecycle default (passed into test method, plus @BeforeEach, @AfterEach)
- 
   named instances with @MockWebServerInstance.

## Constructors

| | |
|---|---|
| [MockWebServerExtension](-mock-web-server-extension.md) | [jvm]<br>fun [MockWebServerExtension](-mock-web-server-extension.md)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [afterEach](after-each.md) | [jvm]<br>open override fun [afterEach](after-each.md)(context: ExtensionContext) |
| [beforeEach](before-each.md) | [jvm]<br>open override fun [beforeEach](before-each.md)(context: ExtensionContext)<br>Start the servers passed in as test method parameters. |
| [resolveParameter](resolve-parameter.md) | [jvm]<br>open override fun [resolveParameter](resolve-parameter.md)(parameterContext: ParameterContext, extensionContext: ExtensionContext): [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html) |
| [supportsParameter](supports-parameter.md) | [jvm]<br>@IgnoreJRERequirement<br>open override fun [supportsParameter](supports-parameter.md)(parameterContext: ParameterContext, extensionContext: ExtensionContext): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
