//[mockwebserver3](../../../index.md)/[mockwebserver3](../index.md)/[SocketPolicy](index.md)

# SocketPolicy

[jvm]\
enum [SocketPolicy](index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[SocketPolicy](index.md)&gt; 

What should be done with the incoming socket.

Be careful when using values like [DISCONNECT_AT_END](-d-i-s-c-o-n-n-e-c-t_-a-t_-e-n-d/index.md), [SHUTDOWN_INPUT_AT_END](-s-h-u-t-d-o-w-n_-i-n-p-u-t_-a-t_-e-n-d/index.md) and [SHUTDOWN_OUTPUT_AT_END](-s-h-u-t-d-o-w-n_-o-u-t-p-u-t_-a-t_-e-n-d/index.md) that close a socket after a response, and where there are follow-up requests. The client is unblocked and free to continue as soon as it has received the entire response body. If and when the client makes a subsequent request using a pooled socket the server may not have had time to close the socket. The socket will be closed at an indeterminate point before or during the second request. It may be closed after client has started sending the request body. If a request body is not retryable then the client may fail the request, making client behavior non-deterministic. Add delays in the client to improve the chances that the server has closed the socket before follow up requests are made.

## Entries

| | |
|---|---|
| [SHUTDOWN_SERVER_AFTER_RESPONSE](-s-h-u-t-d-o-w-n_-s-e-r-v-e-r_-a-f-t-e-r_-r-e-s-p-o-n-s-e/index.md) | [jvm]<br>[SHUTDOWN_SERVER_AFTER_RESPONSE](-s-h-u-t-d-o-w-n_-s-e-r-v-e-r_-a-f-t-e-r_-r-e-s-p-o-n-s-e/index.md)<br>Shutdown [MockWebServer](../-mock-web-server/index.md) after writing response. |
| [KEEP_OPEN](-k-e-e-p_-o-p-e-n/index.md) | [jvm]<br>[KEEP_OPEN](-k-e-e-p_-o-p-e-n/index.md)<br>Keep the socket open after the response. This is the default HTTP/1.1 behavior. |
| [DISCONNECT_AT_END](-d-i-s-c-o-n-n-e-c-t_-a-t_-e-n-d/index.md) | [jvm]<br>[DISCONNECT_AT_END](-d-i-s-c-o-n-n-e-c-t_-a-t_-e-n-d/index.md)<br>Close the socket after the response. This is the default HTTP/1.0 behavior. For HTTP/2 connections, this sends a [GOAWAYframe](https://tools.ietf.org/html/rfc7540#section-6.8) immediately after the response and will close the connection when the client's socket is exhausted. |
| [DISCONNECT_AT_START](-d-i-s-c-o-n-n-e-c-t_-a-t_-s-t-a-r-t/index.md) | [jvm]<br>[DISCONNECT_AT_START](-d-i-s-c-o-n-n-e-c-t_-a-t_-s-t-a-r-t/index.md)<br>Request immediate close of connection without even reading the request. Use to simulate buggy SSL servers closing connections in response to unrecognized TLS extensions. |
| [DISCONNECT_AFTER_REQUEST](-d-i-s-c-o-n-n-e-c-t_-a-f-t-e-r_-r-e-q-u-e-s-t/index.md) | [jvm]<br>[DISCONNECT_AFTER_REQUEST](-d-i-s-c-o-n-n-e-c-t_-a-f-t-e-r_-r-e-q-u-e-s-t/index.md)<br>Close connection after reading the request but before writing the response. Use this to simulate late connection pool failures. |
| [HALF_CLOSE_AFTER_REQUEST](-h-a-l-f_-c-l-o-s-e_-a-f-t-e-r_-r-e-q-u-e-s-t/index.md) | [jvm]<br>[HALF_CLOSE_AFTER_REQUEST](-h-a-l-f_-c-l-o-s-e_-a-f-t-e-r_-r-e-q-u-e-s-t/index.md)<br>Half close connection (InputStream for client) after reading the request but before writing the response. Use this to simulate late connection pool failures. |
| [DISCONNECT_DURING_REQUEST_BODY](-d-i-s-c-o-n-n-e-c-t_-d-u-r-i-n-g_-r-e-q-u-e-s-t_-b-o-d-y/index.md) | [jvm]<br>[DISCONNECT_DURING_REQUEST_BODY](-d-i-s-c-o-n-n-e-c-t_-d-u-r-i-n-g_-r-e-q-u-e-s-t_-b-o-d-y/index.md)<br>Close connection after reading half of the request body (if present). |
| [DISCONNECT_DURING_RESPONSE_BODY](-d-i-s-c-o-n-n-e-c-t_-d-u-r-i-n-g_-r-e-s-p-o-n-s-e_-b-o-d-y/index.md) | [jvm]<br>[DISCONNECT_DURING_RESPONSE_BODY](-d-i-s-c-o-n-n-e-c-t_-d-u-r-i-n-g_-r-e-s-p-o-n-s-e_-b-o-d-y/index.md)<br>Close connection after writing half of the response body (if present). |
| [DO_NOT_READ_REQUEST_BODY](-d-o_-n-o-t_-r-e-a-d_-r-e-q-u-e-s-t_-b-o-d-y/index.md) | [jvm]<br>[DO_NOT_READ_REQUEST_BODY](-d-o_-n-o-t_-r-e-a-d_-r-e-q-u-e-s-t_-b-o-d-y/index.md)<br>Process the response without even attempting to reading the request body. For HTTP/2 this will send MockResponse.getHttp2ErrorCode after the response body or trailers. For HTTP/1 this will close the socket after the response body or trailers. |
| [FAIL_HANDSHAKE](-f-a-i-l_-h-a-n-d-s-h-a-k-e/index.md) | [jvm]<br>[FAIL_HANDSHAKE](-f-a-i-l_-h-a-n-d-s-h-a-k-e/index.md)<br>Don't trust the client during the SSL handshake. |
| [SHUTDOWN_INPUT_AT_END](-s-h-u-t-d-o-w-n_-i-n-p-u-t_-a-t_-e-n-d/index.md) | [jvm]<br>[SHUTDOWN_INPUT_AT_END](-s-h-u-t-d-o-w-n_-i-n-p-u-t_-a-t_-e-n-d/index.md)<br>Shutdown the socket input after sending the response. For testing bad behavior. |
| [SHUTDOWN_OUTPUT_AT_END](-s-h-u-t-d-o-w-n_-o-u-t-p-u-t_-a-t_-e-n-d/index.md) | [jvm]<br>[SHUTDOWN_OUTPUT_AT_END](-s-h-u-t-d-o-w-n_-o-u-t-p-u-t_-a-t_-e-n-d/index.md)<br>Shutdown the socket output after sending the response. For testing bad behavior. |
| [STALL_SOCKET_AT_START](-s-t-a-l-l_-s-o-c-k-e-t_-a-t_-s-t-a-r-t/index.md) | [jvm]<br>[STALL_SOCKET_AT_START](-s-t-a-l-l_-s-o-c-k-e-t_-a-t_-s-t-a-r-t/index.md)<br>After accepting the connection and doing TLS (if configured) don't do HTTP/1.1 or HTTP/2 framing. Ignore the socket completely until the server is shut down. |
| [NO_RESPONSE](-n-o_-r-e-s-p-o-n-s-e/index.md) | [jvm]<br>[NO_RESPONSE](-n-o_-r-e-s-p-o-n-s-e/index.md)<br>Read the request but don't respond to it. Just keep the socket open. For testing read response header timeout issue. |
| [RESET_STREAM_AT_START](-r-e-s-e-t_-s-t-r-e-a-m_-a-t_-s-t-a-r-t/index.md) | [jvm]<br>[RESET_STREAM_AT_START](-r-e-s-e-t_-s-t-r-e-a-m_-a-t_-s-t-a-r-t/index.md)<br>Fail HTTP/2 requests without processing them by sending an MockResponse.getHttp2ErrorCode. |

## Functions

| Name | Summary |
|---|---|
| [valueOf](value-of.md) | [jvm]<br>fun [valueOf](value-of.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [SocketPolicy](index.md)<br>Returns the enum constant of this type with the specified name. The string must match exactly an identifier used to declare an enum constant in this type. (Extraneous whitespace characters are not permitted.) |
| [values](values.md) | [jvm]<br>fun [values](values.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[SocketPolicy](index.md)&gt;<br>Returns an array containing the constants of this enum type, in the order they're declared. |

## Properties

| Name | Summary |
|---|---|
| [name](-r-e-s-e-t_-s-t-r-e-a-m_-a-t_-s-t-a-r-t/index.md#-372974862%2FProperties%2F-199986278) | [jvm]<br>val [name](-r-e-s-e-t_-s-t-r-e-a-m_-a-t_-s-t-a-r-t/index.md#-372974862%2FProperties%2F-199986278): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [ordinal](-r-e-s-e-t_-s-t-r-e-a-m_-a-t_-s-t-a-r-t/index.md#-739389684%2FProperties%2F-199986278) | [jvm]<br>val [ordinal](-r-e-s-e-t_-s-t-r-e-a-m_-a-t_-s-t-a-r-t/index.md#-739389684%2FProperties%2F-199986278): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
