//[okhttp](../../../index.md)/[okhttp3](../index.md)/[WebSocket](index.md)/[send](send.md)

# send

[jvm]\
abstract fun [send](send.md)(text: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Attempts to enqueue `text` to be UTF-8 encoded and sent as a the data of a text (type `0x1`) message.

This method returns true if the message was enqueued. Messages that would overflow the outgoing message buffer will be rejected and trigger a [graceful shutdown](close.md) of this web socket. This method returns false in that case, and in any other case where this web socket is closing, closed, or canceled.

This method returns immediately.

[jvm]\
abstract fun [send](send.md)(bytes: [ByteString](https://square.github.io/okio/2.x/okio/okio/-byte-string/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Attempts to enqueue `bytes` to be sent as a the data of a binary (type `0x2`) message.

This method returns true if the message was enqueued. Messages that would overflow the outgoing message buffer (16 MiB) will be rejected and trigger a [graceful shutdown](close.md) of this web socket. This method returns false in that case, and in any other case where this web socket is closing, closed, or canceled.

This method returns immediately.
