//[mockwebserver3](../../../index.md)/[mockwebserver3](../index.md)/[Dispatcher](index.md)

# Dispatcher

[jvm]\
abstract class [Dispatcher](index.md)

Handler for mock server requests.

## Constructors

| | |
|---|---|
| [Dispatcher](-dispatcher.md) | [jvm]<br>fun [Dispatcher](-dispatcher.md)() |

## Functions

| Name | Summary |
|---|---|
| [dispatch](dispatch.md) | [jvm]<br>abstract fun [dispatch](dispatch.md)(request: [RecordedRequest](../-recorded-request/index.md)): [MockResponse](../-mock-response/index.md)<br>Returns a response to satisfy request. This method may block (for instance, to wait on a CountdownLatch). |
| [peek](peek.md) | [jvm]<br>open fun [peek](peek.md)(): [MockResponse](../-mock-response/index.md)<br>Returns an early guess of the next response, used for policy on how an incoming request should be received. The default implementation returns an empty response. Mischievous implementations can return other values to test HTTP edge cases, such as unhappy socket policies or throttled request bodies. |
| [shutdown](shutdown.md) | [jvm]<br>open fun [shutdown](shutdown.md)()<br>Release any resources held by this dispatcher. Any requests that are currently being dispatched should return immediately. Responses returned after shutdown will not be transmitted: their socket connections have already been closed. |

## Inheritors

| Name |
|---|
| [QueueDispatcher](../-queue-dispatcher/index.md) |
