//[okhttp](../../../index.md)/[okhttp3](../index.md)/[CipherSuite](index.md)

# CipherSuite

[jvm]\
class [CipherSuite](index.md)

[TLS cipher suites](https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml).

**Not all cipher suites are supported on all platforms.** As newer cipher suites are created (for stronger privacy, better performance, etc.) they will be adopted by the platform and then exposed here. Cipher suites that are not available on either Android (through API level 24) or Java (through JDK 9) are omitted for brevity.

See [Android SSLEngine](https://developer.android.com/reference/javax/net/ssl/SSLEngine.html) which lists the cipher suites supported by Android.

See [JDK Providers](https://docs.oracle.com/javase/10/security/oracle-providers.htm) which lists the cipher suites supported by Oracle.

See [NativeCrypto.java](https://github.com/google/conscrypt/blob/master/common/src/main/java/org/conscrypt/NativeCrypto.java) which lists the cipher suites supported by Conscrypt.

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [javaName](java-name.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;javaName&quot;)<br>val [javaName](java-name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the Java name of this cipher suite. For some older cipher suites the Java name has the prefix SSL_, causing the Java name to be different from the instance name which is always prefixed TLS_. For example, TLS_RSA_EXPORT_WITH_RC4_40_MD5.javaName() is &quot;SSL_RSA_EXPORT_WITH_RC4_40_MD5&quot;. |
