//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Cookie](index.md)

# Cookie

[jvm]\
class [Cookie](index.md)

An [RFC 6265](http://tools.ietf.org/html/rfc6265) Cookie.

This class doesn't support additional attributes on cookies, like [Chromium's Priority=HIGH extension](https://code.google.com/p/chromium/issues/detail?id=232693).

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [jvm]<br>class [Builder](-builder/index.md)<br>Builds a cookie. The [name](-builder/name.md), [value](-builder/value.md), and [domain](-builder/domain.md) values must all be set before calling [build](-builder/build.md). |
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | [jvm]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [jvm]<br>@IgnoreJRERequirement<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [matches](matches.md) | [jvm]<br>fun [matches](matches.md)(url: [HttpUrl](../-http-url/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this cookie should be included on a request to [url](matches.md). In addition to this check callers should also confirm that this cookie has not expired. |
| [newBuilder](new-builder.md) | [jvm]<br>fun [newBuilder](new-builder.md)(): [Cookie.Builder](-builder/index.md) |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [domain](domain.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;domain&quot;)<br>val [domain](domain.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the cookie's domain. If [hostOnly](host-only.md) returns true this is the only domain that matches this cookie; otherwise it matches this domain and all subdomains. |
| [expiresAt](expires-at.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;expiresAt&quot;)<br>val [expiresAt](expires-at.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the time that this cookie expires, in the same format as [System.currentTimeMillis](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#currentTimeMillis--). This is December 31, 9999 if the cookie is [persistent](persistent.md), in which case it will expire at the end of the current session. |
| [hostOnly](host-only.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;hostOnly&quot;)<br>val [hostOnly](host-only.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this cookie's domain should be interpreted as a single host name, or false if it should be interpreted as a pattern. This flag will be false if its Set-Cookie header included a domain attribute. |
| [httpOnly](http-only.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;httpOnly&quot;)<br>val [httpOnly](http-only.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this cookie should be limited to only HTTP APIs. In web browsers this prevents the cookie from being accessible to scripts. |
| [name](name.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;name&quot;)<br>val [name](name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a non-empty string with this cookie's name. |
| [path](path.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;path&quot;)<br>val [path](path.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns this cookie's path. This cookie matches URLs prefixed with path segments that match this path's segments. For example, if this path is /foo this cookie matches requests to /foo and /foo/bar, but not / or /football. |
| [persistent](persistent.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;persistent&quot;)<br>val [persistent](persistent.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this cookie does not expire at the end of the current session. |
| [secure](secure.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;secure&quot;)<br>val [secure](secure.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this cookie should be limited to only HTTPS requests. |
| [value](value.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;value&quot;)<br>val [value](value.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a possibly-empty string with this cookie's value. |
