//[okhttp](../../../index.md)/[okhttp3](../index.md)/[Headers](index.md)

# Headers

[common]\
expect class [Headers](index.md) : [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt; 

The header fields of a single HTTP message. Values are uninterpreted strings; use Request and Response for interpreted headers. This class maintains the order of the header fields within the HTTP message.

This class tracks header values line-by-line. A field with multiple comma- separated values on the same line will be treated as a field with a single value by this class. It is the caller's responsibility to detect and split on commas if their field permits multiple values. This simplifies use of single-valued fields whose values routinely contain commas, such as cookies or dates.

This class trims whitespace from values. It never returns values with leading or trailing whitespace.

Instances of this class are immutable. Use [Builder](-builder/index.md) to create instances.

[jvm]\
actual class [Headers](index.md) : [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt;

[nonJvm]\
actual class [Headers](index.md) : [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;&lt;ERROR CLASS&gt;&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt;

## Types

| Name | Summary |
|---|---|
| [Builder](-builder/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect class [Builder](-builder/index.md)<br>[jvm, nonJvm]<br>actual class [Builder](-builder/index.md) |
| [Companion](-companion/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect object [Companion](-companion/index.md)<br>[jvm, nonJvm]<br>actual object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| byteCount | [jvm, nonJvm]<br>[jvm]<br>fun [byteCount]([jvm]byte-count.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>fun [byteCount]([non-jvm]byte-count.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of bytes required to encode these headers using HTTP/1.1. This is also the approximate size of HTTP/2 headers before they are compressed with HPACK. This value is intended to be used as a metric: smaller headers are more efficient to encode and transmit. |
| [equals](equals.md) | [common]<br>expect open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if other is a Headers object with the same headers, with the same casing, in the same order. Note that two headers instances may be *semantically* equal but not equal according to this method. In particular, none of the following sets of headers are equal according to this method:<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [forEach](index.md#-542681236%2FFunctions%2F-2124394033) | [jvm]<br>open fun [forEach](index.md#-542681236%2FFunctions%2F-2124394033)(p0: [Consumer](https://docs.oracle.com/javase/8/docs/api/java/util/function/Consumer.html)&lt;in [Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt;) |
| [get](get.md) | [common]<br>expect operator fun [get](get.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Returns the last value corresponding to the specified field, or null.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual operator fun [get](get.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [getDate](get-date.md) | [jvm]<br>fun [getDate](get-date.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Date](https://docs.oracle.com/javase/8/docs/api/java/util/Date.html)?<br>Returns the last value corresponding to the specified field parsed as an HTTP date, or null if either the field is absent or cannot be parsed as a date. |
| [getInstant](get-instant.md) | [jvm]<br>@IgnoreJRERequirement<br>fun [getInstant](get-instant.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Instant](https://docs.oracle.com/javase/8/docs/api/java/time/Instant.html)?<br>Returns the last value corresponding to the specified field parsed as an HTTP date, or null if either the field is absent or cannot be parsed as a date. |
| hashCode | [jvm, nonJvm]<br>[jvm]<br>open override fun [hashCode]([jvm]hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [hashCode]([non-jvm]hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [iterator](iterator.md) | [common, jvm, nonJvm]<br>[common]<br>expect open operator override fun [iterator](iterator.md)(): [Iterator](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterator/index.html)&lt;[Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt;<br>[jvm, nonJvm]<br>actual open operator override fun [iterator](iterator.md)(): [Iterator](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterator/index.html)&lt;[Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt; |
| [name](name.md) | [common]<br>expect fun [name](name.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the field at position.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [name](name.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [names](names.md) | [common]<br>expect fun [names](names.md)(): [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;<br>Returns an immutable case-insensitive set of header names.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [names](names.md)(): [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |
| [newBuilder](new-builder.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [newBuilder](new-builder.md)(): [Headers.Builder](-builder/index.md)<br>[jvm, nonJvm]<br>actual fun [newBuilder](new-builder.md)(): [Headers.Builder](-builder/index.md) |
| [spliterator](index.md#-1387152138%2FFunctions%2F-2124394033) | [jvm]<br>open fun [spliterator](index.md#-1387152138%2FFunctions%2F-2124394033)(): [Spliterator](https://docs.oracle.com/javase/8/docs/api/java/util/Spliterator.html)&lt;[Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt; |
| [toMultimap](to-multimap.md) | [jvm]<br>fun [toMultimap](to-multimap.md)(): [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt; |
| [toString](to-string.md) | [common]<br>expect open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns header names and values. The names and values are separated by :  and each pair is followed by a newline character \n.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [value](value.md) | [common]<br>expect fun [value](value.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the value at index.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [value](value.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [values](values.md) | [common]<br>expect fun [values](values.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;<br>Returns an immutable list of the header values for name.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [values](values.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt; |

## Properties

| Name | Summary |
|---|---|
| [size](size.md) | [common]<br>expect val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Returns the number of field values.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;size&quot;)<br>actual val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>actual val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
