//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[HttpUrl](../index.md)/[Builder](index.md)

# Builder

[jvm]\
class [Builder](index.md)

## Constructors

| | |
|---|---|
| [Builder](-builder.md) | [jvm]<br>fun [Builder](-builder.md)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [addEncodedPathSegment](add-encoded-path-segment.md) | [jvm]<br>fun [addEncodedPathSegment](add-encoded-path-segment.md)(encodedPathSegment: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [addEncodedPathSegments](add-encoded-path-segments.md) | [jvm]<br>fun [addEncodedPathSegments](add-encoded-path-segments.md)(encodedPathSegments: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md)<br>Adds a set of encoded path segments separated by a slash (either \ or /). If encodedPathSegments starts with a slash, the resulting URL will have empty path segment. |
| [addEncodedQueryParameter](add-encoded-query-parameter.md) | [jvm]<br>fun [addEncodedQueryParameter](add-encoded-query-parameter.md)(encodedName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), encodedValue: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [HttpUrl.Builder](index.md)<br>Adds the pre-encoded query parameter to this URL's query string. |
| [addPathSegment](add-path-segment.md) | [jvm]<br>fun [addPathSegment](add-path-segment.md)(pathSegment: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [addPathSegments](add-path-segments.md) | [jvm]<br>fun [addPathSegments](add-path-segments.md)(pathSegments: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md)<br>Adds a set of path segments separated by a slash (either \ or /). If pathSegments starts with a slash, the resulting URL will have empty path segment. |
| [addQueryParameter](add-query-parameter.md) | [jvm]<br>fun [addQueryParameter](add-query-parameter.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [HttpUrl.Builder](index.md)<br>Encodes the query parameter using UTF-8 and adds it to this URL's query string. |
| [build](build.md) | [jvm]<br>fun [build](build.md)(): [HttpUrl](../index.md) |
| [encodedFragment](encoded-fragment.md) | [jvm]<br>fun [encodedFragment](encoded-fragment.md)(encodedFragment: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [HttpUrl.Builder](index.md) |
| [encodedPassword](encoded-password.md) | [jvm]<br>fun [encodedPassword](encoded-password.md)(encodedPassword: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [encodedPath](encoded-path.md) | [jvm]<br>fun [encodedPath](encoded-path.md)(encodedPath: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [encodedQuery](encoded-query.md) | [jvm]<br>fun [encodedQuery](encoded-query.md)(encodedQuery: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [HttpUrl.Builder](index.md) |
| [encodedUsername](encoded-username.md) | [jvm]<br>fun [encodedUsername](encoded-username.md)(encodedUsername: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [fragment](fragment.md) | [jvm]<br>fun [fragment](fragment.md)(fragment: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [HttpUrl.Builder](index.md) |
| [host](host.md) | [jvm]<br>fun [host](host.md)(host: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [password](password.md) | [jvm]<br>fun [password](password.md)(password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [port](port.md) | [jvm]<br>fun [port](port.md)(port: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [HttpUrl.Builder](index.md) |
| [query](query.md) | [jvm]<br>fun [query](query.md)(query: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [HttpUrl.Builder](index.md) |
| [removeAllEncodedQueryParameters](remove-all-encoded-query-parameters.md) | [jvm]<br>fun [removeAllEncodedQueryParameters](remove-all-encoded-query-parameters.md)(encodedName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [removeAllQueryParameters](remove-all-query-parameters.md) | [jvm]<br>fun [removeAllQueryParameters](remove-all-query-parameters.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [removePathSegment](remove-path-segment.md) | [jvm]<br>fun [removePathSegment](remove-path-segment.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [HttpUrl.Builder](index.md) |
| [scheme](scheme.md) | [jvm]<br>fun [scheme](scheme.md)(scheme: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [setEncodedPathSegment](set-encoded-path-segment.md) | [jvm]<br>fun [setEncodedPathSegment](set-encoded-path-segment.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), encodedPathSegment: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [setEncodedQueryParameter](set-encoded-query-parameter.md) | [jvm]<br>fun [setEncodedQueryParameter](set-encoded-query-parameter.md)(encodedName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), encodedValue: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [HttpUrl.Builder](index.md) |
| [setPathSegment](set-path-segment.md) | [jvm]<br>fun [setPathSegment](set-path-segment.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), pathSegment: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
| [setQueryParameter](set-query-parameter.md) | [jvm]<br>fun [setQueryParameter](set-query-parameter.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?): [HttpUrl.Builder](index.md) |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [username](username.md) | [jvm]<br>fun [username](username.md)(username: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [HttpUrl.Builder](index.md) |
