//[okhttp](../../../index.md)/[okhttp3](../index.md)/[MediaType](index.md)

# MediaType

[common]\
expect class [MediaType](index.md)

An [RFC 2045](http://tools.ietf.org/html/rfc2045) Media Type, appropriate to describe the content type of an HTTP request or response body.

[jvm, nonJvm]\
actual class [MediaType](index.md)

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect object [Companion](-companion/index.md)<br>[jvm, nonJvm]<br>actual object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [charset](charset.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [charset](charset.md)(defaultValue: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)? = null): [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)?<br>Returns the charset of this media type, or [defaultValue](charset.md) if either this media type doesn't specify a charset, of it its charset is unsupported by the current runtime. |
| equals | [jvm, nonJvm]<br>[jvm]<br>open operator override fun [equals]([jvm]equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>open operator override fun [equals]([non-jvm]equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| hashCode | [jvm, nonJvm]<br>[jvm]<br>open override fun [hashCode]([jvm]hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [hashCode]([non-jvm]hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [parameter](parameter.md) | [common]<br>expect fun [parameter](parameter.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Returns the parameter [name](parameter.md) of this media type, or null if this media type does not define such a parameter.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [parameter](parameter.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [toString](to-string.md) | [common]<br>expect open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the encoded media type, like &quot;text/plain; charset=utf-8&quot;, appropriate for use in a Content-Type header.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [subtype](subtype.md) | [common]<br>expect val [subtype](subtype.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a specific media subtype, such as &quot;plain&quot; or &quot;png&quot;, &quot;mpeg&quot;, &quot;mp4&quot; or &quot;xml&quot;.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;subtype&quot;)<br>actual val [subtype](subtype.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>actual val [subtype](subtype.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [type](type.md) | [common]<br>expect val [type](type.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns the high-level media type, such as &quot;text&quot;, &quot;image&quot;, &quot;audio&quot;, &quot;video&quot;, or &quot;application&quot;.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;type&quot;)<br>actual val [type](type.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>actual val [type](type.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
