/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3.internal.duplex;

import java.io.Closeable;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mockwebserver3.Stream;
import mockwebserver3.StreamHandler;
import mockwebserver3.internal.duplex.MockStreamHandler;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Utf8;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0000J\u001a\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0016\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR$\u0010\u0003\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lmockwebserver3/internal/duplex/MockStreamHandler;", "Lmockwebserver3/StreamHandler;", "()V", "actions", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function1;", "Lmockwebserver3/Stream;", "", "Lmockwebserver3/internal/duplex/Action;", "results", "Ljava/util/concurrent/FutureTask;", "Ljava/lang/Void;", "awaitSuccess", "cancelStream", "exhaustRequest", "exhaustResponse", "handle", "stream", "receiveRequest", "expected", "", "requestIOException", "sendResponse", "s", "responseSent", "Ljava/util/concurrent/CountDownLatch;", "serviceStreamTask", "sleep", "duration", "", "unit", "Ljava/util/concurrent/TimeUnit;", "mockwebserver3"})
public final class MockStreamHandler
implements StreamHandler {
    @NotNull
    private final LinkedBlockingQueue<Function1<Stream, Unit>> actions = new LinkedBlockingQueue();
    @NotNull
    private final LinkedBlockingQueue<FutureTask<Void>> results = new LinkedBlockingQueue();

    @NotNull
    public final MockStreamHandler receiveRequest(@NotNull String expected) {
        MockStreamHandler mockStreamHandler;
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        MockStreamHandler $this$receiveRequest_u24lambda_u240 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$receiveRequest_u24lambda_u240.actions).add(new Function1<Stream, Unit>(expected){
            final /* synthetic */ String $expected;
            {
                this.$expected = $expected;
                super(1);
            }

            public final void invoke(@NotNull Stream stream) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                String actual = stream.getRequestBody().readUtf8(Utf8.size$default((String)this.$expected, (int)0, (int)0, (int)3, null));
                if (!Intrinsics.areEqual((Object)actual, (Object)this.$expected)) {
                    throw new AssertionError((Object)(actual + " != " + this.$expected));
                }
            }
        });
        return mockStreamHandler;
    }

    @NotNull
    public final MockStreamHandler exhaustRequest() {
        MockStreamHandler mockStreamHandler;
        MockStreamHandler $this$exhaustRequest_u24lambda_u241 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$exhaustRequest_u24lambda_u241.actions).add(exhaustRequest.1.1.INSTANCE);
        return mockStreamHandler;
    }

    @NotNull
    public final MockStreamHandler cancelStream() {
        MockStreamHandler mockStreamHandler;
        MockStreamHandler $this$cancelStream_u24lambda_u242 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$cancelStream_u24lambda_u242.actions).add(cancelStream.1.1.INSTANCE);
        return mockStreamHandler;
    }

    @NotNull
    public final MockStreamHandler requestIOException() {
        MockStreamHandler mockStreamHandler;
        MockStreamHandler $this$requestIOException_u24lambda_u243 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$requestIOException_u24lambda_u243.actions).add(requestIOException.1.1.INSTANCE);
        return mockStreamHandler;
    }

    @JvmOverloads
    @NotNull
    public final MockStreamHandler sendResponse(@NotNull String s, @NotNull CountDownLatch responseSent) {
        MockStreamHandler mockStreamHandler;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)responseSent, (String)"responseSent");
        MockStreamHandler $this$sendResponse_u24lambda_u244 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$sendResponse_u24lambda_u244.actions).add(new Function1<Stream, Unit>(s, responseSent){
            final /* synthetic */ String $s;
            final /* synthetic */ CountDownLatch $responseSent;
            {
                this.$s = $s;
                this.$responseSent = $responseSent;
                super(1);
            }

            public final void invoke(@NotNull Stream stream) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                stream.getResponseBody().writeUtf8(this.$s);
                stream.getResponseBody().flush();
                this.$responseSent.countDown();
            }
        });
        return mockStreamHandler;
    }

    public static /* synthetic */ MockStreamHandler sendResponse$default(MockStreamHandler mockStreamHandler, String string, CountDownLatch countDownLatch, int n, Object object) {
        if ((n & 2) != 0) {
            countDownLatch = new CountDownLatch(0);
        }
        return mockStreamHandler.sendResponse(string, countDownLatch);
    }

    @NotNull
    public final MockStreamHandler exhaustResponse() {
        MockStreamHandler mockStreamHandler;
        MockStreamHandler $this$exhaustResponse_u24lambda_u245 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$exhaustResponse_u24lambda_u245.actions).add(exhaustResponse.1.1.INSTANCE);
        return mockStreamHandler;
    }

    @NotNull
    public final MockStreamHandler sleep(long duration, @NotNull TimeUnit unit) {
        MockStreamHandler mockStreamHandler;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        MockStreamHandler $this$sleep_u24lambda_u246 = mockStreamHandler = this;
        boolean bl = false;
        ((Collection)$this$sleep_u24lambda_u246.actions).add(new Function1<Stream, Unit>(unit, duration){
            final /* synthetic */ TimeUnit $unit;
            final /* synthetic */ long $duration;
            {
                this.$unit = $unit;
                this.$duration = $duration;
                super(1);
            }

            public final void invoke(@NotNull Stream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Thread.sleep(this.$unit.toMillis(this.$duration));
            }
        });
        return mockStreamHandler;
    }

    @Override
    public void handle(@NotNull Stream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        FutureTask<Void> task = this.serviceStreamTask(stream);
        this.results.add(task);
        task.run();
    }

    private final FutureTask<Void> serviceStreamTask(Stream stream) {
        return new FutureTask<Void>(() -> MockStreamHandler.serviceStreamTask$lambda$9(stream, this));
    }

    public final void awaitSuccess() {
        FutureTask<Void> futureTask = this.results.poll(5L, TimeUnit.SECONDS);
        if (futureTask == null) {
            throw new AssertionError((Object)"no onRequest call received");
        }
        FutureTask<Void> futureTask2 = futureTask;
        futureTask2.get(5L, TimeUnit.SECONDS);
    }

    @JvmOverloads
    @NotNull
    public final MockStreamHandler sendResponse(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return MockStreamHandler.sendResponse$default(this, s, null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Void serviceStreamTask$lambda$9(Stream $stream, MockStreamHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)$stream, (String)"$stream");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Closeable closeable = (Closeable)$stream.getRequestBody();
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)$stream.getResponseBody();
            Throwable throwable2 = null;
            try {
                BufferedSink it2 = (BufferedSink)closeable2;
                boolean bl2 = false;
                while (true) {
                    Function1<Stream, Unit> function1;
                    Function1<Stream, Unit> function12 = function1 = this$0.actions.poll();
                    if (function12 == null) break;
                    Intrinsics.checkNotNull(function12);
                    Function1<Stream, Unit> action = function1;
                    action.invoke((Object)$stream);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return null;
    }
}

