//[mockwebserver3](../../../index.md)/[mockwebserver3](../index.md)/[QueueDispatcher](index.md)

# QueueDispatcher

[jvm]\
open class [QueueDispatcher](index.md) : [Dispatcher](../-dispatcher/index.md)

Default dispatcher that processes a script of responses. Populate the script by calling [enqueueResponse](enqueue-response.md).

## Constructors

| | |
|---|---|
| [QueueDispatcher](-queue-dispatcher.md) | [jvm]<br>fun [QueueDispatcher](-queue-dispatcher.md)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [clear](clear.md) | [jvm]<br>open fun [clear](clear.md)() |
| [dispatch](dispatch.md) | [jvm]<br>open override fun [dispatch](dispatch.md)(request: [RecordedRequest](../-recorded-request/index.md)): [MockResponse](../-mock-response/index.md)<br>Returns a response to satisfy request. This method may block (for instance, to wait on a CountdownLatch). |
| [enqueueResponse](enqueue-response.md) | [jvm]<br>open fun [enqueueResponse](enqueue-response.md)(response: [MockResponse](../-mock-response/index.md)) |
| [peek](peek.md) | [jvm]<br>open override fun [peek](peek.md)(): [MockResponse](../-mock-response/index.md)<br>Returns an early guess of the next response, used for policy on how an incoming request should be received. The default implementation returns an empty response. Mischievous implementations can return other values to test HTTP edge cases, such as unhappy socket policies or throttled request bodies. |
| [setFailFast](set-fail-fast.md) | [jvm]<br>open fun [setFailFast](set-fail-fast.md)(failFast: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>open fun [setFailFast](set-fail-fast.md)(failFastResponse: [MockResponse](../-mock-response/index.md)?) |
| [shutdown](shutdown.md) | [jvm]<br>open override fun [shutdown](shutdown.md)()<br>Release any resources held by this dispatcher. Any requests that are currently being dispatched should return immediately. Responses returned after shutdown will not be transmitted: their socket connections have already been closed. |
