//[mockwebserver3](../../../index.md)/[mockwebserver3](../index.md)/[RecordedRequest](index.md)

# RecordedRequest

[jvm]\
class [RecordedRequest](index.md)@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)constructor(requestLine: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), headers: Headers, chunkSizes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)&gt;, bodySize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), body: [Buffer](https://square.github.io/okio/2.x/okio/okio/-buffer/index.html), sequenceNumber: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), socket: [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html), failure: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html)?)

An HTTP request that came into the mock web server.

## Constructors

| | |
|---|---|
| [RecordedRequest](-recorded-request.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [RecordedRequest](-recorded-request.md)(requestLine: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), headers: Headers, chunkSizes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)&gt;, bodySize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), body: [Buffer](https://square.github.io/okio/2.x/okio/okio/-buffer/index.html), sequenceNumber: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), socket: [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html), failure: [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html)? = null) |

## Functions

| Name | Summary |
|---|---|
| [getHeader](get-header.md) | [jvm]<br>fun [getHeader](get-header.md)(name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Returns the first header named [name](get-header.md), or null if no such header exists. |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [body](body.md) | [jvm]<br>val [body](body.md): [Buffer](https://square.github.io/okio/2.x/okio/okio/-buffer/index.html)<br>The body of this POST request. This may be truncated. |
| [bodySize](body-size.md) | [jvm]<br>val [bodySize](body-size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>The total size of the body of this POST request (before truncation). |
| [chunkSizes](chunk-sizes.md) | [jvm]<br>val [chunkSizes](chunk-sizes.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)&gt;<br>The sizes of the chunks of this request's body, or an empty list if the request's body was empty or unchunked. |
| [failure](failure.md) | [jvm]<br>val [failure](failure.md): [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html)? = null<br>The failure MockWebServer recorded when attempting to decode this request. If, for example, the inbound request was truncated, this exception will be non-null. |
| [handshake](handshake.md) | [jvm]<br>val [handshake](handshake.md): Handshake?<br>The TLS handshake of the connection that carried this request, or null if the request was received without TLS. |
| [headers](headers.md) | [jvm]<br>val [headers](headers.md): Headers<br>All headers. |
| [method](method.md) | [jvm]<br>val [method](method.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [path](path.md) | [jvm]<br>val [path](path.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [requestLine](request-line.md) | [jvm]<br>val [requestLine](request-line.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [requestUrl](request-url.md) | [jvm]<br>val [requestUrl](request-url.md): HttpUrl? |
| [sequenceNumber](sequence-number.md) | [jvm]<br>val [sequenceNumber](sequence-number.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The index of this request on its HTTP connection. Since a single HTTP connection may serve multiple requests, each request is assigned its own sequence number. |
| [tlsVersion](tls-version.md) | [jvm]<br>val [tlsVersion](tls-version.md): TlsVersion?<br>Returns the connection's TLS version or null if the connection doesn't use SSL. |
