//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[OkHttpClient](../index.md)/[Builder](index.md)/[readTimeout](read-timeout.md)

# readTimeout

[jvm]\
fun [readTimeout](read-timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [OkHttpClient.Builder](index.md)

@IgnoreJRERequirement

fun [readTimeout](read-timeout.md)(duration: [Duration](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)): [OkHttpClient.Builder](index.md)

Sets the default read timeout for new connections. A value of 0 means no timeout, otherwise values must be between 1 and [Integer.MAX_VALUE](https://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html#MAX_VALUE--) when converted to milliseconds.

The read timeout is applied to both the TCP socket and for individual read IO operations including on [Source](https://square.github.io/okio/2.x/okio/okio/-source/index.html) of the [Response](../../-response/index.md). The default value is 10 seconds.

## See also

jvm

| | |
|---|---|
| [java.net.Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html#setSoTimeout-kotlin.Int-) |  |
| [okio.Source](https://square.github.io/okio/2.x/okio/okio/-source/timeout.html) |  |
