//[okhttp](../../../index.md)/[okhttp3](../index.md)/[RequestBody](index.md)

# RequestBody

[common]\
expect abstract class [RequestBody](index.md)

[jvm, nonJvm]\
actual abstract class [RequestBody](index.md)

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect object [Companion](-companion/index.md)<br>[jvm, nonJvm]<br>actual object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [contentLength](content-length.md) | [common]<br>expect open fun [contentLength](content-length.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of bytes that will be written to sink in a call to [writeTo](write-to.md), or -1 if that count is unknown.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open fun [contentLength](content-length.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [contentType](content-type.md) | [common]<br>expect abstract fun [contentType](content-type.md)(): [MediaType](../-media-type/index.md)?<br>Returns the Content-Type header for this body.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual abstract fun [contentType](content-type.md)(): [MediaType](../-media-type/index.md)? |
| [isDuplex](is-duplex.md) | [common]<br>expect open fun [isDuplex](is-duplex.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>A duplex request body is special in how it is **transmitted** on the network and in the **API contract** between OkHttp and the application.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open fun [isDuplex](is-duplex.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [isOneShot](is-one-shot.md) | [common]<br>expect open fun [isOneShot](is-one-shot.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if this body expects at most one call to [writeTo](write-to.md) and can be transmitted at most once. This is typically used when writing the request body is destructive and it is not possible to recreate the request body after it has been sent.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open fun [isOneShot](is-one-shot.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [writeTo](write-to.md) | [common]<br>expect abstract fun [writeTo](write-to.md)(sink: [BufferedSink](https://square.github.io/okio/2.x/okio/okio/-buffered-sink/index.html))<br>Writes the content of this request to [sink](write-to.md).<br>[jvm]<br>actual abstract fun [writeTo](write-to.md)(sink: [BufferedSink](https://square.github.io/okio/2.x/okio/okio/-buffered-sink/index.html)) |

## Inheritors

| Name |
|---|
| [FormBody](../-form-body/index.md) |
| [MultipartBody](../-multipart-body/index.md) |

## Extensions

| Name | Summary |
|---|---|
| [gzip](-companion/gzip.md) | [jvm]<br>@[JvmStatic](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-static/index.html)<br>fun [RequestBody](index.md).[gzip](-companion/gzip.md)(): [RequestBody](index.md)<br>Returns a gzip version of the RequestBody, with compressed payload. This is not automatic as not all servers support gzip compressed requests. |
