/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import mockwebserver3.Dispatcher;
import mockwebserver3.MockResponse;
import mockwebserver3.MockWebServer;
import mockwebserver3.PushPromise;
import mockwebserver3.QueueDispatcher;
import mockwebserver3.RecordedRequest;
import mockwebserver3.SocketPolicy;
import mockwebserver3.internal.duplex.DuplexResponseBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.duplex.MwsDuplexAccess;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.ws.RealWebSocket;
import okhttp3.internal.ws.WebSocketExtensions;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u007f2\u00020\u0001:\u0007\u007f\u0080\u0001\u0081\u0001\u0082\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010I\u001a\u00020JH\u0002J\b\u0010K\u001a\u00020JH\u0002J\b\u0010L\u001a\u00020JH\u0016J\u0018\u0010M\u001a\u00020J2\u0006\u0010N\u001a\u00020\f2\u0006\u0010O\u001a\u00020\u001bH\u0002J\u000e\u0010P\u001a\u00020J2\u0006\u0010Q\u001a\u00020RJ\r\u0010!\u001a\u00020\fH\u0007\u00a2\u0006\u0002\bSJ\r\u00102\u001a\u00020\fH\u0007\u00a2\u0006\u0002\bTJ0\u0010U\u001a\u00020J2\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u0002052\u0006\u0010Q\u001a\u00020RH\u0002J\u0006\u0010[\u001a\u00020JJ\u0010\u0010\\\u001a\u00020J2\u0006\u0010]\u001a\u00020\u001bH\u0002J\u0013\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+H\u0007\u00a2\u0006\u0002\b^J\u0010\u0010_\u001a\u00020J2\u0006\u0010V\u001a\u00020WH\u0002J(\u0010`\u001a\u0002052\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\u0006\u0010N\u001a\u00020\fH\u0002J\u0006\u0010a\u001a\u00020JJ\u0006\u0010b\u001a\u00020JJ\u0010\u0010c\u001a\u00020J2\u0006\u0010]\u001a\u00020\u001bH\u0002J\u0015\u0010\t\u001a\u00020J2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\bdJ\u0015\u0010(\u001a\u00020J2\u0006\u0010$\u001a\u00020%H\u0007\u00a2\u0006\u0002\beJ\u001b\u0010/\u001a\u00020J2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+H\u0007\u00a2\u0006\u0002\b^J\u0015\u0010<\u001a\u00020J2\u0006\u00109\u001a\u000208H\u0007\u00a2\u0006\u0002\bfJ\u0006\u0010>\u001a\u00020JJ\u0010\u0010g\u001a\u00020J2\u0006\u0010h\u001a\u00020\u0006H\u0002J\u0016\u0010i\u001a\u00020J2\u0006\u0010j\u001a\u00020k2\u0006\u0010 \u001a\u00020\fJ\u0010\u0010i\u001a\u00020J2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010i\u001a\u00020J2\b\b\u0002\u0010 \u001a\u00020\fH\u0007J\u0006\u0010l\u001a\u000205J\u0018\u0010l\u001a\u0004\u0018\u0001052\u0006\u0010m\u001a\u00020\u00062\u0006\u0010n\u001a\u00020oJ8\u0010p\u001a\u00020J2\u0006\u0010q\u001a\u00020R2\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\u0006\u0010r\u001a\u00020\u00062\u0006\u0010s\u001a\u00020%H\u0002J\u0006\u0010t\u001a\u00020uJ\b\u0010v\u001a\u00020\u0014H\u0016J\u000e\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020\u0014J\u0016\u0010z\u001a\u00020J2\u0006\u0010?\u001a\u00020@2\u0006\u0010H\u001a\u00020%J\u0018\u0010{\u001a\u00020J2\u0006\u0010X\u001a\u00020Y2\u0006\u0010|\u001a\u00020}H\u0002J \u0010~\u001a\u00020J2\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Q\u001a\u00020RH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0019\u001a&\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b \u001c*\u0012\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001e\u001a&\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001f0\u001f \u001c*\u0012\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001f0\u001f\u0018\u00010\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R2\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+8G@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u00101\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\"R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020504X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u00109\u001a\u0004\u0018\u0001082\b\u0010*\u001a\u0004\u0018\u0001088F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u000e\u0010>\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010'\"\u0004\bC\u0010)R\u000e\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0083\u0001"}, d2={"Lmockwebserver3/MockWebServer;", "Ljava/io/Closeable;", "()V", "atomicRequestCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "bodyLimit", "", "getBodyLimit", "()J", "setBodyLimit", "(J)V", "clientAuth", "", "dispatcher", "Lmockwebserver3/Dispatcher;", "getDispatcher", "()Lmockwebserver3/Dispatcher;", "setDispatcher", "(Lmockwebserver3/Dispatcher;)V", "hostName", "", "getHostName", "()Ljava/lang/String;", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "openClientSockets", "", "Ljava/net/Socket;", "kotlin.jvm.PlatformType", "", "openConnections", "Lokhttp3/internal/http2/Http2Connection;", "port", "getPort", "()I", "portField", "protocolNegotiationEnabled", "", "getProtocolNegotiationEnabled", "()Z", "setProtocolNegotiationEnabled", "(Z)V", "value", "", "Lokhttp3/Protocol;", "protocols", "()Ljava/util/List;", "setProtocols", "(Ljava/util/List;)V", "requestCount", "getRequestCount", "requestQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lmockwebserver3/RecordedRequest;", "serverSocket", "Ljava/net/ServerSocket;", "Ljavax/net/ServerSocketFactory;", "serverSocketFactory", "getServerSocketFactory", "()Ljavax/net/ServerSocketFactory;", "setServerSocketFactory", "(Ljavax/net/ServerSocketFactory;)V", "shutdown", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "started", "getStarted", "setStarted", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "taskRunnerBackend", "Lokhttp3/internal/concurrent/TaskRunner$RealBackend;", "tunnelProxy", "acceptConnections", "", "before", "close", "dispatchBookkeepingRequest", "sequenceNumber", "socket", "enqueue", "response", "Lmockwebserver3/MockResponse;", "-deprecated_port", "-deprecated_requestCount", "handleWebSocketUpgrade", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "request", "noClientAuth", "processHandshakeFailure", "raw", "-deprecated_protocols", "readEmptyLine", "readRequest", "requestClientAuth", "requireClientAuth", "serveConnection", "-deprecated_bodyLimit", "-deprecated_protocolNegotiationEnabled", "-deprecated_serverSocketFactory", "sleepIfDelayed", "delayMs", "start", "inetAddress", "Ljava/net/InetAddress;", "takeRequest", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "throttledTransfer", "policy", "byteCount", "isRequest", "toProxyAddress", "Ljava/net/Proxy;", "toString", "url", "Lokhttp3/HttpUrl;", "path", "useHttps", "writeHeaders", "headers", "Lokhttp3/Headers;", "writeHttpResponse", "Companion", "Http2SocketHandler", "SocketHandler", "TruncatingBuffer", "mockwebserver3"})
public final class MockWebServer
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskRunner.RealBackend taskRunnerBackend = new TaskRunner.RealBackend(_UtilJvmKt.threadFactory((String)"MockWebServer TaskRunner", (boolean)false));
    @NotNull
    private final TaskRunner taskRunner = new TaskRunner((TaskRunner.Backend)this.taskRunnerBackend, null, 2, null);
    @NotNull
    private final LinkedBlockingQueue<RecordedRequest> requestQueue = new LinkedBlockingQueue();
    private final Set<Socket> openClientSockets = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Http2Connection> openConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    @NotNull
    private final AtomicInteger atomicRequestCount = new AtomicInteger();
    private long bodyLimit = Long.MAX_VALUE;
    @Nullable
    private ServerSocketFactory serverSocketFactory;
    @Nullable
    private ServerSocket serverSocket;
    @Nullable
    private SSLSocketFactory sslSocketFactory;
    private boolean tunnelProxy;
    private int clientAuth;
    @NotNull
    private Dispatcher dispatcher = new QueueDispatcher();
    private int portField = -1;
    @Nullable
    private InetSocketAddress inetSocketAddress;
    private boolean protocolNegotiationEnabled = true;
    @NotNull
    private List<? extends Protocol> protocols;
    private boolean started;
    private boolean shutdown;
    private static final int CLIENT_AUTH_NONE = 0;
    private static final int CLIENT_AUTH_REQUESTED = 1;
    private static final int CLIENT_AUTH_REQUIRED = 2;
    @NotNull
    private static final Companion.UNTRUSTED_TRUST_MANAGER.1 UNTRUSTED_TRUST_MANAGER;
    private static final Logger logger;

    public MockWebServer() {
        Object[] objectArray = new Protocol[]{Protocol.HTTP_2, Protocol.HTTP_1_1};
        this.protocols = _UtilJvmKt.immutableListOf((Object[])objectArray);
    }

    public final int getRequestCount() {
        return this.atomicRequestCount.get();
    }

    public final long getBodyLimit() {
        return this.bodyLimit;
    }

    public final void setBodyLimit(long l) {
        this.bodyLimit = l;
    }

    @Nullable
    public final synchronized ServerSocketFactory getServerSocketFactory() {
        if (this.serverSocketFactory == null && this.started) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        return this.serverSocketFactory;
    }

    public final synchronized void setServerSocketFactory(@Nullable ServerSocketFactory value) {
        if (!(!this.started)) {
            boolean bl = false;
            String string = "serverSocketFactory must not be set after start()";
            throw new IllegalStateException(string.toString());
        }
        this.serverSocketFactory = value;
    }

    @NotNull
    public final Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void setDispatcher(@NotNull Dispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"<set-?>");
        this.dispatcher = dispatcher;
    }

    public final int getPort() {
        this.before();
        return this.portField;
    }

    @NotNull
    public final String getHostName() {
        this.before();
        InetSocketAddress inetSocketAddress = this.inetSocketAddress;
        Intrinsics.checkNotNull((Object)inetSocketAddress);
        String string = inetSocketAddress.getAddress().getCanonicalHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inetSocketAddress!!.address.canonicalHostName");
        return string;
    }

    public final boolean getProtocolNegotiationEnabled() {
        return this.protocolNegotiationEnabled;
    }

    public final void setProtocolNegotiationEnabled(boolean bl) {
        this.protocolNegotiationEnabled = bl;
    }

    @JvmName(name="protocols")
    @NotNull
    public final List<Protocol> protocols() {
        return this.protocols;
    }

    public final void setProtocols(@NotNull List<? extends Protocol> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        List protocolList = _UtilJvmKt.toImmutableList(value);
        if (!(!protocolList.contains(Protocol.H2_PRIOR_KNOWLEDGE) || protocolList.size() == 1)) {
            boolean $i$a$-require-MockWebServer$protocols$42 = false;
            String $i$a$-require-MockWebServer$protocols$42 = Intrinsics.stringPlus((String)"protocols containing h2_prior_knowledge cannot use other protocols: ", (Object)protocolList);
            throw new IllegalArgumentException($i$a$-require-MockWebServer$protocols$42.toString());
        }
        if (!(protocolList.contains(Protocol.HTTP_1_1) || protocolList.contains(Protocol.H2_PRIOR_KNOWLEDGE))) {
            boolean $i$a$-require-MockWebServer$protocols$52 = false;
            String $i$a$-require-MockWebServer$protocols$52 = Intrinsics.stringPlus((String)"protocols doesn't contain http/1.1: ", (Object)protocolList);
            throw new IllegalArgumentException($i$a$-require-MockWebServer$protocols$52.toString());
        }
        if (!(!protocolList.contains(null))) {
            boolean bl = false;
            String string = "protocols must not contain null";
            throw new IllegalArgumentException(string.toString());
        }
        this.protocols = protocolList;
    }

    public final boolean getStarted() {
        return this.started;
    }

    public final void setStarted(boolean bl) {
        this.started = bl;
    }

    private final synchronized void before() {
        if (this.started) {
            return;
        }
        try {
            MockWebServer.start$default(this, 0, 1, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="port", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_port")
    public final int -deprecated_port() {
        return this.getPort();
    }

    @NotNull
    public final Proxy toProxyAddress() {
        this.before();
        InetSocketAddress inetSocketAddress = this.inetSocketAddress;
        Intrinsics.checkNotNull((Object)inetSocketAddress);
        InetSocketAddress address = new InetSocketAddress(inetSocketAddress.getAddress().getCanonicalHostName(), this.getPort());
        return new Proxy(Proxy.Type.HTTP, address);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="run { this.serverSocketFactory = serverSocketFactory }", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_serverSocketFactory")
    public final void -deprecated_serverSocketFactory(@NotNull ServerSocketFactory serverSocketFactory) {
        Intrinsics.checkNotNullParameter((Object)serverSocketFactory, (String)"serverSocketFactory");
        MockWebServer $this$setServerSocketFactory_u24lambda_u2d4 = this;
        boolean bl = false;
        $this$setServerSocketFactory_u24lambda_u2d4.setServerSocketFactory(serverSocketFactory);
    }

    @NotNull
    public final HttpUrl url(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HttpUrl httpUrl = new HttpUrl.Builder().scheme(this.sslSocketFactory != null ? "https" : "http").host(this.getHostName()).port(this.getPort()).build().resolve(path);
        Intrinsics.checkNotNull((Object)httpUrl);
        return httpUrl;
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="run { this.bodyLimit = bodyLimit }", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_bodyLimit")
    public final void -deprecated_bodyLimit(long bodyLimit) {
        MockWebServer $this$setBodyLimit_u24lambda_u2d5 = this;
        boolean bl = false;
        $this$setBodyLimit_u24lambda_u2d5.setBodyLimit(bodyLimit);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="run { this.protocolNegotiationEnabled = protocolNegotiationEnabled }", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocolNegotiationEnabled")
    public final void -deprecated_protocolNegotiationEnabled(boolean protocolNegotiationEnabled) {
        MockWebServer $this$setProtocolNegotiationEnabled_u24lambda_u2d6 = this;
        boolean bl = false;
        $this$setProtocolNegotiationEnabled_u24lambda_u2d6.setProtocolNegotiationEnabled(protocolNegotiationEnabled);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="run { this.protocols = protocols }", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocols")
    public final void -deprecated_protocols(@NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        MockWebServer $this$setProtocols_u24lambda_u2d7 = this;
        boolean bl = false;
        $this$setProtocols_u24lambda_u2d7.setProtocols(protocols);
    }

    @Deprecated(message="moved to var", replaceWith=@ReplaceWith(expression="protocols", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocols")
    @NotNull
    public final List<Protocol> -deprecated_protocols() {
        return this.protocols;
    }

    public final void useHttps(@NotNull SSLSocketFactory sslSocketFactory, boolean tunnelProxy) {
        Intrinsics.checkNotNullParameter((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.sslSocketFactory = sslSocketFactory;
        this.tunnelProxy = tunnelProxy;
    }

    public final void noClientAuth() {
        this.clientAuth = 0;
    }

    public final void requestClientAuth() {
        this.clientAuth = 1;
    }

    public final void requireClientAuth() {
        this.clientAuth = 2;
    }

    @NotNull
    public final RecordedRequest takeRequest() throws InterruptedException {
        RecordedRequest recordedRequest = this.requestQueue.take();
        Intrinsics.checkNotNullExpressionValue((Object)recordedRequest, (String)"requestQueue.take()");
        return recordedRequest;
    }

    @Nullable
    public final RecordedRequest takeRequest(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.requestQueue.poll(timeout, unit);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="requestCount", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_requestCount")
    public final int -deprecated_requestCount() {
        return this.getRequestCount();
    }

    public final void enqueue(@NotNull MockResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ((QueueDispatcher)this.dispatcher).enqueueResponse(response.clone());
    }

    @JvmOverloads
    public final void start(int port) throws IOException {
        InetAddress inetAddress = InetAddress.getByName("localhost");
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByName(\"localhost\")");
        this.start(inetAddress, port);
    }

    public static /* synthetic */ void start$default(MockWebServer mockWebServer, int n, int n2, Object object) throws IOException {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        mockWebServer.start(n);
    }

    public final void start(@NotNull InetAddress inetAddress, int port) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
        this.start(new InetSocketAddress(inetAddress, port));
    }

    private final synchronized void start(InetSocketAddress inetSocketAddress) throws IOException {
        if (!(!this.shutdown)) {
            boolean bl = false;
            String string = "shutdown() already called";
            throw new IllegalStateException(string.toString());
        }
        if (this.started) {
            return;
        }
        this.started = true;
        this.inetSocketAddress = inetSocketAddress;
        ServerSocketFactory serverSocketFactory = this.getServerSocketFactory();
        Intrinsics.checkNotNull((Object)serverSocketFactory);
        ServerSocket serverSocket = this.serverSocket = serverSocketFactory.createServerSocket();
        Intrinsics.checkNotNull((Object)serverSocket);
        serverSocket.setReuseAddress(inetSocketAddress.getPort() != 0);
        ServerSocket serverSocket2 = this.serverSocket;
        Intrinsics.checkNotNull((Object)serverSocket2);
        serverSocket2.bind(inetSocketAddress, 50);
        ServerSocket serverSocket3 = this.serverSocket;
        Intrinsics.checkNotNull((Object)serverSocket3);
        this.portField = serverSocket3.getLocalPort();
        TaskQueue.execute$default((TaskQueue)this.taskRunner.newQueue(), (String)Intrinsics.stringPlus((String)"MockWebServer ", (Object)this.portField), (long)0L, (boolean)false, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ MockWebServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                try {
                    MockWebServer.access$getLogger$cp().fine(this.this$0 + " starting to accept connections");
                    MockWebServer.access$acceptConnections(this.this$0);
                }
                catch (Throwable e) {
                    MockWebServer.access$getLogger$cp().log(Level.WARNING, this.this$0 + " failed unexpectedly", e);
                }
                ServerSocket serverSocket = MockWebServer.access$getServerSocket$p(this.this$0);
                if (serverSocket != null) {
                    _UtilJvmKt.closeQuietly((ServerSocket)serverSocket);
                }
                Iterator<E> openClientSocket = MockWebServer.access$getOpenClientSockets$p(this.this$0).iterator();
                while (openClientSocket.hasNext()) {
                    E e = openClientSocket.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"openClientSocket.next()");
                    _UtilCommonKt.closeQuietly((Closeable)((Closeable)e));
                    openClientSocket.remove();
                }
                Iterator<E> httpConnection = MockWebServer.access$getOpenConnections$p(this.this$0).iterator();
                while (httpConnection.hasNext()) {
                    E e = httpConnection.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"httpConnection.next()");
                    _UtilCommonKt.closeQuietly((Closeable)((Closeable)e));
                    httpConnection.remove();
                }
                this.this$0.getDispatcher().shutdown();
            }
        }), (int)2, null);
    }

    private final void acceptConnections() throws Exception {
        while (true) {
            Socket socket = null;
            try {
                ServerSocket serverSocket = this.serverSocket;
                Intrinsics.checkNotNull((Object)serverSocket);
                Socket socket2 = serverSocket.accept();
                Intrinsics.checkNotNullExpressionValue((Object)socket2, (String)"serverSocket!!.accept()");
                socket = socket2;
            }
            catch (SocketException e) {
                logger.fine(this + " done accepting connections: " + e.getMessage());
                return;
            }
            SocketPolicy socketPolicy = this.dispatcher.peek().getSocketPolicy();
            if (socketPolicy == SocketPolicy.DISCONNECT_AT_START) {
                this.dispatchBookkeepingRequest(0, socket);
                socket.close();
                continue;
            }
            this.openClientSockets.add(socket);
            this.serveConnection(socket);
        }
    }

    public final synchronized void shutdown() throws IOException {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (!this.started) {
            return;
        }
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket == null) {
            return;
        }
        ServerSocket serverSocket2 = serverSocket;
        serverSocket2.close();
        for (TaskQueue queue : this.taskRunner.activeQueues()) {
            if (queue.idleLatch().await(5L, TimeUnit.SECONDS)) continue;
            throw new IOException("Gave up waiting for queue to shut down");
        }
        this.taskRunnerBackend.shutdown();
    }

    private final void serveConnection(Socket raw) {
        TaskQueue.execute$default((TaskQueue)this.taskRunner.newQueue(), (String)Intrinsics.stringPlus((String)"MockWebServer ", (Object)raw.getRemoteSocketAddress()), (long)0L, (boolean)false, (Function0)((Function0)new Function0<Unit>(this, raw){
            final /* synthetic */ MockWebServer this$0;
            final /* synthetic */ Socket $raw;
            {
                this.this$0 = $receiver;
                this.$raw = $raw;
                super(0);
            }

            public final void invoke() {
                try {
                    this.this$0.new SocketHandler(this.$raw).handle();
                }
                catch (IOException e) {
                    MockWebServer.access$getLogger$cp().fine(this.this$0 + " connection from " + this.$raw.getInetAddress() + " failed: " + e);
                }
                catch (Exception e) {
                    MockWebServer.access$getLogger$cp().log(Level.SEVERE, this.this$0 + " connection from " + this.$raw.getInetAddress() + " crashed", e);
                }
            }
        }), (int)2, null);
    }

    private final void processHandshakeFailure(Socket raw) throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{UNTRUSTED_TRUST_MANAGER};
        context.init(null, trustManagerArray, new SecureRandom());
        SSLSocketFactory sslSocketFactory = context.getSocketFactory();
        Socket socket = sslSocketFactory.createSocket(raw, raw.getInetAddress().getHostAddress(), raw.getPort(), true);
        if (socket == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.SSLSocket");
        }
        SSLSocket socket2 = (SSLSocket)socket;
        try {
            socket2.startHandshake();
            throw new AssertionError();
        }
        catch (IOException iOException) {
            socket2.close();
            return;
        }
    }

    private final void dispatchBookkeepingRequest(int sequenceNumber, Socket socket) throws InterruptedException {
        RecordedRequest request = new RecordedRequest("", Headers.Companion.of(new String[0]), CollectionsKt.emptyList(), 0L, new Buffer(), sequenceNumber, socket, null, 128, null);
        this.atomicRequestCount.incrementAndGet();
        this.requestQueue.add(request);
        this.dispatcher.dispatch(request);
    }

    private final RecordedRequest readRequest(Socket socket, BufferedSource source, BufferedSink sink, int sequenceNumber) throws IOException {
        String request = null;
        request = "";
        Headers.Builder headers = new Headers.Builder();
        long contentLength = -1L;
        boolean chunked = false;
        boolean expectContinue = false;
        TruncatingBuffer requestBody = new TruncatingBuffer(this.bodyLimit);
        List chunkSizes = new ArrayList();
        IOException failure = null;
        try {
            String header;
            request = source.readUtf8LineStrict();
            if (((CharSequence)request).length() == 0) {
                throw new ProtocolException("no request because the stream is exhausted");
            }
            while (!(((CharSequence)(header = source.readUtf8LineStrict())).length() == 0)) {
                Internal.addHeaderLenient((Headers.Builder)headers, (String)header);
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string = header.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
                String lowercaseHeader = string;
                if (contentLength == -1L && StringsKt.startsWith$default((String)lowercaseHeader, (String)"content-length:", (boolean)false, (int)2, null)) {
                    string = header.substring(15);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    contentLength = Long.parseLong(((Object)StringsKt.trim((CharSequence)string)).toString());
                }
                if (StringsKt.startsWith$default((String)lowercaseHeader, (String)"transfer-encoding:", (boolean)false, (int)2, null)) {
                    string = lowercaseHeader.substring(18);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string)).toString(), (Object)"chunked")) {
                        chunked = true;
                    }
                }
                if (!StringsKt.startsWith$default((String)lowercaseHeader, (String)"expect:", (boolean)false, (int)2, null)) continue;
                string = lowercaseHeader.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                if (!StringsKt.equals((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"100-continue", (boolean)true)) continue;
                expectContinue = true;
            }
            SocketPolicy socketPolicy = this.dispatcher.peek().getSocketPolicy();
            if (expectContinue && socketPolicy == SocketPolicy.EXPECT_CONTINUE || socketPolicy == SocketPolicy.CONTINUE_ALWAYS) {
                sink.writeUtf8("HTTP/1.1 100 Continue\r\n");
                sink.writeUtf8("Content-Length: 0\r\n");
                sink.writeUtf8("\r\n");
                sink.flush();
            }
            boolean hasBody = false;
            MockResponse policy = this.dispatcher.peek();
            if (policy.getSocketPolicy() != SocketPolicy.DO_NOT_READ_REQUEST_BODY) {
                if (contentLength != -1L) {
                    hasBody = contentLength > 0L;
                    this.throttledTransfer(policy, socket, source, Okio.buffer((Sink)requestBody), contentLength, true);
                } else if (chunked) {
                    hasBody = true;
                    while (true) {
                        int chunkSize;
                        if ((chunkSize = Integer.parseInt(((Object)StringsKt.trim((CharSequence)source.readUtf8LineStrict())).toString(), CharsKt.checkRadix((int)16))) == 0) {
                            this.readEmptyLine(source);
                            break;
                        }
                        chunkSizes.add(chunkSize);
                        this.throttledTransfer(policy, socket, source, Okio.buffer((Sink)requestBody), chunkSize, true);
                        this.readEmptyLine(source);
                    }
                }
            }
            String method = StringsKt.substringBefore$default((String)request, (char)' ', null, (int)2, null);
            if (!(!hasBody || HttpMethod.permitsRequestBody((String)method))) {
                boolean bl = false;
                String string = Intrinsics.stringPlus((String)"Request must not have a body: ", (Object)request);
                throw new IllegalArgumentException(string.toString());
            }
        }
        catch (IOException e) {
            failure = e;
        }
        return new RecordedRequest(request, headers.build(), chunkSizes, requestBody.getReceivedByteCount(), requestBody.getBuffer(), sequenceNumber, socket, failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleWebSocketUpgrade(Socket socket, BufferedSource source, BufferedSink sink, RecordedRequest request, MockResponse response) throws IOException {
        String key;
        String string = key = request.getHeader("Sec-WebSocket-Key");
        Intrinsics.checkNotNull((Object)string);
        response.setHeader("Sec-WebSocket-Accept", WebSocketProtocol.INSTANCE.acceptHeader(string));
        this.writeHttpResponse(socket, sink, response);
        String scheme = request.getTlsVersion() != null ? "https" : "http";
        String authority = request.getHeader("Host");
        Request fancyRequest = new Request.Builder().url(scheme + "://" + authority + '/').headers(request.getHeaders()).build();
        char[] cArray = new char[]{' '};
        List statusParts = StringsKt.split$default((CharSequence)response.getStatus(), (char[])cArray, (boolean)false, (int)3, (int)2, null);
        Response fancyResponse = new Response.Builder().code(Integer.parseInt((String)statusParts.get(1))).message((String)statusParts.get(2)).headers(response.getHeaders()).request(fancyRequest).protocol(Protocol.HTTP_1_1).build();
        CountDownLatch connectionClose = new CountDownLatch(1);
        RealWebSocket.Streams streams2 = new RealWebSocket.Streams(source, sink, connectionClose){
            final /* synthetic */ BufferedSource $source;
            final /* synthetic */ BufferedSink $sink;
            final /* synthetic */ CountDownLatch $connectionClose;
            {
                this.$source = $source;
                this.$sink = $sink;
                this.$connectionClose = $connectionClose;
                super(false, $source, $sink);
            }

            public void close() {
                this.$connectionClose.countDown();
            }
        };
        WebSocketListener webSocketListener = response.getWebSocketListener();
        Intrinsics.checkNotNull((Object)webSocketListener);
        RealWebSocket webSocket = new RealWebSocket(this.taskRunner, fancyRequest, webSocketListener, (Random)new SecureRandom(), 0L, WebSocketExtensions.Companion.parse(response.getHeaders()), 0L);
        WebSocketListener webSocketListener2 = response.getWebSocketListener();
        Intrinsics.checkNotNull((Object)webSocketListener2);
        webSocketListener2.onOpen((WebSocket)webSocket, fancyResponse);
        String string2 = request.getPath();
        Intrinsics.checkNotNull((Object)string2);
        String name = Intrinsics.stringPlus((String)"MockWebServer WebSocket ", (Object)string2);
        webSocket.initReaderAndWriter(name, streams2);
        try {
            webSocket.loopReader();
            connectionClose.await();
        }
        catch (IOException e) {
            webSocket.failWebSocket((Exception)e, null);
        }
        finally {
            _UtilCommonKt.closeQuietly((Closeable)((Closeable)source));
        }
    }

    private final void writeHttpResponse(Socket socket, BufferedSink sink, MockResponse response) throws IOException {
        this.sleepIfDelayed(response.getHeadersDelay(TimeUnit.MILLISECONDS));
        sink.writeUtf8(response.getStatus());
        sink.writeUtf8("\r\n");
        this.writeHeaders(sink, response.getHeaders());
        Buffer buffer = response.getBody();
        if (buffer == null) {
            return;
        }
        Buffer body = buffer;
        this.sleepIfDelayed(response.getBodyDelay(TimeUnit.MILLISECONDS));
        this.throttledTransfer(response, socket, (BufferedSource)body, sink, body.size(), false);
        if (StringsKt.equals((String)"chunked", (String)response.getHeaders().get("Transfer-Encoding"), (boolean)true)) {
            this.writeHeaders(sink, response.getTrailers());
        }
    }

    private final void writeHeaders(BufferedSink sink, Headers headers) throws IOException {
        for (Pair pair : headers) {
            String name = (String)pair.component1();
            String value = (String)pair.component2();
            sink.writeUtf8(name);
            sink.writeUtf8(": ");
            sink.writeUtf8(value);
            sink.writeUtf8("\r\n");
        }
        sink.writeUtf8("\r\n");
        sink.flush();
    }

    private final void sleepIfDelayed(long delayMs) {
        if (delayMs != 0L) {
            Thread.sleep(delayMs);
        }
    }

    private final void throttledTransfer(MockResponse policy, Socket socket, BufferedSource source, BufferedSink sink, long byteCount, boolean isRequest) throws IOException {
        boolean disconnectHalfway;
        long byteCountNum = byteCount;
        if (byteCountNum == 0L) {
            return;
        }
        Buffer buffer = new Buffer();
        long bytesPerPeriod = policy.getThrottleBytesPerPeriod();
        long periodDelayMs = policy.getThrottlePeriod(TimeUnit.MILLISECONDS);
        long halfByteCount = byteCountNum / (long)2;
        boolean bl = isRequest ? policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_REQUEST_BODY : (disconnectHalfway = policy.getSocketPolicy() == SocketPolicy.DISCONNECT_DURING_RESPONSE_BODY);
        while (!socket.isClosed()) {
            long read;
            for (long b = 0L; b < bytesPerPeriod; b += read) {
                long l = bytesPerPeriod - b;
                long toRead = Math.min(byteCountNum, l);
                if (disconnectHalfway) {
                    l = byteCountNum - halfByteCount;
                    toRead = Math.min(toRead, l);
                }
                if ((read = source.read(buffer, toRead)) == -1L) {
                    return;
                }
                sink.write(buffer, read);
                sink.flush();
                if (!disconnectHalfway || (byteCountNum -= read) != halfByteCount) continue;
                socket.close();
                return;
            }
            this.sleepIfDelayed(periodDelayMs);
        }
    }

    private final void readEmptyLine(BufferedSource source) throws IOException {
        String line = source.readUtf8LineStrict();
        if (!(((CharSequence)line).length() == 0)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Expected empty but was: ", (Object)line);
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        return "MockWebServer[" + this.portField + ']';
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    @JvmOverloads
    public final void start() throws IOException {
        MockWebServer.start$default(this, 0, 1, null);
    }

    public static final /* synthetic */ void access$acceptConnections(MockWebServer $this) {
        $this.acceptConnections();
    }

    public static final /* synthetic */ ServerSocket access$getServerSocket$p(MockWebServer $this) {
        return $this.serverSocket;
    }

    static {
        MwsDuplexAccess.instance = new MwsDuplexAccess(){

            public void setBody(@NotNull MockResponse mockResponse, @NotNull DuplexResponseBody duplexResponseBody) {
                Intrinsics.checkNotNullParameter((Object)mockResponse, (String)"mockResponse");
                Intrinsics.checkNotNullParameter((Object)duplexResponseBody, (String)"duplexResponseBody");
                mockResponse.setBody(duplexResponseBody);
            }
        };
        UNTRUSTED_TRUST_MANAGER = new X509TrustManager(){

            @NotNull
            public Void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                throw new CertificateException();
            }

            @NotNull
            public Void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
                throw new AssertionError();
            }

            @NotNull
            public X509Certificate[] getAcceptedIssuers() {
                throw new AssertionError();
            }
        };
        logger = Logger.getLogger(MockWebServer.class.getName());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmockwebserver3/MockWebServer$SocketHandler;", "", "raw", "Ljava/net/Socket;", "(Lmockwebserver3/MockWebServer;Ljava/net/Socket;)V", "sequenceNumber", "", "createTunnel", "", "handle", "processOneRequest", "", "socket", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "mockwebserver3"})
    public final class SocketHandler {
        @NotNull
        private final Socket raw;
        private int sequenceNumber;

        public SocketHandler(Socket raw) {
            Intrinsics.checkNotNullParameter((Object)MockWebServer.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            this.raw = raw;
        }

        public final void handle() throws Exception {
            SocketPolicy socketPolicy = MockWebServer.this.getDispatcher().peek().getSocketPolicy();
            Protocol protocol = Protocol.HTTP_1_1;
            Socket socket = null;
            if (MockWebServer.this.sslSocketFactory != null) {
                if (MockWebServer.this.tunnelProxy) {
                    this.createTunnel();
                }
                if (socketPolicy == SocketPolicy.FAIL_HANDSHAKE) {
                    MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, this.raw);
                    MockWebServer.this.processHandshakeFailure(this.raw);
                    return;
                }
                SSLSocketFactory sSLSocketFactory = MockWebServer.this.sslSocketFactory;
                Intrinsics.checkNotNull((Object)sSLSocketFactory);
                Socket socket2 = sSLSocketFactory.createSocket(this.raw, this.raw.getInetAddress().getHostAddress(), this.raw.getPort(), true);
                Intrinsics.checkNotNullExpressionValue((Object)socket2, (String)"sslSocketFactory!!.creat\u2026aw.port, true\n          )");
                socket = socket2;
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setUseClientMode(false);
                if (MockWebServer.this.clientAuth == 2) {
                    sslSocket.setNeedClientAuth(true);
                } else if (MockWebServer.this.clientAuth == 1) {
                    sslSocket.setWantClientAuth(true);
                }
                MockWebServer.this.openClientSockets.add(socket);
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    Platform.Companion.get().configureTlsExtensions(sslSocket, null, MockWebServer.this.protocols());
                }
                sslSocket.startHandshake();
                if (MockWebServer.this.getProtocolNegotiationEnabled()) {
                    String protocolString = Platform.Companion.get().getSelectedProtocol(sslSocket);
                    protocol = protocolString != null ? Protocol.Companion.get(protocolString) : Protocol.HTTP_1_1;
                    Platform.Companion.get().afterHandshake(sslSocket);
                }
                MockWebServer.this.openClientSockets.remove(this.raw);
            } else if (MockWebServer.this.protocols().contains(Protocol.H2_PRIOR_KNOWLEDGE)) {
                socket = this.raw;
                protocol = Protocol.H2_PRIOR_KNOWLEDGE;
            } else {
                socket = this.raw;
            }
            if (socketPolicy == SocketPolicy.STALL_SOCKET_AT_START) {
                MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber, socket);
                return;
            }
            if (protocol == Protocol.HTTP_2 || protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                Http2SocketHandler http2SocketHandler = new Http2SocketHandler(socket, protocol);
                Http2Connection connection = Http2Connection.Builder.socket$default((Http2Connection.Builder)new Http2Connection.Builder(false, MockWebServer.this.taskRunner), (Socket)socket, null, null, null, (int)14, null).listener((Http2Connection.Listener)http2SocketHandler).build();
                Http2Connection.start$default((Http2Connection)connection, (boolean)false, (int)1, null);
                MockWebServer.this.openConnections.add(connection);
                MockWebServer.this.openClientSockets.remove(socket);
                return;
            }
            if (protocol != Protocol.HTTP_1_1) {
                throw new AssertionError();
            }
            BufferedSource source = Okio.buffer((Source)Okio.source((Socket)socket));
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)socket));
            while (this.processOneRequest(socket, source, sink)) {
            }
            if (this.sequenceNumber == 0) {
                logger.warning(MockWebServer.this + " connection from " + this.raw.getInetAddress() + " didn't make a request");
            }
            socket.close();
            MockWebServer.this.openClientSockets.remove(socket);
        }

        private final void createTunnel() throws IOException, InterruptedException {
            SocketPolicy socketPolicy;
            BufferedSource source = Okio.buffer((Source)Okio.source((Socket)this.raw));
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)this.raw));
            do {
                socketPolicy = MockWebServer.this.getDispatcher().peek().getSocketPolicy();
                if (this.processOneRequest(this.raw, source, sink)) continue;
                boolean bl = false;
                String string = "Tunnel without any CONNECT!";
                throw new IllegalStateException(string.toString());
            } while (socketPolicy != SocketPolicy.UPGRADE_TO_SSL_AT_END);
        }

        private final boolean processOneRequest(Socket socket, BufferedSource source, BufferedSink sink) throws IOException, InterruptedException {
            boolean responseWantsWebSockets;
            if (source.exhausted()) {
                return false;
            }
            RecordedRequest request = MockWebServer.this.readRequest(socket, source, sink, this.sequenceNumber);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            if (request.getFailure() != null) {
                return false;
            }
            MockResponse response = MockWebServer.this.getDispatcher().dispatch(request);
            if (response.getSocketPolicy() == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                socket.close();
                return false;
            }
            if (response.getSocketPolicy() == SocketPolicy.HALF_CLOSE_AFTER_REQUEST) {
                socket.shutdownOutput();
                return false;
            }
            if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                if (source.exhausted()) {
                    return false;
                }
                throw new ProtocolException("unexpected data");
            }
            boolean reuseSocket = true;
            boolean requestWantsWebSockets = StringsKt.equals((String)"Upgrade", (String)request.getHeader("Connection"), (boolean)true) && StringsKt.equals((String)"websocket", (String)request.getHeader("Upgrade"), (boolean)true);
            boolean bl = responseWantsWebSockets = response.getWebSocketListener() != null;
            if (requestWantsWebSockets && responseWantsWebSockets) {
                MockWebServer.this.handleWebSocketUpgrade(socket, source, sink, request, response);
                reuseSocket = false;
            } else {
                MockWebServer.this.writeHttpResponse(socket, sink, response);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MockWebServer.this + " received request: " + request + " and responded: " + response);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[response.getSocketPolicy().ordinal()]) {
                case 1: 
                case 2: {
                    socket.close();
                    return false;
                }
                case 3: {
                    socket.shutdownInput();
                    break;
                }
                case 4: {
                    socket.shutdownOutput();
                    break;
                }
                case 5: {
                    MockWebServer.this.shutdown();
                }
            }
            int n = this.sequenceNumber;
            this.sequenceNumber = n + 1;
            return reuseSocket;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SocketPolicy.values().length];
                nArray[SocketPolicy.DISCONNECT_AT_END.ordinal()] = 1;
                nArray[SocketPolicy.DO_NOT_READ_REQUEST_BODY.ordinal()] = 2;
                nArray[SocketPolicy.SHUTDOWN_INPUT_AT_END.ordinal()] = 3;
                nArray[SocketPolicy.SHUTDOWN_OUTPUT_AT_END.ordinal()] = 4;
                nArray[SocketPolicy.SHUTDOWN_SERVER_AFTER_RESPONSE.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lmockwebserver3/MockWebServer$TruncatingBuffer;", "Lokio/Sink;", "remainingByteCount", "", "(J)V", "buffer", "Lokio/Buffer;", "getBuffer", "()Lokio/Buffer;", "receivedByteCount", "getReceivedByteCount", "()J", "setReceivedByteCount", "close", "", "flush", "timeout", "Lokio/Timeout;", "write", "source", "byteCount", "mockwebserver3"})
    private static final class TruncatingBuffer
    implements Sink {
        private long remainingByteCount;
        @NotNull
        private final Buffer buffer;
        private long receivedByteCount;

        public TruncatingBuffer(long remainingByteCount) {
            this.remainingByteCount = remainingByteCount;
            this.buffer = new Buffer();
        }

        @NotNull
        public final Buffer getBuffer() {
            return this.buffer;
        }

        public final long getReceivedByteCount() {
            return this.receivedByteCount;
        }

        public final void setReceivedByteCount(long l) {
            this.receivedByteCount = l;
        }

        public void write(@NotNull Buffer source, long byteCount) throws IOException {
            long toSkip;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            long toRead = Math.min(this.remainingByteCount, byteCount);
            if (toRead > 0L) {
                source.read(this.buffer, toRead);
            }
            if ((toSkip = byteCount - toRead) > 0L) {
                source.skip(toSkip);
            }
            this.remainingByteCount -= toRead;
            this.receivedByteCount += byteCount;
        }

        public void flush() throws IOException {
        }

        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        public void close() throws IOException {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lmockwebserver3/MockWebServer$Http2SocketHandler;", "Lokhttp3/internal/http2/Http2Connection$Listener;", "socket", "Ljava/net/Socket;", "protocol", "Lokhttp3/Protocol;", "(Lmockwebserver3/MockWebServer;Ljava/net/Socket;Lokhttp3/Protocol;)V", "sequenceNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "onStream", "", "stream", "Lokhttp3/internal/http2/Http2Stream;", "pushPromises", "request", "Lmockwebserver3/RecordedRequest;", "promises", "", "Lmockwebserver3/PushPromise;", "readRequest", "writeResponse", "response", "Lmockwebserver3/MockResponse;", "mockwebserver3"})
    private final class Http2SocketHandler
    extends Http2Connection.Listener {
        @NotNull
        private final Socket socket;
        @NotNull
        private final Protocol protocol;
        @NotNull
        private final AtomicInteger sequenceNumber;

        public Http2SocketHandler(@NotNull Socket socket, Protocol protocol) {
            Intrinsics.checkNotNullParameter((Object)MockWebServer.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            this.socket = socket;
            this.protocol = protocol;
            this.sequenceNumber = new AtomicInteger();
        }

        public void onStream(@NotNull Http2Stream stream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            MockResponse peekedResponse = MockWebServer.this.getDispatcher().peek();
            if (peekedResponse.getSocketPolicy() == SocketPolicy.RESET_STREAM_AT_START) {
                MockWebServer.this.dispatchBookkeepingRequest(this.sequenceNumber.getAndIncrement(), this.socket);
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(peekedResponse.getHttp2ErrorCode());
                Intrinsics.checkNotNull((Object)errorCode);
                stream.close(errorCode, null);
                return;
            }
            RecordedRequest request = this.readRequest(stream);
            MockWebServer.this.atomicRequestCount.incrementAndGet();
            MockWebServer.this.requestQueue.add(request);
            if (request.getFailure() != null) {
                return;
            }
            MockResponse response = MockWebServer.this.getDispatcher().dispatch(request);
            SocketPolicy socketPolicy = response.getSocketPolicy();
            if (socketPolicy == SocketPolicy.DISCONNECT_AFTER_REQUEST) {
                this.socket.close();
                return;
            }
            this.writeResponse(stream, request, response);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(MockWebServer.this + " received request: " + request + " and responded: " + response + " protocol is " + this.protocol);
            }
            switch (WhenMappings.$EnumSwitchMapping$0[socketPolicy.ordinal()]) {
                case 1: {
                    stream.getConnection().shutdown(ErrorCode.NO_ERROR);
                    break;
                }
                case 2: {
                    ErrorCode errorCode = ErrorCode.Companion.fromHttp2(response.getHttp2ErrorCode());
                    Intrinsics.checkNotNull((Object)errorCode);
                    stream.close(errorCode, null);
                }
            }
        }

        private final RecordedRequest readRequest(Http2Stream stream) throws IOException {
            Headers streamHeaders = stream.takeHeaders();
            Headers.Builder httpHeaders = new Headers.Builder();
            String method = "<:method omitted>";
            String path = "<:path omitted>";
            boolean readBody = true;
            for (Pair pair : streamHeaders) {
                String name = (String)pair.component1();
                String value = (String)pair.component2();
                if (Intrinsics.areEqual((Object)name, (Object)":method")) {
                    method = value;
                } else if (Intrinsics.areEqual((Object)name, (Object)":path")) {
                    path = value;
                } else if (this.protocol == Protocol.HTTP_2 || this.protocol == Protocol.H2_PRIOR_KNOWLEDGE) {
                    httpHeaders.add(name, value);
                } else {
                    throw new IllegalStateException();
                }
                if (!Intrinsics.areEqual((Object)name, (Object)"expect") || !StringsKt.equals((String)value, (String)"100-continue", (boolean)true)) continue;
                readBody = false;
            }
            Headers headers = httpHeaders.build();
            MockResponse peek = MockWebServer.this.getDispatcher().peek();
            if (!readBody && peek.getSocketPolicy() == SocketPolicy.EXPECT_CONTINUE) {
                List continueHeaders = CollectionsKt.listOf((Object)new Header(Header.RESPONSE_STATUS, ByteString.Companion.encodeUtf8("100 Continue")));
                stream.writeHeaders(continueHeaders, false, true);
                stream.getConnection().flush();
                readBody = true;
            }
            Buffer body = new Buffer();
            String requestLine = method + ' ' + path + " HTTP/1.1";
            IOException exception = null;
            if (readBody && !peek.isDuplex() && peek.getSocketPolicy() != SocketPolicy.DO_NOT_READ_REQUEST_BODY) {
                try {
                    long l;
                    String contentLengthString;
                    String string = contentLengthString = headers.get("content-length");
                    long byteCount = string == null ? Long.MAX_VALUE : (l = Long.parseLong(string));
                    MockWebServer.this.throttledTransfer(peek, this.socket, Okio.buffer((Source)stream.getSource()), (BufferedSink)body, byteCount, true);
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            return new RecordedRequest(requestLine, headers, CollectionsKt.emptyList(), body.size(), body, this.sequenceNumber.getAndIncrement(), this.socket, exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeResponse(Http2Stream stream, RecordedRequest request, MockResponse response) throws IOException {
            Settings settings = response.getSettings();
            stream.getConnection().setSettings(settings);
            if (response.getSocketPolicy() == SocketPolicy.NO_RESPONSE) {
                return;
            }
            List http2Headers = new ArrayList();
            char[] cArray = new char[]{' '};
            List statusParts = StringsKt.split$default((CharSequence)response.getStatus(), (char[])cArray, (boolean)false, (int)3, (int)2, null);
            long headersDelayMs = response.getHeadersDelay(TimeUnit.MILLISECONDS);
            long bodyDelayMs = response.getBodyDelay(TimeUnit.MILLISECONDS);
            if (statusParts.size() < 2) {
                throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unexpected status: ", (Object)response.getStatus()));
            }
            http2Headers.add(new Header(Header.RESPONSE_STATUS, (String)statusParts.get(1)));
            Headers headers = response.getHeaders();
            for (Pair pair : headers) {
                String name = (String)pair.component1();
                String value = (String)pair.component2();
                http2Headers.add(new Header(name, value));
            }
            Headers trailers = response.getTrailers();
            MockWebServer.this.sleepIfDelayed(headersDelayMs);
            Buffer body = response.getBody();
            boolean outFinished = body == null && response.getPushPromises().isEmpty() && !response.isDuplex();
            boolean flushHeaders = body == null || bodyDelayMs != 0L;
            if (!(!outFinished || trailers.size() == 0)) {
                boolean bl = false;
                String string = Intrinsics.stringPlus((String)"unsupported: no body and non-empty trailers ", (Object)trailers);
                throw new IllegalArgumentException(string.toString());
            }
            stream.writeHeaders(http2Headers, outFinished, flushHeaders);
            if (trailers.size() > 0) {
                stream.enqueueTrailers(trailers);
            }
            this.pushPromises(stream, request, response.getPushPromises());
            if (body != null) {
                Closeable closeable = (Closeable)Okio.buffer((Sink)stream.getSink());
                MockWebServer mockWebServer = MockWebServer.this;
                Throwable throwable = null;
                try {
                    BufferedSink sink = (BufferedSink)closeable;
                    boolean bl = false;
                    mockWebServer.sleepIfDelayed(bodyDelayMs);
                    mockWebServer.throttledTransfer(response, this.socket, (BufferedSource)body, sink, body.size(), false);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else if (response.isDuplex()) {
                DuplexResponseBody duplexResponseBody = response.getDuplexResponseBody();
                Intrinsics.checkNotNull((Object)duplexResponseBody);
                DuplexResponseBody duplexResponseBody2 = duplexResponseBody;
                duplexResponseBody2.onRequest(request, stream);
            } else if (!outFinished) {
                stream.close(ErrorCode.NO_ERROR, null);
            }
        }

        private final void pushPromises(Http2Stream stream, RecordedRequest request, List<PushPromise> promises) throws IOException {
            for (PushPromise pushPromise : promises) {
                List pushedHeaders = new ArrayList();
                pushedHeaders.add(new Header(Header.TARGET_AUTHORITY, MockWebServer.this.url(pushPromise.path()).host()));
                pushedHeaders.add(new Header(Header.TARGET_METHOD, pushPromise.method()));
                pushedHeaders.add(new Header(Header.TARGET_PATH, pushPromise.path()));
                Headers pushPromiseHeaders = pushPromise.headers();
                for (Pair pair : pushPromiseHeaders) {
                    String name = (String)pair.component1();
                    String value = (String)pair.component2();
                    pushedHeaders.add(new Header(name, value));
                }
                String requestLine = pushPromise.method() + ' ' + pushPromise.path() + " HTTP/1.1";
                List chunkSizes = CollectionsKt.emptyList();
                MockWebServer.this.requestQueue.add(new RecordedRequest(requestLine, pushPromise.headers(), chunkSizes, 0L, new Buffer(), this.sequenceNumber.getAndIncrement(), this.socket, null, 128, null));
                boolean hasBody = pushPromise.response().getBody() != null;
                Http2Stream pushedStream = stream.getConnection().pushStream(stream.getId(), pushedHeaders, hasBody);
                this.writeResponse(pushedStream, request, pushPromise.response());
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SocketPolicy.values().length];
                nArray[SocketPolicy.DISCONNECT_AT_END.ordinal()] = 1;
                nArray[SocketPolicy.DO_NOT_READ_REQUEST_BODY.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lmockwebserver3/MockWebServer$Companion;", "", "()V", "CLIENT_AUTH_NONE", "", "CLIENT_AUTH_REQUESTED", "CLIENT_AUTH_REQUIRED", "UNTRUSTED_TRUST_MANAGER", "mockwebserver3/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1", "Lmockwebserver3/MockWebServer$Companion$UNTRUSTED_TRUST_MANAGER$1;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mockwebserver3"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

