//[okhttp](../../index.md)/[okhttp3](index.md)

# Package okhttp3

## Types

| Name | Summary |
|---|---|
| [Address](-address/index.md) | [jvm]<br>class [Address](-address/index.md)(uriHost: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), uriPort: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), val dns: [Dns](-dns/index.md), val socketFactory: [SocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/SocketFactory.html), val sslSocketFactory: [SSLSocketFactory](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocketFactory.html)?, val hostnameVerifier: [HostnameVerifier](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/HostnameVerifier.html)?, val certificatePinner: [CertificatePinner](-certificate-pinner/index.md)?, val proxyAuthenticator: [Authenticator](-authenticator/index.md), val proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html)?, protocols: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Protocol&gt;, connectionSpecs: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[ConnectionSpec](-connection-spec/index.md)&gt;, val proxySelector: [ProxySelector](https://docs.oracle.com/javase/8/docs/api/java/net/ProxySelector.html))<br>A specification for a connection to an origin server. For simple connections, this is the server's hostname and port. If an explicit proxy is requested (or [no proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html#NO_PROXY--) is explicitly requested), this also includes that proxy information. For secure connections the address also includes the SSL socket factory, hostname verifier, and certificate pinner. |
| [AsyncDns](-async-dns/index.md) | [jvm]<br>interface [AsyncDns](-async-dns/index.md)<br>An async domain name service that resolves IP addresses for host names. |
| [Authenticator](-authenticator/index.md) | [jvm]<br>fun interface [Authenticator](-authenticator/index.md)<br>Performs either **preemptive** authentication before connecting to a proxy server, or **reactive** authentication after receiving a challenge from either an origin web server or proxy server. |
| [Cache](-cache/index.md) | [jvm]<br>class [Cache](-cache/index.md)(directory: [Path](https://square.github.io/okio/2.x/okio/okio/-path/index.html), maxSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), fileSystem: [FileSystem](https://square.github.io/okio/2.x/okio/okio/-file-system/index.html)) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), [Flushable](https://docs.oracle.com/javase/8/docs/api/java/io/Flushable.html)<br>Caches HTTP and HTTPS responses to the filesystem so they may be reused, saving time and bandwidth. |
| [CacheControl](-cache-control/index.md) | [common]<br>expect class [CacheControl](-cache-control/index.md)<br>A Cache-Control header with cache directives from a server or client. These directives set policy on what responses can be stored, and which requests can be satisfied by those stored responses.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual class [CacheControl](-cache-control/index.md) |
| [Call](-call/index.md) | [common]<br>expect interface [Call](-call/index.md)<br>A call is a request that has been prepared for execution. A call can be canceled. As this object represents a single request/response pair (stream), it cannot be executed twice.<br>[jvm, nonJvm]<br>[jvm]<br>actual interface [Call](-call/index.md) : [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html)<br>[nonJvm]<br>actual interface [Call](-call/index.md) |
| [Callback](-callback/index.md) | [common]<br>interface [Callback](-callback/index.md) |
| [CertificatePinner](-certificate-pinner/index.md) | [jvm]<br>class [CertificatePinner](-certificate-pinner/index.md)<br>Constrains which certificates are trusted. Pinning certificates defends against attacks on certificate authorities. It also prevents connections through man-in-the-middle certificate authorities either known or unknown to the application's user. This class currently pins a certificate's Subject Public Key Info as described on [Adam Langley's Weblog](http://goo.gl/AIx3e5). Pins are either base64 SHA-256 hashes as in [HTTP Public Key Pinning (HPKP)](http://tools.ietf.org/html/rfc7469) or SHA-1 base64 hashes as in Chromium's [static certificates](http://goo.gl/XDh6je). |
| [Challenge](-challenge/index.md) | [common]<br>expect class [Challenge](-challenge/index.md)(scheme: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), authParams: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;)<br>An [RFC 7235](https://tools.ietf.org/html/rfc7235) challenge.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual class [Challenge](-challenge/index.md)(val scheme: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), authParams: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;) |
| [CipherSuite](-cipher-suite/index.md) | [jvm]<br>class [CipherSuite](-cipher-suite/index.md)<br>[TLS cipher suites](https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml). |
| [Connection](-connection/index.md) | [jvm]<br>interface [Connection](-connection/index.md)<br>The sockets and streams of an HTTP, HTTPS, or HTTPS+HTTP/2 connection. May be used for multiple HTTP request/response exchanges. Connections may be direct to the origin server or via a proxy. |
| [ConnectionPool](-connection-pool/index.md) | [jvm]<br>class [ConnectionPool](-connection-pool/index.md)<br>Manages reuse of HTTP and HTTP/2 connections for reduced network latency. HTTP requests that share the same [Address](-address/index.md) may share a [Connection](-connection/index.md). This class implements the policy of which connections to keep open for future use. |
| [ConnectionSpec](-connection-spec/index.md) | [jvm]<br>class [ConnectionSpec](-connection-spec/index.md)<br>Specifies configuration for the socket connection that HTTP traffic travels through. For https: URLs, this includes the TLS version and cipher suites to use when negotiating a secure connection. |
| [Cookie](-cookie/index.md) | [jvm]<br>class [Cookie](-cookie/index.md)<br>An [RFC 6265](http://tools.ietf.org/html/rfc6265) Cookie. |
| [CookieJar](-cookie-jar/index.md) | [jvm]<br>interface [CookieJar](-cookie-jar/index.md)<br>Provides **policy** and **persistence** for HTTP cookies. |
| [Credentials](-credentials/index.md) | [jvm]<br>object [Credentials](-credentials/index.md)<br>Factory for HTTP authorization credentials. |
| [Dispatcher](-dispatcher/index.md) | [jvm]<br>class [Dispatcher](-dispatcher/index.md)<br>Policy on when async requests are executed. |
| [Dns](-dns/index.md) | [jvm]<br>fun interface [Dns](-dns/index.md)<br>A domain name service that resolves IP addresses for host names. Most applications will use the [system DNS service](-dns/-companion/-s-y-s-t-e-m.md), which is the default. Some applications may provide their own implementation to use a different DNS server, to prefer IPv6 addresses, to prefer IPv4 addresses, or to force a specific known IP address. |
| [EventListener](-event-listener/index.md) | [jvm]<br>abstract class [EventListener](-event-listener/index.md)<br>Listener for metrics events. Extend this class to monitor the quantity, size, and duration of your application's HTTP calls. |
| [FormBody](-form-body/index.md) | [jvm]<br>class [FormBody](-form-body/index.md) : [RequestBody](-request-body/index.md) |
| [Handshake](-handshake/index.md) | [jvm]<br>class [Handshake](-handshake/index.md)<br>A record of a TLS handshake. For HTTPS clients, the client is *local* and the remote server is its *peer*. |
| [Headers](-headers/index.md) | [common]<br>expect class [Headers](-headers/index.md) : [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt; <br>The header fields of a single HTTP message. Values are uninterpreted strings; use Request and Response for interpreted headers. This class maintains the order of the header fields within the HTTP message.<br>[jvm, nonJvm]<br>[jvm]<br>actual class [Headers](-headers/index.md) : [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[Pair](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-pair/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt; <br>[nonJvm]<br>actual class [Headers](-headers/index.md) : [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;&lt;ERROR CLASS&gt;&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;&gt; |
| [HttpUrl](-http-url/index.md) | [jvm]<br>class [HttpUrl](-http-url/index.md)<br>A uniform resource locator (URL) with a scheme of either http or https. Use this class to compose and decompose Internet addresses. For example, this code will compose and print a URL for Google search: |
| [Interceptor](-interceptor/index.md) | [jvm]<br>fun interface [Interceptor](-interceptor/index.md)<br>Observes, modifies, and potentially short-circuits requests going out and the corresponding responses coming back in. Typically interceptors add, remove, or transform headers on the request or response. |
| [MediaType](-media-type/index.md) | [common]<br>expect class [MediaType](-media-type/index.md)<br>An [RFC 2045](http://tools.ietf.org/html/rfc2045) Media Type, appropriate to describe the content type of an HTTP request or response body.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual class [MediaType](-media-type/index.md) |
| [MultipartBody](-multipart-body/index.md) | [jvm]<br>class [MultipartBody](-multipart-body/index.md) : [RequestBody](-request-body/index.md)<br>An [RFC 2387](http://www.ietf.org/rfc/rfc2387.txt)-compliant request body. |
| [MultipartReader](-multipart-reader/index.md) | [jvm]<br>class [MultipartReader](-multipart-reader/index.md)constructor(source: [BufferedSource](https://square.github.io/okio/2.x/okio/okio/-buffered-source/index.html), val boundary: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)<br>Reads a stream of [RFC 2046](http://www.ietf.org/rfc/rfc2046.txt) multipart body parts. Callers read parts one-at-a-time until [nextPart](-multipart-reader/next-part.md) returns null. After calling [nextPart](-multipart-reader/next-part.md) any preceding parts should not be read. |
| [OkHttp](-ok-http/index.md) | [common]<br>object [OkHttp](-ok-http/index.md) |
| [OkHttpClient](-ok-http-client/index.md) | [jvm]<br>open class [OkHttpClient](-ok-http-client/index.md) : [Call.Factory](-call/-factory/index.md), [WebSocket.Factory](-web-socket/-factory/index.md)<br>Factory for [calls](-call/index.md), which can be used to send HTTP requests and read their responses. |
| [Protocol](-protocol/index.md) | [common]<br>enum [Protocol](-protocol/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[Protocol](-protocol/index.md)&gt; <br>Protocols that OkHttp implements for [ALPN](http://tools.ietf.org/html/draft-ietf-tls-applayerprotoneg) selection. |
| [ProtocolException](-protocol-exception/index.md) | [common, nonJvm, jvm]<br>[common]<br>expect class [ProtocolException](-protocol-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>[nonJvm]<br>actual class [ProtocolException](-protocol-exception/index.md)(message: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [IOException](https://square.github.io/okio/2.x/okio/okio/-i-o-exception/index.html)<br>[jvm]<br>actual typealias [ProtocolException](-protocol-exception/index.md) = [ProtocolException](https://docs.oracle.com/javase/8/docs/api/java/net/ProtocolException.html) |
| [Request](-request/index.md) | [common]<br>expect class [Request](-request/index.md)<br>An HTTP request. Instances of this class are immutable if their [body](-request/body.md) is null or itself immutable.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual class [Request](-request/index.md) |
| [RequestBody](-request-body/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect abstract class [RequestBody](-request-body/index.md)<br>[jvm, nonJvm]<br>actual abstract class [RequestBody](-request-body/index.md) |
| [Response](-response/index.md) | [common, nonJvm]<br>[common]<br>expect class [Response](-response/index.md)<br>[nonJvm]<br>actual class [Response](-response/index.md) : [Closeable](https://square.github.io/okio/2.x/okio/okio/-closeable/index.html)<br>An HTTP response. Instances of this class are not immutable: the response body is a one-shot value that may be consumed only once and then closed. All other properties are immutable.<br>[jvm]<br>actual class [Response](-response/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html) |
| [ResponseBody](-response-body/index.md) | [common]<br>expect abstract class [ResponseBody](-response-body/index.md)<br>A one-shot stream from the origin server to the client application with the raw bytes of the response body. Each response body is supported by an active connection to the webserver. This imposes both obligations and limits on the client application.<br>[jvm, nonJvm]<br>[jvm]<br>actual abstract class [ResponseBody](-response-body/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)<br>[nonJvm]<br>actual abstract class [ResponseBody](-response-body/index.md) : [Closeable](https://square.github.io/okio/2.x/okio/okio/-closeable/index.html) |
| [Route](-route/index.md) | [jvm]<br>class [Route](-route/index.md)(val address: [Address](-address/index.md), val proxy: [Proxy](https://docs.oracle.com/javase/8/docs/api/java/net/Proxy.html), val socketAddress: [InetSocketAddress](https://docs.oracle.com/javase/8/docs/api/java/net/InetSocketAddress.html))<br>The concrete route used by a connection to reach an abstract origin server. When creating a connection the client has many options: |
| [TlsVersion](-tls-version/index.md) | [common]<br>expect enum [TlsVersion](-tls-version/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[TlsVersion](-tls-version/index.md)&gt; <br>Versions of TLS that can be offered when negotiating a secure socket.<br>[jvm]<br>actual enum [TlsVersion](-tls-version/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[TlsVersion](-tls-version/index.md)&gt; <br>Versions of TLS that can be offered when negotiating a secure socket. See [javax.net.ssl.SSLSocket.setEnabledProtocols](https://docs.oracle.com/javase/8/docs/api/javax/net/ssl/SSLSocket.html#setEnabledProtocols-kotlin.Array[kotlin.String]-).<br>[nonJvm]<br>actual enum [TlsVersion](-tls-version/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[TlsVersion](-tls-version/index.md)&gt; |
| [WebSocket](-web-socket/index.md) | [jvm]<br>interface [WebSocket](-web-socket/index.md)<br>A non-blocking interface to a web socket. Use the [factory](-web-socket/-factory/index.md) to create instances; usually this is [OkHttpClient](-ok-http-client/index.md). |
| [WebSocketListener](-web-socket-listener/index.md) | [jvm]<br>abstract class [WebSocketListener](-web-socket-listener/index.md) |
