/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.curl;

import com.github.rvesse.airline.HelpOption;
import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.inject.Inject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.curl.Main;
import okhttp3.internal.Util;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.platform.Platform;
import okhttp3.logging.HttpLoggingInterceptor;
import okhttp3.logging.LoggingEventListener;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Command(name="okcurl", description="A curl for the next-generation web.")
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 L2\u00020\u0001:\u0001LB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010D\u001a\u00020EH\u0002J\b\u0010F\u001a\u00020\u0010H\u0002J\b\u0010G\u001a\u0004\u0018\u00010HJ\n\u0010I\u001a\u0004\u0018\u00010JH\u0002J\b\u0010K\u001a\u00020EH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u000eR \u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\bR&\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R&\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010$8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R \u0010)\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0017\"\u0004\b+\u0010\u0019R\u001e\u0010,\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\f\"\u0004\b.\u0010\u000eR \u0010/\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0017\"\u0004\b1\u0010\u0019R\u001e\u00102\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0006\"\u0004\b4\u0010\bR\u001e\u00105\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0006\"\u0004\b7\u0010\bR \u00108\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0017\"\u0004\b:\u0010\u0019R\u001e\u0010;\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0017\"\u0004\b=\u0010\u0019R\u001e\u0010>\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0006\"\u0004\b@\u0010\bR\u001e\u0010A\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0006\"\u0004\bC\u0010\b\u00a8\u0006M"}, d2={"Lokhttp3/curl/Main;", "Ljava/lang/Runnable;", "()V", "allowInsecure", "", "getAllowInsecure", "()Z", "setAllowInsecure", "(Z)V", "callTimeout", "", "getCallTimeout", "()I", "setCallTimeout", "(I)V", "client", "Lokhttp3/OkHttpClient;", "connectTimeout", "getConnectTimeout", "setConnectTimeout", "data", "", "getData", "()Ljava/lang/String;", "setData", "(Ljava/lang/String;)V", "followRedirects", "getFollowRedirects", "setFollowRedirects", "headers", "", "getHeaders", "()Ljava/util/List;", "setHeaders", "(Ljava/util/List;)V", "help", "Lcom/github/rvesse/airline/HelpOption;", "getHelp", "()Lcom/github/rvesse/airline/HelpOption;", "setHelp", "(Lcom/github/rvesse/airline/HelpOption;)V", "method", "getMethod", "setMethod", "readTimeout", "getReadTimeout", "setReadTimeout", "referer", "getReferer", "setReferer", "showHeaders", "getShowHeaders", "setShowHeaders", "showHttp2Frames", "getShowHttp2Frames", "setShowHttp2Frames", "url", "getUrl", "setUrl", "userAgent", "getUserAgent", "setUserAgent", "verbose", "getVerbose", "setVerbose", "version", "getVersion", "setVersion", "close", "", "createClient", "createRequest", "Lokhttp3/Request;", "mediaType", "Lokhttp3/MediaType;", "run", "Companion", "okcurl"})
public final class Main
implements Runnable {
    @Inject
    @Nullable
    private HelpOption<Main> help;
    @Option(name={"-X", "--request"}, description="Specify request command to use")
    @Nullable
    private String method;
    @Option(name={"-d", "--data"}, description="HTTP POST data")
    @Nullable
    private String data;
    @Option(name={"-H", "--header"}, description="Custom header to pass to server")
    @Nullable
    private List<String> headers;
    @Option(name={"-A", "--user-agent"}, description="User-Agent to send to server")
    @NotNull
    private String userAgent = "okcurl/" + okhttp3.curl.Main$Companion.access$versionString(Companion);
    @Option(name={"--connect-timeout"}, description="Maximum time allowed for connection (seconds)")
    private int connectTimeout = -1;
    @Option(name={"--read-timeout"}, description="Maximum time allowed for reading data (seconds)")
    private int readTimeout = -1;
    @Option(name={"--call-timeout"}, description="Maximum time allowed for the entire call (seconds)")
    private int callTimeout = -1;
    @Option(name={"-L", "--location"}, description="Follow redirects")
    private boolean followRedirects;
    @Option(name={"-k", "--insecure"}, description="Allow connections to SSL sites without certs")
    private boolean allowInsecure;
    @Option(name={"-i", "--include"}, description="Include protocol headers in the output")
    private boolean showHeaders;
    @Option(name={"--frames"}, description="Log HTTP/2 frames to STDERR")
    private boolean showHttp2Frames;
    @Option(name={"-e", "--referer"}, description="Referer URL")
    @Nullable
    private String referer;
    @Option(name={"-V", "--version"}, description="Show version number and quit")
    private boolean version;
    @Option(name={"-v", "--verbose"}, description="Makes okcurl verbose during the operation")
    private boolean verbose;
    @Arguments(title={"url"}, description="Remote resource URL")
    @Nullable
    private String url;
    private OkHttpClient client;
    @NotNull
    public static final String NAME = "okcurl";
    public static final int DEFAULT_TIMEOUT = -1;
    private static Logger frameLogger;
    public static final Companion Companion;

    @Nullable
    public final HelpOption<Main> getHelp() {
        return this.help;
    }

    public final void setHelp(@Nullable HelpOption<Main> helpOption) {
        this.help = helpOption;
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    public final void setMethod(@Nullable String string) {
        this.method = string;
    }

    @Nullable
    public final String getData() {
        return this.data;
    }

    public final void setData(@Nullable String string) {
        this.data = string;
    }

    @Nullable
    public final List<String> getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@Nullable List<String> list) {
        this.headers = list;
    }

    @NotNull
    public final String getUserAgent() {
        return this.userAgent;
    }

    public final void setUserAgent(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.userAgent = string;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public final int getCallTimeout() {
        return this.callTimeout;
    }

    public final void setCallTimeout(int n) {
        this.callTimeout = n;
    }

    public final boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public final void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    public final boolean getAllowInsecure() {
        return this.allowInsecure;
    }

    public final void setAllowInsecure(boolean bl) {
        this.allowInsecure = bl;
    }

    public final boolean getShowHeaders() {
        return this.showHeaders;
    }

    public final void setShowHeaders(boolean bl) {
        this.showHeaders = bl;
    }

    public final boolean getShowHttp2Frames() {
        return this.showHttp2Frames;
    }

    public final void setShowHttp2Frames(boolean bl) {
        this.showHttp2Frames = bl;
    }

    @Nullable
    public final String getReferer() {
        return this.referer;
    }

    public final void setReferer(@Nullable String string) {
        this.referer = string;
    }

    public final boolean getVersion() {
        return this.version;
    }

    public final void setVersion(boolean bl) {
        this.version = bl;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Nullable
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@Nullable String string) {
        this.url = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HelpOption<Main> helpOption = this.help;
        if (helpOption != null) {
            if (helpOption.showHelpIfRequested()) {
                return;
            }
        }
        if (this.version) {
            String string = "okcurl " + Main.Companion.versionString();
            boolean bl = false;
            System.out.println((Object)string);
            string = "Protocols: " + Main.Companion.protocols();
            bl = false;
            System.out.println((Object)string);
            return;
        }
        if (this.showHttp2Frames) {
            Main.Companion.enableHttp2FrameLogging();
        }
        this.client = this.createClient();
        Request request = this.createRequest();
        if (request == null) {
            HelpOption<Main> helpOption2 = this.help;
            if (helpOption2 != null) {
                helpOption2.showHelp();
            }
            return;
        }
        try {
            OkHttpClient okHttpClient = this.client;
            if (okHttpClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            }
            Response response = okHttpClient.newCall(request).execute();
            if (this.showHeaders) {
                StatusLine statusLine = StatusLine.Companion.get(response);
                boolean bl = false;
                System.out.println(statusLine);
                Headers headers = response.headers();
                for (Pair pair : headers) {
                    String name = (String)pair.component1();
                    String value = (String)pair.component2();
                    String string = name + ": " + value;
                    boolean bl2 = false;
                    System.out.println((Object)string);
                }
                bl = false;
                System.out.println();
            }
            PrintStream printStream = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
            Sink out = Okio.sink((OutputStream)printStream);
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                Intrinsics.throwNpe();
            }
            BufferedSource source = responseBody.source();
            while (!source.exhausted()) {
                out.write(source.getBuffer(), source.getBuffer().size());
                out.flush();
            }
            ResponseBody responseBody2 = response.body();
            if (responseBody2 == null) {
                Intrinsics.throwNpe();
            }
            responseBody2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.close();
        }
    }

    private final OkHttpClient createClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.followSslRedirects(this.followRedirects);
        if (this.connectTimeout != -1) {
            builder.connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS);
        }
        if (this.readTimeout != -1) {
            builder.readTimeout((long)this.readTimeout, TimeUnit.SECONDS);
        }
        if (this.callTimeout != -1) {
            builder.callTimeout((long)this.callTimeout, TimeUnit.SECONDS);
        }
        if (this.allowInsecure) {
            X509TrustManager trustManager = Main.Companion.createInsecureTrustManager();
            SSLSocketFactory sslSocketFactory = Main.Companion.createInsecureSslSocketFactory(trustManager);
            builder.sslSocketFactory(sslSocketFactory, trustManager);
            builder.hostnameVerifier(Main.Companion.createInsecureHostnameVerifier());
        }
        if (this.verbose) {
            HttpLoggingInterceptor.Logger.Companion this_$iv = HttpLoggingInterceptor.Logger.Companion;
            boolean bl = false;
            HttpLoggingInterceptor.Logger logger = new HttpLoggingInterceptor.Logger(){

                public void log(@NotNull String message) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    String it = message;
                    boolean bl = false;
                    boolean bl2 = false;
                    System.out.println((Object)it);
                }
            };
            builder.eventListenerFactory((EventListener.Factory)new LoggingEventListener.Factory(logger));
        }
        return builder.build();
    }

    @Nullable
    public final Request createRequest() {
        boolean bl;
        String string;
        Request.Builder request = new Request.Builder();
        String string2 = this.url;
        if (string2 == null) {
            return null;
        }
        String requestUrl = string2;
        String string3 = this.method;
        if (string3 == null) {
            string3 = this.data != null ? "POST" : "GET";
        }
        String requestMethod = string3;
        request.url(requestUrl);
        String string4 = this.data;
        if (string4 != null) {
            string = string4;
            boolean bl2 = false;
            boolean bl3 = false;
            String it2 = string;
            bl = false;
            request.method(requestMethod, RequestBody.Companion.create(it2, this.mediaType()));
        }
        List list = this.headers;
        boolean it2 = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        for (String header : list2) {
            char[] it2 = new char[]{':'};
            bl = false;
            int n = 2;
            List parts = StringsKt.split$default((CharSequence)header, (char[])it2, (boolean)bl, (int)n, (int)2, null);
            request.header((String)parts.get(0), (String)parts.get(1));
        }
        String string5 = this.referer;
        if (string5 != null) {
            string = string5;
            boolean bl4 = false;
            boolean bl5 = false;
            String it3 = string;
            boolean bl6 = false;
            request.header("Referer", it3);
        }
        request.header("User-Agent", this.userAgent);
        return request.build();
    }

    private final MediaType mediaType() {
        List<String> list;
        block7: {
            block6: {
                Object object;
                block5: {
                    list = this.headers;
                    if (list == null) break block6;
                    List<String> list2 = list;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<String> it = list2;
                    boolean bl3 = false;
                    for (String header : it) {
                        int n;
                        boolean bl4;
                        Object object2;
                        List parts = StringsKt.split$default((CharSequence)header, (char[])(object2 = new char[]{':'}), (boolean)(bl4 = false), (int)(n = 2), (int)2, null);
                        if (!StringsKt.equals((String)"Content-Type", (String)((String)parts.get(0)), (boolean)true)) continue;
                        it.remove(header);
                        object2 = (String)parts.get(1);
                        bl4 = false;
                        if (object2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
                        break block5;
                    }
                    object = list = null;
                }
                if (object != null) break block7;
            }
            list = "application/x-www-form-urlencoded";
        }
        List<String> mimeType = list;
        return MediaType.Companion.parse((String)((Object)mimeType));
    }

    private final void close() {
        OkHttpClient okHttpClient = this.client;
        if (okHttpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        }
        okHttpClient.connectionPool().evictAll();
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ Logger access$getFrameLogger$cp() {
        return frameLogger;
    }

    @JvmStatic
    @NotNull
    public static final Main fromArgs(String ... args) {
        return Companion.fromArgs(args);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J!\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0016\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\u0018\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0007\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lokhttp3/curl/Main$Companion;", "", "()V", "DEFAULT_TIMEOUT", "", "NAME", "", "frameLogger", "Ljava/util/logging/Logger;", "createInsecureHostnameVerifier", "Ljavax/net/ssl/HostnameVerifier;", "createInsecureSslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "trustManager", "Ljavax/net/ssl/TrustManager;", "createInsecureTrustManager", "Ljavax/net/ssl/X509TrustManager;", "enableHttp2FrameLogging", "", "fromArgs", "Lokhttp3/curl/Main;", "args", "", "([Ljava/lang/String;)Lokhttp3/curl/Main;", "main", "([Ljava/lang/String;)V", "protocols", "versionString", "okcurl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Main fromArgs(String ... args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            Object object = SingleCommand.singleCommand(Main.class).parse(Arrays.copyOf(args, args.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"SingleCommand.singleComm\u2026:class.java).parse(*args)");
            return (Main)object;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            Companion.fromArgs(Arrays.copyOf(args, args.length)).run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String versionString() {
            Properties prop = new Properties();
            Closeable closeable = Main.class.getResourceAsStream("/okcurl-version.properties");
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                prop.load(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = prop.getProperty("version", "dev");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prop.getProperty(\"version\", \"dev\")");
            return string;
        }

        private final String protocols() {
            return ArraysKt.joinToString$default((Object[])Protocol.values(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }

        private final X509TrustManager createInsecureTrustManager() {
            return new X509TrustManager(){

                public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
                    Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                    Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
                }

                public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
                    Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                    Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
                }

                @NotNull
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
        }

        private final SSLSocketFactory createInsecureSslSocketFactory(TrustManager trustManager) {
            SSLContext sSLContext = Platform.Companion.get().newSSLContext();
            boolean bl = false;
            boolean bl2 = false;
            SSLContext $this$apply = sSLContext;
            boolean bl3 = false;
            $this$apply.init(null, new TrustManager[]{trustManager}, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            Intrinsics.checkExpressionValueIsNotNull((Object)sSLSocketFactory, (String)"Platform.get().newSSLCon\u2026)\n        }.socketFactory");
            return sSLSocketFactory;
        }

        private final HostnameVerifier createInsecureHostnameVerifier() {
            return createInsecureHostnameVerifier.1.INSTANCE;
        }

        private final void enableHttp2FrameLogging() {
            Logger logger = Logger.getLogger(Http2.class.getName());
            boolean bl = false;
            boolean bl2 = false;
            Logger $this$apply = logger;
            boolean bl3 = false;
            $this$apply.setLevel(Level.FINE);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            Logger logger2 = $this$apply;
            boolean bl4 = false;
            boolean bl5 = false;
            ConsoleHandler $this$apply2 = consoleHandler;
            boolean bl6 = false;
            $this$apply2.setLevel(Level.FINE);
            $this$apply2.setFormatter(new SimpleFormatter(){

                @NotNull
                public String format(@NotNull LogRecord record) {
                    Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
                    Object[] objectArray = new Object[1];
                    String string = record.getMessage();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"record.message");
                    objectArray[0] = string;
                    return Util.format((String)"%s%n", (Object[])objectArray);
                }
            });
            ConsoleHandler consoleHandler2 = consoleHandler;
            logger2.addHandler(consoleHandler2);
            frameLogger = logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

